/*
BEGIN DOCUMENTATION

Name: Daniel T. Soldahl				Created: 7/20/83
					    Last Update:05/18/84

Title: TCMINIT.C: Text collection management system slave task.

Index: TCM text editor

Abstract: Implements "TINIT" function of TCM to initialize task
	  and defaults.  Any current text windows are deleted.

Usage:	See "TCM.DOC"

Parameters:

Environment: RSX11M V4.0, DECUS C Compiler

See Also: TCM.C

Description: 

Example(s):  See "TCM.DOC"

Uses:

Internal: 

Update History:

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmpublic.h"



/***	(TINIT) Initialize buffer, delete all windows and free memory    ***/

init()
{
    register struct twindcb	*wptr;

	ret.cd = TS_SUC;		/* Default to successful initialization */
	vttype = sctype();
	vtlin = CRTLIN;			/* Default to 24 lines */
	iff (vttype != VT52) and (vttype != LA120) then
	    vttype = VT100;		/* Default to VT100 */
	iff vttype == VT100 then
	    { vtmar = 132; cpystr(sidebar,BOXSIDE); }
	else iff vttype == VT52 then
	    { vtmar = 80; cpystr(sidebar,"|"); }
	else
	    { ret.cd = TE_CRT; ret.dsw = vttype; }
	while (twinroot != NULL)	/* Delete all allocated windows */
	{
	    wptr = twinroot->twinptr;
	    delwind(twinroot);		/* delete top window on stack */
	    twinroot = wptr;
	}

	/*** set defaults for editing ***/

	wrap = true;		/* Word wrap always on */
	insert = false;		/* Default to overtype */
	select = false;		/* Select range is active */
	tabdisp = false;	/* Tab display is off */
	coldisp = true;		/* Column display is on */
	underline = false;	/* Underscore is off */
	bold = false;		/* Bold face is off */
	curwin = twinroot = NULL; /* No windows */
	errlvl = 0;		/* Return if errors are negative */
/*
	iniout();	commented out, not needed but doesn't hurt
*/
} /* end init */
