/* TCMERR.H: TCM Error Codes */

#define TE_BDH  -1	/* Bad Height Parameter (height > maximum or < 1) */
#define TE_INS  -2	/* ...TCM not installed */
#define TE_BDW  -3	/* Bad Width Parameter (width > maximum or < 2) */
#define TE_BDP  -4	/* Bad Parameter (out of range) */
#define TE_CRT  -5	/* Invalid CRT terminal type */
#define TE_IDS  -6	/* Insufficient Dynamic Storage, no buffer space */
#define TE_ACT  -7	/* TCM not active (aborted) */
#define TE_NSW  -8	/* No such window */
#define TE_OTF  -9	/* Cannot open text_save file */
#define TE_EOL  -10	/* No more lines */
#define TE_SRV  -11	/* Send/Receive Error */
#define TE_AST  -12	/* AST Initialization Failure */
#define TE_STA  -13	/* TCM not started */
#define TE_EVF  -14	/* Event flag directive error */
#define TE_TMO  -15	/* Timeout on no CRT activity */
#define TE_INF  -26	/* Init_data file not found */
#define TE_FIO  -59	/* File I/O error */

/* TCM Status Codes (Editing errors & warnings) */

#define TS_SUC  1	/* Success, valid completion */
#define TS_LSL  2	/* Last line */
#define TS_XFR  3	/* Exit forward */
#define TS_XBK  4	/* Exit backward */
#define TS_ABO  5	/* Abort key pressed, user screen exit */
#define TS_ENT  10	/* Enter key pressed */
#define TS_IKY  11	/* Invalid key pressed */
#define TS_UKY  12	/* Undefined function key pressed */
#define TS_BFI  20	/* Buffer full - char or line insert */
#define TS_BFP  21	/* Buffer full - paste or undelete */
#define TS_MCI  23	/* Maximum lines - char or line insert */
#define TS_MCP  24	/* Maximum lines - paste or undelete */
#define TS_RFS  30	/* Refresh screen key pressed */
#define TS_HLP  31	/* Help key pressed */
#define TS_CUT  40	/* Cut too large */
#define TS_APE  50	/* Advance past end of text */
#define TS_BPS  51	/* Backup past start of text */
#define TS_SNF  52	/* String not found */
#define TS_WTL  53	/* Word too long for line */
