$ IV=F$VERIFY(0)
$ ON CONTROL_Y THEN GOTO QUIT
$ ! Command file to aid the user in building a command file
$ ! to do a full INDEX of a large program
$ !
$ ! Initial intro to make sure that the user is rady to proceed
$ TYPE SYS$INPUT

	This command file is used to generate a command file to
do  a complete  cross reference on a program consisting of many
files. To use this command file, you must first generate a data
file consisting of the names of  each file  that makes  up  the 
program. Each file  on a seperate  line, left  justified. If  a
source file requires a library file (.TLB), put its name on the
same line as the source file (seperated with a comma) and add a
/LIBRARY switch  after  it. If  the  logical  name FORT$LIBRARY
is used to specify the  library  file  then  this action is not
required.

$ ! See if the user is ready to proceed
$ INQUIRE READY "Are you ready to build the command file Y[es] or N[o] "
$ IF .NOT.READY THEN GOTO QUIT	! if not ready-just exit
$ ! Get the name of the command file to be constructed
$ INQUIRE INDEX_NAME  "What is the name of the command file to be generated"
$ ! See if he specified a name
$ IF INDEX_NAME.NES."" THEN GOTO GET_INPUT	! yes-continue
$ ! No name specified-use default name
$ WRITE SYS$OUTPUT "Default command file name is INDEX.COM"
$ INDEX_NAME = "INDEX.COM"
$ GET_INPUT:
$ INQUIRE DATA_NAME -
 "What is the name of the file containing the list of file names "
$ IF DATA_NAME.NES."" THEN GOTO GET_LIST
$ WRITE SYS$OUTPUT "Default file name list data file is INDEX.DAT"
$ DATA_NAME="INDEX.DAT"
$ GET_LIST:
$ INQUIRE LIST_NAME "What is the file name for the cross reference output"
$ IF LIST_NAME.NES."" THEN GOTO OPEN_FILES
$ LIST_NAME="MAIN"
$ WRITE SYS$OUTPUT "Default list file name is MAIN.LIS"
$ OPEN_FILES:
$ INQUIRE LIST_SOURCE "Do you want INDEX listings of the source files [Y/N]"
$ IF LIST_SOURCE.EQS."" THEN WRITE SYS$OUTPUT "Default is No"
$ OPEN/READ/ERROR=NO_SUCH_FILE DATA_FILE 'DATA_NAME'
$ OPEN/WRITE/ERROR=NO_OPEN INDEX_FILE 'INDEX_NAME'
$ ON CONTROL_Y THEN GOTO CLOSE_UP
$ APPEND=""
$ LIST="/LIST="+LIST_NAME
$ !
$ ! The first command in the generated command file is to invoke INDEX
$ !
$ WRITE INDEX_FILE "$ INDEX"
$ !
$ ! first pass-generate the listings and general cross reference
$ ! and do saves for SUPER INDEX
$ !
$ LOOP_1:
$ READ/END_OF_FILE=END_LOOP_1 DATA_FILE FILE_NAME
$ ! See if this needs to have mult passes  over file
$ IF F$EXTRACT(0,1,FILE_NAME).NES."+" THEN GOTO ONE_PASS_1
$ ! Listing generate line with save for save for SUPER INDEX
$ FILE_NAME=F$EXTRACT(1,F$LENGTH(FILE_NAME)-1,FILE_NAME)
$ IF LIST_SOURCE THEN WRITE INDEX_FILE "/LOG/USED",APPEND,LIST,"  ",FILE_NAME
$ ! Save data for SUPER INDEX
$ WRITE INDEX_FILE -
 "/GET_SUP/LOG/NOSOU/NOIND/NULL/IMP/TAG=""IMPORT"" ",FILE_NAME
$ WRITE INDEX_FILE -
 "/GET_SUP/LOG/NOSOU/NOIND/NULL/EXP/TAG=""EXPORT"" ",FILE_NAME
$ APPEND="/MERGE"
$ GOTO LOOP_1
$ ONE_PASS_1:
$ ! Listing generate line with save for save for SUPER INDEX
$ IF LIST_SOURCE THEN -
   WRITE INDEX_FILE "/LOG/USED/SAVE_INDEX",APPEND,LIST,"  ",FILE_NAME
$ ! Save data for SUPER INDEX
$ IF LIST_SOURCE THEN WRITE INDEX_FILE -
 "/GET_SUP/LOG/NOSOU/NOIND/NULL/IMP/TAG=""IMPORT""/SAVE_INDEX"
$ IF .NOT.LIST_SOURCE THEN WRITE INDEX_FILE -
 "/GET_SUP/LOG/NOSOU/NOIND/NULL/IMP/TAG=""IMPORT""/SAVE_INDEX  ",-
  FILE_NAME
$ WRITE INDEX_FILE -
 "/GET_SUP/LOG/NOSOU/NOIND/NULL/EXP/TAG=""EXPORT"" "
$ APPEND="/MERGE"
$ GOTO LOOP_1
$ END_LOOP_1:
$ !
$ ! Generate the super index in two configurations , by variable and module
$ !
$ IF LIST_SOURCE THEN  WRITE INDEX_FILE -
 "/LOG/DO_SUP/SAVE_SUP/MERGE/ORDER=NAME:STORE:MODULE:TAG:TYPE:ARG/IND=1 ",-
  LIST_NAME
$ IF .NOT. LIST_SOURCE THEN   WRITE INDEX_FILE -
"/LOG/DO_SUP/SAVE_SUP/ORDER=NAME:STORE:MODULE:TAG:TYPE:ARG/IND=1   ",LIST_NAME
$ WRITE INDEX_FILE -
 "/LOG/DO_SUP/SAVE_SUP/MERGE/ORDER=MODULE:TAG:STORE:NAME:TYPE/IND=2   ",-
  LIST_NAME
$ WRITE INDEX_FILE -
 "/LOG/DO_SUP/SAVE_SUP/MERGE/ORDER=STORE:NAME:MODULE:TYPE:TAG/IND=1 ",LIST_NAME
$ WRITE INDEX_FILE -
 "/LOG/CALL_ARG/MERGE ",LIST_NAME
$ CLOSE DATA_FILE
$ OPEN DATA_FILE 'DATA_NAME'
$ !
$ ! Pass 2-accumlate data for common block super index
$ !
$ LOOP_2:
$ READ/END_OF_FILE=END_LOOP_2 DATA_FILE FILE_NAME
$ ! See if this needs to have mult passes  over file
$ IF F$EXTRACT(0,1,FILE_NAME).NES."+" THEN GOTO ONE_PASS_2
$ ! Listing generate line with save for save for SUPER INDEX
$ FILE_NAME=F$EXTRACT(1,F$LENGTH(FILE_NAME)-1,FILE_NAME)
$ ! Save data for SUPER INDEX
$ WRITE INDEX_FILE -
 "/LOG/GET_SUPER/NOSOURCE/NOINDEX/NULL/COMMON/USED ",FILE_NAME
$ WRITE INDEX_FILE -
 "/LOG/GET_SUP/NOSOU/NOIND/NULL/COMMO/UNCHAN/UNUS/TAG=""UNUSED"" ",FILE_NAME
$ WRITE INDEX_FILE -
 "/LOG/GET_SUPER/NOSOURCE/NOINDEX/NULL/COMMON/CHANGED/UNUSED ",FILE_NAME
$ GOTO LOOP_2
$ ONE_PASS_2:
$ WRITE INDEX_FILE -
 "/LOG/GET_SUPER/NOSOU/NOIND/NULL/COMMO/USED/SAVE_INDEX  ",FILE_NAME
$ WRITE INDEX_FILE -
 "/LOG/GET_SUP/NOSOU/NOIND/NULL/COMMO/UNCHAN/UNUS/SAVE_IND/TAG=""UNUSED"" "
$ WRITE INDEX_FILE -
 "/LOG/GET_SUPER/NOSOURCE/NOINDEX/NULL/COMMON/CHANGED/UNUSED"
$ GOTO LOOP_2
$ END_LOOP_2:
$ !
$ ! output super index of common block useage
$ !
$ WRITE INDEX_FILE "/LOG/DO_SUPER/MERGE/ORDER=COMMON:MODULE:TAG",-
 "/COMMENT=""Common Block Useage"" ",LIST_NAME
$ CLOSE DATA_FILE
$ OPEN DATA_FILE 'DATA_NAME'
$ !
$ ! Pass-3, accumulate data for entry point cross reference
$ !
$ LOOP_3:
$ READ/END_OF_FILE=END_LOOP_3 DATA_FILE FILE_NAME
$ IF F$EXTRACT(0,1,FILE_NAME).EQS."+" THEN -
  FILE_NAME=F$EXTRACT(1,F$LENGTH(FILE_NAME)-1,FILE_NAME)
$ WRITE INDEX_FILE  "/LOG/GET_ENTRY ",FILE_NAME
$ GOTO LOOP_3
$ END_LOOP_3:
$ !
$ ! generate the entry point cross reference
$ !
$ WRITE INDEX_FILE "/LOG/DO_ENTRY/MERGE/CALLING/CALLED/NOLIB/FILE/STAT ",-
 LIST_NAME
$ !
$ ! Command file built- do final clean up 
$ !
$ WRITE SYS$OUTPUT "Generation completed"
$ CLOSE_UP:
$ CLOSE INDEX_FILE
$ CLOSE DATA_FILE
$ INQUIRE RELEASE -
  "Do you want to delete the data file "'DATA_NAME'" ( Y[es] or N[o])"
$ IF RELEASE THEN DELETE/NOCONFIRM/LOG 'DATA_NAME';*
$ GOTO QUIT
$ !
$ ! Error handler-error opening output command file to be built
$ !
$ NO_OPEN:
$ WRITE SYS$OUTPUT "Unable to open new command file"
$ CLOSE DATA_FILE
$ GOTO QUIT
$ !
$ ! Error handler-error opening file containing list of files
$ !
$ NO_SUCH_FILE:
$ WRITE SYS$OUTPUT "Source file list data file does not exist"
$ GOTO QUIT
$ QUIT:
$ IVV=F$VERIFY(IV)
