; CP4KER.ASM
;	KERMIT - (Celtic for "FREE")
;
;	This is the CP/M-80 implementation of the Columbia University
;	KERMIT file transfer protocol.
;
;	Version 4.0
;
;	Copyright June 1981,1982,1983,1984
;	Columbia University
;
; Originally written by Bill Catchings of the Columbia University Center for
; Computing Activities, 612 W. 115th St., New York, NY 10025.
;
; Contributions by Frank da Cruz, Daphne Tzoar, Bernie Eiben,
; Bruce Tanner, Nick Bush, Greg Small, Kimmo Laaksonen, Jeff Damens, and many
; others. 
;

; This is the header for the system-independent portion of KERMIT, which
; consists of the following files (in this order):
;	CP4KER.ASM - this file
;	CP4DEF.ASM - definitions for both KERMIT and KERSYS
;	CP4MIT.ASM - initialization, main loop, miscellaneous commands
;		     (BYE, EXIT, LOG, SET, SHOW, and STATUS)
;	CP4PKT.ASM - the KERMIT protocol handler (SEND, RECEIVE, LOGOUT,
;		     and FINISH commands)
;	CP4TT.ASM  - the transparent commands (TRANSMIT, CONNECT)
;	CP4CPM.ASM - CP/M commands (DIR, ERA)
;	CP4WLD.ASM - the wildcard handler
;	CP4CMD.ASM - the command parser
;	CP4UTL.ASM - utility routines and data
;
; When building the system-independent part with M80 or MAC80, CP4KER
; INCLUDEs the other files; when building with LASM, each file LINKs to
; the next file.
;
; For now, the system-dependent routines are all in CP4SYS.ASM, with
; the actual configuration defined in CP4TYP.ASM.
;
; revision history (latest first):
; edit 3: February 10, 1985 (CJC)
;	Update for v4.05; add "verno" so CP4UTL doesn't have to change
;	just because some other module did.
;
; edit 2: September 10, 1984 (CJC)
;	Update for v4.03.
;
; edit 1: July 27, 1984 (CJC)
;	Created to allow assembly of Kermit by LASM as well as MAC80 and M80.

verno	EQU	05		; minor version number
	
; Version 4.05 of Kermit consists of the following edit levels:
;	cp4ker.asm edit 3
;	cp4def.asm edit 4
;	cp4mit.asm edit 8
;	cp4pkt.asm edit 6
;	cp4tt.asm edit 4
;	cp4cpm.asm edit 3
;	cp4wld.asm edit 3
;	cp4cmd.asm edit 5
;	cp4utl.asm edit 6
;	cp4lnk.asm edit 5 (cp4lnk.asm is not assembled with cp4ker, but it
;		defines the linkage area expected by cp4ker, and so must
;		match the description in cp4utl.asm)
;
; Version 4.05 of Kermit has been tested with the following edit levels of
; the system-dependent files:
;	cp4typ.asm edit 6
;	cp4sys.asm edit 12
;

FALSE	equ	0
TRUE	equ	NOT FALSE

cp4ker	equ	TRUE	; building system-independent part

;
; Assembler type.  Define the appropriate one TRUE, the rest FALSE.  (We can't
; use ASM, because it cannot handle multiple input files)
mac80	EQU	FALSE		; For assembly via MAC80 cross-assembler.
m80	EQU	FALSE		; For assembly via Microsoft's M80.
lasm	EQU	TRUE		; For assembly via LASM, a public-domain
				; assembler.
;
;	Get the other modules...

IF lasm				; If we're linking, go on to the next file.
	LINK	CP4DEF
ENDIF;lasm

; If we're still here, we must be using M80 or MAC80.  M80 doesn't
; like ENDs inside conditionals, but the END statement has to be
; in CP4UTL for LASM (otherwise, we'd need a file containing just an
; END statement).  So, we leave off the IF m80 OR mac80 conditional
; that ought to be around these INCLUDEs.  No problem until the next
; incompatible assembler comes along...
	INCLUDE CP4DEF.ASM	; definitions
	INCLUDE CP4MIT.ASM	; initialization, main loop, some commands
	INCLUDE	CP4PKT.ASM	; KERMIT protocol handler
	INCLUDE CP4TT.ASM	; transparent communication handler
	INCLUDE	CP4CPM.ASM	; CP/M command support (DIR, ERA)
	INCLUDE	CP4WLD.ASM	; wildcard handler
	INCLUDE	CP4CMD.ASM	; command parser
	INCLUDE CP4UTL.ASM	; Various utilities and data, and END [ToadHall]
	END			; MAC80 ignores END's in included files...
