.ENABLE SUBSTITUTION
.SETS SAVUIC "'<UIC>'"
;
; This file applies a set of changes to an RSX11M V4.1 Update D SYSGEN
; procedure to support loadable device drivers with loadable data bases.
; In addition support for hexadecimal command line numerics can be
; included in the generated system.
;
; DO NOT attempt to use this set of changes without first reading the
; the following two papers, presented at the Spring 1985 DECUS Symposium
; at New Orleans, to be published in the proceedings of the meeting.
; The manuscripts for these papers is also available in the files
; SYSGENMOD.DOC and HEXMOD.DOC included in this modification kit.
;
; These changes were developed by Carl T. Mickelson, at Goodyear Aerospace
; Corporation, Akron, Ohio 44315.  The kit of files comprising these changes
; are supplied for information purposes only.  Use of these changes at
; any PDP-11/RSX11M site is entirely at the risk of the using organization.
; Neither the author, nor Goodyear, nor DECUS, nor the RSX SIG is
; responsible if these changes do not perform successfully in any system.
;
; Note that the modification procedure assumes the presence of copies of
; the modified files as they should exist after being changed.  Due
; to DECUS restrictions on the transfer of copyrighted information via
; the SIG tapes, these files cannot be included in this submission.
; As long as these changes are properly used on an RSX11M V4.1
; distribution kit with Update D applied, there is no need for these files.
;
; RSX11M distribution kits come in three forms:
;
;	A - Big disk distribution kit
;	B - RK06 / RK07 distribution kit
;	C - RL01 / RL02 distribution kit
;
; Use the letters A, B or C from the above table to specify the kit
; type being patched.
;
.BADTYP:
.ASKS [1:1:"A"] KITYPE Enter distribution kit type
.IF KITYPE NE "A" .IF KITYPE NE "B" .IF KITYPE NE "C" .GOTO BADTYP
.SETF BIGKIT
.SETF RKKIT
.SETF RLKIT
.IF KITYPE EQ "A" .SETT BIGKIT
.IF KITYPE EQ "B" .SETT RKKIT
.IF KITYPE EQ "C" .SETT RLKIT
.ASKS [0:5:"'<SYSDEV>':"] KIT What device contains the RSX11M disc
.IF KIT EQ "" .SETS KIT "'<SYSDEV>':"
ASN 'KIT'=KT0:
.IFT RLKIT .ASKS [0:5:"'<SYSDEV>':"] KIT What device contains the EXCPRV disc
.IFT RLKIT .IF KIT EQ "" .SETS KIT "'<SYSDEV>':"
ASN 'KIT'=KT1:
.ASKS [0:5:"'<SYSDEV>':"] MOD What device contains the GAC modification kit
.IF MOD EQ "" .SETS MOD "'<SYSDEV>':"
ASN 'MOD'=MD0:
.ASKS [0:9.:"'SAVUIC'"] GACUIC What UIC contains the GAC modification kit (with []s)
.IF GACUIC EQ "" .SETS GACUIC "'SAVUIC'"
SET /UIC='GACUIC'
;
; This command file is invoked twice during the SYSGEN process.
; The first time, the indirect command processor (ICP) is re-built to enlarge
; the symbol table.  The second time the file is used prior to SYSGEN
; phase 1 to apply the bulk of the Goodyear Aerospace modifications.
;
; Before performing the modifications applied by this command file,
; the indirect command file processor ...AT. should be re-built in order
; to have enough symbol table space for use with SYSGEN.
;
.ASK ICPDON Has the indirect command processor been rebuilt
.IFT ICPDON .GOTO DOMODS
;
; Since the indirect command processor has not yet been rebuilt, this
; procedure will now re-build it.  When the command file ends,
; it will be necessary to manually perform two commands to remove the old
; ICP and to install the new version of the program.
;
@MD0:ICQBLD.BLD
SET /UIC='SAVUIC'
ASN =KT0:
ASN =KT1:
ASN =MD0:
.EXIT 1
.DOMODS:
.IFT RLKIT @MD0:CMPBLD.BLD
.SETF DOHEX
.SETF DOEXE
.SETF DOSGN
.SETF DOXE
;
; The site specific modifications used at Goodyear Aerospace are performed
; by this command file.
;
; The HEXMOD.CMD and HEXMOD.COR files are used to apply changes to the
; standard RSX11M command line interpreter subroutines to support
; hexadecimal numeric data items in command lines.  These changes should be
; applied after copying an RSX11M distribution kit to disc and applying
; RSX11M V4.1 Update D to the baseline distribution.  These changes are applied
; by invoking @HEXMOD.  The command file extracts object and macro definition
; modules from SYSLIB and RSXMAC, disassembles the objects to source
; and applies a SLP update procedure to the resulting files.  The modified
; source files are then compared to the expected results before finishing
; the procedure.  The user is given an opportunity to stop the procedure
; if there are any errors found in the comparison.  (Errors at this step
; indicate that DEC has made some changes in the updated baseline that
; could effect the results of using the GAC patch.)
;
; If the user indicates that there were no errors found, the procedure
; continues by assembling the affected modules and replacing them in
; SYSLIB and RSXMAC.
;
.ASK DOHEX Do the HEXMOD patches now (before SYSGEN)
;
; The EXEDRVMOD.CMD and EXEDRVMOD.COR files are used to apply some changes
; to the RSX11M Executive sources and SYSGEN command files to allow
; an RSX11M system to be generated with support for loadable drivers with
; loadable data bases.  The Executive changes are made to SYSCM.MAC,
; and INITL.MAC in order to eliminate link time global references
; to .TT0 and .CO0.  The necessary fields in the executive data bases
; are filled in by the code added to INITL that is executed at virgin
; system bootstrap.
;
; These patches also modify the source code for PMT, the pool monitor task,
; and the object library of COT, the console output task.  These changes
; are made to remove link-time global references to .TT0 and .CO0 as
; well.
;
; Note:  These patches can stand alone.  It is not necessary to apply
;	 the SYSGEN patches following, however these changes are required
;	 if the SYSGEN patches following are to be done.
;
; Note:  These patches also change MDSUB.MAC in RSX11M to properly perform
;	 disc write checking support.
;
.ASK DOEXE Do the loadable driver Executive patches now (before SYSGEN)
.SETF DOSGN
.IFF DOEXE .GOTO NOSGN
;
; The SYSGENMOD.CMD and SYSGENMOD.COR files are used to apply changes to
; the SYSGEN command files to allow the generation of an RSX11M Executive
; that will support loadable data bases for ALL device drivers including
; DEC supplied drivers.
; 
.ASK DOSGN Do the loadable driver SYSGEN patches now (before SYSGEN)
.NOSGN:
;
; The DEUNA device driver distributed with RSX11M V4.1 Update D has a
; serious error when processing diagnostic function QIO's that do not
; perform data transfers.  This command procedure applies a GAC
; developed fix to the driver that repairs the problem.
;
.SETT DOXE
;
.ASK ALONE Do you wish unattended application of the GAC patches
.IFT ALONE .ENABLE TIMEOUT
.IFF ALONE .DISABLE TIMEOUT
;
.IFT DOHEX @MD0:HEXMOD
.IFT DOEXE @MD0:EXEDRVMOD
.; Do not do the following patches without the EXEDRVMOD patches above.
.IFT DOEXE .IFT DOSGN @MD0:SYSGENMOD
.IFT DOXE @MD0:XEDRVMOD
SET /UIC='SAVUIC'
ASN =KT0:
ASN =KT1:
ASN =MD0:
