#include <clang.c>;
#include <signal.c>;
#include <cx.h>;

WFLOR(narg, efn1)
int narg; int *efn1;
{
register int mask, group, **pnextarg; 
int efn, g, i;
#define nogroup -32768
plient("WFLOR");
iff narg==0 then signal(NUMARGS);
mask = 0;
group = nogroup;
pnextarg = &efn1;
for ( i=1; i<=narg; i++ )
 {
  efn = (**pnextarg++) - 1;
  iff group != (g = efn>>4)
    then
     {
      iff group == nogroup
        then group = g;
	else
    	 {
	  msg("WFLOR call with event flags not in same group");
	  signal(ERROR);
	 }
     }
   mask |= 1 << (efn & 0xF/*low 4 bits*/);
  }
switch(group)
 {
  case 0: wtlo0(mask);
	  goto done;
  case 1: wtlo1(mask);
	  goto done;
  case 2: wtlo2(mask);
	  goto done;
  case 3: wtlo3(mask);
	  goto done;
  case 4: wtlo4(mask);
	  goto done;
  case 5: wtlo5(mask);
	  goto done;
  default: $dsw = (int)(char)IE_IEF; /*illegal event flag number*/
 }				/*don't know why cx.h defines as byte*/
done:
iff $dsw!=IS_SUC
  then
   {
    msgti("error on WFLOR, dsw = %", $dsw);
    signal(ERROR);
   }
}
