.; [2,24]AUTOBCKUP.CMD		R RHODERICK			6-FEB-85
.;
.; - Nightly automatic incremental backup of system disks.  Backs up any files
.;   created or revised since the date/time of the last successful backup from
.;   any specified physical or logical devices.  This command file should be run
.;   when there is absolutely no disk activity going on, to assure accurate
.;   duplication of files at a known time.  To avoid problems with higher-level
.;   system operations, files in several accounts on LB0: ([1,4], [1,6],
.;   and [1,7]*.SYS) are not duplicated.  Additionally, any files in account
.;   [1,3] on any disk are ignored.  The strings SKPLB0 and SKPALL define the
.;   accounts/files to skip, and may be modified as needed.
.;   The date and time an input device is successfully backed up by this
.;   process is saved in a file on each disk backed up for reference the next
.;   time this process is run.  The string FILSPC contains the location (UIC)
.;   and name of this file, and should be modified if needed.  This file
.;   must be found on each disk with files to be backed up.  The format of
.;   this file is:
.;      First record:	LAST AUTOMATIC BACKUP
.;      Second record:	dd-yyy-yy hh:mm:ss
.;    This procedure will back up files created or revised after the
.;    'dd-mmm-yy hh:mm:ss' date/time.  If this procedure successfully backs
.;    up files from an input device, it then saves the current date/time in
.;    a new file on the backed up disk.  If the input disk is duplicated (as
.;    in online pack duplication for archival purposes, etc.), this file
.;    should reflect the date/time the pack is duplicated.
.;
.; - Input devices:
.;   The string INLIST defines all the physical or logical devices to back up,
.;   and may be modified as needed.  This procedure will only back up files
.;   from a specified device if that device is already MOUNTED as a PUBLIC
.;   device, and contains an autobackup reference file.
.;   **NOTE**   The device to back up TO must not be included in the list
.;   of devices to back up FROM.
.; - Output device:
.;   Files to back up are BRUed to logical device NB0:, if it has been
.;   defined (ie., "ASN DR4:=NB0:/GBL").  If it has not, no backup occurs.
.;   If NB0: is assigned to a disk device, the string DLABEL must contain the
.;   label of the pack to back up to.  The default label is the DECNET node
.;   name with the string "BACKUP" appended to it, ie, "DENVERBACKUP".  If for
.;   any reason the pack cannot be logically mounted with the proper label, no
.;   backup occurs.
.;   If NB0: is assigned to a tape device, this process will attempt to append
.;   a backup set to it.  For this reason, the tape must be initialized before
.;   this process uses it:  "BRU/REW/DENS:nn LB0:[1,1]Z.Z Mdu:" will initialize
.;   the tape, where nn is either 800 or 1600, d is M, T, or S, depending on
.;   your type of tape drive, and u is the unit number of the tape drive.
.; - Post backup processing:
.;   If the output device is a disk device, it may be desirable to limit the
.;   number of versions of backed up files to conserve space.  This procedure
.;   will attempt to purge the files on the output disk to the number of
.;   versions specified in variable VERS.  If VERS is 0, no files on the backup
.;   disk are purged.
.;   If DECNET software is used, FTS (network despooler task) log files tend to
.;   accumulate.  This procedure will look for FTS.LOG files on any disk it
.;   backs up from, and deletes them after it backs up the device.  If you don't
.;   want these files deleted, set the variable FTS to FALSE.
.;
	.ENABLE SUBSTITUTION
	.ENABLE GLOBAL


.; these definitions may be changed as required:
    .; list of devices (physical or logical) to back up
	.SETS INLIST "LB0:,UD1:,UD2:,UD3:,UD4:"
    .; UICs/files to skip backing up from LB0:  (BRU /EXCLUDE string format)
	.SETS SKPLB0 "[1,4],[1,6],[1,7]*.SYS"
    .; UICs/files to skip backing up from any disk (BRU /EXCLUDE string format)
	.SETS SKPALL "[1,3],[2,24]INITDATE.DAT"
    .; label of disk to back up to
	.SETS DLABEL <NETNOD>+"BACKUP"
    .; complete filespec of file to store last successful backup devices/dates
	.SETS FILSPC "[2,24]AUTOBCKUP.DAT"
    .; name of temporary BRU command file
	.SETS BRUFIL "LB0:[1,4]AUTOBRU.CMD"
    .; number of versions to purge all files on backup disk to
    .; (if set to zero, files on the backup disk will not be purged)
	.SETN VERS 3
    .; FTS determines whether to delete FTS.LOG files from backed up disks
	.SETT FTS


	.SETF MOUNTD
	.SETF PIPREM
	.SETF BRUREM
	.SETF MOUREM
	.SETF DMOREM

	.; install PIP, BRU, MOU and DMO if they are not installed
	.ENABLE QUIET
	.IFNINS PIP .SETT PIPREM
	.IFT PIPREM INS $PIP
	.IF <EXSTAT> NE 1 .GOTO INSERR
	.IFNINS BRU .SETT BRUREM
	.IFT BRUREM INS $BRU
	.IF <EXSTAT> NE 1 .GOTO INSERR
	.IFNINS MOU .SETT MOUREM
	.IFT MOUREM INS $MOU
	.IF <EXSTAT> NE 1 .GOTO INSERR
	.IFNINS DMO .SETT DMOREM
	.IFT DMOREM INS $DMO
	.IF <EXSTAT> EQ 1 .GOTO CLNUP
.INSERR:
;
; ERROR - could not install BRU, PIP, MOU or DMO - no backup done
;
	.GOTO EEXIT


.CLNUP:
	.; delete any BRU command files this procedure may have left earlier
	PIP 'BRUFIL';*/DE/NM
	.DISABLE QUIET

	.; check for output device (logical NB0:)
	.TESTDEVICE NB0:
	.TEST <EXSTRI> "NSD"
	.IF <STRLEN> EQ 0 .GOTO OKNB0

;
; ERROR - Nightly Backup process logical output device ( NB0: ) not found
;		-- NO BACKUP DONE --
;
	.GOTO EEXIT


.OKNB0:
	.; check if FTSDEQ task is installed
	.IFNINS FTSDEQ .SETF FTS
	.; start list of physical devices finished
	.PARSE <EXSTRI> ":" OULIST GARBAG
	.SETS OULIST OULIST+":"

	.; set up BRU switch for disk output device
	.SETS SW "/NOINITIALIZE/UFD/SUPERSEDE"

	.; check to see if the output device is a tape unit
	.SETF TAPE
	.SETS CHAR OULIST[1:1]
	.IF CHAR NE "M" .GOTO MNT
	.SETS CHAR OULIST[2:2]
	.IF CHAR NE "F" .IF CHAR NE "M" .IF CHAR NE "S" .IF CHAR NE "T" .GOTO MNT
	.SETT TAPE
	.; output to tape device - set up BRU switch for tape unit
	.SETS SW "/DENS:1600/REWIND/APPEND"
	.IF CHAR EQ "T" .SETS SW "/DENS:800/REWIND/APPEND"
	.GOTO BACKUP

.; output to disk device - make sure the correct pack is in the correct drive
.MNT:	.ENABLE QUIET
	MOU NB0:'DLABEL'
	.DISABLE QUIET
	.IF <EXSTAT> EQ 1 .SETT MOUNTD
	.IFT MOUNTD .GOTO BACKUP
;
; ERROR occured during nightly backup; could not mount backup disk pack -
;	no backup done
;
	.GOTO EEXIT


.BACKUP:
;
; Begin automatic nightly files backup to 'OULIST' at '<TIME>' on '<DATE>'
;

	.; Find devices and back them up
	.GOSUB NXTDEV

.; Backup finished - do any other housekeeping

	.; Purge all but three highest versions of backed up files
	.ENABLE QUIET
	.; (trap indirect errors, in case user deleted symbol VERS)
	.ONERR NOPURG
	.IF VERS GT 0 .IFF TAPE PIP NB0:[*,*]*.*/NM/PU:'VERS'
.NOPURG:
	.DISABLE QUIET
	;
	; End automatic nightly files backup at '<TIME>' on '<DATE>'
	;

.EEXIT:
.; remove tasks we installed, dismount output disk
	.ENABLE QUIET
	.IFT PIPREM REM PIP
	.IFT BRUREM REM BRU
	.IFT MOUREM REM MOU
	.IFT DMOREM REM DMO
	.IFT MOUNTD DMO NB0:
	.EXIT

.;**********************************************************************
.; Find next device to back up
.NXTDEV:
	.; Get next name from input device list
	.PARSE INLIST "," INDEV INLIST
	.IF INDEV EQ "" .RETURN
	.SETF INLB0
	.IF INDEV EQ "LB0:" .OR .IF INDEV EQ "LB00:" .SETT INLB0

	.; Find out physical device name
	.TESTDEVICE 'INDEV'
	.; Make sure this device exists
	.TEST <EXSTRI> "NSD"
	.IF <STRLEN> GT 0 .GOTO NXTDEV
	.PARSE <EXSTRI> ":" INDEV GARBAG
	.SETS INDEV INDEV+":"
	.; See if we've already backed up this device
	.TEST OULIST INDEV
	.IF <STRLEN> GT 0 .GOTO NXTDEV
	.; Make sure the input device is mounted - if not, don't back it up
	.TEST <EXSTRI> "MTD"
	.IF <STRLEN> EQ 0 .GOTO NXTDEV
	.; Make sure the input device is public - if not, don't back it up
	.TEST <EXSTRI> "PUB"
	.IF <STRLEN> EQ 0 .GOTO NXTDEV
	.; Look for file specifying last time this disk was backed up
	.TESTFILE 'INDEV''FILSPC'
	.IF <FILERR> NE 1 .GOTO NXTDEV


    .; OK to back it up -add it to the list of physical devices backed up
	.SETS OULIST OULIST+INDEV

    .; go back up from INDEV to NB0:
	.GOSUB DOBRU

    .; Go find another device to back up
	.GOTO NXTDEV
.;**********************************************************************

.;**********************************************************************
.DOBRU:

    .; set up /EXCLUDE UICs/files command line
	.SETS EXCLUD FILSPC
	.TEST SKPALL
	.IF <STRLEN> GT 0 .SETS EXCLUD EXCLUD+","+SKPALL
	.TEST SKPLB0
	.IFT INLB0 .IF <STRLEN> GT 0 .SETS EXCLUD EXCLUD+","+SKPLB0

    .; set up arguments specifying /REVISED:AFTER: date and time
    .;	using date and time from this device's autobackup reference file
	.; format of file: first record: LAST AUTOMATIC BACKUP
	.;		  second record: dd-mmm-yy hh:mm:ss
.GETRC:	.OPENR 'INDEV''FILSPC'
	.IF <FILERR> EQ 1 .GOTO RDREC
;
; ERROR - could not open autobackup reference file 'INDEV''FILSPC'
;	  Device not backed up.
;
	.GOTO BRUDON

.RDREC:	.READ REC
	.IFF <EOF> .GOTO TSTREC
;
; ERROR reading last backup date/time from autobackup reference file on 'INDEV'
;	Device not backed up.
;
	.CLOSE
	.GOTO BRUDON

.TSTREC:
	.; Skip record if it's the header
	.TEST REC "BACKUP"
	.IF <STRLEN> GT 0 .GOTO RDREC
	.PARSE REC " " DAT TIM
	.CLOSE

    .; make indirect command file to pass to BRU
	.OPEN 'BRUFIL'
	.DATA 'SW'/MOUNTED/EXCLUDE/VERIFY-
	.DATA /REVISED:AFTER:('DAT' 'TIM')
	.DATA 'INDEV''EXCLUD'
	.DATA NB0:
	.CLOSE
	
; '<TIME>'    Backing up files from 'INDEV'
	.ENABLE QUIET
	BRU @'BRUFIL'
	.DISABLE QUIET

	.; check if BRU completed ok (allow exit with WARNING status)
	.IF <EXSTAT> LE 1 .GOTO UPDATE
;
; ERROR occured during backup from 'INDEV' - BRU did not complete successfully.
;	I/O error code  '<EXSTAT>'
	.GOTO BRUDON

.UPDATE:
    .; write time/date of this successful backup to new reference file
	.OPEN 'INDEV''FILSPC'
	.IF <FILERR> EQ 1 .GOTO WRIT
;
; ERROR - Cannot write current backup date/time to 'INDEV''FILSPC' -
;
	.GOTO BRUDON
.WRIT:
	.DATA LAST AUTOMATIC BACKUP
	.DATA '<DATE>' '<TIME>'
	.CLOSE
    .; delete DECNET FTS log files
	.IFF FTS .GOTO BRUDON
	.ENABLE QUIET
	PIP 'INDEV'[*,*]FTS.LOG;*/DE/NM
	.DISABLE QUIET

.BRUDON:
    .; purge old reference files, delete BRU command file
	.ENABLE QUIET
	PIP 'INDEV''FILSPC'/PU:3/NM
	PIP 'BRUFIL';*/DE/NM
	.DISABLE QUIET
	.RETURN
.;**********************************************************************
