#include <cx.h>
#include <stdio.h>

#define	NDQLUN	8	/* lun for network data que */
#define	LINKLUN	7	/* lun for network link */

#define IS_SUC	1	/* sucess return */

struct conblk {		/* connect block */
  byte n_rnd[6];
  byte n_rfm;
  byte n_rot;
  word n_rdec;
  byte n_rde[16];
  word n_ridc;
  byte n_rid[16];
  word n_rpsc;
  byte n_rps[8];
  word n_racc;
  byte n_rac[16];
  } ;

char tstmsg[] = "This is test message 0";

$$nargs=1;

main()
{
  word iosb[2];	/* io status block */
  word status;
  int i;
  byte *bp;

  bp = iosb;

  netopn("DEVSYS", "REC10");

  for (i=0; i <= 9; i++) {
    status = sndwnt(LINKLUN, 2, iosb, 0, tstmsg, strlen(tstmsg));
    dirtst(status, bp, "sndw failed");
    }

  netcls();
  exits(1);
}

netopn(dest_node, dest_task)
char *dest_node, *dest_task;
{
  struct conblk conbuf;
  word iosb[2];	/* io status block */
  word status;
  byte *bp;

  bp = iosb;

  status = alunx(NDQLUN, "NS", 0);
  dirtst(status, 0, "alun 1 failed");
  if (status != 1) fatal("alun 1 failed", status, iosb);

  status = alunx(LINKLUN, "NS", 0);
  dirtst(status, 0, "alun 2 failed");

  status = opnwnt(NDQLUN, 1, iosb, 0, 0, 0);
  dirtst(status, bp, "opnw failed");
  if ((status != 1) || (*bp != 1)) fatal("opnw failed", status, iosb);

/* fill connect request block */

  conb0(&conbuf, dest_node, dest_task);	/* fill con req block */

  status = conwnt(LINKLUN, 2, iosb, 0, 
		&conbuf, sizeof conbuf, 0, 0, 0, 0);
  dirtst(status, bp, "conw failed");

  return(1);
}

conb0(conp, node, task)
struct conblk *conp;
char *node, *task;
{
  int len;

  zero(conp, (sizeof (struct conblk)));
  fill(conp->n_rnd, 040, 6);	/* put spaces in node name */
  fill(conp->n_rde, 040, 16);	/* and destination task */

  len = strlen(node);
  copy(conp->n_rnd, node, (len > 6 ? 6 : len));

  conp->n_rdec = ((len = strlen(task)) > 16) ? 16 : len;
  copy(conp->n_rde, task, conp->n_rdec);

  conp->n_rfm = 1;	/* type 1 descriptor */
  conp->n_rot = 0;	/* object type 0 */

  return(1);
}

netcls()
{
  word iosb[2];	/* io status block */
  word status;
  byte *bp;

  bp = iosb;

  status = dscwnt(LINKLUN, 2, iosb, 0, 0,0);
  dirtst(status, bp, "dscw failed");

  return(1);
}

dirtst(dstat, pio, msg)
int dstat;
char *pio, *msg;
{
  if ((dstat >= 0) && ((pio == 0) || (*pio == 1))) return(0);
  fatal(msg, dstat, pio);
}

fatal(msg, dsw, fiosb)
char *msg;
word dsw, *fiosb;
{
  printf("FATAL:%s: \ndsw:%o, fiosb:%o:%o\n", 
			msg, dsw, *fiosb++, *fiosb);
  exits(4);
}
