#include <cx.h>
#include <stdio.h>

#define	NDQLUN	8	/* lun for network data que */
#define	LINKLUN	7	/* lun for network link */

#define NT_CON	1	/* connect */
#define NT_DSC	3	/* disconnect */
#define NT_INT	2	/* interrupt */

#define IS_SUC	1	/* sucess return */
#define IE_NDA	-78	/* no data */

struct conblk {		/* connect block */
  word n_ctl;
  word n_segz;
  byte n_dfm;
  byte n_dot;
  byte n_snd[6];
  byte n_sfm;
  byte n_sot;
  word n_cidc;
  byte n_cid[16];
  word  n_cpsc;
  byte n_cps[8];
  word n_cacc;
  byte n_cac[16];
  word n_cdev;
  byte n_cuni;
  byte n_xxx;
  word n_cuic;
  byte n_xxz[40];
  word n_cdac;
  byte n_cda[16];
  } conbuf;

int flag = 0;

$$nargs=1;

main()
{
  word iosb[2];	/* io status block */
  extern word cmpast();
  extern word netast();
  word status;
  char text[80], *tp;
  int i;
  byte *bp;

  bp = iosb;
  tp = text;

  clef(10);	/* just in case */

  status = alunx(NDQLUN, "NS", 0);
  if (status != 1) fatal("alun 1 failed", status, iosb);

  status = alunx(LINKLUN, "NS", 0);
  if (status != 1) fatal("alun 2 failed", status, iosb);

  status = opnwnt(NDQLUN, 1, iosb, 0, 0,0);
  if ((status != 1) || (*bp != 1)) fatal("opnw failed", status, iosb);

  status = spawnt(NDQLUN, 1, iosb, &cmpast, &netast);
  if ((status != 1) || (*bp != 1)) fatal("spaw failed", status, iosb);

  wtse(10);

  dsar();
  printf(" connected \n");
  enar();

  while (flag == 0) {
    status = recwnt(LINKLUN, 2, iosb, 0, tp, 80);
    if ((status != 1) || (*bp != 1)) fatal("recw failed", status, iosb);
    *(tp + iosb[1]) = 0;		/* null string */
    dsar();
    printf("r10:%s\n", tp);
    enar();
    }

  status = clswnt(NDQLUN, 1, iosb, 0);
  if ((status != 1) || (*bp != 1)) fatal("clsw failed", status, iosb);
  exit(1);
}

word cmpast()
{
  byte *piosb;	/* pointer  to iosb */

  astset();
  piosb = gtdp(0);	/* point to iosb */
  if (*piosb != 1) fatal("spaw failed", 0, piosb);
  piosb += 2;		/* move 1 word */
  if (*piosb < 0) get_msg(*piosb);
  astx(1);
}

word netast()
{
  astset();
  get_msg(1);
  astx(0);
}

get_msg(msgcnt)
int msgcnt;
{
  char *cp;
  word iosb[2];
  byte *bp;
  word status;

  cp = &conbuf;
  bp = iosb;

  while (msgcnt-- > 0) {
    status = gndwnt(NDQLUN, 1, iosb, 0, 
		&conbuf, (sizeof (struct conblk)), 0);
    if (status == IE_NDA) return(1);	/* no data waiting */

    if ((status != IS_SUC) || (*bp++ != 1))
		  fatal("gndw failed", status, iosb);

    switch (*bp) { 
	case NT_CON:	{
    		status = accwnt(LINKLUN, 2, iosb, 0, 
				&conbuf, (sizeof (struct conblk)), 0,0);
		bp = iosb;
    		if (*bp != IS_SUC) fatal("accw failed", status, iosb);
  		setf(10);
		break;
  		}    
	case NT_DSC:	{
    		flag = 1;
		break;
  		}    
    
	case NT_INT:	{
    		*(cp + iosb[1]) = 0;	/* make a string */
    		printf("INT:%s\n", cp);
		break;
  		}    
    
	default:	fatal("unexpected msg", status, iosb);
	}
  }

  return(1);
}


fatal(msg, dsw, fiosb)
char *msg;
word dsw, *fiosb;
{
  printf("FATAL:%s: \ndsw:%o, fiosb:%o:%o\n", 
			msg, dsw, *fiosb++, *fiosb);
  exit(4);
}
