.; Command file to generate CDC.MAC, conditionals file for CD: driver
.; Mayo Clinic, October, 1984

	.enable escape,substitution

	.testdevice TI:
	.parse <EXSTRI> ":" TT DMY
	.open CDC'TT'.TMP
	.data ; CDC.MAC  Conditionals file
	.data ; '<DATE>' '<TIME>'
	.data ;
	.data LD$CD	=0	;If defined, loadable driver

.11:	.ask [<TRUE>] SWRG Does the target system have a switch register
	.iff <ESCAPE> .goto 12
	;   The switch register is used as the source for a random number used as the
	;   delay count for restarting the communications protocol.
	.goto 11
.12:	.ift SWRG .goto 31
	.parse <TIME> ":" DMY DMY TMP
.21:	.askn [0.:60.:'TMP'.] TICS Enter the number of ticks to wait between starts
	.iff <ESCAPE> .goto 22
	;   Since the target system has no switch register, the symbol DLTICS defines
	;   the delay count (in tics) for restarting the communications protocol.  This
	;   value must be different for each system not using a switch register.
	.goto 21
.22:	.data DLTICS	='TICS'.	;Delay ticks

.31:	.askn [0:3:1] N11W Enter the number of physical DR11-W devices
	.iff <ESCAPE> .goto 32
	;   Primarily, this driver supports DR11-W hardware but also an internal
	;   communications link and may be assembled without any physical DR11-W device
	;   support.  Enter here only the number of physical DR11-Ws, not including
	;   the internal device.
	.goto 31
.32:	.data D$$11W	='N11W'	;Number of DR11-W units
	.data NUMR	=2	;Number of UMRs per unit
	.if N11W eq 0 .goto 70

	.setn VEC0 600
	.setn CSR0 163600
	.setn VEC1 500
	.setn CSR1 163500
	.setn VEC2 504
	.setn CSR2 163420

	.setn C 0
.50:	.setn TMPN 0
	.ifdf VEC'C' .setn TMPN VEC'C'
.51:	.askn [::'TMPN'] VEC What is the vector for CD'C':
	.iff <ESCAPE> .goto 52
	;   Enter the vector for this physical DR11-W.
	.goto 51
.52:	.data VEC$'C'	='VEC'	;Vector for CD'C':
	.setn TMPN 0
	.ifdf CSR'C' .setn TMPN CSR'C'
.56:	.askn [::'TMPN'] CSR What is the CSR for CD'C':
	.iff <ESCAPE> .goto 57
	;   Enter the CSR for this physical DR11-W.
	.goto 56
.57:	.data CSR$'C'	='CSR'	;CSR for CD'C':
	.inc C
	.if C le N11W-1 .goto 50

.70:	.setn C N11W
.71:	.ask [<TRUE>] TF Do you want to include the internal communications link
	.iff <ESCAPE> .goto 72
	;   Primarily, this driver supports DR11-W hardware but also an internal
	;   communications link.  This internal device can be thought of as a link from
	;   one processor to itself.  If included, this internal device will be CD'C':.
	.goto 71
.72:	.iff TF .goto 75
	.ift SWRG .setf QBUS
	.ift SWRG .goto 74
.73:	.ask [<TRUE>] QBUS Is the target processor a Q-bus machine
	.iff <ESCAPE> .goto 74
	;   We use the Boot PROM for the CSR of the internal device.  For Q-bus
	;   machines, this will be different from UNIBUS machines.
	.goto 73
.74:	.data ICDRV	=0	;If defined, internal device included
	.data VEC$'C'	=0	;Vector for CD'C': (internal device)
	.iff QBUS .data CSR$'C'	=165744	;CSR for CD'C': (internal device)
	.ift QBUS .data CSR$'C'	=173000	;CSR for CD'C': (internal device). Use Boot PROM address
.75:	.ift TF .inc N11W
	.if N11W eq 0 ; ***  FATAL ERROR -- No CD devices defined  ***
	.if N11W eq 0 .exit
	.data CD$NUM	='N11W'	;Total number units (including internal device)
	.data CDPR	=5*40	;DR11-W device priority

.81:	.ask [<FALSE>] TF Do you want to include the trace feature
	.iff <ESCAPE> .goto 82
	;   The driver may be generated with a trace feature invoked which will cause
	;   every interrupt, I/O request, I/O completion and other relevant actions to
	;   be traced in a trace common area of memory.  This feature incurs
	;   considerable overhead, but is extremely useful in debugging and tracking
	;   down hardware problems.  Even if the trace feature is assembled in the
	;   driver, tracing may be disabled by loading the driver without a partition
	;   named CDTRAC present in the system.  This eliminates 95% of the overhead
	;   of having the trace feature present.  Tracing may also be temporarily
	;   disabled by "freezing" the trace with the trace dump program CDDUMP.
	;   Freezing the trace cuts the overhead of tracing by 50%.  Tracing may have
	;   add as much as five ms per transfer and the driver code is increased in
	;   size by approximately 500 words.
	.goto 81
.82:	.ift TF .data TRCE	=1	;If defined, trace feature included
	.iff TF .data ;TRCE	=1	;If defined, trace feature included

.91:	.ask [<FALSE>] TF Do you want to include long timeout values
	.iff <ESCAPE> .goto 92
	;   The driver''s timeout values can be extended during testing for debugging
	;   purposes.
	.goto 91
.92:	.ift TF .data DBUG	=0	;If defined, timeout values extended
	.iff TF .data ;DBUG	=0	;If defined, timeout values extended
	.close
	.enable quiet
	PIP CDC.MAC/NV=CDC'TT'.TMP & CDC'TT'.TMP;*/DE/NM
