	.ENABLE SUBSTITUTION
	.ENABLE GLOBAL
	.ENABLE QUIET
	.ENABLE ESCAPE
	.DISABLE LOWERCASE
	.;
	.; File:	ERRDIS.CMD
	.; Author:	Robin Miller
	.; Date:	January 27, 1981
	.;
	.; Description:
	.;
	.; This command file is used to request the type of error report
	.; to be generated by the error logging report generator (RPT).
	.;
	.; Modification History:
	.;
	.; August 17, 1984 by Robin Miller.
	.;	Modify for RSX-11M+ V2.1 and add new switches.
	.;
	.; July 20, 1982 by Gary Larson.
	.; 	Implement changes for RSX-11M Version 4.0.
	.;
	.;**************************************************************
	.;
	.; Define exit status variables.
	.;
	.SETN EX$WAR 0			! Warning status
	.SETN EX$SUC 1			! Success status
	.SETN EX$ERR 2			! Error status
	.SETN EX$SEV 4			! Severe error
	.;
	.; Define error codes.
	.;
	.SETN IE$NSF 346		! No such file
	.SETS $NAME "ERRDIS --"		! Name for error messages
	.TESTDEVICE TI0:
	.PARSE <EXSTRI> ":" TERM NULL
	.IFINS ...CA. CLR
	.DISABLE QUIET
	;
	; Error Display Utility V3.0	'<DATE>'  '<TIME>'
	;
	.IF P1 <> "" .GOTO DLG
	.ENABLE QUIET
	.SETS RUIC "'<UIC>'"
	.DISABLE QUIET
	.GOTO DLG
.DLGH:
	;
	; Long dialogue results in a short explaination being displayed
	; before asking each question.  If you answer "N"o, help is still
	; available on a per question basis by pressing the <Escape> key.
	;
.DLG:	.ASK $DLG Do you want long dialogue (<Escape> for explaination)
	.IFT <ESCAPE> .GOTO DLGH
	.IFF $DLG .GOTO INP
	;
	; This program is used to request the type of error information
	; to be displayed by the Error Report Generator Utility (RPT).
	;
	; All questions have a default answer in parenthesis.  To select
	; the default answer, press the <Return> key.
	;
	;-----------------------------------------------------------------
.DL10:
	.IFF $DLG .GOTO INP
.INH:
	;
	; The next question requests the error file to be used as input to
	; the report file generator (RPT).  The error file which RPT uses
	; is "LB0:[1,6]LOG.ERR".  Unless this file has been renamed the
	; default should be used.
	;
	;     *** You can exit at any time by typing Ctrl/Z (^Z). ***
	;
.INP:
	.SETS $DEV "LB0:"
	.SETS $UIC "[1,6]"
	.SETS $FILES "LOG.ERR"
	.ASKS INFILE Input file (LB0:[1,6]LOG.ERR)  
	.IFT <ESCAPE> .GOTO INH
.;
.;	This is the default input file to RPT.
.;
.;	.IF <STRLEN> = 0 .SETS INFILE "LB0:[1,6]LOG.ERR"
	.IF <STRLEN> = 0 .GOTO I10
.;	@LB:[1,2]FILSPC 'INFILE'
.;	.IF <EXSTAT> <> 1 .OR .IFT $WILD .GOTO INP
.;	.SETS INFILE "'$FILSP'"
	.TESTFILE 'INFILE'
	.IF <FILERR> = 1 .GOTO I10
	;
	; File "'<FILSPC>'" does not exist, please try again !!!
	;
	.GOTO INP
.I10:	.IFF $DLG .GOTO OUTP
.OUTH:
	;
	; The next question requests where to write the error report.  The
	; report can be directed to a terminal, a line printer, or a disk
	; file.  The default is to output to the line printer.
	;
.OUTP:
	.SETS CMD ""
	.SETS $DEV "SY0:"
	.SETS $UIC "'<UIC>'"
	.SETS $FILES "ERRREPORT.LST"
.;	.SETF SPOOL
.;	.ASKS OUTFIL Output file ('TERM':)            
	.ASKS OUTFIL Output file (LP0:)             
	.IFT <ESCAPE> .GOTO OUTH
.;	.IF <STRLEN> = 0 .SETS OUTFIL "'TERM':"
	.IF <STRLEN> = 0 .SETS OUTFIL "LP0:"
	.IF <STRLEN> = 0 .GOTO O10
	.PARSE OUTFIL "." NAME EXT
	.IF EXT = "" .SETS OUTFIL "'OUTFIL'.LST"
.;	@LB:[1,2]FILSPC 'OUTFIL'
.;	.IF <EXSTAT> <> 1 .OR .IFT $WILD .GOTO OUT
.;	.SETS OUTFIL "'$FILSP'"
.;
.;	RSX-11M+ has transparent spooling.
.;
.;	.IFNACT QMG... .GOTO O10
.;	.SETS ODEV $DEV[1:2]
.;	.IF ODEV <> "LP" .GOTO O10
.;	.SETT SPOOL
.;	.SETS SPDEV "'$DEV'"
.;	.SETS OUTFIL "'$UIC''$FILES'"
.O10:	.IFF $DLG .GOTO SOPT
.SOPTH:
	;
	; The next question allows you to select a summary report.
	;
	; The Summary Options are:
	;
	;    All      -  Selects all summary reports.
	;    Error    -  Selects summary report based on device errors.
	;    Geometry -  Selects summary report based on disk geometry.
	;    History  -  Selects summary report based on error history.
	;    None     -  Create no summary reports.
	;
.SOPT:
	.ASKS SUM Summary Options (None)         
	.IFT <ESCAPE> .GOTO SOPTH
	.IF SUM = "" .SETS SUM "N"
	.SETS SUM SUM[1:1]
.;
.;	The RPT utility gives an "Unknown argument" with /SU:N
.;
	.IF SUM = "N" .GOTO S20
	.IF SUM = "A" .OR .IF SUM = "E" .GOTO S10
	.IF SUM = "G" .OR .IF SUM = "H" .OR .IF SUM = "N" .GOTO S10
	;
	; Illegal option "'SUM'", press the <Escape> key for valid options.
	;
	.GOTO SOPT
.S10:	.SETS CMD "'CMD'/SU:'SUM'"
.S20:	.IFF $DLG .GOTO HOPT
.HOPTH:
	;
	; The next question allows you to select the type of error(s) to
	; be reported.  By default, all hardware errors are reported.
	;
	; The Hardware Options are:
	;
	;    All        -  Selects all packets in the error file.
	;    Control    -  Selects command packets from the ELI task.
	;    Errors     -  Selects processor, memory, and peripheral errors.
	;    Memory     -  Selects memory events, such as parity errors.
	;    Peripheral -  Selects all or selected peripheral errors.
	;    Processor  -  Selects CPU events, such as unknown interrupts.
	;    System     -  Selects system events, such as time changes,
	;                  system service messages, and mounts/dismounts.
	;
.HOPT:
	.ASKS HDW Hardware Options (Errors)      
	.IFT <ESCAPE> .GOTO HOPTH
	.IF HDW = ""  .SETS HDW "ER"
	.SETS HO HDW[1:1]
	.IF HO = "P" .SETS HO HDW[1:2]
	.IF HO = "A" .OR .IF HO = "C" .OR .IF HO = "E" .GOTO H10
	.IF HO = "M" .OR .IF HO = "PE" .OR .IF HO = "PR" .GOTO H10
	.IF HO = "S" .GOTO H10
	;
	; Illegal option "'HDW'", press the <Escape> key for valid options.
	;
	.GOTO HOPT
.H10:	.SETS CMD "'CMD'/T:'HDW'"
	.IF HDW <> "PE" .GOTO DE10
	.IFF $DLG .GOTO DEV
.DEVH:
	;
	; The next question allows you to select error(s) for a specific
	; device or all devices.
	;
	; Examples:
	;    DL     -  Reports errors on all RL01/2 drives.
	;    DL1:   -  Reports errors on RL01/2 drive 1 only.
	;    DB,DL  -  Reports errors an all RP06's & RL01/2's.
	;
	; If you want error(s) for all devices, press the <Return> key.
	;
.DEV:
	.ASKS DEVICE Device name (All)              
	.IFT <ESCAPE> .GOTO DEVH
	.IF DEVICE = "" .SETS DEVICE "ALL"
	.SETS CMD "'CMD'/DE:('DEVICE')"
.DE10:	.IFF $DLG .GOTO FREP
.FREPH:
	;
	; The next question asks for the format of the error report.  The
	; valid options are:
	;
	;    Brief    -  Display one packet per line.
	;    Full     -  Display all information in a packet.
	;    None     -  Do not display information on packets.
	;    Register -  Display device registers for peripheral errors.
	;
.FREP:
	.ASKS FREPT Error report format (Brief)    
	.IFT <ESCAPE> .GOTO FREPH
	.IF FREPT = "" .SETS FREPT "B"
	.SETS FSW FREPT[1:1]
	.IF FSW = "B" .OR .IF FSW = "F" .GOTO F10
	.IF FSW = "N" .OR .IF FSW = "R" .GOTO F10
	;
	; Illegal option "'FREPT'", press the <Escape> key for valid options.
	;
	.GOTO FREP
.F10:	.SETS CMD "'CMD'/F:'FSW'"
	.IFF $DLG .GOTO DAT
.DATH:
	;
	; The next question allows you to select packets based on the date
	; that an event occured.  The valid options are:
	;
	;    Month           -  Selects errors for the previous month.
	;    Previous:n      -  Selects errors for the previous n days.
	;    Range:start:end -  Selects a starting and ending date.
	;    Today           -  Selects all errors logged today.
	;    Week            -  Selects errors for the previous week.
	;    Yesterday       -  Selects errors logged since yesterday.
	;
	; The date has the format:
	;
	;     dd-mmm-yy >>> Where dd = Day, mmm = Month, and yy = Year.
	;
.DAT:
	.ASKS DATE After Date (First entry)       
	.IFT <ESCAPE> .GOTO DATH
.;
.;	The following is the default date switch.
.;
.;	.IF DATE = "" .SETS DATE "/DA:R:*:*"
	.IF DATE = "" .GOTO D90
	.SETS DT DATE[1:1]
	.;
	.; No options for TODAY or YESTERDAY.
	.;
	.IF DT = "T" .OR .IF DT = "Y" .GOTO D50
	.;
	.; The MONTH qualifier selects the previous 31 days.
	.;
	.IF DT <> "M" .GOTO D10
	.SETS DATE "P:31"
	.GOTO D50
	.;
	.; The PREVIOUS qualifier must have the number of days.
	.;
.D10:	.IF DT <> "P" .GOTO D20
	.PARSE DATE ":" NULL DAYS
	.IF DAYS = "" .SETS DAYS "1"
	.SETS DATE "P:'DAYS'"
	.GOTO D50
	.;
	.; The RANGE qualifier must have a starting and ending date.
	.;
.D20:	.IF DT <> "R" .GOTO D30
	.PARSE DATE ":" NULL START END
	.IF START = "" .SETS START "*"
	.IF END = "" .SETS END "*"
	.SETS DATE "R:'START':'END'"
.;	.PARSE DATE "-" DAY MONTH YEAR
.;	.IF MONTH = "" .OR .IF YEAR = "" .GOTO DATH
	.GOTO D50
	.;
	.; The WEEK qualifier selects the previous 7 days.
	.;
.D30:	.IF DT <> "W" .GOTO D40
	.SETS DATE "P:7"
	.GOTO D50
.D40:	;
	; Illegal option "'DATE'", press the <Escape> key for valid options.
	;
	.GOTO DAT
.D50:	.SETS CMD "'CMD'/DA:'DATE'"
.D90:	.IFF $DLG .GOTO WID
.WIDH:
	;
	; The next question requests the width of the error report.  The
	; valid options are:
	;
	;    Narrow -  Generates a narrow (80) column report.
	;    Wide   -  Generates a wide (132) column report.
	;
	; Note that summary reports are always in wide format.
	;
.WID:
	.ASKS WIDTH Report width (Wide)            
	.IFT <ESCAPE> .GOTO WIDH
	.IF WIDTH = "" .GOTO W20
	.SETS W WIDTH[1:1]
	.IF W = "N" .OR .IF W = "W" .GOTO W10
	;
	; Illegal option "'WIDTH'", press the <Escape> key for valid options.
	;
	.GOTO WID
.W10:	.SETS CMD "'CMD'/W:'W'"
.W20:	.IFF $DLG .GOTO BAT
.BATH:
	;
	; The next question allows you to submit the running of the error
	; log report (RPT) utility to Batch to free your terminal.
	;
.BAT:
	.ASK BATCH Submit RPT to Batch         
	.IFT <ESCAPE> .GOTO BATH
	.;
	.; Prepare the command line for RPT.  If the command line is too
	.; long, the command line is stored in a command file using the
	.; terminal name as the file name.  If we're submitting to Batch,
	.; we always create a command file.
	.;
	.SETS CMDLIN "'OUTFIL'='INFILE''CMD'"
	.SETF FOPEN
	.SETS CMDFIL ""
	.SETN CMDSIZ 70.
	.IFNINS ...RPT .SETN CMDSIZ 50.
	.TEST CMDLIN
	.IF <STRLEN> < CMDSIZ .GOTO DOIT
	.SETT FOPEN
	.SETS CMDFIL "'<LOGDEV>':'<LOGUIC>''TERM'.CMD"
	.OPEN 'CMDFIL'
	.DATA 'OUTFIL'='INFILE''CMD'
	.CLOSE
	.SETS CMDLIN "@'CMDFIL'"
.DOIT:
	.IFF BATCH .GOTO ATTTY
	.;
	.; Build the command file to submit to Batch.
	.;
	.PARSE <ACCOUN> "," NAME NULL
	.PARSE NAME " " LAST FIRST
	.IF LAST = "" .SETS LAST "'TERM'"
	.SETS RPTFIL "'<LOGDEV>':'<LOGUIC>'RP'TERM'.CMD"
	.OPEN 'RPTFIL'
	.DATA $JOB 'LAST' '<LOGUIC>'
	.DATA $!
	.DATA $! Command file to run the Error Report Utility (RPT).
	.DATA $!
	.IFINS ...RPT .DATA $RPT 'CMDLIN'
	.IFNINS ...RPT .DATA $RUN $RPT/TASK=RP'TERM'/CMD="RPT 'CMDLIN'"
	.IFT FOPEN .DATA $PIP 'CMDFIL';0/DE
	.DATA $EOJ
	.CLOSE
	SUBMIT 'RPTFIL'/DE
	.EXIT
	.;
	.; Running from the terminal.
	.;
.ATTTY:	;
	; The Error Report is being generated at '<TIME>', please be patient ...
	;
	.ENABLE QUIET
	.IFINS ...RPT RPT 'CMDLIN'
	.IFNINS ...RPT RUN $RPT/TASK=RP'TERM'/CMD="RPT 'CMDLIN'"
	.DISABLE QUIET
	;
	; The Error Report "'OUTFIL'" completed at '<TIME>'.
	;
	.ENABLE QUIET
	.IFT FOPEN PIP 'CMDFIL';0/DE
.;	.IFF SPOOL .GOTO B20
.;	.IFINS ...PRI PRINT 'SPDEV'ERRLOG/FL='OUTFIL'/DEL
.;	.IFINS ...PRI .GOTO B20
.;	.DISABLE QUIET
.;	;---------------------------------------------------------------
.;	;
.;	; The "PRINT" command is not available.  The error log report
.;	; is in a file called "'OUTFIL'".  You can display this
.;	; file using the "TYPE" command (i.e., "TYPE 'OUTFIL'").
.;	;
.;	;---------------------------------------------------------------
.B20:	.DISABLE QUIET
.;	.GOTO DL10
