	.TITLE	TTICH - PATCH FOR ALTERNATE CLI SUPPORT
	.IDENT	/V2.19P/
	.ENABL	GBL
;
;+
;*****
;
;	TTICH.PAT - Patch to TTICH.MAC module of the RSX-11M terminal
;	 driver.  The patch involves determining the full CLI prompt
;	 for all CLI's and the default CLI prompt for those CLI's
;	 that aren't typically part of a vanilla RSX system, e.g. MCR/DCL,
;	 to be echoed in response to CTRL-R.  THIS IS A COSMETIC PATCH
:	 AND DOES NOT DIRECTLY INFLUENCE ALTERNATE CLI ACTIVITY.
;
;	 The full CLI prompt for Digital supplied CLI's (in systems
;	 supporting alternate CLI's) is contained 
;	 in the system common region of the executive (SYSCM)
;	 @ global symbols $CLIPT and $MCRPT.  These 2 symbols define:
;	 	1) TCB ADDRESS OF CLI DISPATCHER TASK
;		2) ASCIZ STRING OF CLI'S FULL PROMPT
;	 The default CLI prompt is hard coded into TTDRV'S data section,
;	 and is the unmodifiable <LF>">".
;
;	 Alternate CLI'S will place a similar set of information in
;	 the system pool which is linked to the CLI task as a receive 
;	 data packet that is never dequeued until the CLI is "ELIMINATED".
;	 Its format is,
;	 	1) TCB ADDRESS OF CLI DISPATCHER TASK
;		2) ASCIZ STRING OF CLI'S FULL PROMPT
;		3) ASCIZ STRING OF CLI'S DEFAULT PROMPT
;
;	NOTE: This patch is for RSX-11M+ V1.0, TTICH .IDENT /V2.19/.
;	 For other versions, extract and disassemble TTICH from TTDRV.OLB
;	 and find the lines resembling (follow local symbol I2CTR2):
;		MOV	#ASCLP,R3
;		MOV	#2,R2
;		TST	xx(R4)	; xx=30 or U.TFPB
;		BEQ	...
;	 and redefine STARTP to point to the MOV #ASCLP instruction.
;
;*****
;
;	P. Sorenson, 12/29/83
;	AEP/Interactive Graphics Section
;	Columbus, OH
;
;*****
;-
	.ENABL	LSB
	.PSECT
STARTP=2310
.=.+STARTP		; OFFSET = 42 (8) WORDS PAST "I2CTR2" ENTRY POINT
	MOV	U.CLI-U.TSTA(R5),R3	; GET CLI'S CONTROL BLOCK ADDRESS
	TST	(R3)+			; STEP PAST CLI'S TCB POINTER
	CMP	#$POOL,R3		; INFO IN SYSTEM POOL ??
	BHI	5$			; BRANCH IF NO, DEC CLI
	JMP	CLIP1			; TRANSFER CONTROL TO PATCH CODE
5$:	TST	U.TFPB(R4)		; DO FULL CLI PROMPT ??
	BEQ	10$			; BRANCH IF NO
	JMP	CLIP2			; TRANSFER CONTROL TO PATCH CODE
10$:	MOV	#ASCLP,R3		; PICKUP DEC DEFAULT PROMPT
	MOV	#2,R2
	JMP	ECHSTR			; ECHO PROMPT
	.DSABL	LSB
;
	.PSECT	PAT1
CLIP1:		; ENTRY POINT FOR ALL PROMPTS -- USER CLI'S
	TST	30(R4)			; DO FULL CLI PROMPT ??
	BNE	4$			; BRANCH IF YES
2$:	TSTB	(R3)+			; NO, SKIP OVER FULL PROMPT SO
	BNE	2$			;  POINT TO DEFAULT STRING
4$:
CLIP2:		; ENTRY POINT FOR FULL PROMPT -- DEC CLI'S
	MOV	R3,R2			; COPY START ADDRESS
2$:	TSTB	(R2)+			; HIT TERMINATOR ??
	BNE	2$			; BRANCH IF NO, LOOK AGAIN
	SUB	R3,R2			; COMPUTE STRING LENGTH
	JMP	ECHSTR			;  AND ECHO IT

	.END
