	SUBROUTINE DIS2BR(IHIS,IZMIN,IZMAX,IXMIN,IXMAX,IYMIN,IYMAX)
C
C	SUBROUTINE TO PLOT HISTOGRAMS ON THE ADM3A DUMB TERMINAL
C		IHIS	= HIST #
C
C		IZMIN,IZMAX	= SCALE FOR 1 OR 2 DIM HISTS
C			0	= AUTO SCALE
C		IZMIN		= ANY CONTOUR # FOR 2 DIM PLOT
C
	BYTE IB(80)
	INTEGER*4 IN2,IXMIN,IXMAX,IYMIN,IYMAX,IZMIN,IZMAX,JZMIN,JZMAX
	REAL	DIVS(12)
	COMMON	/MSCAL/XORG,XSC,YORG,YSC
	COMMON	/D2SAVE/IHS,IXSIZ,IYSIZ,IXS,IX0,IYS,IY0,ITYPE,
	1	IJUMP,JXMIN,JXMAX,JYMIN,JYMAX,JZMIN,JZMAX,IX,IY
	COMMON /SCRAT/IA(70),IB
	DATA	DIVS/1.,1.E1,1.E2,1.E3,1.E4,1.E5,1.E6,
	1	1.E7,1.E8,1.E9,1.E10,1.E11,1.E12/
	IHS	= IHIS
	IF(IHS .GT. 0) GO TO 15
	MIN	= -20*IHS + 1
	MAX	= MIN + 20
	DO 10 I	= MIN,MAX
	CALL GTITL(I,IB,5)				! GET 5 WORD TITLE
	CALL HSTAT(I,IXSIZ,IYSIZ,IXS,IX0,IYS,IY0,ITYPE)	! GET SIZES,SCALES
	IF(IXSIZ .LE. 0) GO TO 10			! none
	WRITE(5,1001) I,(IB(J),J=1,10)			! Write number,title
10	CONTINUE
	RETURN
15	DO 20 J	= 1,45
20	IB(J)	= ' '
	CALL GTITL(IHS,IB,5)				! GET 5 WORD TITLE
	CALL GTITL(0,IB(13),5)
	CALL TIME(IB(25))				! GET TIME
	CALL DATE(IB(37))				! GET DATE INTO ARRAY
	WRITE(5,1001) IHIS, (IB(J),J=1,45)
	CALL HSTAT(IHS,IXSIZ,IYSIZ,IXS,IX0,IYS,IY0,ITYPE)	! GET SIZES,SCALES
	ITYPE	= IAND("3,ITYPE)
	IJUMP	= 2
	IF(ITYPE .EQ. 1) IJUMP	= 1
	IF(IXSIZ .LE. 0) RETURN				! No hist to plot

C
C	SECTION TO DETERMINE SCALES + RANGES
C
	JXMIN	= (IXMIN-IX0)/IXS	! Minimum x index
	JXMAX	= (IXMAX-IX0)/IXS	! Max x index
	JYMIN	= (IYMIN-IY0)/IYS	! Same for y
	JYMAX	= (IYMAX-IY0)/IYS
	IF(IYMIN .EQ. 0 .AND. IYMAX .EQ. 0) JYMIN = IYSIZ ! Do whole y?
	IF(JXMIN .LT. 0)JXMIN	= 0		! Min index too small?
	IF(JYMIN .LT. 0)JYMIN	= 0
	IF(JXMAX .GE. IXSIZ)JXMAX	= IXSIZ-1	! Max index too big?
	IF(JYMAX .GE. IYSIZ)JYMAX	= IYSIZ-1
	IF(JXMIN+5 .LT. JXMAX) GO TO 25
	JXMIN	= 0		! Do whole x axis
	JXMAX	= IXSIZ-1
25	IF(JYMAX .GE. JYMIN) GO TO 30
	JYMIN	= 0
	JYMAX	= IYSIZ-1
30	CONTINUE
	IY	= JYMAX-JYMIN			! NUMBER OF SWEEPS
	IX	= JXMAX-JXMIN
	JZMIN	= IZMIN
	JZMAX	= IZMAX
	IF(JZMIN .LT. JZMAX) GO TO 40
	IF(JZMIN .GT. 0 .AND. IY .GT. 0) GO TO 400	! 2 dim hist?
	IN2	= 0
	K	= 1				! IF 2 D IGNORE OVERFLOW
	IF(IY .LE. 0) K	= 0			! 1D SO NO 2D OVERFLOW
	I	= JYMIN+K
	J	= JXMIN+1
	CALL HGET(IHS,JZMIN,IJUMP*(I*IXSIZ+J)+1,IJUMP,ISZ)
	JZMAX	= JZMIN
	DO 35 I	= JYMIN+K,JYMAX-K
	DO 35 J	= JXMIN+1,JXMAX-1
	CALL HGET(IHS,IN2,IJUMP*(I*IXSIZ+J)+1,IJUMP,ISZ)
	IF(IN2 .LT. JZMIN) JZMIN	= IN2
	IF(IN2 .GT. JZMAX) JZMAX	= IN2
35	CONTINUE
40	IF(IY .GT. 0) GO TO 400				! DO 2 DIM HIST

C
C	DO 1 DIMENSIONAL HIST
C
	IN2	= 0					! START WITH ZERO
	JXSTEP	= (JXMAX-JXMIN+68)/70			! Points to average
	IF(JXSTEP .LE. 0) JXSTEP = 1			! Limit it
	JZSTEP	= (JZMAX-JZMIN + 19)/20			! Z step
	IF(JZSTEP .LE. 0) JZSTEP = 1
	INDEX	= 0
	ICHAN	= JXMIN * IJUMP + 1			! First chan number
	DO 60 I	= JXMIN,JXMAX,JXSTEP
	INDEX	= INDEX + 1
	AVERAG	= 0.
	DO 50 J	= 1,JXSTEP
	CALL HGET(IHS,IN2,ICHAN,IJUMP,ISZ)		! GET VALUES DESIRED
	ICHAN	= ICHAN + IJUMP
50	AVERAG	= AVERAG + IN2
	AVERAG	= AVERAG / JXSTEP
	AVERAG	= AVERAG - JZMIN
	AVERAG	= AVERAG / JZSTEP
	IF(AVERAG .LT. 0.) AVERAG = 0.
	IF(AVERAG .GT. 20.) AVERAG = 20.
60	IA(INDEX)	= AVERAG		! Save vertical chan to plot
	DO 80 K	= 20,0,-1
	DO 70 I	= 1,INDEX
	IB(I)	= ' '
	IF(IA(I) .GE. K) IB(I)	= '*'
70	CONTINUE
	NUMBER	= JZMIN + K*JZSTEP
80	WRITE(5,1001) NUMBER, (IB(I),I = 1,INDEX)
1001	FORMAT(1X,I7,1X,70A1)
	GO TO 600

C
C	DO 2 DIMENSIONAL HISTS HERE
C
400	CONTINUE
	JZMIN	= JZMAX/2
	IF(JZMIN .LE. 0) JZMIN	= 1			! Minimum countour
	JXSTEP	= 1
401	IYSTEP	= 10
	IF(IX .GT. 69) IX	= 69
	IF(IY .GT. 20) IY	= 20
	DO 500 IYP	= IY,0,-1
	MAX	= 0
	DO 490 IXP	= 0,IX
	I	= JXMIN + IXP + (JYMIN + IYP)*IXSIZ
	I	= IJUMP*I + 1
	CALL HGET(IHS,IN2,I,IJUMP,ISZ)
	IB(IXP+1)	= ' '				! DEFALUT PLOT BLANK
	IF(IN2 .LT. JZMIN) GO TO 490
	IB(IXP+1)	= '*'				! POINT TO DISPLAY
	MAX	= IXP					! MAX POINT TO DISPLAY
490	CONTINUE
	NUMBER	= IY0 + IYS*(IYP+JYMIN)
	WRITE(5,1001) NUMBER, (IB(J),J=1,MAX+1)		!  Plot 1 line
500	CONTINUE

C
C	NOW PUT UP THE X SCALE
C
600	CONTINUE
	DO 610 J	= 1,7
610	IA(J)	= IX0 + IXS*( JXMIN + (J-1)*10*JXSTEP )
	WRITE(5,1010) (IA(J),J=1,7)
1010	FORMAT(7(I8,' $') )
C
C	HERE THE PLOTTING IS TERMINATED
C
900	CONTINUE
	END					!EXIT FROM PROGRAM

	SUBROUTINE HISTO(IH)
C
C	ROUTINE TO OUTPUT HISTOGRAMS
C	IH	= HISTOGRAM NUMBER 
C
	BYTE	LBUF(140)
	BYTE	LABL(20) 
	INTEGER*4 IX,IJ,IMIN
	REAL ABUF(20)
	COMMON /SCRAT/LBUF,ABUF,LABL,IX,IJ,IMIN
C 
C	OUTPUT HEADER   RUN#,HIST #, LABEL
C 
	IHMIN	= 1
	CALL	HSTAT(0,I,IHMAX)
	IF(IH.EQ. 0)GO TO 1
	IHMIN 	= IH
	IHMAX 	= IH
1	DO 600 IHIS	= IHMIN,IHMAX
	CALL HSTAT(IHIS,IXSIZ,IYSIZ,IXS,IX0,IYS,IY0,ITYPE)
	IF(IXSIZ .LE. 0) GO TO 600
	ITYPE	= IAND(ITYPE,3)
	IXSIZ	= IXSIZ - 1
	IYSIZ 	= IYSIZ -1
C
C	GET CUTS (MAX OF 8) FOR PRINT OUT
C
	IM 	= 1
	CALL	MGETF(0,MKMAX)
	DO 100 J 	= 1,MKMAX		! LOOK AT all CUT VALUES
	CALL MGETF(J,K,ABUF(IM))			! GET CUT VALUE
	LBUF(IM)	= 'X'
	IF(K .LT. 0) LBUF(IM)	= 'Y'
	IF(ABS(K) .EQ. IHIS) IM 	= IM + 1	! CUT IS FOR THIS HIST
	IF(IM .GT. 20) GO TO 101			! TOO MANY CUTS, DON'T LOOK FOR MORE
100	CONTINUE
101	CONTINUE
	IM	= IM - 1
	CALL	GTITL(IHIS,LABL,5)
	CALL	GTITL(0,LABL(11),5)
	WRITE(6,1000)IHIS,LABL,IXS,IYS
	IF(IM .GT. 0)WRITE(6,1005)(ABUF(J),LBUF(J),J=1,IM)
C 
C	CHECK FOR MAX NUMBER TO PRINT 
C	IF MAX	= 0 DO NOT PRINT AT ALL
C 
	IXMAX	= 0 
	IXMIN	= IXSIZ 
	IYMAX	= 0
	IYMIN	= IYSIZ
	IMIN	= 0
	IJUMP	= 2
	IF(ITYPE .EQ. 1) IJUMP	= 1
	ICHAN	= 1
	DO 150 JY	= 0,IYSIZ
	DO 150 JX	= 0,IXSIZ
	CALL HGET(IHIS,IJ,ICHAN,IJUMP,IJJ)
	ICHAN	= ICHAN + IJUMP
	IF(IJ .EQ. 0)GO TO 150
	IJ	= ABS(IJ)
	IF(JX .LT. IXMIN)IXMIN	= JX
	IF(JX .GT. IXMAX)IXMAX	= JX
	IF(JY .GT. IYMAX)IYMAX	= JY
	IF(JY .LT. IYMIN)IYMIN	= JY
	IF(IMIN .LT. IJ)IMIN	=IJ
150	CONTINUE
	IF(IMIN .EQ. 0) GO TO 600
C
C	FIND THE NUMBER OF DIGITS/NUMBER
C
	DO 160 J	= 2,12
	M	= J
	IMIN	= IMIN/10
	IF(IMIN .EQ. 0)GO TO 161
160	CONTINUE
161	CONTINUE

C
C	HERE WE DO 2 DIMENSIONAL HISTS
C
	N	= 119/M				!NUMBERS PER LINE
	DO 450 JX	= IXMIN,IXMAX,N
	IMAX	= N				!NUMBERS FOR THIS LINE
	IF(JX+N.GT.IXSIZ)IMAX	= IXSIZ-JX+1
	NN	= 10
	IF(M .GT. 2) NN	= 5
	IF(M .GT. 5) NN	= 2
	IJ	= 0
	CALL NCONV(IJ,LBUF,135)
	DO 410 I	= 0,IMAX-1,NN 			!SET UP XSCALE PRINT
	ICHAN	= 12 + M + I*M				!LOCATION OF X TIC
	IX	= JX + I
	LBUF(ICHAN)	= '$'				!TIC
	IX	= IX0 + IX * IXS			!VALUE AT TIC
	CALL	NCONV(IX,LBUF(ICHAN-11),11)		!CONVERT VALUE TO CHARS
410	CONTINUE
	IF(JX .EQ. 0) LBUF( 12 + M)	= '<'		!LOWEST CHAN
	IF(JX + N .GT. IXSIZ) LBUF(12+M*IMAX )	= '>'	!HIGHEST CHAN
	WRITE(6,1001)(LBUF(I),I	= 1,131)		!OUTPUT THE X LABLE
	IF(IYSIZ .EQ. 0) GO TO 412			!IF 1 DIM SKIP EXTRA TICS
	IJ	= 0
	CALL	NCONV(IJ,LBUF,135)
	DO 411 I	= 1,IMAX
	ICHAN	= 12 + I*M
	LBUF(ICHAN)	= '$'
	ICH	= I - 1 + JX
	IF(ICH .EQ. 0)LBUF(ICHAN)	= '<'
	IF(ICH .EQ. IXSIZ)LBUF(ICHAN)	= '>'
411	CONTINUE
	WRITE(6,1001)(LBUF(I),I	= 1,131)
412	DO 450 JY	= IYMAX,IYMIN,-1
	ICHAN	= JX + (IXSIZ+1) * JY 
	ICHAN	= IJUMP*ICHAN + 1
	ICH	= 13
	IJ	= 0
	DO 420 I	= 1,IMAX
	CALL HGET(IHIS,IJ,ICHAN,IJUMP,IJJ) 		!VALUE TO PRINT
	ICHAN	= ICHAN + IJUMP
	CALL NCONV(IJ,LBUF(ICH),M)			!CONVERT NUMBER
	IF(IJ .EQ. 0) LBUF(ICH+M-1)	= '.'
420	ICH	= ICH + M
	MAX	= 12 + IMAX*M
	LBUF(12)	= '$'
	IF(IYSIZ .EQ. 0) GO TO 430			!ONLY 1 DIM PRINT
	IF(JY .EQ. 0)LBUF(12)	= '<'
	IF(JY .EQ. IYSIZ)LBUF(12)	= '>'
	IX	= JY
	IX	= IY0 + IX*IYS
	CALL	NCONV(IX,LBUF,11)
430	WRITE(6,1001)(LBUF(J),J= 1,MAX) 
450	CONTINUE
600	CONTINUE					!END OF MASTER DO LOOP (MULT HIST)
	RETURN
1000	FORMAT(
	1 I5,5X,10A1,5X,10A1,T40,'XSTEP='I6  ,T60 'YSTEP='I6
	1  ,T90'UNDER/OVERFLOW=< / >')
1001	FORMAT(1X,131A1)
1005	FORMAT(T25, 'CUTS'1P,6(G15.7,1X,A1))
	END 

	SUBROUTINE	NCONV(NUMBER,IBUF,ISIZE)
	INTEGER*4	NUMBER,N,M
	BYTE	IBUF(ISIZE),ITEMP(20)
	IF(ISIZE .LE. 0)RETURN
	ENCODE(20,1000,ITEMP) NUMBER
	I	= 20
	DO 10 J	= ISIZE,1,-1
	IF(I .LT. 1) I = 1
	IBUF(J)	= ITEMP(I)
10	I	= I - 1
1000	FORMAT(I20)
	END
