/*		MICROLIN.C   Ver. 3.0
 *		  Ver. 3.0  01/30/84
 *		  Ver. 2.0  01/16/84
 *		  Ver. 1.0  05/12/83
 *
 * Written for the Lattice (Ver. 2.0) C compiler by Harvey G. Lord.
 *
 * Sends print size and line spacing control characters to the Microline
 * 82A and 83A printers from a menu-driven screen format without resorting
 * to any terminal dependant code.
 *
 * NOTE:  When compiled under MS DOS 2.xx, the program will only run under
 * MS DOS 2.xx, NOT Ver. 1.xx.
 *
 * The difference between Ver. 2.0 and Ver. 3.0 is that the later version
 * does low level, unbuffered (i.e., fast) console I/O. Moral: do Level 1
 * I/O whenever possible.
 *
 * Please send bug reports or fixes to me at 203-429-8044.
 *
 * Enjoy.  H.G.L.
 *
 */

#include "stdio.h"
#include "conio.c"
#define ESC	0x1B
#define RS	0x1E
#define GS	0x1D
#define US	0x1F
#define SIX	0x36
#define EIGHT	0x38

main()
{
 static char *signon[] =
 {
 "\n\n\nMICROLIN.EXE  Ver. 3.0 (for MS DOS 2.xx only)\n",
 "Written & placed in the Public Domain on 01/30/84 by Harvey G. Lord.\n\n\n",
 "This program sends print control characters to an Okidata Microline\n",
 "82A or 83A printer.\n\n",
 "Please plug in your printer and connect it to the computer.\n\n\n\n\n",
 "Press any key to continue.\n\n\n\n\n\n\n\n\n\n",
 NULL
 };
	display(signon);
	getch();		/* Wait for key press			*/
	menu();
	size_selections();	/* Choose what printer should do 	*/
}

menu()				/* Things the printer can do		*/
{
	static char *mnu[] =
	{
	"\n\n\n\n\n\n\n\n\n\n\n\n\t  ** Printer Control Menu **\n\n",
	"1 - 16.5 chars per inch\n",
	"2 - 10   chars per inch     A - 6 lines per inch\n",
	"3 - 8.25 chars per inch     B - 8 lines per inch\n",
	"4 - 5    chars per inch\n",
	"5 - Exit\n\n",
	NULL
	};
	display(mnu);
	cputs("Please select a number:  ");
}				/* End of menu				*/

size_selections()			/* Select print size		*/
{
	int c;
	c = getche();			/* Get & display char		*/
	switch(c)
	{
		case '1':		/* 16.5 cpi			*/
		case '2':		/* 10 cpi			*/
		case '3':		/* 8.25 cpi			*/
		case '4':		/* 5 cpi			*/
			cputs("  Please select A or B.  ");
			space_selections(c);
			break;
		case '5':		/* Exit to printer defaults	*/
			putch('\n');
			_exit(0);
		default:		/* If none of the above		*/
			cputs("\nPlease choose 1-5.       ");
			size_selections();
	}
}					/* End of size_selections	*/

space_selections(n)			/* Select line spacing		*/
int n;
{
	int c;
	c = getche();			/* Get & display char		*/
	switch(c)
	{
		case 'A':		/* 6 lpi			*/
		case 'B':		/* 8 lpi			*/
		case 'a':		/* 6 lpi			*/
		case 'b':		/* 8 lip			*/
			send_out(n,c);
			break;
		default:		/* If none of the above		*/
			cputs("\n\t\t\t    Please select A or B.  ");
			space_selections(n);
	}
}					/* End of space_selections	*/

send_out(n,m)		/* Verify selection; if ok, send to printer	*/
int n, m;
{
	FILE *fp;		/* File number or error code		*/
	cputs("\n\n\nPrint size = ");
	if(n == '1')
		cputs("16.5 characters per inch.\n");
	else if(n == '2')
		cputs("10 characters per inch.\n");
	else if(n == '3')
		cputs("8.25 characters per inch.\n");
	else
		cputs("5 characters per inch.\n");
	cputs("Line spacing = ");
	if(m == 'A' || m == 'a')
		cputs("6 lines per inch\n\n");
	else
		cputs("8 lines per inch\n\n");
	cputs("Is this what you want? (Y/N)  ");
	want_this();			/* Process Y/N answer		*/
	if((fp = fopen("PRN:","w")) == NULL) /* Error: can't open PRN:	*/
	{
	   cputs("\n\n\n\n\nSorry, I can\'t send anything to your printer.");
	   cputs("\nPlease check it, then run MICROLIN again.\n");
	   _exit(0);
	}
	if(n == '1')			/* 16.5 cpi			*/
		putc(GS,fp);		/* Send control to printer	*/
	else if(n == '2')		/* 10 cpi			*/
		putc(RS,fp);		/* Send control to printer	*/
	else if(n == '3')		/* 8.25 cpi			*/
	{
		putc(GS,fp);		/* Send control to printer	*/
		putc(US,fp);		/* Send control to printer	*/
	}
	else				/* 5 cpi			*/
	{
		putc(RS,fp);		/* Send control to printer	*/
		putc(US,fp);		/* Send control to printer	*/
	}
	if(m == 'A' || m == 'a')	/* 6 lpi			*/

	{
		putc(ESC,fp);		/* Send control to printer	*/
		putc(SIX,fp);		/* Send control to printer	*/
	}
	else				/* 8 lpi			*/
	{
		putc(ESC,fp);		/* Send control to printer	*/
		putc(EIGHT,fp);		/* Send control to printer	*/
	}
	fclose(fp);			/* Close PRN: device		*/
	cputs("\n\nOK.  The printer\'s all setup.\n");
	cputs("To change settings, run this program again.\n\n");
	_exit(0);			/* Instant exit			*/
}

want_this()			/* Do you really want this selection?	*/
{
	int c;
	c = getche();			/* Get and display char		*/
	if(c == 'N' || c == 'n')
		rerun();
	else if(c == 'Y' || c == 'y')
		return;
	else
	{
		cputs("\n\nPlease press \"Y\" or \"YES\" or \"N\" for \"NO.\"\
  ");
		want_this();
	}
}					/* End of want_this		*/

rerun()					/* Repeat whole process		*/
{
	menu();
	size_selections();
}					/* End of rerun			*/

display(array_name)			/* Display array of arrays	*/
char *array_name[];
{
	int i;
	for(i = 0;array_name[i] != NULL;i++)
		cputs(array_name[i]);
}					/* End of display		*/
