{$E+}

{ External Procedures -- Timer Support }

PROCEDURE Sleep({ Using	} t:integer); (* pause for t seconds *)
   BEGIN
     TimeLeft := t * 60; { in ticks }
     REPEAT
     { nothing }
     UNTIL (TimeLeft<=0);
   END;


PROCEDURE ITime;  { Initialize Timer }
BEGIN
{$C
	DVEC = ^O100
	MOV	@LTCVEC,SAV			;SAVE OLD VECTOR
	MOV	@LTCVEC,SAV2			;SAVE OLD VECTOR FOR RTI
  	CLR	RNTICK				;CLEAR TICKS
	MOV	#LTCINT,@LTCVEC			;OUR INTERRUPT
}

END;

PROCEDURE RTime;  { Reset Timer	}
BEGIN

{$C
	TST	SAV				;TEST 
	BEQ	9$
	MOV	SAV,@LTCVEC			;RESTORE VECTOR
	CLR	SAV				;SET OFF
9$:	NOP	
}
END;

{$C
	.EVEN
	.GLOBL	LTCVEC
LTCVEC:	.WORD	DVEC				;LTC VECTOR
RNTICK:	.WORD	0				;TICKS FOR RUNTIME
SAV:	.WORD	0				;SAVED INTERUPT
SAV2:	.WORD	0
;
LTCINT:	MOV	R5,-(SP)			;SAVE R5
	MOV	$RESR5,R5			;GET  BASE
	INC	RNTICK				;TIMER INTERRUPT
	DEC	TimeLeft(R5)			;DECREASE TIME LEFT
	CMP	RNTICK,#^O74			;COMPARE TO 60
	BLT	9$
	INC	RunTime(R5)			;INCREASE RUNTIME		
	CLR	RNTICK				;ZERO TICKS
9$:	MOV	(SP)+,R5
	JMP	@SAV2				;JUMP TO SYSTEM	INTERRUPT 
;						;AND LET IT DO THE RTI

}

{ External Procedures -- For Console }

{$C

;	MACRO ROUTINES FOR RT-11 STIP
;	TO HANDLE CONVERSION OF	LOWER CASE
;
	.GLOBL	CONLOW
	.GLOBL	CONUP
;********************************************
JSW=^O44			;JSW
MASK=^O40000			;FOR BIT 14
;********************************************
CONLOW:	BIS	#MASK,@#JSW	;DO NOT	CONVERT
	RTS	PC
;********************************************
CONUP:	BIC	#MASK,@#JSW	;CONVERT
	RTS	PC
}

PROCEDURE ICON; { set	console	- enable interupts }
  BEGIN
{$C
	.MCALL .SCCA
	.GLOBL	TTSPEC
	.SCCA	#AREA,#CHECKC			;INHIBIT CONTROL C
	JSR	PC,TTSPEC			;SET SPECIAL MODE
}
   END;

  PROCEDURE RCON; { reset console }
   BEGIN

{$C
	.GLOBL	TTNORM
	.SCCA	#AREA,#0			;RESTORE CONTROL C
	JSR	PC,TTNORM			;RESET
}

   END;

{$C
	.EVEN
AREA:	.BLKW	2				;for .SCCA EMT
CHECKC:	.WORD	0				

}
	
FUNCTION CheckTheConsole : boolean;
VAR 
  c : integer;
BEGIN
{$C
	.MCALL	.TTINR	
	CLR 	R0
	.TTINR
	BCS	9$
	BIC	#^O177600,R0
	MOV	R0,c(SP)
9$:	NOP	
}
	IF c = ord('A') THEN
		FromConsole := AbortNow
	ELSE IF c = ord('a') THEN
		FromConsole := AbortNow
	ELSE IF c = CR THEN 
		FromConsole := CRin
	ELSE 
		FromConsole := Nothing; 

	CheckTheConsole := (FromConsole = AbortNow) OR (FromConsole = CRin);
END;
