  { EXTERNALS  used  for SendSwitch & RecvSwitch 
	      (	Not all	are used )		  }
 
  { prims -- primitive functions and procedures	  }

  PROCEDURE stiphalt; {	used by	external procedures for	halt }
  EXTERNAL;

  { initio (RT-11) -- initialize open file list	}
  PROCEDURE initio;
  EXTERNAL;

  { open (RT-11) -- open a file	for reading or writing }
  FUNCTION Sopen (VAR name : string; omode : integer) :	filedesc;
  EXTERNAL;

  FUNCTION getc	(VAR c : character) : character;
  EXTERNAL;

  { getcf (UCB)	-- get one character from file }
  FUNCTION getcf (VAR c: character; fd : filedesc) : character;
  EXTERNAL;

  { getline (UCB) -- get a line	from file }
  FUNCTION getline (VAR	s : string; fd : filedesc;
		    maxsize : integer) : boolean;
  EXTERNAL;

  PROCEDURE putc (c : character);
  EXTERNAL;

  { putcf (UCB)	-- put a single	character on file fd }
  PROCEDURE putcf (c : character; fd : filedesc);
  EXTERNAL;

  { putstr (UCB) -- put	out string on file }
  PROCEDURE putstr (VAR	s : string; f :	filedesc);
  EXTERNAL;

  { close (omsi) -- close a file }
  PROCEDURE Sclose (fd : filedesc);
  EXTERNAL;

  { close all files on exit }
  PROCEDURE closeall;
  EXTERNAL;

  { utilities }
  { itoc - convert integer n to	char string in s[i]... }
  FUNCTION itoc	(n : integer; VAR s : string; i	: integer) : integer; 
     { returns end of s	}
  EXTERNAL;

  { length -- compute length of	string }
  FUNCTION length (VAR s : string) : integer;
  EXTERNAL;

  { scopy -- copy string at src[i] to dest[j] }
  PROCEDURE scopy (VAR src : string; i : integer;
		   VAR dest : string; j	: integer);
  EXTERNAL;

  { index -- find position of character	c in string s }
  FUNCTION index (VAR s	: string; c : character) : integer;
  EXTERNAL;

  PROCEDURE CtoS({ Using } x:cstring; {	Returning } VAR	s:string);
    { convert constant to STIP string }
  EXTERNAL;

  FUNCTION Exists({ Using } VAR	s:string): { Returning } boolean;
  EXTERNAL;

  { number of arguments	-- RT-11 }
  FUNCTION nargs : integer;
  EXTERNAL;

  { getarg (RT-11) -- copy n-th	command	line argument into s }
  FUNCTION getarg (n : integer;	VAR s :	string;
		   maxs	: integer) : boolean;
  EXTERNAL;

  PROCEDURE PutCon({ Using } x:cstring;
		   { Using } fd:filedesc);
    { output literal preceeded by NEWLINE }
  EXTERNAL;

  PROCEDURE PutCln({ Using } x:cstring;
		   { Using } fd:filedesc);
    { output literal followed by NEWLINE }
  EXTERNAL;

  PROCEDURE PutNum({ Using } n:integer;
		   { Using } fd:filedesc);
    { Ouput number }
  EXTERNAL;

  PROCEDURE PutCS({ Using } x:cstring;
		  { Using } s :	string;
		  { Using } fd:filedesc);
  EXTERNAL;

  PROCEDURE PutCN({ Using } x:cstring;
		  { Using } v :	integer;
		  { Using } fd:filedesc);
  EXTERNAL;

  PROCEDURE AddTo({ Updating } VAR sum : Stats;
		  { Using }  inc:integer);
  EXTERNAL;

  PROCEDURE Sleep({ Using } t:integer);	{ pause	for t seconds }
  EXTERNAL;

  PROCEDURE PutPacket( p : Ppack); { Output Packet }
  EXTERNAL;

  FUNCTION GetIn { Returning } :character;  { get character }
    { Should return NULL if no characters }
  EXTERNAL;

  PROCEDURE StartTimer;
  EXTERNAL;

  PROCEDURE StopTimer;
  EXTERNAL;

  FUNCTION MakeChar({ Using } c:character): { Returning	} character;
    { convert integer to printable }
  EXTERNAL;

  FUNCTION UnChar({ Using } c:character): { Returning }	character;
    { reverse of makechar }
  EXTERNAL;

  FUNCTION IsControl( c:character):  boolean;
    { true if control }
  EXTERNAL;

  FUNCTION Ctl(	c:character):  character;
    { c	XOR 100	}
  EXTERNAL;

  FUNCTION CheckFunction({ Using } c:integer): { Returning } character;
    { calculate	checksum }
  EXTERNAL;

  PROCEDURE EnCodeParm({ Updating } VAR	data:string);
    { encode parameters	}
  EXTERNAL;

  PROCEDURE DeCodeParm({ Using } VAR data:string); { decode parameters }
  EXTERNAL;

  PROCEDURE SYSinit; { special initialization }
  EXTERNAL;

  PROCEDURE SYSfinish; { System	dependent }
  EXTERNAL;

  PROCEDURE StartRun; {	initialization as necessary }
  EXTERNAL;

  PROCEDURE OpenPort;
  EXTERNAL;

  PROCEDURE BadVTerminalConnect;
  EXTERNAL;

  PROCEDURE MakeConnection;
  EXTERNAL;

  PROCEDURE KermitInit;	 { initialize various parameters  & defaults }
  EXTERNAL;

  PROCEDURE FinishUp(ok	: boolean); { do any End of Program clean up }
  EXTERNAL;

  PROCEDURE DebugPacket({ Using	}    mes : cstring;
			{ Using	}  VAR p : Ppack);
    { Print Debugging Info }
  EXTERNAL;

  PROCEDURE ReSendPacket;
    { re -sends	previous packet	}
  EXTERNAL;

  PROCEDURE SendPacket;
  EXTERNAL;

  PROCEDURE SendACK({ Using } n:integer); { send ACK packet }
  EXTERNAL;

  PROCEDURE SendNAK({ Using } n:integer); { send NAK packet }
  EXTERNAL;

  PROCEDURE ErrorPack({	Using }	c:cstring);
    { output Error packet if necessary -- then exit }
  EXTERNAL;

  PROCEDURE Verbose({ Using } c:cstring);
    { Print mssage if verbosity	}
  EXTERNAL;

  PROCEDURE PutErr({ Using } c:cstring);
    { Print error_messages }
  EXTERNAL;

  FUNCTION RecvPacket: boolean;
  EXTERNAL;

  FUNCTION RecvACK : { Returning } boolean;
    { receive ACK with correct number }
  EXTERNAL;
{
