; CP4DEF.ASM
;	KERMIT - (Celtic for "FREE")
;
;	This is the CP/M-80 implementation of the Columbia University
;	KERMIT file transfer protocol.
;
;	Version 4.0
;
;	Copyright June 1981,1982,1983,1984
;	Columbia University
;
; Originally written by Bill Catchings of the Columbia University Center for
; Computing Activities, 612 W. 115th St., New York, NY 10025.
;
; Contributions by Frank da Cruz, Daphne Tzoar, Bernie Eiben,
; Bruce Tanner, Nick Bush, Greg Small, Kimmo Laaksonen, Jeff Damens, and many
; others. 
;
;	This file contains definitions used by both modules of Kermit.
;
; revision history:
; edit 2: July 10, 1984 (CJC)
;	Remove defines for TRUE and FALSE, during reorganization for LASM
;	compatibility.  If we're using LASM, this file is linked by CP4KER
;	or CP4TYP, and links to CP4MIT or CP4LNK.  Also, push comments around
;	a little.
;
; edit 1: May, 1984 (CJC)
;	extracted from CPMBASE.M80 version 3.9; modifications are described
;	in the accompanying .UPD file.
;

;Symbolic Definitions for some ASCII characters
;
soh	EQU	01O	;ASCII SOH (Control-A)
ctrlc	EQU	03O	;ASCII ETX (Control-C)
bell	EQU	07O	;ASCII BEL (Control-G)
bs	EQU	10O	;ASCII backspace (Control-H)
tab	EQU	11O	;ASCII Tab (Control-I)
lf	EQU	12O	;ASCII Line Feed (CTRL-J)
ff	EQU	14O	;ASCII Form Feed (CTRL-L)
cr	EQU	15O	;ASCII Carriage Return (CTRL-M)
xon	EQU	21O	;ASCII XON (Control-Q)
xoff	EQU	23O	;ASCII XOFF (Control-S)
esc	EQU	33O	;ASCII ESCape
subt	EQU	32O	;ASCII SUB (CTRL-Z)
del	EQU	177O	;ASCII DELete (rubout)
;
;BDOS calls
bdos	EQU	0005H	;BDOS entry point, for the following functions:
;
;Function Name		Function	Input Parameters Output Parameter
;=============		========	================ ================
;	(ALL Function Numbers are passed in Register C)
conin	EQU	01H	;Read Console	NONE		 ASCII Char in A
conout	EQU	02H	;Write Console	ASCII Char in E	 NONE
auxin	EQU	03H	;Auxiliary input
rdrin	EQU	03H	;Read Reader	NONE		 ASCII Char in A
lstout	EQU	05H	;Write List	ASCII Char in E	 NONE
dconio	EQU	06H	;Direct Con I/O ASCII Char in E	 I/O Status in A
			;				 if E=0FEH,
			;				  Input if E=0FFH
prstr	EQU	09H	;Print String	String-Address	 NONE
			;		in DE (term=$)
rdstr	EQU	0AH	;Read Buffer	Buffer-Address	Read Buffer filled
;					in DE
;	Read Buffer	Byte	Function
;			  1	Maximum Buffer Length
;			  2	Current Buffer Length (returned value)
;			3-n	Data (returned values)
;
consta	EQU	0BH	;Console Stat	NONE		LSB(A)=1 if char ready
inbdos	EQU	0DH	;Init BDOS	NONE		NONE
logdsk	EQU	0EH	;LOG-In disk	Value in E	NONE
			;		A=0,B=1,...
openf	EQU	0FH	;Open File	FCB-Addr in DE	Byte Addr.of FCB,
			;				 or 0FFH if not
closf	EQU	10H	;Close File	FCB-Addr in DE	Byte Addr.of FCB,
			;				 or 0FFH if not
sfirst	EQU	11H	;Search File	FCB-Addr in DE	Byte Addr.of FCB(0-3),
			;				 or 0FFH if not
snext	EQU	12H	;Search next	FCB-Addr in DE	Byte Addr.of next FCB,
			;				 or 0FFH if not
delf	EQU	13H	;Delete File	FCB-Addr in DE	Byte Addr.of FCB(0-3),
			;				 or 0FFH if not
readf	EQU	14H	;Read Record	FCB-Addr in DE	0=successful read
			;				1=read past EOF
			;				2=reading random data
writef	EQU	15H	;Write Record	FCB-Addr in DE	0=successful write
			;				1=ERROR extending
			;				2=End of disk data
			;				255=No more DIR space
makef	EQU	16H	;Make File	FCB-Addr in DE	0-3= success,
			;				255= no more dir space
renam	EQU	17H	;Rename File	FCB-Addr in DE	0-3= success,
			;				255= file not found
rdlog	EQU	18H	;Ret. Log Code	NONE		Login Vector in HL
rddrv	EQU	19H	;Read Drive #	NONE		# of logged in drive in
			;				(A=0,B=1,C=2....)
setdma	EQU	1AH	;Set DMA Addr.	Addr. of 128	NONE
			;		byte buffer in DE
wrtprt	EQU	1CH	;Write prot dsk	NONE		NONE
getrov	EQU	1DH	;Get R/O Vect.	NONE		HL= R/O Vect. value
setfat	EQU	1EH	;Set File Attr.	FCB-Addr.in DE	Dir. code in A
gtdpar	EQU	1FH	;Get DSK par.	NONE		HL=DPB Address
usrcod	EQU	20H	;Get/Set Usr.Cd	E=0FFH (get)	A=current code (get)
			;		E-code (set)	A=no value (set)
rrand	EQU	21H	;Read  Random	FCB-Addr in DE	A=Return code
wrand	EQU	22H	;Write Random	FCB-Addr in DE	1=read'g unwritten data
			;				2=(not used)
			;				3=can't close curr. ext
			;				4=seek to unwr. ext.
			;				5=dir overflow(write)
			;				6=seek past End of DSK
cflsz	EQU	23H	;Comp File Sz.	FCB Addr.in DE	Rand.Rec.field set to
			;				 File size
setrar	EQU	24H	;Set Rand. Rec.	FCB-Addr.in DE	Rand.Rec.field set

; CPM 2 only:
punout	EQU	04H	;Write Punch	ASCII Char in E	 NONE
gtiob	EQU	07H	;Get I/O status NONE		 I/O Status in A
ptiob	EQU	08H	;Put I/O status	I/O Status in E	 NONE
getalv	EQU	1BH	;Get All.Vect.	NONE		All.Vect in HL

; CPM 3 only:
auxout	EQU	04H	;Auxiliary output
auxist	EQU	07H	;Get AUXIN: status		 A=FF if character
			;				 ready, A=0 if none
auxost	EQU	08H	;Get AUXOUT: status		 A=FF if ready, A=0
			;				 if not ready
getfs	EQU	2EH	;Get free space	E=drive		# rec free in dma addr
;
parevn	EQU	00H	;Even parity.
parmrk	EQU	03H	;Mark parity.
parnon	EQU	06H	;No parity (eighth bit is data).
parodd	EQU	09H	;Odd parity.
parspc	EQU	0CH	;Space parity.

defpar	EQU	parnon	;Default parity.
ibmpar	EQU	parmrk	;IBM COMTEN's parity.

fcb	EQU	5CH	;Location of File Control Block.
fcbext	equ	fcb+12
fcbrno	equ	fcb+33
buff	EQU	80H	;Location of file output buffer (DMA).
bufsiz	EQU	80H	;Size of DMA.

maxpkt  EQU	'~'-' '+2O;Maximum size of a packet.
maxtry	EQU	05O	; Number of retries on a packet.
imxtry	EQU	20O	; Number of retries send initiate.

; opcodes for command parser
cmkey	EQU	01H	;Parse a keyword.
cmifi	EQU	02H	;Parse an input file spec (can be wild).
cmofi	EQU	03H	;Parse an output file spec.
cmcfm	EQU	04H	;Parse a confirm.
cmtxt	EQU	05H	;Parse text.
cmifin	EQU	10H	;Parse an input file spec (but no
			;Error output
;
; If this is being assembled by LASM, we need to LINK to one of two modules;
; if we're not using LASM, no problem.
; CP4KER.ASM defines "cp4ker" TRUE, and CP4TYP.ASM defines it FALSE, so we can
; determine what's going on.
IF lasm AND cp4ker	; building CP4KER with LASM?
	LINK	CP4MIT	; yes, chain to next piece.
ENDIF;lasm AND cp4ker
IF lasm AND NOT cp4ker	; LASM, but not building CP4KER?
	LINK	CP4LNK	; yes, chain to different piece.
ENDIF;lasm AND NOT cp4ker
   