/*
 *  C U 2 
 *
 *  assign and attach port routines
 */

#include <stdio.h>
#include "cu.h"

/*
 * these are from 'qiottdrv.h'
 */
#define		TC_XSP     4
#define		SF_GMC     1392
#define		SF_SMC     1312
#define		S_1200     11
#define		S_300      9

extern 	pt_enqueue ();			/* ast service routines	*/
extern	tt_enqueue ();

#ifdef	PORTNUM
int port_num = PORTNUM;			/* tt: number of second port */
#else
int port_num;
#endif

attach_ports()
/*
 * assign and attach tty and port connected to the modem
 *
 */
{
	char what[2];				/* local buffer */

	/*
	 * assign and attach tty and second port
	 */
#ifndef PORTNUM
	printf("\nEnter number of tty attached to modem: ");
	scanf("%o", &port_num);
#endif
	alunx(TTYLUN, "TI", 0);			/* assign tty */
	alunx(LUN, "TT", port_num);		/* assign second port */
	devpar[0] = &pt_enqueue;		/* ast service handler	*/
	if (qiow(IO_ATA, LUN, 3, 0, 0, devpar) < 0)
		error ("cux: can't attach tt%2o\n", port_num);
	devpar[0] = &tt_enqueue;		/* ast service handler	*/
	if (qiow(IO_ATA, TTYLUN, 4, 0, 0, devpar) < 0)
		error ("cux: can't attach tty\n");

	/*
	 * print connect speed
	 */
	devpar[0] = &what[0];			/* address of GMC buf */
	devpar[1] = 2;				/* and length in bytes */
	what[0] = TC_XSP;			/* ask transmit speed */
	qiow(SF_GMC, LUN, 1, 0, 0, devpar);	/* get speed */
	if (what[1] == S_1200)
		printf("connected at 1200 baud");
	else if (what[1] == S_300)
		printf("connected at 300 baud");
	else printf("connected at undefined speed = %o", what[1]);
	printf(" via tt%2o:\n", port_num);
}


detach_ports ()
/*
 * detach attached devices.
 */
{
	qiow (IO_KIL, LUN, 3, 0, 0, 0);		/* kill outstanding requests */
	qiow (IO_DET, LUN, 3, 0, 0, 0);		/* detach device */
	qiow (IO_KIL, TTYLUN, 4, 0, 0, 0);	/* kill i/o requests */
	qiow (IO_DET, TTYLUN, 4, 0, 0, 0);	/* detach device */
}
