/*
 * RSX11M V4.0 System Definition Headers for C.
 *
 * Window Definition Block  ( WDBDF$ )
 *
 * Used with 'craw', 'elaw', 'map', 'umap', 'sref' and 'rref'
 * functions.
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS FILE
 *
 * Bob Denny
 * 19-Oct-82
 *
 */
struct	wdb	{
		byte	w_nid;		/* Window ID */
		byte	w_napr;		/* Base APR # */
		address	w_nbas;		/* Virtual base addr. */
		word	w_nsiz;		/* Window size */
		word	w_nrid;		/* Region ID */
		word	w_noff;		/* Offset in part. */
		word	w_nlen;		/* Length to map */
		word	w_nsts;		/* Window status word */
		address	w_nsrb;		/* Send/Rec buf. virtual
					   address */
		};

/* Window Status Word Symbols */

#define	WS_CRW	0100000	/* Address Window succ. created */
#define	WS_UNM	0040000	/* Windows unmapped in CRAW or MAP */
#define	WS_ELW	0020000	/* Windows eliminated in CRAW or MAP */
#define	WS_RRF	0010000	/* Reference successfully received */
#define	WS_64B	0000400	/* 64 byte alignment allowed */
#define	WS_MAP	0000200	/* Map after CRAW or rec. by ref. */
#define	WS_RCX	0000100	/* Exit if no ref's to receive */
#define	WS_DEL	0000010	/* Send with delete access */
#define	WS_EXT	0000004	/* Send with extend access */
#define	WS_WRT	0000002	/* Send or map with write access */
#define	WS_RED	0000001	/* Send with read access */
