/*
 *  C U 5 . C
 *
 */
#include <stdio.h>
#include "cu.h"

static char *mode = "w";		/* default file open mode */

divert_to()
/*
 * divert output to the named file. Output diversions of the following
 * form are handled:
 *
 * ^W>[>][:]file
 *
 * A trailing ^W> terminates the diversion.
 */
{
	register char *s;		/* local pointer */
	extern char *scget();		/* wizard screen i/o primitive */

	s = scget(cmd_buf, 80, "\r>"); 	/* get filename */
	if (*s == '\0'){		/* terminate redirection */
		if (recv_file_open){
			fclose(rcvfd);
			recv_file_open = OFF;
		}
	}
	else {
		/*
		 * redirect reads from remote system to named file
		 */
		*mode = 'w';		/* assume write new file	*/
		if (*s == '>'){ 	/* append to existing file	*/
			*mode = 'a';
			s++;		/* skip over '>' */
		}
		if (*s == ':'){		/* silent divert */
			echo_flag = OFF;
			s++;		/* bump ':' */
		}
		if (recv_file_open){	/* close currently opened file */
			fclose(rcvfd);
			recv_file_open = OFF;
		}
		if((rcvfd = fopen(s, mode)) == NULL)
			printf("\rcux: can't open %s\n", s);
		else {
			recv_file_open = ON;
			buff_ptr = buff; /* init buffer		*/
		}
	}
}

dvt_from()
/*
 * '^W<[:]file' is interpreted as send the contents of the named 
 * file to the remote system, as though typed at the terminal.
 * The optional ':' allows for silent diversion
 */
{
	register char *s;		/* local pointer */
	extern char *scget();		/* wizard screen i/o primitive */

	s = scget(cmd_buf, 80, "\r<"); 	/* get filename */
	if (*s == '\0')
		printf("\rmissing name for redirect\n");
	else {
		if (*s == ':'){		/* silent divert */
			echo_flag = OFF;/* turn off local echo */
			s++;		/* bump ':' */
		}
		if ((xfd = fopen(s, "r")) != NULL)
			x_file_open = ON;
		else printf("\rcux: Can't divert %s\n", s);
	}
}

