@make(text)
@style(spacing 1,indentation 0,linewidth 72)
@style(hyphenation on,hyphenbreak off,widestblank 1.4,justification off)
@comment(Use Scribe 3C to get automatic hyphenation)

@define(q,facecode r)
@define(section,use B,above 2, below 1, need 6, break, initialize "* ")
@define(subsection,use B,above 1, below 1, need 5, break, initialize ". ")
@define(paragraph,above 1, below 1, need 5, break, initialize ".. ")

@define(table,use example,leftmargin +0,rightmargin +0,above 1,below 1,group)
@modify(description,above 1,below 1,leftmargin +8, indent -8)
@modify(enumerate,above 1,below 1)
@modify(itemize,above 1,below 1)
@modify(example,above 1,below 1)
@modify(verbatim,above 1,below 1)
@modify(quotation,above 1,below 1,indent 0)
@modify(heading,above 2,below 1)
@string(-msversion="@q<2.26>")
@heading(KERMIT Version @value(-msversion) for MS-DOS and PC-DOS)

@center(July 26, 1984)

Kermit-MS is a program that provides terminal emulation and file
transfer for Intel 8088- and 8086-based microcomputers running the
MS-DOS or PC-DOS operating system.  The Kermit file transfer protocol
was developed and the Kermit-MS program were developed at the Columbia
University Center for Computing Activities.

@section<Program Operation>

Kermit-MS can be run interactively, from a batch file, or as an "external" DOS
command.  Commands consist of one or more fields, separated by "whitespace" --
one or more spaces or tabs.  
Upon startup, the program executes any commands found in the
file @q(MSKERMIT.INI) in the current path.

@subsection(Interactive Operation:)

To run Kermit-MS interactively, invoke the program from DOS command level by
typing its name.  When you see the command's prompt, "Kermit-MS>",
you may type Kermit commands repeatedly until you are ready to exit the
program.  You can use these special characters while typing
commands.
@begin(description)
BACKSPACE@ @ Delete the character most recently typed.  May be typed repeatedly
to delete backwards.  You may also use DELETE, RUBOUT, or equivalent keys.

CTRL-W@\Delete the most recent "word", or field, on the command line.  May be
typed repeatedly.

CTRL-U@\Delete the entire command line.

CTRL-C@\Cancel the current command and return to the "@q(Kermit-MS>)" prompt.

@q<?>@\Type a brief message describing what you are expected to type in the
current field.

ESC@\If enough characters have been supplied in the current field (keyword
or file name) to uniquely identify it, supply the remainder of the field and
position to the next field of the command.  Otherwise, sound a beep.

@q<=>@\Wildcard character for matching single characters in filenames,
equivalent to MS-DOS "@q<?>".
@end(description)

@subsection(Command Line Invocation:)

Kermit-MS may also be invoked with command line arguments from DOS command
level, for instance:
@Begin(Example,below 0)
A>@ux(kermit send foo.bar)
@End(Example)
or
@Begin(Example,above 0)
A>@ux(kermit set port 1, set baud 9600, connect)
@End(Example)
When invoked with command line arguments, Kermit-MS will behave as if it
were an external DOS command, like MODE.  Note that several commands may
be given on the command line, separated by commas.

@Section<Kermit-MS Commands>

Kermit-MS V@value(-msversion) has the following commands:
@Begin(Format,spread 0,above 1,below 1)
@tabclear()@tabset(1.25inches)
@>BYE@\  to remote server.
@>CLOSE@\  log file and stop logging remote session.
@>CONNECT@\  as terminal to remote system.
@>DEFINE@\  macros of Kermit-MS commands.
@>DELETE@\  local files.
@>DIRECTORY@\  listing of local files.
@>DO@\  a macro expansion.
@>EXIT@\  from Kermit-MS.
@>FINISH@\  Shut down remote server.
@>GET@\  remote files from server.
@>HELP@\  about Kermit-MS.
@>LOCAL@\  prefix for local file management commands.
@>LOG@\  remote terminal session.
@>LOGOUT@\  remote server.
@>PUSH@\  to MS-DOS command level.
@>QUIT@\  from Kermit-MS
@>RECEIVE@\  files from remote Kermit.
@>REMOTE@\  prefix for remote file management commands.
@>RUN@\  an MS-DOS program.
@>SEND@\  files to remote Kermit.
@>SERVER@\  mode of remote operation.
@>SET@\  various parameters.
@>SHOW@\  various parameters.
@>SPACE@\  inquiry.
@>STATUS@\  inquiry.
@>TAKE@\  commands from file.
@End(format)
The following SET commands are available in Kermit-MS:
@Begin(Format,spread 0,above 1,below 1)
@tabclear()@tabset(2.0inches)
@>BAUD@\  Communications port line speed
@>BELL@\  Whether to beep at the end of a transaction
@>BLOCK-CHECK-TYPE@\  Level of error checking for file transfer
@>DEBUG@\  Display packet contents during file transfer
@>DEFAULT-DISK@\  Default disk drive for file i/o
@>DESTINATION@\  Default destination device for incoming files
@>END-OF-LINE@\  Packet terminator
@>EOF@\  Method for determining or marking end of file
@>ESCAPE@\  Escape character for CONNECT
@>FLOW-CONTROL@\  Enable or disable XON/XOFF
@>HANDSHAKE@\  Half-duplex line turnaround option
@>HEATH19@\  Heath/Zenith-19 terminal emulation
@>INCOMPLETE@\  What to do with an incompletely received file
@>KEY@\  Specify key redefinitions, or "keystroke macros"
@>LOCAL-ECHO@\  Specify which host does the echoing during CONNECT
@>PARITY@\  Character parity to use
@>PORT@\  Select a communications port
@>PROMPT@\  Change the "Kermit-MS>" prompt to something else
@>RECEIVE@\  Request remote Kermit to use specified parameters
@>REMOTE@\  For running Kermit-MS interactively from back port
@>SEND@\  Use the specified parameters during file transfer
@>TAKE-ECHO@\  Control echoing of commands from TAKE files
@>TIMER@\  Enable/disable timeouts during file transfer
@>WARNING@\  Specify how to handle filename collisions
@End(format)

The STATUS command shows the values of parameters which may be SET.

@section[Command Macros]

Kermit-MS provides a facility for combining commands into "macros."  Command
macro definitions may be included in your @q[MSKERMIT.INI] file, TAKEn
explicitly from a specified file, or typed interactively, and may be invoked
with the DO command.

@Section<Command Macros>

@index[DEFINE]@index[Macro]@index[Command Macro]
Kermit-MS command macros are constructed with the DEFINE command.  The
syntax is
@example(DEFINE @i[macro-name]  [@i(command) [, @i(command) [, ...]]])
Any Kermit-MS commands may be included.  Example:
@begin(example)
define telenet set parity mark, set baud 1200, connect
@end(example)

A Kermit-MS command macro is invoked using the DO command.  For instance,
Kermit-MS comes with a predefined macro to allow convenient setup for IBM
communications; to invoke it, you would type
@Example[do ibm]
The IBM macro is defined as "parity mark, handshake xon, local-echo on, timer
on".  You can delete or replace this definition by adding a new (perhaps null)
definition, such as
@begin(Example,below 0)
define ibm parity even, handshake cr, local-echo on, timer on]
@end(example)
or
@begin(Example,above 0)
define ibm
@end(example)

Command macro definitions can be displayed with the SHOW MACROS command.

@Section<Terminal Emulation>

Here are the terminal emulation options for the systems presently supported by
Kermit-MS:
@begin<format,leftmargin +2,above 1,below 1,group>
@tabclear()@tabset(1.5inches,2.5inches,3.8inches)
@ux(System)@\@ux(EscChar)@\@ux(Cabilities)@\@ux(Terminal Service)
IBM PC, XT   @\  @q(^])   @\R M P K@\Heath19 emulation
DEC Rainbow  @\  @q(^])   @\R   P K@\VT102 firmware
HP-150       @\  @q(^])   @\R      @\HP-2623 firmware
Wang PC      @\  @q(^A)   @\       @\Wang firmware
Generic DOS  @\  @q(^])   @\       @\Depends on system
@end(format)
Under Capabilities, R means rollback, M means mode line, P means printer
control, and K means key redefinition.

IBM PC/XT Kermit can disable Heath-19 emulation and use an external console
device driver like @q(ANSI.SYS) instead.

The escape character is used to regain the attention of Kermit-MS.
When you type the escape character, Kermit-MS waits for you to follow it with a
single character command:
@Begin(Description,leftmargin +6,indent -4, spread 0)
@q<?>@\Help -- prints the available single-@|character commands.

@q<C>@\Close the connection and return to Kermit-MS prompt level.

@q<S>@\Show the status of the connection.

@q<B>@\Send a BREAK signal to the port.

@q<0>@\(the digit zero) Send a NUL (ASCII 0) to the port.
 
@q<Q>@\Temporarily quit logging the remote session.

@q<R>@\Resume logging the remote session.
      
@q<M>@\Toggle the mode line, i.e. turn it off if it is on & vice versa.

@q<^]>@\(or whatever you have set the escape character to be)@\Typing the
escape character twice sends one copy of it to the connected host.
@End(Description)
Typing any other character (except the space bar, which is the "null
command") after the escape character will cause Kermit-MS to beep, but
will do no harm.  The escape character can be changed to something other
than Control-@|Rightbracket by using the SET ESCAPE command.

Kermit-MS includes several advanced features for use during terminal emulation,
including screen scroll, printer control, and key redefinitions.

@subsection(Screen Scroll)

Kermit-MS provides several pages of screen memory, which may be
scrolled up and down using keys as follows:
@begin<format,leftmargin +2,above 1,below 1,longlines keep>
@tabclear()@tabset(2.0inches,3.2inches,5.0inches)
@ux(Function)    @\@ux(IBM PC/XT)@\@ux(Rainbow)@\@ux(HP-150)
Screen Down      @\PgDn     @\PrevScreen     @\Prev
Line Down        @\Ctrl-PgDn@\Ctrl-PrevScreen@\Shift-UpArrow
Screen Up        @\PgUp     @\NextScreen     @\Next
Line Up          @\Ctrl-PgUp@\Ctrl-NextScreen@\Shift-DownArrow
Top of Memory    @\Home
Bottom of Memory @\End
@end(format)

@subsection(Printer Control)

A locally attached printer may be controlled in the normal manner, on most
systems.  Pushing the "Print Screen" key (shifted on some systems) will cause
the current contents of the screen to be printed or spooled; holding down CTRL
while depressing Print Screen will start or stop the spooling of incoming
characters to the printer.

CTRL-Print-Screen can be simulated with the Kermit-MS LOG PRN and CLOSE
commands.

@subsection(Key Redefinitions)

Use SHOW KEY to find out the scan code of the key you want to redefine,
then use SET KEY SCAN xxx to define the new value.  Control characters
are entered in the definition string as \ooo (a backslash followed by
2 or 3 octal digits denoting the ASCII value of the character).
