.;[1,6]PROCESS.CMD, very similar to [1,6]SYSACT.CMD
.;
.;	Create files with specific system accounting data and reports.
.;	B. Z. Lederman 26-Mar-84
.;		       13-Apr-84 brought up to date
.;			7-May-84 add default exit for batch processing
.;
.;	INPUTS: none required, but will use $QUIET if defined.
.;
	.ENABLE SUBSTITUTION
	.ENABLE TIMEOUT
	.ENABLE DECIMAL
	.IFDF $QUIET .ENABLE QUIET
.;				Install utilities if not already installed.
@RMSINS
	.IFNINS SRT INS $SORT
	.IFNINS DTR INS $DTR
	.SETS $SYSID "Z"
.;					Remember where we are.
	.SETS OUIC <UIC>
.;					We want to be in a particular account.
SET /UIC=[1,6]
.;				See if there is a last file used message.
.;
	.TESTFILE [1,6]LASTFIL.ACC
	.IF <FILERR> = 1 .GOTO LSTFIL
.;
.;	No file information saved, ask for it.
.;	If we do not get a real answer, quit (assume batch processor)
.;
.ASK1:
	.SETS DEF "X.X;1"
	.ASKS [3:32:DEF:20S] INFILE Accounting information source file
	.IFT <TIMOUT> .EXIT <WARNIN>
	.IFF <DEFAUL> .GOTO ASK2
	.DISABLE QUIET
;
;	There is no default answer: you must enter a file name.
;
	.IFDF $QUIET .ENABLE QUIET
	.GOTO ASK1
.;					Get the date for the file name.
	.SETS DEF "01-JAN-81"
.ASK2:
	.ASKS [8:9:DEF:20S] DAT Traffic date
	.IFT <TIMOUT> .EXIT <WARNIN>
	.IFF <DEFAUL> .GOTO SET
	.DISABLE QUIET
;
;	There is no default answer. You must enter a traffic date of
;		the type shown.
;
	.IFDF $QUIET .ENABLE QUIET
	.GOTO ASK2
.SET:
.;					Strip out the date.
	.PARSE DAT "-" T1 T2 T3 A
	.GOTO SHOW
.;					We have a last file used file, use it
.;						for name and date.
.LSTFIL:
.;					Get oldest file first.
	.OPENR #1 [1,6]LASTFIL.ACC;-1
	.SETS A " "			! need to create variable
.;
.;				Skip directory header, then get real data.
	.READ #1 A
	.READ #1 A
.;					Separate file name.
	.PARSE A "." FILE A
.;					Separate extension.
	.PARSE A " " EXT A
.;					Strip off leading blanks.
.L1:
	.PARSE A " " B A
	.IF B = "" .GOTO L1
.;					Strip out date.
	.PARSE B "-" T1 T2 T3 A
.;					Strip trailing blanks from file name.
	.PARSE FILE " " FILE B
.;					Reconstruct file names.
	.SETS INFILE FILE+"."+EXT
.;					All information obtained.
	.CLOSE #1
	.ENABLE QUIET
	.SETT DELACC
.;				Convert the information to a readable form.
.SHOW:
	.DISABLE QUIET
SHOW ACCOUNTING/DATATRIEVE:'INFILE' ACNTRN.SEQ
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
	.ENABLE QUIET
.;				Clean up files.
PIP ACNTRN.SEQ/TR/NM
PIP ACNTRN.SEQ/PU/NM
.;
.;	Split out the device data from today's accounting file.
.;
	.DISABLE QUIET
SRT SY:DEVDAT.SEQ/FO:F:46 = SY:ACNTRN.SEQ/FO:F:120, SY:DEVICE
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
	.ENABLE QUIET
PIP SY:DEVDAT.SEQ/TR
.;		Don't need to keep a lot of old data: summaries are retained.
PIP SY:DEVDAT.SEQ/PU/NM
.;					Ditto for task reports.
	.DISABLE QUIET
SRT SY:TASK.SEQ/FO:F:64 = SY:ACNTRN.SEQ/FO:F:120, SY:TASK
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
	.ENABLE QUIET
PIP SY:TASK.SEQ/TR
PIP SY:TASK.SEQ/PU/NM
.;					Now Datatrieve can summarize data.
	.DISABLE QUIET
;
;	You may ignore any messages of the form
;
;	"Proceeding to report unsorted records" or
;	"Attempt to divide by zero"
;
;	Do not Control-C while DTR is running!
;
DTR :DEVICE-SUM-CREATE
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
DTR :RMD-CORRECT
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
DTR :REDUCED-TASK-CREATE
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
DTR :TASK-S-REPORT
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
	.ENABLE QUIET
.;					Create a file name.
	.SETS FILE $SYSID+T1+T2+T3
.;
.;	Clean up files and re-name files for reference.
.;
PIP DEVSUM.SEQ/TR/NM, TSKSUM.SEQ
	.IFNDF $QUIET .DISABLE QUIET
PIP 'FILE'.DEV/NV/RE/NM = DEVSUM.SEQ
PIP 'FILE'.TSK/NV/RE/NM = TSKSUM.SEQ
PIP 'FILE'.RPT/NV/RE/NM = TASKS.RPT
;PIP 'INFILE'/DE/NM
.;						Last file used indicator is
.;						no longer required.
	.IFT DELACC PIP LASTFIL.ACC;-1/DE/NM
	.IFDF $QUIET .ENABLE QUIET
.;					Put us back were we were.
SET /UIC='OUIC'
.;					Processing concludes successfully.
	.EXIT <SUCCES>
.EREXT:
	.DISABLE QUIET
;
;	A task had an unsuccessful exit status while processing
;		system accounting data.
;
	.EXIT <ERROR>
