c
c 	VAXNET global declarations
c
	implicit integer*4 (a-z)

	!  logical names used for assignment of I/O channels
	character*(*) 	localLogName,defaultLogNam
	parameter	(maxLogNames = 50)
	parameter	(noLinesErr = 998)
	parameter 	(localLogName = 'KERMIT$LOCAL')
	parameter 	(defaultLogNam = 'KERMIT$REM')

	parameter	(OFF = 0)
	parameter	(ON = 1)

	!  tty control characters
	integer 	CR,LF,cntlC,cntlD,cntlP,cntlY,
     1			unixInterrupt,unixEot,escapeChar
	parameter	(LOCALONLY = 0)
	parameter 	(CR = 13)
	parameter 	(LF = 10)
	parameter	(CNTLA = 1)
	parameter	(CNTLB = 2)
	parameter 	(CNTLC = 3)
	parameter 	(CNTLD = 4)
	parameter	(CNTLE = 5)
	parameter	(CNTLF = 6)
	parameter	(CNTLG = 7)
	parameter	(CNTLH = 8)
	parameter 	(CNTLI = 9)
	parameter 	(CNTLJ = 10)
	parameter	(CNTLK = 11)
	parameter	(CNTLL = 12)
	parameter 	(CNTLM = 13)
	parameter 	(CNTLN = 14)
	parameter	(CNTLO = 15)
	parameter	(CNTLP = 16)
	parameter 	(CNTLQ = 17)
	parameter 	(CNTLR = 18)
	parameter	(CNTLS = 19)
	parameter	(CNTLT = 20)
	parameter	(CNTLU = 21)
	parameter	(CNTLV = 22)
	parameter 	(CNTLW = 23)
	parameter 	(CNTLX = 24)
	parameter	(CNTLY = 25)
	parameter	(CNTLZ = 26)
	parameter 	(unixNewLine1 = CR)
	parameter 	(unixNewLine2 = LF)
	parameter 	(unixInterrupt = cntlC)
	parameter 	(unixEOT       = cntlD)
	parameter 	(escapeChar    = cntlP)

	!  I/O buffer sizes
	parameter 	localToRemoteBufSize = 500
	parameter 	remoteToLocalBufSize = 500
	parameter 	iosbBufferSize = 100
	parameter 	iosbArraySize = 400 

	!  max characters buffered before writing local terminal
	parameter 	maxLocalWrite = 500


	!  parameters governing monitoring of the remote system's typeahead buffer
	!
	! the terminal driver XOFFS the remote when the typeahead buffer has 
	! less than 8 characters left. A wait time of 10 msecs is 5 or 6
	! characters at 4800 baud. So typeAheadLimit must be at least 14 
	! smaller than maxTypeAhead.
	parameter maxTypeAhead = 78 	! system wide size of typeahead buffer
	parameter typeAheadLimit = 40 	! max chars allowed before we read
	character*(*) remoteWaitTime
	parameter (remoteWaitTime = '0 00:00:00.01')

	!  i/o commands to remote system read routine
	parameter keepReading = 1
	parameter stopReading = 2

	!  all event flags used herein
	parameter waitRemoEFN = 1

	!  variables
	integer*4 localReadFunc, remoteReadFunc, remoteTypeAhdFunc
	integer*4 localTerminator(2), remoteTerminator(2)
	integer*4 localReadSize
	integer*4 localWriteFunc, remoteWriteFunc

	!  i/o control storage
	integer*2 localReadIosb(4), remoteReadIosb(4)
	integer*2 localWriteIosb(4), remoteWriteIosb(4)
	integer*4 localChannel,remoteChannel
	integer*4 localWrtIosbUsed	! current # of write Iob buffers in use
					! and hence outstanding.
	integer*4 localWrtIosbAvail 	! current available buffer

	!  buffers
	logical*1 localToRemoteBuf(localToRemoteBufSize)  
	logical*1 remoteToLocalBuf(remoteToLocalBufSize)  
	integer*4 remoteReadStart	! pointer to empty space in read buf
	integer*4 localWriteChars 	! chars waiting to go to local term
	logical*4 waitingToReadRemote 	! indicates stalling for buffer space

	!  trace state variable set by the value of parameter tracing
	logical*1 firstTimeRun, noPassAll, firstTurn
	integer*4 remoteReadCnt

	!  termination code for exit handler (not currently used)
	integer*4 exitStatus
	logical*4	connected, shuttingDown

	common /global/ localToRemoteBuf, remoteToLocalBuf,
     1			localWriteSize, localReadSize,
     1			localChannel, remoteChannel,
     1			localReadFunc, remoteReadFunc,
     1			localTerminator, remoteTerminator,
     1			localWriteFunc, remoteWriteFunc,
     1			localReadIosb, remoteReadIosb, 
     1			localWriteIosb, remoteWriteIosb,
     1			localWrtIosbAvail,localWrtIosbUsed, 
     1			waitingToReadRemote, localWriteChars,
     1			remoteReadStart, exitStatus, firstTimeRun,
     1			noPassAll, remoteReadCnt,
     1			connected, shuttingDown

