{$E+}
{ Initialization & finish - up }

 PROCEDURE ConLow; { Console lower case }
 EXTERNAL;

 PROCEDURE Sclose(fd: filedesc);
 EXTERNAL;

 PROCEDURE SYSfinish;
 EXTERNAL;

 PROCEDURE SYSinit;
 EXTERNAL;

  { initio (RT-11) -- initialize open file list }
 PROCEDURE initio;
  VAR
    i : filedesc;
   BEGIN
     openlist[STDIN].mode := IOREAD;
     openlist[STDOUT].mode := IOWRITE;

     redirect[STDIN] := STDIN;
     redirect[STDOUT] := STDOUT;

     openlist[STDERR].mode := IOWRITE;

     { connect STDERR to user's terminal ... }
     rewrite(openlist[STDERR].filevar,'TI:');

     { initialize rest of files }
     FOR i := STDERR+1 TO MAXOPEN DO
     openlist[i].mode := IOAVAIL;

     openlist[DL11LINE].mode := IOLINE;
     openlist[BINARYFILE].mode := IOERROR;

     ConLow; { allow lower case }

     new(ThisPacket);
     new(LastPacket);
     new(CurrentPacket);
     new(NextPacket);
     new(InputPacket);

   END;


  PROCEDURE KermitInit;  { initialize various parameters  & defaults }
   BEGIN
     Pad := DEFPAD;               { set defaults }
     MyPad := DEFPAD;
     PadChar := DEFPADCHAR;
     MyPadChar := DEFPADCHAR;
     TheirTimeOut := DEFTIMEOUT;
     MyTimeOut := DEFTIMEOUT;
     Delay := DEFDELAY;
     SizeRecv := MAXPACK;
     SizeSend := MAXPACK;
     SendEOL :=  CR; 			
     MyEOL :=  CR;
     SendQuote := DEFQUOTE;
     MyQuote := DEFQUOTE;
     MaxTry := DEFITRY;
     QuoteForBinary := ENDSTR;		{ to indicate not defined yet }
     
     EOLforFile := LineFeed;

     Local := false;      { default to remote }

     OneWayOnly := false;
     Verbosity := false;       { default to false / only valid if local }
     Debug := false;
     RunType := invalid;
     DiskFile := IOERROR;      { to indicate not open yet }
     LineIN := STDIN;
     LineOUT := STDOUT;
     exitProgram := false;
     invalidConnection := true;

     { defaults for parser }

     localEcho := oOFF;
     fileWarn := oOFF;
     debugging := oOFF;
     parity := oEVEN;
     eightBitQuoting := oON;

     SYSinit;             {  system dependent  }

   END;


  PROCEDURE FinishUp(ok : boolean); { do any End of Program clean up }
   BEGIN
     Sclose(DiskFile);
     SYSfinish;              { do System dependent }
     oldRunType := RunType;
   END;

