@Part(CPMKERMIT,root="USER")
@Chapter<CP/M-80 KERMIT>
@Begin<Description,Leftmargin +12,Indent -12,spread 0>
@i(Program:)@\Bill Catchings, Columbia University,
with contributions from Bernie Eiben (DEC), Nick Bush (Stevens),
John Bray (University of Tennessee), Bruce Tanner (Cerritos College),
Greg Small (University of California at Berkeley),
Kimmo Laaksonen (Helskini University of Technology), and many others.

@i(Language:)@\8080 Assembler or MAC80

@i(Version:)@\3.9

@i(Date:)@\April 1984

@i(Documentation:)@\Frank da Cruz, Columbia University
@end<Description>
@label<-k80>

@i<KERMIT-80 Capabilities At A Glance:>
@begin<format,leftmargin +2>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\No
Transfers text files:@\Yes
Transfers binary files:@\Yes
Wildcard send:@\Yes
@q<^X/^Y> interruption:@\Yes
Filename collision avoidance:@\Yes
Can time out:@\Yes 
8th-bit prefixing:@\Yes
Repeat count prefixing:@\No
Alternate block checks:@\Yes
Terminal emulation:@\Yes, VT52 and others
Communication settings:@\Yes; duplex, parity
Transmit BREAK:@\Yes; some versions
IBM communication:@\Yes
Transaction logging:@\No
Session logging (raw download):@\Yes
Raw upload:@\Yes
Act as server:@\No
Talk to server:@\Yes; SEND, GET, FIN, BYE
Advanced commands for servers:@\No
Local file management:@\Yes; DIR, ERA, SET DEFAULT disk
Handle file attributes:@\No
Command/init files:@\No
Printer control:@\Yes, limited 
@end<format>

@heading<Summary of CP/M>

CP/M-80 (version 2@q<.>2)
has only five built-in commands, and they all deal with files;
other functions are done by invoking programs.

CP/M file specifications are of
the form @q(DEV:XXXXXXXX.YYY), where
@begin<description>
 @q(DEV:)@\is a @i<device name>,
normally the A:@ or B:@ floppy.  If omitted, the device name defaults
to your connected diskette.

@q(XXXXXXXX)@\is a @i<filename> of up to 8 characters.

@q(YYY)@\is the @i<file type>, up to 3 characters.
 @end<description>
 File names and file types may contain letters, digits, and some
special characters, including dash, dollar sign, and underscore, but
no imbedded spaces.  Upper and lower case letters are equivalent.

 "Wildcard" file-@|group specifications are permitted in file names
and file types (but not device names) within certain contexts; a "@q(*)"
matches a whole field, a "@q(?)"  matches a single character, including
space.  Examples: "@q(*.F??)" specifies all files whose @i<types> start
with F and are 1, 2, or 3 characters long; "@q(F?.*)" specifies all
files whose names start with F and are no more than two characters
long (before the trailing spaces).

The five CP/M commands are:
 @Begin<Description>
DIR @i<file>@\Lists the the names of the specified files.  The
default file specification is "*.*".  Example: @w<"@q(DIR B:*.FOR)">.

ERA @i<file>@\Erases (deletes) the specified file(s); wildcards allowed.

REN @i<new> @i<old>@\Changes the name of a file from @i<old> to @i<new>, e.g.@*
@w<"@q(REN NEW.FOR=OLD.FOR)">.

SAVE@\Saves the specified number of memory blocks into a file.

TYPE @i<file>@\Types the specified file on the screen, e.g.
@w<"@q(TYPE FOO.TXT)">.
 @End<Description>
The most important programs are:
 @Begin<Description>
STAT@\Gives statistics on disk usage.

PIP@\@u<P>eripheral @u<I>nterchange @u<P>rogram.  Copies files.  In
response to the "@q(*)" prompt, give a command of the form
 @example<disk:outfile=disk:infile>
 Wildcards ("@q(*)" for a whole field or "@q(?)"  for a letter) can be used.
Examples: "@q(A:=B:*.*)" to copy a whole disk, "@q(A:=B:*.FOR)" to copy all
the Fortran programs from disk B to disk A.  If the disk specification
is omitted, your "connected" disk is assumed.  Command line arguments
are also accepted, e.g. "@q(PIP A:=B:*.*)".
@End<Description>
For further information on CP/M, consult your microcomputer manual or
a CP/M handbook.

@heading<KERMIT-80 Description>

Implementations of Kermit-80 presently exist for the DEC VT180@ (Robin), the
DECmate II, the Intertec Superbrain, the Heath/Zenith 89 and Z100, the @w<Apple
II> with the Z80 SoftCard, the @w<Osborne 1>, the TRS-80 II with CP/M, the
Telcon Zorba, the Kaypro, the Vector Graphics CP/M system, the Morrow
@w<Decision I>, the Nokia MikroMikko, and others.  There
is also a "generic" CP/M version that should run on most 8080-@|compatible CP/M
2.2 systems, but which may provide less performance, and another for CP/M 3.0.

@index<Timeout>
Since Kermit-80 runs on a standalone micro, it is always in control of the
screen -- it is always @i<local>@index<Local>.  Thus, it always keeps the
screen updated with the file name and the packet number, whether sending or
receiving.  Kermit-80 is capable of an imprecise or "fuzzy" timeout on an
input request, and can break deadlocks automatically.  In most cases, this is
not important, because the KERMIT on the other side is most likely able to
handle the timeouts.  The timeouts done by Kermit-80 are fuzzy because they
depend on the speed of the Z80 processor and other factors that can vary from
system to system.

If despite the timeout capability, the transmission appears to be stuck (and
you can tell that this has happened if the screen fails to change for a while)
you can type carriage return to have the micro do what it would have done on a
@Index[Timeout] timeout, namely NAK@Index[NAK] the expected packet to cause to
foreign host to send it again (or, if the micro is sending, to retransmit the
last packet).  Micro/@|micro or micro/@|IBM-@|mainframe transfers could require
this kind of manual intervention.

File transfers may be interrupted in several ways.
@begin<description>
Control-C@\This will return you to Kermit-80 command level immediately, so that
you can connect back to the remote system, or take any other desired action.

Control-X@\When sending a file, this will terminate the sending of the current
file with a signal to the KERMIT on the other side to discard what it got so
far.  If there are more files to be sent, KERMIT-80 will go on to the next one.
When receiving a file, KERMIT-80 will send a signal to the remote KERMIT to
stop sending this file.  If the remote KERMIT understands this signal (not all
implementations of KERMIT do), it will comply, otherwise the file will keep
coming.  In any case, the remote KERMIT will go on to the next file in the
group, if any.

Control-Z@\Like Control-X, except if a file group is being transmitted, this
will stop the transmission of the entire group.  If only a single file is being
transmitted, it works exactly like Control-X.

Carriage Returns@\If you type carriage return repeatedly Kermit-80 will retry
the current packet up to its retry limit (somewhere between 5 and 16 times) and
then, if no valid response was received, return to Kermit-80 command level.
@end<description>

@heading<Kermit-80 Commands>

KERMIT-80 uses the DECSYSTEM-20 keyword style command language.  Each keyword
may be abbreviated to its minumum unique length.  "?" may be typed to request a
menu of the available options for the current field at any point in a command.
ESC may be typed at any point in a command to fill out the current keyword or
filename; if sufficient characters have not been typed to identify the current
field uniquely, KERMIT-80 will sound a beep and allow you to continue from that
point.
@begin<description,leftmargin +8,indent -8>
@Index[Virtual Terminal]@Index[Escape Character]@Index[Connect]
CONNECT@\Establish a "virtual terminal" connection to any host that may be
connected to the serial port, i.e.@ pass all typein to the serial port and
display all input from the serial port on the screen.  Also, emulate a DEC VT52
to allow cursor control, screen clearing, etc., if VT52-EMULATION is ON (see
below), in which case you should also set your terminal type on the remote host
to VT52.  (Some versions emulate other terminals.)  The escape character
differs from micro to micro; when you issue the CONNECT command, the micro will
print a message telling you how to get back.  The escape sequence is generally
an uncommonly-@|used control character, like CTRL-backslash or
CTRL-rightbracket, followed by a single letter "command".
 @begin<description,spread 0,leftmargin +4, indent -4>
C@\Close Connection, return to @q(Kermit-80>) command level.

S@\Display Status of connection, but maintain remote connection.

@q<?>@\List available single-character commands.

0@\(zero) Send a null (0) character.

B@\Send a BREAK signal.  Only some systems provide this function.

@q<^]>@\(or whatever - a second copy of the escape character) Send the
escape character itself to the remote host.
 @end<description>

@Index[SEND]SEND @i<filespec>@\Send file(s) specified by @i<filespec> to
the remote Kermit.  The @i<filespec> may contain CP/M wildcards.

@Index[RECEIVE]@Index[File-Warning]
RECEIVE@\Receive file(s) from the remote
Kermit.  Store them under the names provided in the file headers supplied by
the remote host.  If the names aren't legal, use as many legal characters from
the name as possible (see the description of SET FILE-WARNING below).  If
there's a conflict, and FILE-WARNING is ON, warn the user and try to build a
unique name for the file by adding "@q<&>" characters to the name.

@Index<GET>GET @i<filespec>@\When Kermit-80 is talking to a Kermit Server on
the host, you should use the GET command to request the server to send
files to you, for example: @q[@w<get hlp:k*.hlp>] Limitation: If you request
an alternate block check type using the SET BLOCK command, the GET command will
not communicate it to the remote server.  If you want to have type 2 or 3 block
checks done when getting files from the server, you have to issue the
appropriate SET BLOCK command to the remote KERMIT before putting it in server
mode.

@Index[LOG]LOG @i<filespec>@\When CONNECTed to a foreign host as a terminal,
log the terminal session to the specified diskette file.  This functionality
depends to some extent on the remote host's ability to do
@Index[XON/XOFF]XON/XOFF flow control, and does not guarantee a complete
transcript (after all, that's what the KERMIT protocol is for).  The log file
is closed when the connection is closed by typing the escape character followed
by the single-@|character command "C".

@Index[TRANSMIT]TRANSMIT @i<filespec>@\Send the specified file to the system on
the other end of the connection as though it were being typed at the terminal,
one line at a time.  No KERMIT protocol is involved.  You must manually confirm
each line.  This is useful for sending files to systems that don't have a
KERMIT program.  During transmission, you may type the escape character
followed by one of these single-@|character commands:
@begin<description,spread 0,leftmargin +4, indent -4>
C@\Cease transmission

R@\Re-transmit the previous line
@end<description>

BYE@\When talking to a remote Kermit Server, this command shuts down
the server and logs it out, and also exits from Kermit-80 to CP/M command
level.@Index[BYE]

@Index[LOGOUT]LOGOUT@\Like BYE, but leaves you at Kermit-80 command level.

@Index[FINISH]FINISH@\Like LOGOUT, but shuts down the remote server without
logging it out.  Leaves you at Kermit-80 command level; subsequent CONNECT
commands will put you back at host system command level.

@Index[SET]SET @i<parameter> [@i<value>]@\Set the specified parameter to
the specified value.  Possible settings:
@begin<description,leftmargin +8,indent -8>
@Index[Warning]WARNING ON (or OFF)@\Warn user of filename conflicts when
receiving files from remote host, and attempt to generate a unique name by
adding "@q<&>" characters to the given name.  ON by default.

@Index[VT52]VT52-EMULATION ON (or OFF)@\When connected as a terminal
to a foreign host, controls whether the micro emulates a VT52 or
runs in "native mode".  VT52 emulation is ON by default, except on micros
that already have terminal functionality built in, such as the DEC VT180 and
DECmate (these act as @index<VT100>VT100-@|series terminals).  Some systems
emulate other terminals, like the ADM3A.

@Index[Local-Echo]LOCAL-ECHO ON (or OFF)@\When you CONNECT to a remote
host, you must set LOCAL-@|ECHO ON if the host is half duplex, OFF if
full duplex.  OFF by default.

@Index[Escape Character]ESCAPE@\Change the escape character for
virtual terminal connections.  Kermit-80 will prompt you for the new
escape character, which you enter literally.

@Index[Baud]BAUD@\Change the baud rate of the communications port.  This
command only works on some systems, and its actual operation can vary from
system to system.  Type SET BAUD followed by a question mark, and follow the
directions.  On systems that do not support this command, you must set the port
baud rate from CP/M or other setup mechanism outside of KERMIT-80.

@Index[Parity]PARITY@\Sets parity for outgoing characters to one of the
following: NONE, SPACE, MARK, EVEN, or ODD.  On input, if parity is NONE, then
the 8th bit is kept (as data), otherwise it is stripped and ignored.  The
parity setting applies to both terminal connection and file transfer.
If you set parity to anything other than none, KERMIT-80 will attempt to use
@Index<Eighth-Bit Prefix>
"8th bit prefixing" to transfer binary files.  If the other KERMIT is also
capable of 8th bit prefixing, then binary files can be transferred
successfully; if not, the 8th bit of each data byte will be lost (you will see
a warning on your screen if this happens).

@Index[TIMER]TIMER ON (or OFF)@\Enable or disable the "fuzzy timer".  The timer
is off by default, because in the normal case KERMIT-80 is communicating with a
mainframe KERMIT that has its own timer.  Mainframe KERMIT timers tend to be
more precise or adaptable to changing conditions.  You should SET TIMER ON if
you are communicating with a KERMIT that does not have a timer.  You should SET
TIMER OFF if you are communicating over a network with long delays.

@Index[IBM]IBM ON (or OFF)@\Allow the transfer of files to and from an IBM
mainframe computer.  This makes Kermit-80 wait for the IBM turnaround character
(XON), ignore parity on input, add appropriate parity to output, and use local
echoing during CONNECT.  As distributed, KERMIT-80 uses MARK parity for IBM
communication.  If you don't give this command, IBM mode is OFF.  Since IBM
VM/CMS KERMIT does not have timeout capability, SET IBM ON also turns on the
"fuzzy timer" automatically.

@Index[Block Check]BLOCK-CHECK-TYPE@\The options are:
@begin<description,spread 0,leftmargin +8,indent -8>
1-CHARACTER-CHECKSUM@\Normal, default, standard 6-bit checksum.

2-CHARACTER-CHECKSUM@\A 12-bit checksum encoded as two characters.

3-CHARACTER-CRC-CCITT@\A 16-bit CCITT-format Cyclic Redundancy Check, encoded
as 3 characters.

@end<description>
The 2 and 3 character options should only be used under conditions of extreme
line noise.  Many implementations of KERMIT only support the single character
checksum.

FILE-MODE@\Tells KERMIT-80 what kind of file it is sending, so that KERMIT can
correctly determine the end of the file.  SET FILE BINARY means to send all the
128-@|byte blocks of the file, including the last block in its entirety; SET
FILE ASCII is used for text files, and transmission stops when the first
Control-Z is encountered anywhere in the file (this is the CP/M convention for
marking the end of a text file).  If binary transmission is used on a text
file, some extraneous characters (up to 127 of them) may appear at the end of
the file on the target system.  If ASCII transmission is used on a binary file,
the entire file will not be sent if it happens to contain any data bytes that
correspond to Control-Z.

DEFAULT-DISK@\This allows you to set the default disk as source and destination
of file transfers.  In addition, issuing this command causes you to switch to
the specified disk and log it in, write-@|enabled.  The selected disk appears
in your KERMIT-80 prompt, for instance @example[Kermit-80 A:>]

PORT@\Allows you to switch between different communication ports.  This command
is not available on all systems.

PRINTER@\ON or OFF.  Turns copying of CONNECT session to printer on and off.
No attempt is made to do buffering or flow control; it is assumed printer can
keep up.
@end<description>

DIR@\This provides a directory listing of the specified files.  If no files are
specified, all files on the default disk are listed.  File sizes, in K, are
included.  You may interrupt the listing at any time by typing any character.
The listing (even if interrupted) concludes with a display of the amount of
free storage left on the disk.

ERA@\This executes the CP/M ERA command on the specified file(s).  The names of
the files being erased are not displayed.
@end<description>

@section<Generic KERMIT-80>

@index<Generic Kermit-80>@index<8080> "Generic Kermit-80" is a implementation
of Kermit that should run on any 8080-@|compatible CP/M system no modification
at all, or perhaps only a minor one.  Unlike other Kermit-80 implementations,
it contains no system-@|dependent manipulation of the serial port or screen.
All I/O is done with standard CP/M BIOS@index<BIOS> calls, and I/O redirection
is done using the CP/M IOBYTE function, which, according to the Digital
Research @i<CP/M Operating System Manual>, is an optional feature of any
particular CP/M implementation.  If your system does not provide the IOBYTE
function, Generic Kermit-80 will not work; furthermore, not all systems that
implement IOBYTE do so in the same way.

 The reason all Kermit-80 implementations aren't
generic is that a good deal of speed is sacrificed by getting all services from
the operating system.  While a specific implementation of Kermit-80 may be able
to operate at 4800, 9600, or even 19200 baud, Generic Kermit will fail to work
on some systems at speeds in excess of 1200 baud.

Generic Kermit also differs from other Kermit-80 implementations in that it
does not do fancy screen control during file transfer; it simply types the
file names, packet numbers, and messages in sequence across and down the
screen.  This works best if you can put your micro or terminal in "autowrap"
mode; otherwise the packet numbers will pile up in the rightmost column; the
filenames and messages will always appear on a new line, however.  Neither does
generic Kermit-80 do termimal emulation; thus a generic Kermit-80 acts either
as a "dumb terminal" (sometimes called a "glass TTY"), or else its own built in
terminal firmware provides cursor control functions independent of the Kermit
program.

Note that VT180 and DECmate-II Kermit are simply adaptations of Generic Kermit
that do VT100 (ANSI) screen control during file transfer.

@section<Installation>

Kermit-80 was written originally for the @Index[Superbrain] Intertec SuperBrain
in lowest-@|common-@|denominator @Index[8080] 8080 code with
the standard assembler, ASM (no macros, no advanced instructions), so that it
can be assembled on any CP/M-80 system@foot{The 8080 assembler is distributed
as a standard part of CP/M-80, whereas the fancier Z80@Index[Z80] or macro
assemblers are normally a commercial product}.  It has since been modified to
run on many other systems as well.  Kermit-80 should be able to run on any
8080-, 8085- or Z80-@|based microcomputer under @Index[CP/M] CP/M with only
minor modifications (see below).

All versions of Kermit-80 are assembled from the same source, with system
dependencies taken care of by assembly-@|time conditionals.  The most important
system dependencies are terminal emulation (when CONNECTed to the remote host)
and screen handling, which are dependent on the individual micro's escape codes
(these features are table driven and easily modified for other CP/M systems),
and the lowest level i/o routines for the serial communications port.  The port
routines are best done only with BDOS calls, but some systems do not allow
this, primarily because the BDOS routines strip the parity bit during port i/o,
and the parity bit is used for data when transmitting binary files.  Also,
using BDOS calls, there's no way to poll the serial port; you must hang until
input appears.

Kermit-80's i/o routines must check the port status and go elsewhere if no
input is available; this allows for virtual terminal connection, keyboard
interruption of stuck transmissions, etc.  On systems that fully implement i/o
redirection via the optional CP/M IOBYTE facility, this may be done by
switching the IOBYTE definition.  On others, however, IN/OUT instructions
explicitly referencing the port device registers must be used.

@index<Timeout>
CP/M-80 KERMIT version 3.8 and above includes a "fuzzy timer" that allows a
timeout to occur after an interval ranging from 5 to 20 seconds (depending upon
the speed of the processor and the operating system routines) during which
expected input does not appear at the port.  In this case, retransmission
occurs automatically.  In any case, you may type a carriage return during
transmission to simulate a timeout when the transfer appears to be stuck.

@subsection<Downloading Kermit-80>

If you already have a version of Kermit on your micro and you want to install
a new version, simply use your present version to get the new one.  If it's
stored in the form of a @q<.COM> file, you can run it directly.  If it's stored
as a @q<.HEX> file, you must first LOAD it on your micro to produce a @q<.COM>
file.

If you do not have a copy of KERMIT on your micro, and you cannot borrow a
Kermit floppy but you do have access to a mainframe computer with a copy of the
Kermit-80 distribution, you should read this section.

@Index[Bootstrap]@index<Downloading> There are several ways to get Kermit from
a host system to your micro.  The easiest is to "download" the precompiled
"hex" file into your micro's memory and then save it on the disk.  The
following is a procedure which, though far from foolproof, should allow you to
get a version of Kermit to your CP/M based micro.  It depends upon the host
prompt, or at least the first character of the host prompt, being some
character that cannot appear in a hex file (the valid characters for hex files
are the digits 0-9, the upper case letters A-F, the colon ``@q<:>'', carriage
return, and line feed).  As soon as any other character is encountered, the
transfer will terminate.  If your host does not issue a prompt that will
accommodate this scheme, you can achieve the same effect by modifing the adding
an atsign ``@@'' to the very end of the hex file before sending it from the
host.  The program below looks for an atsign (the normal DEC-20 prompt, hex
40).  DECSYSTEM-10 users would look for a dot, hex 2E.
 @Begin <Enumerate>
Look for the appropriate hex file in the host's KERMIT area.  The name will be
something like @q<CPMROBIN.HEX>, @q<CPMHEATH.HEX>, @q<CPMOSBORN.HEX>, etc.
If you don't find it, but you do find a corresponding @q<.ASM> or @q<.M80>
file, you'll either have to build a new hex file on the host using a cross
assembler (see below for how to do this on a DEC-10 or DEC-20), or else bring
the M80 source file to your micro and assemble it there.

Connect to your host using a terminal or a terminal emulation facility.  Ensure
that your host does not have your terminal in "page mode".  E.g. on the DEC-20,
give the Exec command @q<TERMINAL NO PAUSE END-OF-PAGE>.

Tell the host to display the hex file at your terminal.  E.g. on the DEC-20,
give the Exec command @q<TYPE KERMIT.HEX>, @i<@u(without) a terminating
carriage return>.

Return to your micro.  Connect to a floppy disk with plenty of free space.
Make sure your IOBYTE is set so that @q<RDR:> and @q<PUN:> correspond to the
I/O port that is connected to the DEC-20 (this would normally be the case
unless you have done something special to change things).  Run DDT and type in
the following (the comments should not be typed in; they are there just to tell
you what's happening):
@Begin <Example,Free>
-ikermit.hex            ;Setup FCB for file KERMIT.HEX.
-a100                   ;Begin assembling code at 100.
0100 lxi h,ffe          ;Where to put HEX file.
0103 shld 300           ;Save the address.
0106 mvi e,d            ;Get a CR.
0108 mvi c,4            ;Output function.
010A call 5
010D mvi c,3            ;Input function.
010F call 5
0112 ani 7f             ;Turn off the parity.
0114 cpi 40             ;Our DEC-20 prompt atsign?
0116 jz 124             ;Yes, we have whole file.
0119 lhld 300           ;Get the pointer.
011C mov m,a            ;Else, store the char.
011D inx h              ;Increment the pointer.
011E shld 300           ;Save the pointer.
011F jmp 10d            ;Go around again.
0124 mvi a,1a           ;Get a control-Z.
0126 lhld 300           ;Get the pointer.
0129 mov m,a            ;Store the char.
012A shld 300           ;Save the pointer.
012D lxi h,1000         ;Pointer to file.
0130 shld 310           ;Save the pointer.
0133 mvi c,16           ;Make file.
0135 lxi d,5c
0138 call 5
013B lhld 310           ;Get the file pointer.
013E xchg               ;Put it in DE.
013F mvi c,1a           ;Set DMA.
0141 call 5
0144 mvi c,15           ;Write DMA to file.
0146 lxi d,5c
0149 call 5
014C lhld 310           ;Get the file pointer.
014F lxi d,80           ;Get the DMA size.
0152 dad d              ;Adjust file pointer.
0153 shld 310           ;Save it.
0156 lda 301            ;Get high order byte.
0159 cmp h              ;Have we passed the end?
015A jm 170             ;Yes.
015D jz 163             ;Maybe.
0160 jmp 13b            ;No.
0163 lda 300            ;Get low order byte.
0166 cmp l              ;Passed the end?
0167 jm 170             ;Yes.
016A jz 170             ;Yes.
016D jmp 13b            ;Not quite.
0170 mvi c,10           ;Close file.
0172 lxi d,5c
0175 call 5
0178 ret
0179
-g100,179               ;Execute the program.
-                       ;Reboot
@End<Example>
 Now there should be a file @q<KERMIT.HEX> on your connected disk.

Load this using the CP/M command LOAD to produce @q<KERMIT.COM>.  This should
be a runnable version of Kermit.  Note that CP/M hex files have checksums on
each line.  If there were any transmission errors during the downloading
process, the CP/M loader will notice a bad checksum and will report an error
(something like "Illegal Format").  If you get any errors during loading,
either fix the hex file locally with an editor, or repeat the previous step.
 @End<Enumerate>

You now should have a running version of Kermit-80.

@subsection<Building KERMIT.HEX>

The source for Kermit-80 should be available on your host computer.  It is
written using 8080 assembler mnemonics, so it can be assembled on most 8080s
and Z80s using the standard 8080 assembler provided with CP/M.  If you have
@q<KERMIT.ASM> on your CP/M system, you can assemble it directly on the micro
using ASM, setting the desired assembly switches as explained below.  If you
don't have it, you can attempt to download the source file from the host using
the procedure outlined above.

A cross assembler @index<Cross Assembler> is provided that runs on the
@index<DECSYSTEM-20>@index<DECsystem-10> DEC-10 and DEC-20, called MAC80,
contributed by Bruce Tanner at Cerritos College, that may be used for cross
assembling KERMIT-80 as shown in this example (for TOPS-20):
 @begin<enumerate>
Copy @q(PS:<KERMIT>CPMK@i<xx>.M80) to your directory, as @q<KERMIT.M80>.
TOPS-10 filename rules must be followed.  This is the 8080 assembler source
file; @i<xx> is the current version number; for instance version 3.8 would be
stored as @q<CPMK38.M80>.

Edit @q<KERMIT.M80> to set the conditional assembly switch for your machine.
These are right near the top of the file.  The switch for your machine should
be set to TRUE and all the others to FALSE.

The "ibm-flag" setting is site dependent.  As shipped from Columbia, it turns
on half duplex line handshaking, using CTRL-Q as the turnaround character, sets
LOCAL-ECHO ON, TIMER ON, and PARITY MARK.  Make any changes required for your
site.

The default FILE-MODE is ASCII as shipped from Columbia.  This means that when
text files are sent from the CP/M system, no extraneous characters will be sent
after the end, but that outgoing binary files may be truncated erroneously if
the user forgets to SET FILE BINARY.  You can change the default to BINARY, so
that no data is ever lost from any file, but text files will usually have
extraneous junk at the end.

@begin<multiple>
@index<MAC80>@index<Hex File>
Run MAC80:
@begin<example>
@@@u<mac80>
*@ux<kermit=kermit>
*@ux<^Z>
@end<example>
The result will be in your directory as @q<KERMIT.HEX>.
@end<multiple>

Use Kermit, MODEM, or any other downloading mechanism to transfer
@q(KERMIT.HEX) to the micro, or download it using the DDT program shown above.

On the micro, load the hex file:
@example{A>@ux[load kermit]}
@q(KERMIT.COM) will appear on the floppy.

 The new Kermit should be ready to run.
 @end<enumerate>

@subsection<Generic Kermit-80>

@index<Generic Kermit-80>@Index<IOBYTE>
If your CP/M 2.2 system implements i/o redirection via the (optional) IOBYTE
mechanism, you can probably run Generic Kermit on it, either without
modification, or by a very simple change to the program.  The standard CP/M
IOBYTE is set up as follows:
@begin<verbatim,group,blanklines hinge>
I/O Byte assignments (four 2-bit fields for 4 devices at location 3)
:
bits 6+7        LIST field
    0           LIST is Teletype device (TTY:)
    1           LIST is CRT device (CRT:)
    2           LIST is Lineprinter (LPT:)
    3           LIST is user defined (UL1:)

bits 4+5        PUNCH field
    0           PUNCH is Teletype device (TTY:)
    1           PUNCH is high speed punch (PUN:)
    2           PUNCH is user defined #1 (UP1:)
    3           PUNCH is user defined #2 (UP2:)

bits 2+3        READER field
    0           READER is Teletype device (TTY:)
    1           READER is high speed reader (RDR:)
    2           READER is user defined #1 (UR1:)
    3           READER is user defined #2 (UR2:)

bits 0+1        CONSOLE field
    0           CONSOLE is console printer (TTY:)
    1           CONSOLE is CRT device (CRT:)
    2           CONSOLE is in Batch-mode (BAT:); READER = Input, LIST = Output
    3           CONSOLE is user defined (UC1:)
@end<verbatim>
(Here, bit zero is the least significant, "rightmost", bit).

I/O redirection is accomplished by switching the IOBYTE between two values,
"batch i/o" and "normal i/o".  In normal i/o mode, the keyboard is defined to
be the console.  In batch i/o mode, the serial port is defined to be the
console.  This switching is necessary because the console is the only device
that can be tested to see if input is available, but KERMIT must shuttle back
and forth between the keyboard @i<and> the serial port looking for input.  Here
are the batch and default i/o mode definitions used in "standard" Generic
KERMIT-80:
@begin<verbatim>

batio   EQU     056H            ;I/O byte CON=BAT,LIST=CRT,READER=RDR
defio   EQU     095H            ;I/O byte CON=CRT,LIST=LPT,READER=RDR
@end<verbatim>

Other systems may have other logical devices that point to the serial port,
in which case you'll need to redefine these symbols to point to those devices
and then reassemble the program (with assembly switch GENER set to TRUE, all
others FALSE).

If your system runs CP/M 3.0, then the CPMPLUS version of KERMIT should run on
your system without modification, except perhaps for screen control or baud
rate setting.
