C+
C  GET_TERMTYPE     Return the code showing the type of terminal currently
C		    in use for SYS$INPUT.  If SYS$INPUT is part of a batch
C		    stream, or not a terminal return Iterminal=0 to 
C		    such to mainline.
C
C	CALL GET_TERMTYPE(Itype)
C
C	where Itype I*4	  Device type code from $DVIDEF
C
C
C	Written by:	James G. Downward
C			KMS Fusion, Inc.
C			P.O. Box 1567
C			Ann Arbor, Mich 48104
C			(313)-769-8500
C			12-Nov-1982
C			
C-
C
	SUBROUTINE GET_TERMTYPE(Itype)
	IMPLICIT INTEGER*4 (A-Z)
	INTEGER*2 DVI_Code,DVI_Length,DVI_Header(2)	! For GETDVI setup
	INTEGER*4 LIST(3), LENGTH			!


	EQUIVALENCE (DVI_Header(1),DVI_Length)
	EQUIVALENCE (DVI_Header(2),DVI_Code)
	EQUIVALENCE (DVI_Header(1),LIST(1))

	PARAMETER (DT$_TTYUNKN=	0)			! Unknown
	PARAMETER (DT$_VT05=	1)			! **Unknown**
	PARAMETER (DT$_VK100=	2)			! Vk100 video board
	PARAMETER (DT$_VT173=	3)			! **Unknown**
	PARAMETER (DT$_FT1=	16)			! Tek 4014 term
	PARAMETER (DT$_FT2=	17)			! NBI Term
	PARAMETER (DT$_FT3=	18)			! **Unknown**
	PARAMETER (DT$_FT4=	19)			! **Unknown**
	PARAMETER (DT$_FT5=	20)			! **Unknown**
	PARAMETER (DT$_FT6=	21)			! **Unknown**
	PARAMETER (DT$_FT7=	22)			! **Unknown**
	PARAMETER (DT$_FT8=	23)			! **Unknown**
C ... hard copy terminals
C ...
	PARAMETER (DT$_LAX=	32)			! Send 7 LF FF to all
	PARAMETER (DT$_LA36=	32)			! hard copy terminals
	PARAMETER (DT$_LA120=	33)			! unless have form ctl
	PARAMETER (DT$_LA34=	34)			!
	PARAMETER (DT$_LA38=	35)			!
	PARAMETER (DT$_LA12=	36)			!
	PARAMETER (DT$_LA24=	37)			!
	PARAMETER (DT$_LA100=	37)			!
	PARAMETER (DT$_LQP02=	38)			!
C ... Video terminals
C ...
	PARAMETER (DT$_VT5X=	64)			!  **Unknown**
	PARAMETER (DT$_VT52=	64)			! Treat as VT52
	PARAMETER (DT$_VT55=	65)			! Treat as VT52
	PARAMETER (DT$_VT100=	96)			! Treat as VT100
	PARAMETER (DT$_VT101=	97)			! Treat as VT100
	PARAMETER (DT$_VT102=	98)			! Treat as VT100
	PARAMETER (DT$_VT105=	99)			! Treat as VT100
	PARAMETER (DT$_VT125=	100)			! Treat as VT100
	PARAMETER (DT$_VT131=	101)			! Treat as VT100
	PARAMETER (DT$_VT132=	102)			! Treat as VT100

C
C ... For finding device type
	PARAMETER (DC$_TERM=	'42'X)			! If device a terminal
C
	DVI_Code =4					! Get from $DVIDEF
	DVI_Length = 4					! 4 bytes long
	LIST (2) = %LOC(IType)				! Set up GETDVI
	LIST (3) = %LOC(Ilength)			! 
	ISTATUS=SYS$GETDVI(,,'SYS$INPUT',LIST,,,,)	!
	IF(.NOT.Istatus)		THEN 		!
	  TYPE *,'GETDVI failed in TERMTYPE'		!
	  CALL EXIT
	END IF
	IF(Itype.NE.DC$_TERM)		THEN		!
C	  TYPE *,'FATAL -- SYS$INPUT is not a terminal. Exiting...'
C	  GOTO 1000
	  Itype=0					!
	  RETURN					!
	END IF

	DVI_Code =6					! Get from $DVIDEF
	DVI_Length = 4					! 4 bytes long
	LIST (2) = %LOC(IType)				! Set up GETDVI
	LIST (3) = %LOC(Ilength)			! 
	ISTATUS=SYS$GETDVI(,,'SYS$INPUT',LIST,,,,)	!
	RETURN						!
	END
