C+
C  PAGE		Erase the screen of a video terminal or move to
C		a new page on a hardcopy device.
C
C	CALL PAGE
C
C	This subroutine recognizes the following classes of terminals
C		VT100    terminals in ANSI mode	   Erases screen
C		Tek 4014 terminals (/FT1)	   Erases screen
C		NBI      terminals (/FT2)	   Erases Screen
C		VK100    Video Board		   Erases Screen
C	        LA120    Printer		   Form Feed
C		all others			   7 line feeds
C
C	Written by:	James G. Downward
C			KMS Fusion, Inc.
C			P.O. Box 1567
C			Ann Arbor, Mich 48104
C			(313)-769-8500
C			12-Nov-1982
C
C	Modified by:	James G. Downward
C			26-Mar-1984		Delay after erase on 4014
C			
C-
C
	SUBROUTINE PAGE
	IMPLICIT INTEGER*4 (A-Z)
	CHARACTER*1 Cescape,Cform_Feed,Cline_Feed	!
	CHARACTER*12 Cpage
	INTEGER*2 DVI_Code,DVI_Length,DVI_Header(2)	! For GETDVI setup
	INTEGER*4	DELAY_INTERVAL(2)		! For SETIMR
	INTEGER*4 LIST(3), LENGTH			!


	EQUIVALENCE (DVI_Header(1),DVI_Length)
	EQUIVALENCE (DVI_Header(2),DVI_Code)
	EQUIVALENCE (DVI_Header(1),LIST(1))
	DATA Cescape	 /27/
	DATA Cform_feed /12/
	DATA Cline_feed /10/
	PARAMETER (DT$_TTYUNKN=	0)			! Unknown
	PARAMETER (DT$_VT05=	1)			! **Unknown**
	PARAMETER (DT$_VK100=	2)			! Vk100 video board
	PARAMETER (DT$_VT173=	3)			! **Unknown**
	PARAMETER (DT$_FT1=	16)			! Tek 4014 term
	PARAMETER (DT$_FT2=	17)			! NBI Term
	PARAMETER (DT$_FT3=	18)			! **Unknown**
	PARAMETER (DT$_FT4=	19)			! **Unknown**
	PARAMETER (DT$_FT5=	20)			! **Unknown**
	PARAMETER (DT$_FT6=	21)			! **Unknown**
	PARAMETER (DT$_FT7=	22)			! **Unknown**
	PARAMETER (DT$_FT8=	23)			! **Unknown**
C ... hard copy terminals
C ...
	PARAMETER (DT$_LAX=	32)			! Send 7 LF FF to all
	PARAMETER (DT$_LA36=	32)			! hard copy terminals
	PARAMETER (DT$_LA120=	33)			! unless have form ctl
	PARAMETER (DT$_LA34=	34)			!
	PARAMETER (DT$_LA38=	35)			!
	PARAMETER (DT$_LA12=	36)			!
	PARAMETER (DT$_LA24=	37)			!
	PARAMETER (DT$_LA100=	37)			!
	PARAMETER (DT$_LQP02=	38)			!
C ... Video terminals
C ...
	PARAMETER (DT$_VT5X=	64)			!  **Unknown**
	PARAMETER (DT$_VT52=	64)			! Treat as VT52
	PARAMETER (DT$_VT55=	65)			! Treat as VT52
	PARAMETER (DT$_VT100=	96)			! Treat as VT100
	PARAMETER (DT$_VT101=	97)			! Treat as VT100
	PARAMETER (DT$_VT102=	98)			! Treat as VT100
	PARAMETER (DT$_VT105=	99)			! Treat as VT100
	PARAMETER (DT$_VT125=	100)			! Treat as VT100
	PARAMETER (DT$_VT131=	101)			! Treat as VT100
	PARAMETER (DT$_VT132=	102)			! Treat as VT100

C
C
	DVI_Code =6					! Get from $DVIDEF
	DVI_Length = 4					! 4 bytes long
	LIST (2) = %LOC(Idevice_Type)			! Set up GETDVI
	LIST (3) = %LOC(Ilength)			! 
	ISTATUS=SYS$GETDVI(,,'SYS$OUTPUT',LIST,,,,)	!
	IF(Idevice_Type.GE.DT$_VT100)		THEN	! If a VT100
	   Cpage=Cescape//'[1;H'//Cescape//'[2J'	!
	   Length=9					!
	ELSE IF(Idevice_Type.EQ.DT$_FT1)	THEN	! If a 4014
	   Cpage=Cescape//Cform_Feed			!
	   Length=2					!
	ELSE IF(Idevice_Type.EQ.DT$_FT2	  .OR.		! If a NBI beastie
     -		Idevice_Type.EQ.DT$_LA120 .OR.		!  or a LA120
     -		Idevice_Type.EQ.DT$_VK100)	THEN	!   or VK100 vid board
	   Cpage=Cform_Feed				! then use a FF
	   Length=1					!
	ELSE 						! Else use 7 linefeeds
	   DO I=1,7					!  to simulate a page
	     Cpage(I:I)=Cline_Feed			!
	   END DO					!
	   Length=7					!
	END IF						!

	IF(Idevice_Type.LT.DT$_VT100) TYPE *, ' '	!
	WRITE(*,20) Cpage(1:Length)			! Output control char
20	FORMAT('+',A,$)					!
	IF(Idevice_Type.EQ.DT$_FT1)		THEN	! Set delay 10 sec
	    STATUS = SYS$BINTIM ('0 00:00:02',DELAY_INTERVAL)! Cnvt ASCII to binary	
	    STATUS = SYS$SETIMR (%VAL(1), DELAY_INTERVAL,,)! Now wait
	    STATUS = SYS$WAITFR (%VAL(1))		!
	END IF						!

	RETURN						!
	END
