
C+
C	EXIT_SPAWN
C
C	This subroutine establishes the exit handler for the VPW window.
C	We need to be sure that when we exit, any subprocess
C	left hanging out there is terminated.  This is necessary because
C	the subprocess may or may not be there when we exit or
C	when the user lets loose with a ctrl-y

C
C		CALL DTC_EXIT_SPAWN(Sub_PID)
C	Where
C		Sub_PID    I*4	PID for created subprocess
C
C	Written by:	James G. Downward
C			KMS Fusion, Inc.
C			PO Box 1567
C			Ann Arbor, Mich 48106
C
C		IDENT	/1.1/
C-
	SUBROUTINE EXIT_SPAWN(Sub_PID)
	IMPLICIT	INTEGER*4 (A - Z)		!
	LOGICAL		Is_Set
	INTEGER*4	EXIT_STATUS, EXIT_BLOCK(5)	!
	EXTERNAL	EXIT_SPAWN2			! Call on exit
	COMMON		/PID/ PID,Is_Set
	DATA		Clip_Brd_Used /0/		! Assume not used
	DATA	Is_Set	/.FALSE./

C	Declare exit handler
10	EXIT_BLOCK(2) = %LOC(EXIT_Spawn2)		!
	EXIT_BLOCK(3) = 1				! Transmit one argument
	EXIT_BLOCK(4) = %LOC(EXIT_STATUS)		!
	PID=Sub_PID					!
	IF (Is_Set) 				RETURN	! Only declare once
	STATUS = SYS$DCLEXH (EXIT_BLOCK)		! Requires Implicit
	Is_Set=.TRUE.					! Light a candle
	IF (.NOT. STATUS) CALL LIB$STOP (%VAL(STATUS))	!  INTEGER*4 (A-Z)
	RETURN						! Back to mainline
	END						!

	SUBROUTINE	EXIT_Spawn2(EXIT_STATUS)
C
C  ..  This routine is called when the program tries to exit.  
C      Its basic function is to delete any subprocess left lying about.
C
C	IDENT /V1.1/
C
	IMPLICIT	INTEGER*4 (A - Z)		!
	LOGICAL		Is_Set
	COMMON		/PID/ PID,Is_Set

	IF(PID.NE.0) Istatus=SYS$DELPRC(PID,)
	RETURN
	END






