	subroutine iniplt(iunit, xsize, ysize) 
 c 
 c	this routine initializes the plot. xsize and ysize denote the  
 c	size of the total plotting surface in inches. no plotting is  
 c	permitted outside this area. iunit is the logical unit 
 c	number of the plot. for iunit = 6, the plot is sent directly 
 c	to the plotter. 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 common /pagsiz/ xbond, ybond 
 c 
 	common /world/ xmin, xmax, ymin, ymax 
 c 
 	byte vtbufr(128) 
 	integer vtpos, vtbufl 
 	common / vtbuf/ vtbufr, vtpos, vtbufl 
 c 
 	vtbufl = 128 
 	vtpos = 0 
 	lunplt = iunit 
 	if( iunit .ne. 7 ) open( unit=iunit, carriagecontrol='FORTRAN' ) 
 c 
 c	set terminal to trasparent mode TSX command 
 c 
 	call writch(29) 
 	call writch(77) 
 	call erase 
 c 
 	scrx = 75. 
 	scry = 75. 
 c 
 	xbond = xsize 
 	ybond = ysize 
 	ixbond = ifix(scrx * xsize) 
 	iybond = ifix(scry * ysize) 
 	dxb = .5 * xbond 
 	dyb = .5 * iybond 
 	xmid = dxb 
 	ymid = dyb 
 c 
 c	set default values 
 c 
 	ixorig = 0 
 	iyorig = 0 
 	iascr = 0 
 	ibscr = ixbond 
 	icscr = 0 
 	idscr = iybond 
 c 
 	xslope = ixbond 
 	xconst = 0. 
 	yslope = iybond 
 	yconst = 0. 
 c 
 	xmin = 0. 
 	xmax = 1. 
 	ymin = 0. 
 	ymax = 1. 
 c 
 	ichar(1) = 7 
 	ichar(2) = 10 
 	ichar(3) = 19 
 	ichar(4) = 29 
 	ichar(5) = 38 
 c 
 	return 
 	end 
 
 
  
 	subroutine endplt 
 c 
 c	this routine ends plotting by deselecting the plotter and 
 c	dumping the buffer 
 c 
 	common /zgrap/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 	call pltoff 
 	call dmpplt 
 	return 
 	end 
 
 
 	subroutine pendwn 
 c 
 c	this routine puts the pen down so it will draw 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 c	<ESC>/0d	turns on ots  
 c 
 	call writch(27) 
 	call writch(47) 
 	call writch(48) 
 	call writch(100) 
 c 
 c	GS (^])		turns on vector mode 
 c 
 	call writch(29) 
 c 
 	return 
 	end 
 
 
 	subroutine penup 
 c 
 c	this routine puts the pen up 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 c	<ESC>/1d	turns off dots 
 c 
 	call writch(27) 
 	call writch(47) 
 	call writch(49) 
 	call writch(100) 
 c 
 c	FS (^\)		turns on point plot mode 
 c 
 	call writch(28) 
 c 
 	return 
 	end 
 
 
 	subroutine wrtstr(str, len, irot, isize) 
 c 
 c	subroutine "write string" 
 c	len is the length of the string 
 c	irot determines the rotation of the string (1 - 4), 1 is 
 c	right side up, 2 is rotated 90 degrees clockwise, etc. 
 c	string is checked to see if in is in bounds 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 	byte inum(5) 
 	data inum / ':', '9', '1', '2', '3' / 
 	byte str(len) 
 c 
 c	check to see if in bounds 
 c 
 	isz = max0(isize, 1)  
 	isz = min0(isz, 5 )  
 	iy = 1.5 * ichar(isz) 
 	ix = ichar(isz) * len 
 	irt = mod(irot - 1, 4) + 1 
 	irrt = mod( 12 - 2 * irt , 8 ) 
 	isx = iabs(irt - 3) - 1 
 	isy = iabs(irt - 2) - 1 
 	ixl = isx * ix - isy * iy + ixcur 
 	iyl = isx * iy + isy * ix + iycur 
 	if( abs(ixl - xmid) .gt. dxb )goto 100 
 	if( abs(iyl - ymid) .gt. dyb )goto 100 
 c 
 c	plot string 
 c	<ESC>/0d	turns on dots 
 c 
  
 	call writch(27) 
 	call writch(47) 
 	call writch(48) 
 	call writch(100) 
 c 
 c	US (^_)		turns on alphagraphics mode 
 c 
 	call writch(31) 
 c 
 c	Set character size 
 c 
 	call writch(27) 
 	call writch(inum(isz)) 
 c 
 c	set character rotation 
 c 
 	call writch(27) 
 	call writch('/') 
 	call writch(irrt + 48) 
 	call writch('e') 
 c 
 c	write string 
 c 
 	do 999 i = 1, len 
 	if( str(i) .eq. 0 ) goto 999 
 	call writch(str(i)) 
 999	continue 
 c 
 	return 
 c 
 c	string is out of bunds 
 c 
 100	call pltoff 
 	type 1, (str(i), i = 1, len) 
 	type 2 
 	call plton 
 c 
 	return 
 1	format('$WARNING  string ', 100a1) 
 2	format(' is out of bounds and will not be plotted') 
 	end 
 
 
  
 	subroutine marker(mrknum, isize) 
 c 
 c	places a marker at the current coordinates 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid, 
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 	return 
 	end 
 
 
 	subroutine coltyp (col) 
 c 
 c	this subroutine sets the line color 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 	return 
 	end 
 
 
 	subroutine plot(ixo, iyo, i) 
 c 
 c	this routine moves to the screen coordinates ix, iy. 
 c	if i = 0, the pen is put up before moving, if i = 1, the 
 c	pen is put down before moving. checks to see if within 
 c	surface boundary. 
 c 
 	byte lowy, highy,lowx, highx, yl, yh, xl, xh 
 	data yl, yh, xl, xh / 96, 32, 64, 32 / 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 	ix = ixo 
 	iy = iyo 
 c 
 c	check to see if in bounds 
 c 
 	delx = ix - xmid 
 	if(abs(delx) .le. dxb)goto 100 
 	xsc = xmid + sign(dxb, delx) 
 	xsl = 1. 
 	if ( ix .ne. ixcur ) xsl = ( xsc - ixcur ) / float(ix - ixcur) 
 	xsl = (iy - iycur) * xsl 
 	ix = sc 
 	iy = xsl + iycur 
 c 
 100	dely = iy - ymid 
 	if(abs(dely) .le. dyb)goto 200 
 	ysc = ymid + sign(dyb, dely) 
 	ysl = 1. 
 	if ( iy .ne. iycur ) ysl = ( ysc - iycur ) / float(iy - iycur) 
 	ysl = (ix - ixcur) * ysl 
 	ix = ysl + ixcur 
 	iy = ysc 
 c 
 c	plot point 
 c 
 200	if(i .eq. 0)call penup 
 	if(i .ne. 0)call pendwn 
 c 
 	lowy = mod( iycur, 32 ) .or. yl 
 	highy = ( iycur / 32 ) .or. yh 
 	lowx = mod( ixcur, 32 ) .or. xl 
 	highx = ( ixcur / 32 ) .or. xh 
 c 
 c	output previous position 
 c 
 	call writch(highy) 
 call writch(lowy) 
 	call writch(highx) 
 	call writch(lowx) 
 c 
 	lowy = mod( iy, 32 ) .or. yl 
 	highy = ( iy / 32 ) .or. yh 
 	lowx = mod( ix, 32 ) .or. xl 
 	highx = ( ix / 32 ) .or. xh 
 c 
 c	output current position 
 c 
 	call writch(highy) 
 	call writch(lowy) 
 	call writch(highx) 
 	call writch(lowx) 
 c 
 c	save current coordinates 
 c 
 	ixcur = ix 
 	iycur = iy 
 c 
 	return 
 	end 
 
 
 	subroutine plotin(x, y, i) 
 c 
 c	plots the point x, y where x and y are given in inches. 
 c	if i = 0, pen is put up before plottig, else pen is put down. 
 c 
 	ix = ifix(75 * x) 
 	iy = ifix(75 * y) 
 	call plot(ix, iy, i) 
 	return 
 	end 
 
	subroutine erase 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c	 
 c	<ESC><FF>	erases graphics page homes cursor 
 c 
 	call writch(27) 
 	call writch(12) 
 c 
 	return 
 	end 
 
	subroutine plton 
 	call writch(31) 
 	return 
 	end 
 
	subroutine pltoff 
 	call writh(24) 
 	return 
 	end 
 
	subroutine writch(ch) 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr,  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 	byte vtbufr(128) 
 	integer vtpos, vtbufl 
 	common / vtbuf/ vtbufr, vtpos, vtbufl 
 c 
 	byte ch 
 	vtpos = vtpos + 1 
 	vtbufr(vtpos) = ch 
 	if ( vtpos .ge. vtbufl ) call dmpplt 
 c 
 	return 
 	end 
 
	subroutine dmpplt 
 c 
 	common /zgraph/ lunplt, iascr, ibscr, icscr, idscr  
 	1 xm, ym, dx, dy, dxb, dyb, ixcur, iycur, xmid, ymid,  
 	1 xslope, yslope, xconst, yconst, scrx, scry, ichar(5), 
 	1 ixorig, iyorig 
 c 
 	byte vtbufr(128) 
 	integer vtpos, vtbufl 
 	common / vtbuf/ vtbufr, vtpos, vtbufl 
 c 
 	write(lunplt,1) ( vtbufr(i), i = 1, vtpos ) 
 1	format( '+', 128( a1, $ ) ) 
 	vtpos = 0 
 c 
 	return 
 	end 
