      SUBROUTINE PLTX(N) 
 C     SUBROUTINE PLTX(N) transmits relative mode primitive commands 
 C     to the Houston Instruments HIPLOT DMP-4, etc. DMPL plotters. 
 C 
 C     ORIGINAL PROGRAM BY C. E. COHN FOR THE DDP-24, MODIFIED 
 C     FOR THE PDP-11/34 BY J. MORMAN, AUG., 1979 
 C     PLOTTER X AND Y MOTIONS ARE IN STEPS OF 0.005 INCH, 
 C     WITH DIAGONAL MOTIONS OF SQRT(2)*0.005 INCH. 
 C   
 C     MODIFIED BY PAUL MURPHY, FEB., 1981 FOR INCLUSION 
 C     IN THE FOURIER DATA ANALYSIS PROGRAM 
 C 
 C 4-Nov-82 DJensen - Converted to call PLTOUT and overall output 
 C     string sizes reduced.   
 C 9-Nov-82 DVJensen - Converted to call PENUP and PENDWN. 
 C 
 C     THE INTEGER N SPECIFIES THE OPERATION AS FOLLOWS: 
 C     N =  0, INITIALIZE, NO PLOTTER MOTION 
 C       =  1, STEP IN -Y DIRECTION  
 C       =  2, STEP IN +Y DIRECTION  
 C       =  4, STEP IN -X DIRECTION  
 C       =  5, DIAGONAL STEP IN -X,-Y DIRECTION  
 C       =  6, DIAGONAL STEP IN -X,+Y DIRECTION  
 C	=  8, STEP IN +X DIRECTION  
 C	=  9, DIAGONAL STEP N +X,-Y DIRECTION  
 C	= 10, DIAGONAL STEP IN +X,+Y DIRECTION  
 C	= 16, LOWER PEN  
 C	= 32, RAISE PEN  
       IMPLICIT INTEGER*2 (I-N) 
 C 
       INTEGER*2 ISUB(9),LENGTH(9) 
       LOGICAL*1 LWORD(8),SP(2),LDUMU 
       REAL*8 DCHAR(9),DWORD 
       EQUIVALENCE (DWORD,LWORD(1)) 
       DATA ISUB/0,1,2,4,5,6,8,9,10/ 
       DATA DCHAR/' ;:R    ','0,-1    ','0,1     ','-1,0    ', 
      $'-1,-1   ','-1,1    ','1,0     ','1,-1    ','1,1     '/ 
       DATA LENGTH/4,5,4,5,6,5,4,5,4/ 
 C LENGTH defines the number of chaacters in each DCHAR element to output. 
       DATA SP/' ',','/ 
 C 
       IDIFF=N-16 
       IF(IDIFF) 5,6,7 
 6     CALL PENDWN 
       RETURN 
 C 
 7     CALL PENUP 
       RETURN 
 C 
 5     NSEL=0 
       DO 2 I=1,11 
       NSEL=NSEL+1 
       IDIFF=ISUB(I)-N 
       IF(IDIFF) 2,3,2 
 2     CONTINUE 
 3     DWORD=DCHAR(NSEL) 
       CALL PLTOUT( LWORD,LENGTH(NSEL) ) 
 71    RETURN 
       END 
