C NAME OF PGRM  LOGARITHMIC AXIS PLOTTER 
 C AUTHOR        CHARLES E. COHN, ARGONNE NATIONAL LABORATORY 
 C PURPOSE       TO GENERATE LOGARITHMIC AXES FOR CALCOMP GRAPHS 
 C CALLING STATEMENT IS 
 C     CALL LOGAX(X,Y,NC,S,THETA,IMAX,NDEC,H,CHARS) 
 C X AND Y ARE THE COORDINATES OF THE ORIGIN OF THE AXIS IN INCHES 
 C S IS THE LENGTH OF THE AXIS IN INCHES 
 C IMAX IS AN INTEGER GIVING THE POWER OF TEN ASSOCIATED WITH THE FAR END 
 C      OF THE AXIS. 
 C NDEC IS AN INTEGER GIVING THE (WHOLE) NUMBER OF DECADES INTO HICH THE 
 C      AXIS IS DIVIDED. THIS AND THE ABOVE QUANTITY ARE NORMALLY 
 C      OBTAINED FROM -SCALOG-. 
 C H IS THE HEIGHT OF THE CHARACTERS IN THE SCALE MARKINGS AND LEGEND 
 C THE MAGNITUDE OF NC GIVES THE NUMBER OF CHARACTERS IN THE LEGEND. 
 C IF NC IS POSITIVE, THE SCALE MARKINGS AND LEGEND 
 C WILL BE PLACED IN THE COUNTERCLOCKWISE DIRECTION FROM THE AXIS, 
 C OR IN THE CLOCKWISE DIRECTION FOR NC NEGATIVE. FOR A 
 C CONVENTIONAL GRAPH, THE X-AXIS HAS THETA=0. AND NC NEGATIVE TO PLACE 
 C THE MARKINGS BEOW THE GRAPH. THE Y-AXIS HAS THETA=90. AND NC POSITIVE 
 C TO PLACE THE MARKINGS TO THE LEFT OF THE GRAPH. 
 C CHARS IS A BYTE ARRAY OR ALPHANUMERIC LITERAL CONTAINING THE LEGEND. 
       SUBROUTINE LOGAX(X,Y,ND,S,THETA,IMAX,NDEC,H,CHARS) 
       BYTE CHARS(1),LEGEND(3) 
       DIMENSION Z(9),DSN(9),DCS(9) 
       DATA Z(1),Z(2),Z(3),Z(4),Z(5),Z(6),Z(7),Z(8),Z(9)/.3010299, 
      1  .1760913,.1249387,.9691001E-1,.7918125E-1,.6694679E-1, 
      2 .5799195E-1,.5115252E-1,.4575749E-1/ 
       NC=ND 
       SGN=1.0 
      IF(NC)1,2,2 
     1 SGN=-1.0 
       NC=-NC 
     2 TNC=NC+1 
       TH=THETA/57.295779513 
       CTH=COS(TH) 
       STH=SIN(TH) 
       XB=X 
       YB=Y 
       DS=S/FLOAT(NDEC) 
       SDS=STH*DS 
       CDS=CTH*DS 
       DO 3 J=1,9 
       TEMP1=Z(J) 
       DSN(J)=TEMP1*SDS 
     3 DCS(J)=TEMP1*CDS 
       HC=H*CTH 
       HS=H*STH 
       K=IMAX 
       TEMP1=2.*SGN 
       XA=X+HS*TEMP1 
       YA=Y-HC*TEMP1 
       CALL PLOT(XA,YA,3) 
       CALL PLTX(16) 
       XD=X+SGN*HS 
       YD=Y-SGN*HC 
       DO   21 I=1,NDEC       XA=XA+CDS 
       YA=YA+SDS 
       CALL PLOT(XB,YB,1) 
       DO 20 J=1,9 
       TEMP1=DCS(J) 
       TEMP2=DSN(J) 
       XC=XB+TEMP1 
       YC =YB+TEMP2 
       CALL PLOT(XC,YC,1) 
       XD=XD+TEMP1 
       YD=YD+TEMP2 
       IF(J-9)18,19,19 
    18 CALL PLOT(XD,YD,1) 
       CALL PLOT(XC,YC,1) 
    19 XB=XC 
    20 YB=YC 
    21 CALL PLOT(XA,YA,1) 
       IMIN=IMAX-NDEC 
       IF(IMIN+10)60,60,61 
    60 EL=2.14285*H 
       GO TO 70 
    61 IF(IMAX+10)60,60,63 
    63 IF(IMAX-100)64,60,60 
    64 IF(IMIN-100)65,0,60 
    65 IF(IMIN-10)66,67,67 
    67 EL=1.71428*H 
       GO TO 70 
    66 IF(IMAX-10)68,67,67 
    68 IF(IMIN)67,69,69 
    69 IF(IMAX)67,71,71 
    71 EL=1.28571*H 
    70 XA=XB-(EL+0.2*H)*SGN*STH-EL 
       TEMP1=.5*H 
       YA=YB+1.3*SGN*HC-TEMP1 
       XC=XA+1.8*H 
       YC=YA+TEMP1 
       N=NDEC+1 
       DO 30 I=1,N 
       CALL SETGRF(XA,YA,0.,H,2,2H10) 
       IF (K+10) 40,40,41 
    40 NP=1 
    41 IF(K)42,44,43 
    42 NP=2 
       GO TO 50 
    43 IF(K-10)44,45,45 
    44 NP=3 
       GO TO 50 
    45 IF(K-10042,40,40 
   111 FORMAT(I3) 
    50 ENCODE(3,111,LEGEND)K 
   114 CALL SETGRF(XC,YC,0.,H,4-NP,LEGEND(NP)) 
       XA = XA - CDS 
       XC = XC  - CDS 
       YA = YA  -  SDS 
       YC =   YC - SDS 
       K=K-1 
    30 CONTINUE 
       XB =  0.5*S - TNC*H*.42857142 
       YB =   (3.5*SGN  - .5)*H 
       XA =  X  +XB*CTH-(YB+(EL+0.5*H)*SGN)*STH 
       YA = Y +   XB*STH +    YB*CTH 
       CALL SETGRF(XA,YA,THETA,H,NC,CHARS) 
       RETURN 
       END 
