      SUBROUTINE AXIS(X,Y,SIZE,THETA,YMIN,DY,ND,TITLE) 
 C 
 C AUTHOR:       CHARLES E. COHN, ARGONNE NATIONAL LABORATORY 
 C     MODIFIED FOR THE FOURIER DATA ANALYSIS PROGRAM BY 
 C     P. MURPHY, FEB., 1981. 
 C 
 C NAME OF PGRM: CALCOMP LINEAR AXIS PLOTTER FOR FORTRAN-IV (AXIS) 
 C PURPOSE:      TO PLOT LINEAR AXES FOR GRAPHS, COMPLETE WITH SCALE 
 C               MARKINGS AND LEGENDS 
 C TO PLOT AN AXIS, USE THE STATEMENT 
 C     CALL AXIS(X,Y,SIZE,THETA,YMIN,DY,ND,TITLE) 
 C     (ALL ARGS FLT PT EXCEPT NC) 
 C    "X" AND "Y" ARE THE COORDINATES OF THE ORIGIN OF THE AXIS IN INCHES 
 C     "SIZE" IS THE LENGTH OF THE AXIS IN INCHES (NORMALLY A WHOLE NUMBER) 
 C     "THETA" IS THE INCLINATION OF THE AXIS IN DEGREES RELATIVE TO THE 
 C           POSITIVE X-AXIS. 
 C     "YMIN" IS THE SCALE MARKING TO BE PRINTED AT THE ORIGIN 
 C     "DY" IS THE INCREMENT IN SCALE MARKING PER INCH 
 C     IF DY=0.0, THEN ONLY THE AXIS WILL BE DRAWN WITHOUT 
 C                  ANY LABELS. 
 C (THE ABOVE TWO PARAMETERS NORMALLY DERIVED BY "SCAE". IF DY IS LESS 
 C  THAN 1, SCALE MARKINGS (EVERY INCH) ARE WRITTEN WITH TWO DECIMAL 
 C  PLACES. OTHERWISE, THEY ARE WRITTEN AS INTEGERS.) 
 C THE MAGNITUDE OF ND GIVES THE NUMBER OF CHARACTERS IN THE LEGEND 
 C INCLUDING THE SPACING CONTROL CHARACTER. IF ND IS POSITIVE, THE SCALE 
 C MARKINGS AND LEGEND WILL BE PLACED IN THE COUNTERCLOCKWISE DIRECTION 
 C FROM THE AXIS, OR IN THE CLOCKWISE DIRECTION FOR ND NEGATIVE. FOR A 
 C CONVENTIONAL GRAPH, THE X-AXIS HAS THETA=0. AND ND NEGATIVE TO PLACE 
 C THE MARKING BELOW THE GRAPH. THE Y-AXIS HAS THETA=90. AND ND POSITIVE 
 C TO PLACE THE MARKINGS TO THE LEFT OF THE GRAPH. 
 C "TITLE" IS A ALPHANUMERIC LITERAL CONTAINING THE LEGEND. 
       IMPLICIT INTEGER*2 (I-N) 
       LOGICAL*1 TITLE(1),LEGEND(7) 
       EQUIVALENCE (XB,XAA,BIG),(YB,YAA),(XC,ADY),(YC,ABSU) 
       NC=ND 
       SGN=0.1 
       IF(NC)1,2,2 
     1 SGN=-0.1 
       NC=-NC 
     2 TH=THETA/57.295779513 
       N=SIZE+0.5 
       CTH=COS(TH) 
       STH=SIN(TH) 
       TN=N 
       XB=X 
       YB=Y 
       XA=X-SGNSTH 
       YA=Y+SGN*CTH 
       CALL PLOT(XA,YA,3) 
       CALL PLTX(16) 
       DO 20 I=1,N 
       CALL PLOT(XB,YB,1) 
       XC=XB+CTH 
       YC=YB+STH 
       CALL PLOT(XC,YC,1) 
       XA=XA+CTH 
       YA=YA+STH 
       CALL PLOT(XA,YA,1) 
       XB=XC 
   20  YB=YC 
       IF(DY.EQ.0.0) RETURN 
       ADY=DY 
       ABSV=YMIN+ADY*TN 
       IP=0 
       TEMP2 = ABS(YMIN) 
       IF (ADY) 10,18,10 
   14  ADY=ADY*10. 
       ABSV=ABSV*10. 
       TEMP2=TEMP2*10. 
       IP=IP-1 
    10 IF(ADY - .01)14,18,18 
    18 TEMP1=23*SGN-.0625 
       XA = XB-TEMP1*STH-.4*CTH 
       YA = YB + TEMP1*CTH-.4*STH 
       BIG=AMAX1(ABSV,TEMP2) 
   182 IF(BIG-9999.99)181,181,781 
   781 ADY=ADY/10. 
       ABSV=ABSV/10. 
       BIG=BIG/10. 
       IP=IP+1 
       GO TO  182 
   181 N=N+1 
       XB=ADY-.999 
       DO  30  I=1,N 
       IF(ABS(ABSV) .LE. .0049)ABSV=0. 
       IF(XB) 6,7,7 
     6 ENCODE(7,3,LEGEND) ABSV 
     3 FORMAT (F7.2) 
       LC=7 
       GO TO 8 
     7 IF(ABSV)9,11,11 
     9 NA=ABSV-.5 
       GOTO21 
    11 NA=ABSV+.5 
    21 ENCODE(,13,LEGEND)NA 
    13  FORMAT(I5) 
       LC=5 
     8 CALL SETGRF(XA,YA,THETA,.125,LC,LEGEND) 
       ABSV=ABSV - ADY 
       XA = XA-CTH 
    30  YA = YA-STH 
       TNC = NC+1 
       TEMP1=SIZE/2. -  .0535714*TNC 
       TEMP2 =  -.0625+SGN*4.375 
       XA=X+TEMP1*CTH-TEMP2*STH 
       YA =Y+TEMP1*STH+TEMP2*CTH 
       IF(IP)35,50,35 
    35 TEMP1 =  (TNC+1.)*.1071428 
       XA = XA - .375*CTH 
       YA = YA - .375*STH 
       XAA = XA+TEMP1*CTH 
       YAA =  YA +TEMP1*STH 
       CALL SETGRF(XAA,YAA,THETA,.125,8,8HX10   )) 
       JXYP=(-IP) 
       ENCODE(3,5,LEGEND) JXYP 
       CALL SETGRF(XAA+.43*CTH-.06*STH,YAA+.43*STH+.06*CTH,THETA,.125, 
      1 3,LEGEND) 
     5 FORMAT(I3) 
    50 CALL SETGRF(XA,YA,THETA,.125,NC,TITLE) 
       RETURN 
       END 
