! ANSI.CTL -- KERMIT ANSI Labeled Tape Export, 1600 bit per inch.
!
! KERMIT ANSI Export tape, 1600 bpi, ASCII recording, format D
! (unspanned variable length records).  Use this for exporting to
! VAX/VMS sites (which can read the tape with the COPY command),
! and RSX/11, RSTS/E, and other systems that support ANSI label tapes,
! and to sites that don't tell you what kind of computer they have or what
! kind of tape they want.  This format conforms completely to the
! national standard for information interchange, so most systems
! should be able to read it.
!
! When exporting, tell recipient that it's a 1600bpi, 9-track, odd
! parity ASCII ANSI standard labeled tape in industry compatible
! format with variable length (unspanned) records (ANSI
! Format D with ASCII Record Control Words), maximum record length 200
! block length 2000.
!
! This depends on Chuck Hedrick's Rutgers Pascal WRITEL program for writing
! writing ANSI tapes with intelligent blocking (rather than 1 record per
! block, as the Exec COPY command does.)
!
! NOTE -- Tape hardware format is "industry compatible", not "ansi-ascii",
! so these tapes can be produced on any DEC-20; a TM02 is not necessary.
!
! ANOTHER NOTE -- There should be only ASCII text files in the directory.
! Binary files will be useless on the tape and may fill it up unnecessarily.
!
! Submit this job with a CPU time limit of at least 15 minutes.
!
@mount tape kermit:/label:ansi/write/volid:kermit -
@ /remark:"KERMIT Export, Initialize ANSI Label 'KERMIT' 1600bpi, Mark 'ANSI 1600 bpi', Return to Bin 7W"
@
@set tape parity odd
@set tape density 1600 
@set tape format industry-compatible
@info tape
!
! Now copy the files to the tape.  The dialog is as follows:
!
!   Tape: kermit:
!   Format: d
!   Record Length: 200
!   Block Length: 2000
!   Copy from: ker:*.*.0
!   (blather blather)
!   Copy from: ^C
!
@aid:writel
*kermit:
*d
*200
*2000
*ker:*.*.0
=^C
@
@eof kermit:
!
! All done, dismount the tape.
!
@dismount tape kermit:
@
@GOTO x
%ERR::
%TERR::
@NOERROR
@mm s .
*ANSI KERMIT tape job failed
*See log file to find out why.
*
*(signed) Your friend, ANSI.CTL
=^Z
@
x::
