.sp 3
.ce
Supplement to the "Kermit User's Guide"
.hy
.sp 3
3.x. CYBER 170/750 KERMIT
.sp
Kermit is written for the Cyber 170/750 in FTN5, CDC's FORTRAN 77 compiler.
It mimics the DEC-20 style command parser in that a question mark followed
by a carriage return will display the possible inputs for a given field.  
This version of Kermit must be watched since it has no timeout capabilities.  
.sp
Kermit only uses local files.  To send a file, it must first be copied to
a local file.  Kermit may then be run to send it from the Cyber to another
Kermit.  To receive a file, Kermit will write it to a local file.  This
file must be copied to a permanent file before logging out if it is to be
saved.
.sp
A Cyber filename is restricted to 7 alphanumeric characters with the first
character being an alpha.  Kermit will use the first 7 valid characters
of any file being sent to the Cyber.  If a file under that name already
exists, an Error packet stating so will be sent back and Cyber Kermit will
abort the transfer.
.sp
Kermit can only deal with "8 in 12" ASCII files.  At the University of Texas,
an "8 in 12" ASCII file is defined to be an 8 bit ASCII character stored in
a 12 bit byte.  There are 60 bits in a word so that is 5 bytes per word.
A null character is represented as an octal 4000 and the CR/LF pair is
mapped into the single character NEL (octal 205).  This is the same character
set that Cyber C uses.  Unfortunately, CDC hasn't officially defined it's
"8 in 12" character set yet, but it is likely that the end of line convention
will be the similar to the current one which is one or more 0000
bytes in the low order portion of a word.
.sp
You can run Kermit interactively by typing repeated commands in response to
its "Kermit-170>" prompt, or you can run it as a remote server.  Here are
the Kermit-170 commands:
.sp
.in +8
.ti -8
EXIT	Exit from Kermit-170.  You may also stop Kermit-170 in the midst of
a transfer or during server operations by aborting the program (CTRL-C or
CTRL-G ABORT); the program traps them and puts yor terminal back to normal
before halting.
.sp
.ti -8
HELP [<topic>]
.br
Give Help.  There's a general help text, plus seperate help texts for each
Kermit-170 command.
.sp
.ti -8
QUIT	Synonym for EXIT.
.sp
.ti -8
RECEIVE	Receive a file or group of files from the other host.  If the name in the
header packet is not a legal Cyber file name, the first 7 legal characters
will be used.

If the file already exits as a local file, Kermit will abort the transfer.
If an error occurs during transfer, the file being received will be
removed from the local file list to allow the transfer to be retried.
You should escape back to your local Kermit after entering RECEIVE
mode and give the SEND command.
.sp
.ti -8
SEND filename
.br
Send a file to the other host.  The name of the file is passed
to the other host in a file header packet, so that the file can be
stored there with the same name.
You should escape back to your local Kermit and give the RECEIVE
command.  If you don't do this fast enough the "send-init" packet may
arrive prematurely.  To prevent this, use SET DELAY or hit the RETURN key
on your microcomputer if it does not timeout.
.sp
.ti -8
SERVER	Act as a server for another Kermit.  Whatever options were
previously SET will be used.  The server may be shut down from the local
Kermit by using the BYE or FINISH commands, or by
connecting back to the Cyber, and typing Control-C or Control-G ABORT.
.sp
.ti -8
SET	Establish system-dependent parameters.  You can examine their 
values with the
SHOW command.  Numeric values may be decimal, octal (postfixed with a B),
or hexadecimal (postfixed by an H).  The following may be SET:
.sp
.in +8
.ti -8
DEBUG <option>
.br
Show packet traffic explicitly.  Options are:
.sp
.in +8
.ti -8
ALL	Set all debug options.
.sp
.ti -8
LOG-FILE filename
.br
Log states and packets to the specified file.  The default
log-file is file KERMLOG.
.sp
.ti -8
OFF	Don't display debugging information (this is the default).  If
debugging was in effect, turn it off and close any log file.
.sp
.ti -8
PACKETS	Display each incoming and outgoing packet (lengthy).
.sp
.ti -8
STATES	Show kermit state transitions and packet numbers (brief).
.sp
.in -8
.ti -8
DELAY <decimal-number>
.br
How many seconds to wait before sending the first packet.  This gives you
time to "escape" back and issue a RECEIVE command.
.sp
.ti -8
DUPLEX <keyword>
.br
Changes the method of echoing characters when being prompted for commands.
The choices are FULL and HALF.  Full means the Cyber will echo the
characters you type.  Half means the local systems echos them.  Full is
the default, and is used by most hosts.
.sp
.ti -8
INIT-RETRY <decimal-number>
.br
Set the maximum number of retries allowed for the initial connection
before giving up.
.sp
.ti -8
PARITY <keyword>
.br
Allows you to adjust the parity on characters send by Kermit-170 to
another system's requirements.  The possibilities are NONE, EVEN, ODD,
SPACE, or MARK.  If NONE, then the 8th bit can be used for data when 
sending and receiving binary files.  If other than NONE, the 8th bit
on outgoing characters will be set to achieve the desired parity, and the 
8th bit on incoming characters will be discarded.  The default is NONE.
.sp
.ti -8
RECEIVE <parameter> <value>
.br
These commands allow you to specify to the other Kermit what the packets it 
sends should look like, or to inform this Kermit what to expect.
.sp
.in +8
.ti -8
EOLCHR <octal-number>
.br
The octal value of the ASCII character to be used as a line terminator
or packets, if one is required by the other system.  Carriage return
(15B) is the default.
.sp
.ti -8
PACKLEN <decimal-number>
.br
Maximum packet length to send, decimal number, between 20 and 94,
94 by default.
.sp
.ti -8
PADCHR <octal-number>
.br
Character to use for padding.  Default is NUL.
.sp
.ti -8
PADLEN <decimal-number>
.br
How much padding to send before a packet.  Default is no padding.
.sp
.ti -8
QUOTECHR <octal-number>
.br
What printable character to use for quoting of control characters.
.sp
.ti -8
SYNCCHR <octal-number>
.br
The control character that marks the beginning of the packet.  Normally
SOH (Control-A, ASCII 1).  There should be no reason to change this.
.sp
.ti -8
TIMEOUT <decimal-number>
.br
How many seconds the other Kermit should wait for a packet before asking 
for retransmission.
.sp
.in -8
.ti -8
RETRY <decimal-number>
.br
Set the maximum number of retries for a given packet before giving up.
.sp
.ti -8
SEND <parameter> <value>
.br
These commands allow you to specify how outgoing packets should look, in
case the other Kermit has nonstandard requirements.
.sp
.in +8
.ti -8
EOLCHR <octal-number>
.br
The octal value of the ASCII character to be used as a line terminator
for packets, if one is required by the other system.  Carriage
return (15B) by default.
.sp
.ti -8
PACKLEN <decimal-number>
.br
Maximum packet length to send, decimal number, between 20 and 94,
94 by default.
.sp
.ti -8
PADCHR <octal-number>
.br
Character to use for padding.  Default is NUL.
.sp
.ti -8
PADLEN <decimal-number>
.br
How much padding to send before a packet.  Default is no padding.
.sp
.ti -8
QUOTECHR <octal-number>
.br
What printable character to use for quoting of control characters.
The default is "#" (43B).  there should be no reason to change this.
.sp
.ti -8
SYNCCHR <octal-number>
.br
The control character that marks the beginning of the packet.  Normally
SOH (Control-A, ASCII 1).  There should be no reason to change this.
.sp
.ti -8
TIMEOUT <decimal-number>
.br
How many seconds the other Kermit should wants before being asked for
retransmission.  Unfortunately, the Cyber has no way of timing out so
this parameter is ignored.
.sp
.in -8
.in -8
.ti -8
SHOW	Display current SET parameters, version of Kermit-170, and other
information.
.sp
.ti -8
STATUS	Give statistics about the most recent file transfer.
.in -8
.sp
Planned further enhancements to Kermit-170 being done at the University
of Texas include:
.sp
.in +5
.ti -2
- Addition of new server functions: directory, type, delete, etc.
.sp
.ti -2
- Host commands -- pass a command string to the system for execution.
This may be a problem when implementing at other NOS sites.
.sp
.ti -2
- Two and Three character checksums.
.sp
.ti -2
- 8th-bit quoting, to allow transfer of binary files with systems that
can't use the parity bit for data.
.sp
.ti -2
- Temporary escaping back to control command level.
.sp
.ti -2
- Badly needed performance tuning.  Currently we have been experiencing
500-900 baud effective data throughput on a 2400 baud line.
.in -5

