
#include "k.h"

/*
 *	Various KERMIT utilities.
 */

/* converts a control character to a printable one by adding a space */
char tochar(ch)
char ch;
{
	return(ch + ' ');					/* make sure not a control char */
}


/* undoes tochar */
char unchar(ch)
char ch;
{
	return(ch - ' ');					/* restore char */
}


/*
 * turns a control character into a printable character by toggling the
 * control bit (ie. ^A becomes A and A becomes ^A).
 */
char ctl(ch)
char ch;
{
	return(ch ^ 64);					/* toggle the "control" bit */
}


/* fill the array data with the appropriate send-init paramaters */
spar(data)
char data[];
{
	data[0] = tochar(MAXPACK);			/* biggest packet I can receive */
	data[1] = tochar(MYTIME);			/* when I want to be timed out */
	data[2] = tochar(MYPAD);			/* how much padding I need */
	data[3] = ctl(MYPCHAR);				/* padding character I want */
	data[4] = tochar(MYEOL);			/* end-of-line character I want */
	data[5] = MYQUOTE;					/* quote character I send */
}


/* get the other host's send-init parameters */
rpar(data)
char data[];
{
	spsiz = unchar(data[0]);			/* maximum send packet size */
	timint = unchar(data[1]);			/* when I should time out */
	pad = unchar(data[2]);				/* number of pads to send */
	padchar = ctl(data[3]);				/* padding character to send */
	eol = unchar(data[4]);				/* EOL character I must send */
	quote = data[5];					/* incoming data quote char */
}
