Problems with KERMIT-80 (October 21, 1983):
------------------------------------------

1. Three separate sources:

v3.1   CPMKERMIT.ASM (old, pre-generic)
v3.2   CPMGENERI.ASM (incorporates Bernie's generic support, CP/M 3.0 support)
v3.5   CPMBASE.M80   (new, current source, but largely untested)

These are kept around because not all implementations (Kaypro, Osborne,
Heath, Apple, etc) have been tested in each one, but a working version for each
system can be generated from at least one them.

The first thing we need to do is test (and fix, if necessary) the support for
each system in the current version, and then discard the older sources.

2. The incredibly ugly IF...ENDIF structure of the program makes it almost
impossible to read and maintain, and to add support for new systems without
endangering the support for old ones.  The program needs to be completely
rewritten, broken up into separate modules for protocol, disk i/o, screen i/o,
console i/o, port/modem i/o, command parsing, terminal emulation, data and
definitions.  Of these, only the protocol module would be system independent.

3. Lower case letters in an incoming file header should be raised to upper case
and nulls or other control characters in the filename should be discarded.

4. A NAK for the next packet is NOT an ack for the current one if the current
one was a Send-Init.

5. Check for packet number wrap-around when checking for things like "is this
a NAK for the previous packet?" when comparing packet numbers.

6. May want to verify other side's Send-Init parameters more rigorously and
force them to legal values if illegal.

7. Junk in command buffer after a file transfer (or is it just an unsuccessful
file transfer?) always prevents the first command after the transfer from being
parsed.

8. The old file stepping mechanism -- which allowed only 16 files to be sent in
a wildcard send command -- has been replaced by a new mechanism that lets any
number be sent.  However, the new mechanism is very costly, requiring on the
order of n**2 directory lookups to send n files.  The new method should
incorporate the old -- build a table of, say, 16 (32? 64?) files to send, and
when that gets used up, build another table.

9. KERMIT-80 (and all the other micro versions) badly need to be able to send
a BREAK signal.  You need it to talk to IBM systems, and to get the attention
of various kinds of port switchers, multiplexers, etc.  Code has been added to
allow the VT180 to do this, but none of the other implementations have it.
This is, of course, highly system dependent.

10. Fix logging function.  Most implementations don't have it; those that do
lose characters.  Log to a big area in memory; when buffer gets nearly full,
send ^S, dump it to disk, send ^Q.  Look at MODEM, see what it does.

11. Retry count still isn't updated in every case.

------------

Once all these problems are fixed, or most of them, we can begin adding
enhancements (printer support, init files, etc) and new protocol features
(8th-bit-quoting, more interactions with server, etc).
