.;
.; INTERR Generation Command File
.;
.;
.;	This command file has been updated for more automatic generation
.;	under the new versions of RSX (M V4.0, M-Plus V2.0).  As always,
.;	some of these features are not backward compatible and may cause
.;	problems on older versions of RSX.  
.;
.;
			.SETS VERSN "Y01.02"
			.ENABLE SUBSTITUTION
			.ENABLE GLOBAL
			.SETS UIC <UIC>
;
;	INTERR DECnet remote node assignment program generation procedure
;	Version 'VERSN'
;
;	This program is a privileged task which is run at DECnet startup
;	time to assign node numbers and names.  It interrogates a master
;	master node in the network to obtain configuration  information,
;	then  spawns  commands  to  set  node  numbers and names.  It is
;	useful in larger networks because it eliminates the need to keep
;	local copies of node assignment files which must be continuously
;	updated.
;
.ASKS NULL Use carriage return to proceed
;
;	When run, the program connects by object type to NICE/NML on the
;	target  node, which may be any RSX or VAX/VMS node.  It sends an
;	enquiry packet to NICE/NML, which then responds with a series of
;	packets  containing  node number and name information.  The task
;	then disconnects from NICE/NML on the remote node and  spawns  a
;	series  of  NCP SET commands to the MCR... CLI to set those node
;	names and numbers on the local  node.   Finally,  it  logs  this
;	activity  on  the  system  console  and exits to RSX with status
;	SUCCESS.
;
;	If a failure occurs at any point which would affect the integrity
;	of the information to be set at the local node, the program exits
;	with status ERROR.
;
.ASKS NULL Use carriage return to proceed
;
;
;	Option Generation Phase
;
			.BEGIN
;
;
; 	This question asks you for the node number of the node  on  which
;	the  program  is to run.  This number is decimal and may be found
;	by the results of the command NCP SHO EXECUTOR, which follows  if
;	NCP is installed on this system.
;
.IFINS ...NCP		NCP SHOW EXECUTOR
;
.ASKN [1.:255.:1.] $LNODE Enter the number of the local node
			.END
			.BEGIN
			.SETN $MXNOD 0.
;
;
;	Due to the extremely large size of  some  networks,  the  maximum
;	number  of  nodes is exceeded.  These networks are usually broken
;	up into partitioned subnets, with each subnet seeing  only  those
;	nodes below a certain node number.
;
.ASK $SBNET Is the target node part of a partitioned subnet
.IFF $SBNET		.GOTO 10
;
.ASK $SBNET Is partitioned subnet support desired
.IFF $SBNET		.GOTO 10
;
;	If partitioned subnet support  is  desired,  then  the  following
;	question  must  be  answered  with the maximum node number in the
;	partitioned subnet.  This number is decimal and may be  found  by
;	the  results  of  the  command NCP SHOW EXECUTOR CHARACTERISTICS,
;	which follows if NCP is installed on this system.
;
.IFINS ...NCP		NCP SHOW EXECUTOR CHARACTERISTICS
;
.ASKN [2.:255.:2.] $MXNOD What is the maximum node number in the subnet
.10:
			.END
			.BEGIN
;
;
;	Through a miracle of modern science, it is possible to ''echo'' the
;	NCP  commands  being  spawned  to MCR... on the terminal invoking
;	INTERR.  This is fine for documentation purposes and  in  smaller
;	networks.  However, in large networks, it becomes a bit of a bear
;	when 200 NCP SET commands are echoed on  the  invoking  terminal;
;	therefore, it is an option that you may select or not select.
;
.ASK $TPEKO Is terminal command pseudoechoing support desired
			.BEGIN
			.SETS $ODT ""
;
;
;	It is possible to build a version of  this  task  which  includes
;	extensive  inline  debugging support.  However, such a version of
;	the task is useful only for debugging, as it is quite verbose.
;
.ASK $DEBUG Should this be a debugging version
.IFF $DEBUG .GOTO 10
;
.ASK ODT In that case, should the task be built against ODT
.IFT ODT		.SETS $ODT "/DA"
.10:
			.END
			.BEGIN
;
;
;	Obtain the network UIC group for build use
;
.IFDF <NETUIC>		.PARSE <NETUIC> "[," N1 $N2 N3
.IFNDF <NETUIC>		.ASKN [1:377:1] $N2 What is the network UIC group
			.END
			.BEGIN
;
;
;	Test for FCSFSL or FCSRES resident library support
;
			.SETF $RSLIB
.IF <SYSTEM> EQ 1	.TESTFILE LB:[1,1]FCSFSL.STB
.IF <SYSTEM> EQ 6	.TESTFILE LB:[1,1]FCSRES.STB
.IF <FILERR> NE 1	.GOTO 10
;	An FCS resident library, either FCSFSL or FCSRES, has been found
;	on  your  system.   You may build the INTERR task against it, if
;	you wish, but there is no advantage in it  because  INTERR  does
;	not use any FCS services.
;
.ASK [<FALSE>] $RSLIB Should the task be built against this library
.10:
			.END
;
;
.ASK $LIST Do you want a listing of the MACRO source
;
;
.ASK $TMAP Do you want a map of the output task file
;
;
;	Generation phase begun at '<TIME>' on '<DATE>'
;
.;
.;	Set up MACRO assembly prefix file from data given
.;
			PIP INTERPRE.MAC;*/DE
.OPENA INTERPRE.MAC
.ENABLE DATA
	.SBTTL	INTERPRE Prefix File
	.SBTTL	


.DISABLE DATA
.IFT $TPEKO .DATA P$$EKO = 0					; Enable terminal pseudoecho
.IFT $DEBUG .DATA D$$BUG = 0					; Enable debug support
.DATA L$$NOD = '$LNODE'.				; Local node number
.IFT $SBNET .DATA M$$XND = '$MXNOD'.				; Max node number in subnet
.CLOSE INTERPRE.MAC
;
;	Assemble the source file
;
			PIP INTERR.OBJ;*/DE
			.SETS LST ""
.IFT $LIST		.SETS LST ",INTERR/-SP"
			.OPEN CAMRRETNI.CMD
			.DATA SY:INTERR'LST' = LB:[1,1]NETLIB/ML, -
			.DATA SY:'<UIC>'INTERPRE/PA:1, -
			.DATA INTERR
			.CLOSE CAMRRETNI.CMD
			MAC @CAMRRETNI
			PIP CAMRRETNI.CMD;*, INTERPRE.MAC;*/NM/DE
;
;	Build the task 
;
			PIP DLBRRETNI.CMD;*/DE
			.SETS $MAP ""
.IFT $TMAP		.SETS $MAP ", SY:INTERR/MA/-SP"
			.OPEN DLBRRETNI.CMD
			.DATA INTERR/PR:0/-CP'$ODT''$MAP' = INTERR
			.DATA /
			.DATA UNITS=4
			.DATA ACTFIL=0
			.DATA TASK=INTERR
			.DATA UIC=['$N2',54]
			.DATA PRI=100
.IF <SYSTEM> EQ 1 .IFT $RSLIB .DATA LIBR=FCSRES:RO
.IF <SYSTEM> EQ 6 .IFT $RSLIB .DATA SUPLIB=FCSFSL:SV
			.DATA //
			.CLOSE DLBRRETNI.CMD
			PIP INTERR.TSK;*/PR:0/FO
			PIP INTERR.TSK;*/NM/DE
			TKB @DLBRRETNI
;
;	Clean up the mess
;
			PIP INTERR.MAP;*/PR/FO
			SET /UIC='UIC'
			PIP INTERR.LST, INTERR.MAP/PU
			PIP INTERR.OBJ;*, DLBRRETNI.CMD;*/NM/DE
;
;	Remember to install and run the interrogator task at startup time
;	... but only AFTER DECnet is completely started!
;
;	Task generation completed at '<TIME>' on '<DATE>'
;
			.EXIT
