.ENABLE TIMEOUT
.ENABLE SUBSTITUTION
.IF P1 NE "" .GOTO NOTEXT

.;
.;  Display the format and options to the user :
.;
;FORMAT IS:
;	@F FILENAME [OPT] [OPT] ...
;	WHERE FILENAME IS ONLY NAME, NO TYPE
;
;	  OPTION               DESCRIPTION               DEFAULT
;       ---------------------------------------------------------
;       CK (-C/NC)       INCLUDE ARRAY CHECKING             CK
;       DE (-D/ND)       INCLUDE FORTRAN DEBUG LINES        -D
;       ER (-E/NE)       INCLUDE SHORT ERROR MESSAGES       -E
;       LI (-L/NL)       PRODUCE LISTING                    -L
;       MP (-M/NM)       CREATE TASK MAP FILE               -M
;       RN (-R/NR)       RUN TASK PRODUCED                  RN
;       SP (-S/NS)       SPOOL LISTING                      -S
;       TR (-T/NT)       TRACE ALL                          TR
;       +O               INCLUDE OPTIONS IN TASK BUILD
;       +P               PRODUCTION (/NOTR/NOCK)
;       +V               SOURCE HAS VIRTUAL ARRAYS
;       OL=FILENAME      INCLUSION OF OBJECT LIBRARY 
;       U=#              # OF UNITS AND ACTFILS
;
.EXIT
.NOTEXT:

.;
.;  See if a file is given. If it is then continue, otherwise, report
.;  an error :
.;
.TESTFILE 'P1'.FTN
.IF <FILERR> NE 1 .GOTO NOFILE

.;
.;  Initialize Logical Variables :
.;
.SETT CHECK	;CK
.SETF DEBUG	;-D
.SETF SHORT	;-E
.SETF LIST	;-L
.SETF MAP	;-M
.SETT RUN	;RN
.SETF SPOOL	;-S
.SETT TRACE	;TR
.SETF OPTNS	;No Options For Task Builder
.SETF PROD	;No Production
.SETF VIRT	;No Virtual Arrays In Source
.SETF INCLBR	;No Object Library Included
.SETF UNITS	;Default Number of Units (4)

.;
.; Initialize String Variables :
.;
.SETS OL ""
.SETS OLPRM "OL="
.SETS UNT ""
.SETS UNTPRM "U="

.;
.;  Put the options (P2 thru P9) into the variable PC and see if it
.;  decodes in the subroutine CHKPRM :
.;
.SETS PC P2
.GOSUB CHKPRM
.SETS PC P3
.GOSUB CHKPRM
.SETS PC P4
.GOSUB CHKPRM
.SETS PC P5
.GOSUB CHKPRM
.SETS PC P6
.GOSUB CHKPRM
.SETS PC P7
.GOSUB CHKPRM
.SETS PC P8
.GOSUB CHKPRM
.SETS PC P9
.GOSUB CHKPRM

.;
.;  Now decipher what was decoded :
.;
.;   CHECK
.IFT CHECK .SETS CHK "/CK"
.IFF CHECK .SETS CHK "/NOCK"

.;   DEBUG :
.IFT DEBUG .SETS DEB "/DE"
.IFF DEBUG .SETS DEB ""

.;   Short Error Messages
.IFT SHORT .SETS SRT ",LB:[1,1]SYSLIB/LB:$SHORT"
.IFF SHORT .SETS SRT ""

.;   SPOOL
.IFT SPOOL .SETS SPL "/SP"
.IFF SPOOL .SETS SPL "/-SP"

.;   LIST
.IFT LIST .SETS LST ",'P1'"
.IFF LIST .SETS LST ""
.IFF LIST .SETS SPL ""

.;   MAP
.IFT MAP  .SETS MP  ",'P1'/-SP"
.IFF MAP  .SETS MP  ""

.;   TRACE
.IFT TRACE .SETS TRC "/TR"
.IFF TRACE .SETS TRC "/NOTR"

.;   Production
.IFT PROD .SETS TRC "/NOTR"
.IFT PROD .SETS CHK "/NOCK"

.;   Include an Object Library?
.IFT INCLBR .SETS LIB ",'OL'.OLB/LB"
.IFF INCLBR .SETS LIB ""

.;   Set APR Number as Per Inclusion of Virtual Arrays :
.IFT VIRT .SETS APR "6"
.IFF VIRT .SETS APR "7"

.;
.;  Create the Build File :
.;
.OPEN 'P1'.BLD
.ENABLE DATA
'P1''MP'='P1''LIB''SRT'
/
LIBR = FCSRES:RO:'APR'
.DISABLE DATA

.;  If UNITS specified then put into build file :
.IFF UNITS .GOTO OPTCOD
.ENABLE DATA
UNITS = 'UNT'
ACTFIL= 'UNT'
.DISABLE DATA

.;   If you want more options then get them now :
.OPTCOD:
.IFF OPTNS .GOTO CLSBLD
.MORE:
.ASKS [0:30.:"":10S] OPT PLEASE ENTER OPTIONS (<CR> NO MORE)
.IFT <TIMOUT> .GOTO CLSBLD
.IF OPT EQ "" .GOTO CLSBLD
.DATA 'OPT'
.GOTO MORE

.;  Close the Build file :
.CLSBLD:
.ENABLE DATA
//
.DISABLE DATA
.CLOSE

.;
.;  Delete old files :
.;
PIP 'P1'.OBJ;*/DE/NM,'P1'.TSK;*,'P1'.LST;*,'P1'.MAP;*

.;
.;  Do the Fortran Compile :
.;
F77 'P1''LST''SPL'='P1''DEB''TRC''CHK'
.IF <EXSTAT> NE 1 .GOTO EXIT

.;
.;  Do the task build :
.;
TKB @'P1'.BLD
.IF <EXSTAT> NE 1 .GOTO EXIT

.;
.;  Delete the Build File :
.;
PIP 'P1'.OBJ;*/DE/NM,'P1'.BLD;*

.;
.;  Run the task unless told not to :
.;
.IFT RUN ;RUNNING 'P1'
.IFT RUN RUN 'P1'
.IFF RUN ;NORUN SELECTED

.;
.;  Now its time to exit :
.;
.EXIT:
	.IF <EXSTAT> NE 1 ;ERROR   EXIT STATUS = '<EXSTAT>'
;END
.EXIT

.CHKPRM:
.;
.;  This section of code will examine the variable PC and will set
.;  other variables depending on what is found.
.;
.;   If Blank then RETURN
.IF PC EQ "" .RETURN

.;   Look for CHECK :
.IF PC EQ "-C" .SETF CHECK
.IF PC EQ "NC" .SETF CHECK
.IF PC EQ "CK" .SETT CHECK

.;   Look for DEBUG :
.IF PC EQ "-D" .SETF DEBUG
.IF PC EQ "ND" .SETF DEBUG
.IF PC EQ "DE" .SETT DEBUG

.;   Look for Short Error Messages :
.IF PC EQ "ER" .SETT SHORT
.IF PC EQ "-E" .SETF SHORT
.IF PC EQ "NE" .SETF SHORT

.;   Look for LIST :
.IF PC EQ "-L" .SETF LIST
.IF PC EQ "NL" .SETF LIST
.IF PC EQ "LI" .SETT LIST

.;   Look for Task MAP Output
.IF PC EQ "MP" .SETT MAP
.IF PC EQ "-M" .SETF MAP
.IF PC EQ "NM" .SETF MAP

.;   Look for RUN :
.IF PC EQ "-R" .SETF RUN
.IF PC EQ "NR" .SETF RUN
.IF PC EQ "RU" .SETT RUN

.;   Look for SPOOL :
.IF PC EQ "-S" .SETF SPOOL
.IF PC EQ "NS" .SETF SPOOL
.IF PC EQ "SP" .SETT SPOOL

.;   Look for TRACE :
.IF PC EQ "-T" .SETF TRACE
.IF PC EQ "NT" .SETF TRACE
.IF PC EQ "TR" .SETT TRACE

.;   Look for OPTIONS :
.IF PC EQ "+O" .SETT OPTNS

.;   Look for PRODuction :
.IF PC EQ "+P" .SETT PROD

.;   Look for Virtual Arrays :
.IF PC EQ "+V" .SETT VIRT

.;   Look for Object Librarys and Increased Units :
.TEST PC
.SETN LEN <STRLEN>
.IF LEN LE 2 .RETURN
.IF OLPRM EQ PC[1:3] .SETS OL PC[4:LEN]
.IF OLPRM EQ PC[1:3] .SETT INCLBR
.IF UNTPRM EQ PC[1:2] .SETS UNT PC[3:LEN]
.IF UNTPRM EQ PC[1:2] .SETT UNITS

.RETURN

.NOFILE:
.;
.;  This will send a message to the user stating that the requested
.;  file does not exist and then it will exit the Indirect Command
.;  File Processor.
.;
;ERROR 'P1'.FTN DOES NOT EXIST
;END
.EXIT
