;
;	RUNOFF (M3.0) FOR RSX  --  DECUS SPRING '83 DISTRIBUTION
;
; The following procedure will create a new RUNOFF task image tailored
; for use on your system.


	.ENABLE	SUBSTITUTION
	.DISABLE LOWERCASE

	.SETS	TASKS	""
	.IFNINS   MAC	.SETS	TASKS	TASKS+"	MAC"
	.IFNINS   LBR	.SETS	TASKS	TASKS+"	LBR"
	.IFNINS   PIP	.SETS	TASKS	TASKS+"	PIP"
	.IFNINS   TKB	.SETS	TASKS	TASKS+"	TKB"
	.IF  TASKS = ""	.GOTO T0
	;
	; Your system does not have the following task(s) installed:
	;
	;			'TASKS'
	;
	; This procedure assumes that 1-line commands can be issued for that(those)
	; task name(s).  If that isn't true for your system, you should stop here
	; and either install the task(s) or edit this command file (MAKRNO.CMD)
	; as required.
	;
	.ASK	ANS	Okay to continue
	.IFF	ANS	.EXIT

.T0:	;
	; You can request expanded comments on any question by responding
	; with an ESCAPE character.
	;
	.ASK	EXPAND	Do you want all the expanded comments
	.ENABLE	ESCAPE

.; Check for existence of object library

	.TESTFILE RNO.OLB
	.IF  <FILERR> EQ 1  .GOTO T1
	.SETS	NAME	"ALL"
	.GOTO T2

.T1:	.IFF   EXPAND	.GOTO Q1
.C1:
	;
	; You have an object library for building RUNOFF.  You can use that library
	; to build the task if you haven't made any changes to the source code.
.Q1:	;
	.ASK	ANS	Use existing object library
	.IFT  <ESCAPE>	.GOTO C1
	.IFT	ANS	.GOTO T4

	.IFF	EXPAND	.GOTO Q2
.C2:
	;
	; You can have one or more of the source modules assembled at this time.
	; You should enter the name of the file you want assembled, or "ALL" to
	; have all modules assembled.
	;
	; If you enter individual module names, press RETURN to signal when you
	; are done entering names.
	;
.Q2:
		.ASKS	NAME	Name of module to assemble (or "ALL")
		.IFT  <ESCAPE>	.GOTO C2:
		.IF   <STRLEN> = 0   .GOTO T3
		.SETT	ASM
		.IF   NAME = "ALL"   .GOTO T2

			.PARSE	NAME	"."	NAME  JUNK
			@REPLACE 'NAME' C
			.IF   <EXSTAT> <> 1   .GOTO ERROR
			.GOTO Q2

.T2:		.GOSUB	RNOASM
		.IF   <EXSTAT> <> 1   .GOTO ERROR
		.GOTO T4

.T3:	.IFF	ASM	.GOTO T4

		LBR RNO/CO:100.=RNO.OLB
		.IF   <EXSTAT> <> 1   .GOTO ERROR
.;		PIP RNO.OLB/PU
.;		PIP *.*;1=RNO.OLB/RE
		PIP RNO.OLB/TR

.T4:	.TESTFILE MAKRNO.TKB
	.IF  <FILERR> NE 1  .GOTO T5
	.TESTFILE MAKRNO.ODL
	.IF  <FILERR> NE 1  .GOTO T5
	;
	.ASK	ANS	Use existing task builder command file & ODL file
	.IFT	ANS	.GOTO T8

.T5:	;
	; STARTING SETUP FOR TASK BUILD
	;

	.GOSUB	OPTION

	.SETF	FCSRES		! Assume FCSRES not available
	.SETF	MAP		! Assume no MAP file
	.SETF	CRF		! Assume no cross reference

	.IFF	EXPAND	.GOTO Q3
.C3:
	;
	; FCSRES is a system library which is permanently resident in memory.
	; If your system has such a library and you want your RUNOFF task to
	; make use of it, answer "Y".
.Q3:	;
	.SETT	RSX32
	.ASK	FCSRES	Does your system have an FCSRES resident library
	.IFT  <ESCAPE>	.GOTO C3
	.IFF	FCSRES	.GOTO T6
	.IFF	EXPAND	.GOTO Q4
.C4:
	;
	; The task building commands created by this command file are compatible
	; with RSX-11M, version 3.2, using DEC''s version of FCSRES.
	;
	; If you answer "N", an overlay structure for RSX-11M, version 4.1 will
	; be used.  If it turns out that isn't compatible with your system, you
	; should edit the build files after they are created.
	;
.Q4:	.ASK	RSX32	Does your system use RSX-11M V3.2, with DEC''s FCSRES
	.IFT  <ESCAPE>	.GOTO C4
.T6:	.IFF	EXPAND	.GOTO Q5
.C5:
	;
	; The task builder can produce a map file containing information about
	; the task image, including the addresses of all the global symbols used
	; in the program.
	;
	; If you want that information, answer "Y".
	;
.Q5:	.ASK	MAP	Do you want a MAP file
	.IFT  <ESCAPE>	.GOTO C5
	.IFF	MAP	.GOTO T7
	.IFF	EXPAND	.GOTO Q6
.C6:
	;
	; The task builder's map file can be made to include a cross reference
	; showing which modules define and reference the global symbols.
	;
	; If you want that information, answer "Y".
	;
.Q6:	.ASK	CRF	Do you want a cross reference
	.IFT  <ESCAPE>	.GOTO C6

.T7:	.SETS	MAPFIL	""
	.IFT	MAP	.SETS	MAPFIL	",RNO/-SP"
	.IFT	CRF	.SETS	MAPFIL	MAPFIL+"/CR"
	.SETS	LIBR	""
	.IFT	FCSRES	.SETS	LIBR	"LIBR=FCSRES:RO"

	.GOSUB	MAKTKB
	.GOSUB	MAKODL

.; All ready to task build

.T8:	;
	.ASK	ANS	Continue with the task build
	.IFF	ANS	.EXIT
	;
	TKB @MAKRNO.TKB
	.IF   <EXSTAT> <> 1   .GOTO ERROR
	;
	.ASK	ANS	Delete task builder command files
	.IFT	ANS	PIP MAKRNO.TKB;0/DE,MAKRNO.ODL;0
	.IFT	ANS	.GOTO T9

		;
		; The following files were created for the task builder:
		;
		;	MAKRNO.TKB	Commands to the task builder
		;	MAKRNO.ODL	Overlay description for the task
.T9:	;
	; RNO.TSK is ready for use.  (Transfer the file to LB:'<SYSUIC>'.)
	;
	.EXIT

.ERROR:	;
	;  ***  ABNORMAL EXIT DUE TO ERROR  ***
	;
	.EXIT

.; Subroutine to assemble all modules and create object library


.RNOASM:;
	; Assemble each module
	;
	PIP COMND.OBJ;*/DE/NM
	MAC COMND=RNPRE,COMND
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP CMTAB.OBJ;*/DE/NM
	MAC CMTAB=RNPRE,CMTAB
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP DATA.OBJ;*/DE/NM
	MAC DATA=RNPRE,DATA
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP ERMSG.OBJ;*/DE/NM
	MAC ERMSG=RNPRE,ERMSG
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP FMTCM.OBJ;*/DE/NM
	MAC FMTCM=RNPRE,FMTCM
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP HYPHEN.OBJ;*/DE/NM
	MAC HYPHEN=RNPRE,HYPHEN
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP INDEX.OBJ;*/DE/NM
	MAC INDEX=RNPRE,INDEX
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP PINDX.OBJ;*/DE/NM
	MAC PINDX=RNPRE,PINDX
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP PRTOC.OBJ;*/DE/NM
	MAC PRTOC=RNPRE,PRTOC
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP QUEUE.OBJ;*/DE/NM
	MAC QUEUE=RNPRE,QUEUE
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP RNCMD.OBJ;*/DE/NM
	MAC RNCMD=RNPRE,RNCMD
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP RNFIO.OBJ;*/DE/NM
	MAC RNFIO=RNPRE,RNFIO
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP RNORSX.OBJ;*/DE/NM
	MAC RNORSX=RNPRE,RNORSX
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP RUNOFF.OBJ;*/DE/NM
	MAC RUNOFF=RNPRE,RUNOFF
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP SETUP.OBJ;*/DE/NM
	MAC SETUP=RNPRE,SETUP
	.IF <EXSTAT> NE 1  .GOTO 10

	PIP START.OBJ;*/DE/NM
	MAC START=RNPRE,START
	.IF <EXSTAT> NE 1  .GOTO 10

	;
	; Create object library
	;

	PIP RNO.OBS=*.OBJ
	.IF <EXSTAT> NE 1  .GOTO 10
	PIP *.OBJ;*/DE/NM

	LBR RNO/CR:100.::64.=RNO.OBS
	.IF <EXSTAT> NE 1  .GOTO 10
	PIP RNO.OBS;*/DE/NM
	.GOTO 20

.10:	;
	; Abnormal exit due to error
	;

.20:	.RETURN

.; Subroutine to ask for default values for options


.OPTION:; The following questions will determine how you want RUNOFF to be
	; configured for your users.

	.IFF	EXPAND	.GOTO OQ1
.OC1:
	;
	; A default will usually be assumed if you just press RETURN in
	; response to a request.  In the cases where that will happen, the
	; default is indicated by a number in brackets.  Thus, for example,
	; a value of 66 (decimal) will be used as the default here.
	;
	; RUNOFF needs to know how many lines there are on a page so it will
	; know how many linefeeds to output between pages when formfeeds are
	; not used (i.e., when /-FF is specified).
.OQ1:	;
	.ASKN [::66.] D	Enter number of HARDWARE LINES PER PAGE
	.IFT  <ESCAPE>	.GOTO OC1
	.GOSUB	OCTAL
	.SETN	HLPP	O

	;
	; DEFAULT settings for COMMAND-LINE SWITCHES
	;
	;	Note that users can always include switches on the RUNOFF
	;	command line to override the defaults selected.
	;
	.SETN	SWTCHS	0
	.IFF	EXPAND	.GOTO OQ2
.OC2:
	;
	; If your printing hardware does NOT respond to formfeed characters,
	; you will need to have RUNOFF output linefeeds instead.  In that
	; case, you should respond "N".
	;
.OQ2:	.ASK	ANS	Use FORMFEEDS (/FF)
	.IFT  <ESCAPE>	.GOTO OC2
	.IFT	ANS	.SETN	SWTCHS	SWTCHS+1
	.IFF	EXPAND	.GOTO OQ3
.OC3:
	;
	; RUNOFF will hyphenate words at the ends of lines when possible.  That
	; is usually desirable to make the right margin more uniform when not
	; justifying, or to avoid extreme space filling when justifying.
	;
	; Unfortunately, RUNOFF's hyphenation algorithm is far from perfect.
	; Thus, you might want to turn it off.  That can be done in two ways.
	;
	;   1.  The /-HY command-line switch will unconditionally prevent
	;       hyphenation in a document.
	;
	;   2.  The NO HYPHENATION command can be used within an input file
	;       to disable hyphenation.
	;
	; If you want the HY command-line switch to default to the "/-HY"
	; setting, answer "N".
	;
.OQ3:	.ASK	ANS	Allow HYPHENATION (/HY)
	.IFT  <ESCAPE>	.GOTO OC3
	.IFT	ANS	.SETN	SWTCHS	SWTCHS+2
	.IFF	EXPAND	.GOTO OQ4
.OC4:
	;
	; If you have RUNOFF send its output directly to a printer, you may
	; want to have the output pause after each page so you can insert the
	; next sheet of paper.  (The output resumes when the user presses the
	; RETURN key on his/her terminal.)
	;
	; If you want the default setting for the WA command-line switch to
	; be such that RUNOFF will wait between pages, answer "Y".
	;
	; Note, however, that when /WA is used, RUNOFF will wait between pages
	; even if the output is being written to a disk file!
	;
.OQ4:	.ASK	ANS	WAIT between pages of output (/WA)
	.IFT  <ESCAPE>	.GOTO OC4
	.IFT	ANS	.SETN	SWTCHS	SWTCHS+4
	.IFF	EXPAND	.GOTO OQ5
.OC5:
	;
	; RUNOFF output is usually written to a disk file.  If you wanted that
	; file to be automatically sent to the printer, you would specify a
	; "/SP" switch in the RUNOFF command line.
	;
	; If you want the output to be printed by default, answer "Y".
	;
.OQ5:	.ASK	ANS	Automatically SPOOL output file (/SP)
	.IFT  <ESCAPE>	.GOTO OC5
	.IFT	ANS	.SETN	SWTCHS	SWTCHS+10
	.IFF	EXPAND	.GOTO OQ6
.OC6:
	;
	; Some people use terminals which can only input uppercase characters
	; (comments suppressed!).  In that case, control information must be
	; included in the RUNOFF input file to tell RUNOFF when to convert
	; to lowercase.
	;
	; The /UC command-line switch can then be used to suppress that
	; conversion.
	;
	; If your input files won't contain the LOWERCASE command, or the "\\"
	; control sequence, the setting of the UC switch will have no effect.
	;
.OQ6:	.ASK	ANS	Suppress conversion of UPPERCASE to lowercase (/UC)
	.IFT  <ESCAPE>	.GOTO OC6
	.IFT	ANS	.SETN	SWTCHS	SWTCHS+20
	.IFF	EXPAND	.GOTO OQ7
.OC7:
	;
	; RUNOFF can be made to put the page title(s) and numbers on
	; alternating sides of the pages for when the output document
	; is to be reproduced on both sides of the paper.  Also, every
	; other page can be offset to the right so the margins will be
	; correct for both sides of the printed pages.
	;
	; The /-AL switch can be used to disable all the RUNOFF commands
	; associated with alternating output.
	;
.OQ7:	.ASK	ANS	Allow ALTERNATING output (/AL)
	.IFT  <ESCAPE>	.GOTO OC7
	.IFT	ANS	.SETN	SWTCHS	SWTCHS+40
	.IFF	EXPAND	.GOTO OQ8
.OC8:
	;
	; RUNOFF output is normally written to a new disk file.  It is
	; possible to use the /AP switch to have the output appended to
	; an existing file instead.
	;
	; Answer "Y" if you want appending to be the default behavior.
	;
.OQ8:	.ASK	ANS	APPEND output to exising file (/AP)
	.IFT  <ESCAPE>	.GOTO OC8
	.IFT	ANS	.SETN	SWTCHS	SWTCHS+100
	.IFF	EXPAND	.GOTO OQ9
.OC9:
	;
	; RUNOFF can process underlining in four different ways.  The /UL
	; switch determines which will be used.
	;
	; BACKSPACE underlining results in every underlined character being
	; output as <underbar><backspace><character>.  Obviously, this
	; requires that your printer be able to backspace.
	;
	; LINE OVERPRINT mode causes the underlining to be output as a second
	; line which is printed over the text line.  This is the most common
	; mode for line printers.
	;
	; HYPHEN SIMULATION underlining is used when the printer does not
	; have an underbar character.  In this mode, a new line is printed
	; under the text line, with hyphens ("-") used in place of underbars.
	;
	; SUPPRESSION of underlining can be done if none of the above modes
	; is desirable.
	;
	.ASK	ANS	Press RETURN to continue
.OQ9:
	;
	;	Set default UNDERLINE MODE
	;
	;	For  BACKSPACE		(/UL:B)  enter  102
	;	For  LINE OVERPRINT	(/UL:L)  enter  114
	;	For  HYPHEN SIMULATION	(/UL:S)  enter  123
	;	For  SUPPRESSION	(/UL:N)  enter  116
	;
	.ASKN	ULMOD	Enter desired default
	.IFT  <ESCAPE>	.GOTO OC9
	.IF   ULMOD = 102   .GOTO OT1
	.IF   ULMOD = 114   .GOTO OT1
	.IF   ULMOD = 123   .GOTO OT1
	.IF   ULMOD <> 116  .GOTO OQ9

.OT1:	.IFF	EXPAND	.GOTO OQ10
.OC10:
	;
	; RUNOFF needs to know how many lines of output you want on each
	; page (including the page headers).
	;
	; You can set the default value to be assumed when RUNOFF starts
	; processing an input file.  That default can be changed with the
	; /LO or /PS switch, or the PAGE SIZE or LAYOUT commands.
	;
.OQ10:	.ASKN [::56.] D	Enter default OUTPUT LINES PER PAGE
	.IFT  <ESCAPE>	.GOTO OC10
	.GOSUB	OCTAL
	.SETN	NLPG	O
	.IFF	EXPAND	.GOTO OQ11
.OC11:
	;
	; The default right margin determines how wide the page headers and
	; text will be on the output pages.  It also determines the value
	; assumed for the right margin when a RIGHT MARGIN command appears
	; without an argument.
	;
	; The default can be changed with the /WI switch or the PAGE SIZE
	; or LAYOUT commands.
	;
.OQ11:	.ASKN [::60.] D	Enter default RIGHT MARGIN
	.IFT  <ESCAPE>	.GOTO OC11
	.GOSUB	OCTAL
	.SETN	RMARG	O
	.IFF	EXPAND	.GOTO OQ12
.OC12:
	;
	; The default top margin determines how many blank lines are to be
	; output at the top of each page before the page header.
	;
	; The default can be changed with the /DO switch or the LAYOUT
	; command.
	;
.OQ12:	.ASKN [::0.] D	Enter default TOP MARGIN
	.IFT  <ESCAPE>	.GOTO OC12
	.GOSUB	OCTAL
	.SETN	TOPMRG	O
	.IFF	EXPAND	.GOTO OQ13
.OC13:
	;
	; The default base left margin determines how many blanks are to be
	; output at the left of each line of the output.  That is, the output
	; is shift that many spaces to the right without affecting the left
	; margin.
	;
	; The default can be changed with the /LE switch or the LAYOUT command.
	;
.OQ13:	.ASKN [::0.] D	Enter default BASE LEFT MARGIN
	.IFT  <ESCAPE>	.GOTO OC13
	.GOSUB	OCTAL
	.SETN	BASMRG	O
	.IFF	EXPAND	.GOTO OQ14
.OC14:
	;
	; The default header length determines how many lines are to be output
	; at the top of each page before the text.  Those lines will include
	; the page title and subtitle, if specified, and the page number if
	; numbering is enabled.
	;
	; The default can be changed with the /HL switch or the HEADER command.
	;
.OQ14:	.ASKN [::5.] D	Enter default number of LINES IN HEADERS
	.IFT  <ESCAPE>	.GOTO OC14
	.GOSUB	OCTAL
	.SETN	HDRLEN	O
	.IFF	EXPAND	.GOTO OQ15
.OC15:
	;
	; RUNOFF normally outputs extra blank lines at the start of new chapters,
	; appendices, and when outputting the index and tables of contents.  You
	; can set the default number of lines to be output in those cases.
	;
	; The value you enter should be the total number of blank lines you want
	; output.
	;
	; The default can be changed with the /BL switch.
	;
.OQ15:	;	Enter number of BLANK LINES above "CHAPTER", "APPENDIX", "INDEX",
	.ASKN [::7.] D		and "CONTENTS" headings
	.IFT  <ESCAPE>	.GOTO OC15
	.GOSUB	OCTAL
	.SETN	CHPSKP	O
	.IFF	EXPAND	.GOTO OQ16
.OC16:
	;
	; RUNOFF's hyphenation routine can be restricted from breaking words on
	; too many consecutive lines.  Enter the maximum number of consecutive
	; hyphenations you want to permit.
	;
	; This setting cannot be changed by the user.
	;
.OQ16:	;	Enter MAXIMUM number of CONSECUTIVE LINES allowed to be
	.ASKN [::2.] D		HYPHENATED
	.IFT  <ESCAPE>	.GOTO OC16
	.GOSUB	OCTAL
	.SETN	HYLINS	O
	.IFF	EXPAND	.GOTO OQ17
.OC17:
	;
	; RUNOFF's hyphenation algorithm contains a "threshold" criterion which
	; is used in determining where to break words.  The larger the value of
	; the threshold, the less hyphenation is done.
	;
	; RUNOFF version 2.0 used 20; version 2.4 uses 144.  You will have to
	; experiment with different values to find one which results in
	; hyphenations reasonably acceptable to you.
	;
	; This setting cannot be changed by the user.
	;
.OQ17:	.ASKN [::20] HYTHRS	Enter HYPHENATION THRESHOLD value
	.IFT  <ESCAPE>	.GOTO OC17
	.IFT  <DEFAUL>	.SETN	HYTHRS   20
	.IFF	EXPAND	.GOTO OQ18
.OC18:
	;
	; RUNOFF's hyphenation routine can be restricted from breaking words in
	; such a way that a short fragment is left at the right end of a line.
	; Enter the minimum number of characters you want to permit ahead of
	; hyphens.
	;
	; This setting cannot be changed by the user.
	;
.OQ18:	;	Enter MINIMUM hyphenation FRAGMENT LENGTH (minimum = 2,
	.ASKN [2:7:2] HYCHRS		maximum = 7, default = 2)
	.IFT  <ESCAPE>	.GOTO OC18

	.RETURN

.; Subroutine to create task build command file


.MAKTKB:.OPEN	MAKRNO.TKB
	.ENABLE	DATA
;
; TASK BUILD RUNOFF M3.0
;
RNO/MM/CP/-FP'MAPFIL'=MAKRNO/MP
;
'LIBR'
;
TASK=...RNO
PAR=GEN
ACTFIL=3
UNITS=4
ASG=TI:1:2:3:4
STACK=128
EXTTSK=2048
;
; Default HARDWARE LINES PER PAGE (octal)
;
GBLDEF=HWLPP$:'HLPP'
;
; Default SWITCHES (octal value = sum of desired "ON" switch masks)
;
GBLDEF=INI$SW:'SWTCHS'
;
; Default UNDERLINE MODE (octal)
;
GBLDEF=IUL:'ULMOD'
;
; Default LINES PER PAGE and COLUMNS PER LINE (octal)
;
GBLDEF=INLPG$:'NLPG'
GBLDEF=IRMRG$:'RMARG'
;
; Default TOP MARGIN on output pages (octal)
;
GBLDEF=ITMRG$:'TOPMRG'
;
; Default BASE LEFT MARGIN (octal)
;
GBLDEF=IBMRG$:'BASMRG'
;
; Default number of LINES IN HEADERS (octal)
;
GBLDEF=HDLEN:'HDRLEN'
;
; Number of BLANK LINES above "CHAPTER n", "APPENDIX a", & "INDEX" (octal)
;
GBLDEF=ICHBL$:'CHPSKP'
;
; MAXIMUM number of CONSECUTIVE LINES allowed to be HYPHENATED (octal)
;
GBLDEF=HYMAXL:'HYLINS'
;
; "Threshold" criterion for hyphenation algorithm (octal)
;
GBLDEF=THRESH:'HYTHRS'
;
; Length of MINIMUM WORD FRAGMENTS allowed during hyphenation (octal)
;
GBLDEF=HYMINC:'HYCHRS'
;
/
.DISABLE DATA
	.CLOSE
	.RETURN

.; Subroutine for creating ODL file for task build


.MAKODL:.OPEN	MAKRNO.ODL
	.ENABLE	DATA
	.PSECT	DSPTCH,GBL,D
	.PSECT	STRING,GBL,D
	.PSECT	SWTCH,GBL,D
	.NAME	RNO
	
	.ROOT	RNO-R1-R2-R3-*(B1,B2)
	
R1:	.FCTR	RNO/LB:DATA:RUNOFF:RNCMD:FMTCM
R2:	.FCTR	RNO/LB:RNFIO:RNORSX
F1A:	.FCTR	LB:[1,1]SYSLIB/LB:.CSI1
F1B:	.FCTR	LB:[1,1]SYSLIB/LB:.CSI2-SWTCH
	
.DISABLE DATA

	.IFF	FCSRES	.GOTO ODL3

.; Continuation for system with FCSRES

	.DATA R3:	.FCTR	RNO/LB:INDEX:CMTAB-DSPTCH

	.IFF	RSX32	.GOTO ODL1

	.DATA B1:	.FCTR	RNO/LB:START:ERMSG:QUEUE:SETUP-(F1A,F1B,B1A,B1B)

	.GOTO ODL2

.ODL1:	.DATA B1:	.FCTR	RNO/LB:START:ERMSG:QUEUE:SETUP-F1B-(F1A,B1A,B1B)

.ODL2:	.ENABLE	DATA
B2:	.FCTR	RNO/LB:HYPHEN:COMND-STRING
B1A:	.FCTR	RNO/LB:PINDX
B1B:	.FCTR	RNO/LB:PRTOC
	
.DISABLE DATA

	.GOTO ODL4

.; Continuation for system without FCSRES

.ODL3:	.ENABLE	DATA
R3:	.FCTR	RNO/LB:CMTAB:PINDX:PRTOC-DSPTCH
B1:	.FCTR	RNO/LB:START:SETUP:QUEUE-(F1,F2)
B2:	.FCTR	RNO/LB:HYPHEN:INDEX:COMND-STRING
F1:	.FCTR	RNO/LB:ERMSG-(F1A,F1B)
F2:	.FCTR	LB:[1,1]SYSLIB/LB:OPEN-(OP1,OP2)
OP1:	.FCTR	LB:[1,1]SYSLIB/LB:CLOSE:CREATE:DEL:FINIT:MKDL:OPFNB:RQLCB
OP2:	.FCTR	LB:[1,1]SYSLIB/LB:PARSE
	
.DISABLE DATA

.ODL4:	.DATA 	.END
	.CLOSE

	.RETURN

.; Subroutine to compute octal value of input parameter "D"; result => "O"


.OCTAL:	.SETN O 0
	.IF D = 0 .GOTO OCTAL2

	.SETN B 1
.OCTAL1:
	.SETN R D
	.IF D >= 8.  .SETN R D-((D/8.)*8.)
	.SETN O O+(B*'R')
	.SETN D D/8.
	.IF D = 0 .GOTO OCTAL2
		.SETN B B*10	
		.GOTO OCTAL1

.OCTAL2:.RETURN
