.;									 
.;******************************************************************************
.;
.; This software is provided on an "as is" basis only. Caterpillar Tractor Co.,
.; disclaims  all  warranties on the program, including without limitation, all
.; implied warranties of merchantablity and fitness.
.;
.; Full  permission  and  consent  is  hereby  given  to DECUS and to the DECUS
.; special interest groups to reproduce,  distribute,  and  publish  and permit
.; others to reproduce in whole or in part, in any form and without restriction
.; this program and any information relating thereto
.;
.;******************************************************************************
.;
.; Author:
.; 
.; 	Rick Webster, Process Control Applications, MSDGO
.; 	Caterpillar Tractor Co.
.; 
.; Description:
.; 
.; 	This command file is used in conjunction with the CONFIG command file
.; 	which will produce a sysgen-like listing of a saved answer file. 
.; 
.ENABLE GLOBAL
.ENABLE SUBSTITUTION
.DISABLE LOWERCASE
.3: .SETF REPEAT
.2: .DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; Target configuration
.IFF $TTCFG ; Target configuration
.DATA #3 ;
.IFF $TTCFG ;
.SETF FRCPRM
.;
.;PROCESSOR
.;
.SETN SYDISK 0
.SETF PTW
.SETF GTW
.SETF SRD
.SETN ECC 0
.SETF $MMP
.SETF $CHE
.SETS DEF ""
.IFNDF $TPR .DATA #3 ;  1. [$TPR] Not defined defaulting to 11/34
.IFNDF $TPR .IFF $TTCFG ;  1. [$TPR] Not defined defaulting to 11/34
.IFNDF $TPR .SETS $TPR "11/34"
.DATA #3 ;  1. [$TPR] Processor Type -- '$TPR'
.IFF $TTCFG ;  1. [$TPR] Processor Type -- '$TPR'
.IF $TPR EQ "11/60" .IFNDF $FPP .SETT $FPP
.;
.;DETERMINE INDIVIDUAL PROCESSOR FEATURES
.;
.SETF $AMA
.IF $TPR EQ "11/04" .OR .IF $TPR EQ "11/34" .SETT $AMA
.;
.; SWITCH REGISTER
.;
.IFNDF $SWR .SETF $SWR
.IFT $SWR  .DATA #3 ;  2. [$SWR] Processor does have a switch register
.IFT $SWR  .IFF $TTCFG ;  2. [$SWR] Processor does have a switch register
.IFF $SWR  .DATA #3 ;  2. [$SWR] Processor does **NOT** have a switch register
.IFF $SWR  .IFF $TTCFG ;  2. [$SWR] Processor does **NOT** have a switch register
.SETS $SYS "M"
.SETF $11S
.;
.;TARGET MEMORY SIZE
.;
.DATA #3 ;  3. [$TME] Memory size (in K-word blocks) -- '$TME'
.IFF $TTCFG ;  3. [$TME] Memory size (in K-word blocks) -- '$TME'
.;
.;K-SERIES
.;
.IFNDF $KSR .SETF $KSR
.IFT $KSR  .DATA #3 ;  4. [$KSR] Support for K-series devices included
.IFT $KSR  .IFF $TTCFG ;  4. [$KSR] Support for K-series devices included
.IFF $KSR  .DATA #3 ;  4. [$KSR] Support for K-series devices **NOT** included
.IFF $KSR  .IFF $TTCFG ;  4. [$KSR] Support for K-series devices **NOT** included
.;
.;EAE SUPPORT
.;
.IFNDF $EAE .SETF $EAE
.IFT $EAE  .DATA #3 ;  5. [$EAE] Extended arithmetic element (KE11-A/B EAE) 
.IFT $EAE  .IFF $TTCFG ;  5. [$EAE] Extended arithmetic element (KE11-A/B EAE) 
.IFT $EAE  .DATA #3 ;            support included
.IFT $EAE  .IFF $TTCFG ;            support included
.IFF $EAE  .DATA #3 ;  5. [$EAE] Extended arithmetic element (KE11-A/B EAE) 
.IFF $EAE  .IFF $TTCFG ;  5. [$EAE] Extended arithmetic element (KE11-A/B EAE) 
.IFF $EAE  .DATA #3 ;            support **NOT** included
.IFF $EAE  .IFF $TTCFG ;            support **NOT** included
.;
.;FPP
.;
.IFNDF $FPP .SETF $FPP
.IFT $FPP  .DATA #3 ;  6. [$FPP] Floating point processor (FP-11) support included
.IFT $FPP  .IFF $TTCFG ;  6. [$FPP] Floating point processor (FP-11) support included
.IFF $FPP  .DATA #3 ;  6. [$FPP] Floating point processor (FP-11) support **NOT** included
.IFF $FPP  .IFF $TTCFG ;  6. [$FPP] Floating point processor (FP-11) support **NOT** included
.;
.;FIS
.;
.IFNDF $FIS .SETF $FIS
.IFT $FIS  .DATA #3 ;  7. [$FIS] Floating instruction set (FIS) support included
.IFT $FIS  .IFF $TTCFG ;  7. [$FIS] Floating instruction set (FIS) support included
.IFF $FIS  .DATA #3 ;  7. [$FIS] Floating instruction set (FIS) support **NOT** included
.IFF $FIS  .IFF $TTCFG ;  7. [$FIS] Floating instruction set (FIS) support **NOT** included
.;
.;EIS SUPPORT
.;
.IFNDF $EIS .SETF $EIS
.IFT $EIS  .DATA #3 ;  8. [$EIS] Extended instruction set (EIS) support included
.IFT $EIS  .IFF $TTCFG ;  8. [$EIS] Extended instruction set (EIS) support included
.IFF $EIS  .DATA #3 ;  8. [$EIS] Extended instruction set (EIS) support **NOT** included
.IFF $EIS  .IFF $TTCFG ;  8. [$EIS] Extended instruction set (EIS) support **NOT** included
.SETT FRCPRM
.;
.;PROGRAMMABLE CLOCK
.;
.IFNDF $PRO .SETN $PRO 0
.IF $PRO NE 0 .DATA #3 ;  9. [$PRO] Using KW11-P as system clock: number of intrps./sec. -- '$PRO'
.IF $PRO NE 0 .IFF $TTCFG ;  9. [$PRO] Using KW11-P as system clock: number of intrps./sec. -- '$PRO'
.IF $PRO EQ 0 .DATA #3 ;  9. [$PRO] **NOT** using KW11-P as system clock
.IF $PRO EQ 0 .IFF $TTCFG ;  9. [$PRO] **NOT** using KW11-P as system clock
.;
.;LINE FREQUENCY
.;
.IF $LIN EQ "A" .DATA #3 ; 10. [$LIN] Line frequency:   A- 60 Hz
.IF $LIN EQ "A" .IFF $TTCFG ; 10. [$LIN] Line frequency:   A- 60 Hz
.IF $LIN EQ "B" .DATA #3 ; 10. [$LIN] Line frequency:   B- 50 Hz
.IF $LIN EQ "B" .IFF $TTCFG ; 10. [$LIN] Line frequency:   B- 50 Hz
.;
.;WATCHDOG TIMER SUPPORT
.;
.IFNDF $WAT .SETF $WAT
.IFT $WAT .DATA #3 ; 11. [$WAT] KW11-Y Watchdog timer support included
.IFT $WAT .IFF $TTCFG ; 11. [$WAT] KW11-Y Watchdog timer support included
.IFf $WAT .DATA #3 ; 11. [$WAT] KW11-Y Watchdog timer support **NOT** included
.IFf $WAT .IFF $TTCFG ; 11. [$WAT] KW11-Y Watchdog timer support **NOT** included
.;
.;MEMORY PARITY
.;
.IFNDF $MPR .SETF $MPR
.IFT $MPR .DATA #3 ; 12. [$MPR] Memory parity support included
.IFT $MPR .IFF $TTCFG ; 12. [$MPR] Memory parity support included
.IFf $MPR .DATA #3 ; 12. [$MPR] Memory parity support **NOT** included
.IFf $MPR .IFF $TTCFG ; 12. [$MPR] Memory parity support **NOT** included
.;
.;CACHE MEMORY
.;
.IFNDF $CAH.SETF $CAH
.IFT $CAH .DATA #3 ; 13. [$CAH] Cache memory support included
.IFT $CAH .IFF $TTCFG ; 13. [$CAH] Cache memory support included
.IFF $CAH .DATA #3 ; 13. [$CAH] Cache memory support **NOT** included
.IFF $CAH .IFF $TTCFG ; 13. [$CAH] Cache memory support **NOT** included
.SETT FRCPRM
.;
.;HIGHEST INTERRUPT VECTOR
.;
.DATA #3 ; 14. [$HIV] Highest interrupt vector -- '$HIV'
.IFF $TTCFG ; 14. [$HIV] Highest interrupt vector -- '$HIV'
.SETT FRCPRM
.;
.;TARGET SYSTEM I/O DEVICES
.;
.SETF FINI
.SETS $DEVA $DEV
.SETS $DV2A $DV2
.SETS $DV3A $DV3
.407B:
.TEST $DEVA
.IF <STRLEN> EQ 0 .GOTO 407C
.SETS ADEV $DEVA[1:2]
.SETS ANUM $DEVA[3:4]
.SETN 'ADEV' 'ANUM'.
.SETT X'ADEV'
.IF <STRLEN> EQ 4 .GOTO 407C
.SETS $DEVA $DEVA[5:<STRLEN>]
.GOTO 407B
.407C:
.TEST $DV2A
.IF <STRLEN> EQ 0 .GOTO 407D
.SETS ADEV $DV2A[1:2]
.SETS ANUM $DV2A[3:4]
.SETN 'ADEV' 'ANUM'.
.SETT X'ADEV'
.IF <STRLEN> EQ 4 .GOTO 407D
.SETS $DV2A $DV2A[5:<STRLEN>]
.GOTO 407C
.407D:
.TEST $DV3A
.IF <STRLEN> EQ 0 .GOTO 407E
.SETS ADEV $DV3A[1:2]
.SETS ANUM $DV3A[3:4]
.SETN 'ADEV' 'ANUM'.
.SETT X'ADEV'
.IF <STRLEN> EQ 4 .GOTO 407E
.SETS $DV3A $DV3A[5:<STRLEN>]
.GOTO 407D
.407E: 
.407X:
.DATA #3 ;==============================================================================
.IFF $TTCFG ;==============================================================================
.DATA #3 ;		D e v i c e   C o n f i g u r a t i o n
.IFF $TTCFG ;		D e v i c e   C o n f i g u r a t i o n
.DATA #3 ;==============================================================================
.IFF $TTCFG ;==============================================================================
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;     [$DEV, $DV2, $DV3]
.IFF $TTCFG ;     [$DEV, $DV2, $DV3]
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;     Response format is:
.IFF $TTCFG ;     Response format is:
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;     dev1=number controllers,dev2=number controllers, ...
.IFF $TTCFG ;     dev1=number controllers,dev2=number controllers, ...
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;
.IFF $TTCFG ;
.402B:
.SETS TEMPS2 ""
.SETN TEMPN2 0
.SETT NOLIST
.SETS TEMPS "AD"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "AF"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "AR"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "LA"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "LS"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "IC"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "IP"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "IS"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "UD"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "CR"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "CT"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DB"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DD"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DF"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DK"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DL"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DM"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DP"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DR"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DS"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DT"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DU"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DX"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "DY"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "EM"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "LP"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "MM"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "MT"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "MS"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "NL"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "PP"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "PR"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "XB"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "XL"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "XM"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "XP"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "XQ"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "XU"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "XW"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "GR"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "MF"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "CO"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "YL"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "YH"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "YZ"
.IFDF X'TEMPS' .GOSUB 402C
.SETS TEMPS "YJ"
.IFDF X'TEMPS' .GOSUB 402C
.IF TEMPN2 NE 0 .GOSUB 402D
.IFT NOLIST .DATA #3 ;     SGN -- Current configuration is not defined
.IFT NOLIST .IFF $TTCFG ;     SGN -- Current configuration is not defined
.GOTO 405A
.402C:
.SETF NOLIST
.SETN TEMPN 'TEMPS'
.IF TEMPN2 GT 0 .SETS TEMPS2 TEMPS2+", "
.SETS TEMPS2 TEMPS2+"'TEMPS'='TEMPN'"
.INC TEMPN2
.IF TEMPN2 LT 8. .GOTO 402E
.402D:
.DATA #3 ; 15. Devices? 'TEMPS2'
.IFF $TTCFG ; 15. Devices? 'TEMPS2'
.SETS TEMPS2 ""
.SETN TEMPN2 0
.402E: .RETURN
.405A:
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;    A/D and industrial/laboratory devices supported:
.IFF $TTCFG ;    A/D and industrial/laboratory devices supported:
.DATA #3 ; 
.IFF $TTCFG ; 
.SETF FIND01
.IFDF XAD .DATA #3 ;	AD- AD01-D A/D Converter
.IFDF XAD .IFF $TTCFG ;	AD- AD01-D A/D Converter
.IFDF XAD .SETT FIND01
.IFDF XAF .DATA #3 ;	AF- AFC11 A/D Converter
.IFDF XAF .IFF $TTCFG ;	AF- AFC11 A/D Converter
.IFDF XAF .SETT FIND01
.IFDF XAR .DATA #3 ;	AR- AR11 Laboratory Subsystem
.IFDF XAR .IFF $TTCFG ;	AR- AR11 Laboratory Subsystem
.IFDF XAR .SETT FIND01
.IFDF XIC .DATA #3 ;	IC- ICR11/ICS11 Industrial Control Subsystem
.IFDF XIC .IFF $TTCFG ;	IC- ICR11/ICS11 Industrial Control Subsystem
.IFDF XIC .SETT FIND01
.IFDF XIP .DATA #3 ;	IP- IP11/IP300 Industrial Control Subsystem
.IFDF XIP .IFF $TTCFG ;	IP- IP11/IP300 Industrial Control Subsystem
.IFDF XIP .SETT FIND01
.IFDF XIS .DATA #3 ;	IS- DRS11/DSS11 Industrial Control Subsystem
.IFDF XIS .IFF $TTCFG ;	IS- DRS11/DSS11 Industrial Control Subsystem
.IFDF XIS .SETT FIND01
.IFDF XLA .DATA #3 ;	LA- LPA11 Laboratory Subsystem
.IFDF XLA .IFF $TTCFG ;	LA- LPA11 Laboratory Subsystem
.IFDF XLA .SETT FIND01
.IFDF XLS .DATA #3 ;	LS- LPS11 Laboratory Subsystem
.IFDF XLS .IFF $TTCFG ;	LS- LPS11 Laboratory Subsystem
.IFDF XLS .SETT FIND01
.IFDF XUD .DATA #3 ;	UD- UDC11 Universal Digital Controller
.IFDF XUD .IFF $TTCFG ;	UD- UDC11 Universal Digital Controller
.IFDF XUD .SETT FIND01
.IFF FIND01 .DATA #3 ;	*** none specified ***
.IFF FIND01 .IFF $TTCFG ;	*** none specified ***
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;    Interprocessor communication devices supported:
.IFF $TTCFG ;    Interprocessor communication devices supported:
.DATA #3 ; 
.IFF $TTCFG ; 
.SETF FIND01
.IFDF XXB .DATA #3 ;	XB- DA11-B Interprocessor Link
.IFDF XXB .IFF $TTCFG ;	XB- DA11-B Interprocessor Link
.IFDF XXB .SETT FIND01
.IFDF XXL .DATA #3 ;	XL- DL11-E Interprocessor Link
.IFDF XXL .IFF $TTCFG ;	XL- DL11-E Interprocessor Link
.IFDF XXL .SETT FIND01
.IFDF XXM .DATA #3 ;	XM- DMC11-E/DMR11 Interprocessor Link
.IFDF XXM .IFF $TTCFG ;	XM- DMC11-E/DMR11 Interprocessor Link
.IFDF XXM .SETT FIND01
.IFDF XXP .DATA #3 ;	XP- DP11 Synchronous Interface
.IFDF XXP .IFF $TTCFG ;	XP- DP11 Synchronous Interface
.IFDF XXP .SETT FIND01
.IFDF XXQ .DATA #3 ;	XQ- DQ11 Synchronous Interface
.IFDF XXQ .IFF $TTCFG ;	XQ- DQ11 Synchronous Interface
.IFDF XXQ .SETT FIND01
.IFDF XXU .DATA #3 ;	XU- DU11 Synchronous Interface
.IFDF XXU .IFF $TTCFG ;	XU- DU11 Synchronous Interface
.IFDF XXU .SETT FIND01
.IFDF XXW .DATA #3 ;	XW- DUP11 Synchronous Interface
.IFDF XXW .IFF $TTCFG ;	XW- DUP11 Synchronous Interface
.IFDF XXW .SETT FIND01
.IFF FIND01 .DATA #3 ;	*** none specified ***
.IFF FIND01 .IFF $TTCFG ;	*** none specified ***
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;    Unit record devices supported:
.IFF $TTCFG ;    Unit record devices supported:
.DATA #3 ; 
.IFF $TTCFG ; 
.SETF FIND01
.IFDF XCR .DATA #3 ;	CR- CR11/CM11-E Card Reader
.IFDF XCR .IFF $TTCFG ;	CR- CR11/CM11-E Card Reader
.IFDF XCR .SETT FIND01
.IFDF XGR .DATA #3 ;	GR- VT11/VS60 Graphics Subsystem
.IFDF XGR .IFF $TTCFG ;	GR- VT11/VS60 Graphics Subsystem
.IFDF XGR .SETT FIND01
.IFDF XLP .DATA #3 ;	LP- LA11/LP11/LS11/LV11 Line Printer
.IFDF XLP .IFF $TTCFG ;	LP- LA11/LP11/LS11/LV11 Line Printer
.IFDF XLP .SETT FIND01
.IFDF XPP .DATA #3 ;	PP- PC11 Paper Tape Punch
.IFDF XPP .IFF $TTCFG ;	PP- PC11 Paper Tape Punch
.IFDF XPP .SETT FIND01
.IFDF XPR .DATA #3 ;	PR- PC11/PR11 Paper Tape Punch and Reader
.IFDF XPR .IFF $TTCFG ;	PR- PC11/PR11 Paper Tape Punch and Reader
.IFDF XPR .SETT FIND01
.IFF FIND01 .DATA #3 ;	*** none specified ***
.IFF FIND01 .IFF $TTCFG ;	*** none specified ***
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;    Disk devices supported:
.IFF $TTCFG ;    Disk devices supported:
.DATA #3 ; 
.IFF $TTCFG ; 
.SETF FIND01
.IFDF XDB .DATA #3 ;	DB- RP04/RP05/RP06 Disk Drive
.IFDF XDB .IFF $TTCFG ;	DB- RP04/RP05/RP06 Disk Drive
.IFDF XDB .SETT FIND01
.IFDF XDD .DATA #3 ;	DD- TU58 Cartridge DECtape II
.IFDF XDD .IFF $TTCFG ;	DD- TU58 Cartridge DECtape II
.IFDF XDD .SETT FIND01
.IFDF XDF .DATA #3 ;	DF- RF11 Fixed Head Disk Drive
.IFDF XDF .IFF $TTCFG ;	DF- RF11 Fixed Head Disk Drive
.IFDF XDF .SETT FIND01
.IFDF XDK .DATA #3 ;	DK- RK03/RK05 Disk Drive
.IFDF XDK .IFF $TTCFG ;	DK- RK03/RK05 Disk Drive
.IFDF XDK .SETT FIND01
.IFDF XDL .DATA #3 ;	DL- RL01/RL02 Disk Drive
.IFDF XDL .IFF $TTCFG ;	DL- RL01/RL02 Disk Drive
.IFDF XDL .SETT FIND01
.IFDF XDM .DATA #3 ;	DM- RK06/RK07 Disk Drive
.IFDF XDM .IFF $TTCFG ;	DM- RK06/RK07 Disk Drive
.IFDF XDM .SETT FIND01
.IFDF XDP .DATA #3 ;	DP- RP02/RP03 Disk Drive
.IFDF XDP .IFF $TTCFG ;	DP- RP02/RP03 Disk Drive
.IFDF XDP .SETT FIND01
.IFDF XDR .DATA #3 ;	DR- RM02/RM03/RM05/RM80/RP07 Disk Drive
.IFDF XDR .IFF $TTCFG ;	DR- RM02/RM03/RM05/RM80/RP07 Disk Drive
.IFDF XDR .SETT FIND01
.IFDF XDS .DATA #3 ;	DS- RS03/RS04 Fixed Head Disk Drive
.IFDF XDS .IFF $TTCFG ;	DS- RS03/RS04 Fixed Head Disk Drive
.IFDF XDS .SETT FIND01
.IFDF XDT .DATA #3 ;	DT- TU56 DECtape
.IFDF XDT .IFF $TTCFG ;	DT- TU56 DECtape
.IFDF XDT .SETT FIND01
.IFDF XDU .DATA #3 ;	DU- UDA50 Unibus Disk Adapter
.IFDF XDU .IFF $TTCFG ;	DU- UDA50 Unibus Disk Adapter
.IFDF XDU .SETT FIND01
.IFDF XDX .DATA #3 ;	DX- RX01 Floppy Disk Drive
.IFDF XDX .IFF $TTCFG ;	DX- RX01 Floppy Disk Drive
.IFDF XDX .SETT FIND01
.IFDF XDY .DATA #3 ;	DY- RX02 Floppy Disk
.IFDF XDY .IFF $TTCFG ;	DY- RX02 Floppy Disk
.IFDF XDY .SETT FIND01
.IFDF XEM .DATA #3 ;	EM- ML11 Non-Rotating Electronic Memory
.IFDF XEM .IFF $TTCFG ;	EM- ML11 Non-Rotating Electronic Memory
.IFDF XEM .SETT FIND01
.IFF FIND01 .DATA #3 ;	*** none specified ***
.IFF FIND01 .IFF $TTCFG ;	*** none specified ***
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;    Magnetic tape devices supported:
.IFF $TTCFG ;    Magnetic tape devices supported:
.DATA #3 ; 
.IFF $TTCFG ; 
.SETF FIND01
.IFDF XCT .DATA #3 ;	CT- TU60 Cassette Tape Drive
.IFDF XCT .IFF $TTCFG ;	CT- TU60 Cassette Tape Drive
.IFDF XCT .SETT FIND01
.IFDF XMF .DATA #3 ;	MF- TU78 Magtape Drive
.IFDF XMF .IFF $TTCFG ;	MF- TU78 Magtape Drive
.IFDF XMF .SETT FIND01
.IFDF XMM .DATA #3 ;	MM- TU16/TU45/TU77/TE16 Magtape Drive
.IFDF XMM .IFF $TTCFG ;	MM- TU16/TU45/TU77/TE16 Magtape Drive
.IFDF XMM .SETT FIND01
.IFDF XMS .DATA #3 ;	MS- TS04 Magtape Drive
.IFDF XMS .IFF $TTCFG ;	MS- TS04 Magtape Drive
.IFDF XMS .SETT FIND01
.IFDF XMT .DATA #3 ;	MT- TU10/TE10/TS03 Magtape Drive
.IFDF XMT .IFF $TTCFG ;	MT- TU10/TE10/TS03 Magtape Drive
.IFDF XMT .SETT FIND01
.IFF FIND01 .DATA #3 ;	*** none specified ***
.IFF FIND01 .IFF $TTCFG ;	*** none specified ***
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;    Terminal interfaces supported:
.IFF $TTCFG ;    Terminal interfaces supported:
.DATA #3 ; 
.IFF $TTCFG ; 
.SETF FIND01
.IFDF XYH .DATA #3 ;	YH- DH11 Asynchronous Terminal Interface
.IFDF XYH .IFF $TTCFG ;	YH- DH11 Asynchronous Terminal Interface
.IFDF XYH .SETT FIND01
.IFDF XYJ .DATA #3 ;	YJ- DJ11 Asynchronous Terminal Interface
.IFDF XYJ .IFF $TTCFG ;	YJ- DJ11 Asynchronous Terminal Interface
.IFDF XYJ .SETT FIND01
.IFDF XYL .DATA #3 ;	YL- DL11-A/-B/-C/-D/-E/-J/-W Asynchronous Terminal Interface
.IFDF XYL .IFF $TTCFG ;	YL- DL11-A/-B/-C/-D/-E/-J/-W Asynchronous Terminal Interface
.IFDF XYL .SETT FIND01
.IFDF XYZ .DATA #3 ;	YZ- DZ11 Asynchronous Terminal Interface
.IFDF XYZ .IFF $TTCFG ;	YZ- DZ11 Asynchronous Terminal Interface
.IFDF XYZ .SETT FIND01
.IFF FIND01 .DATA #3 ;	*** none specified ***
.IFF FIND01 .IFF $TTCFG ;	*** none specified ***
.DATA #3 ; 
.IFF $TTCFG ; 
.DATA #3 ;    Pseudo devices supported:
.IFF $TTCFG ;    Pseudo devices supported:
.DATA #3 ; 
.IFF $TTCFG ; 
.SETF FIND01
.IFDF XCO .DATA #3 ;	CO- console device
.IFDF XCO .IFF $TTCFG ;	CO- console device
.IFDF XCO .SETT FIND01
.IFDF XNL .DATA #3 ;	NL- null device
.IFDF XNL .IFF $TTCFG ;	NL- null device
.IFDF XNL .SETT FIND01
.IFF FIND01 .DATA #3 ;	*** none specified ***
.IFF FIND01 .IFF $TTCFG ;	*** none specified ***
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;==============================================================================
.IFF $TTCFG ;==============================================================================
.DATA #3 ;
.IFF $TTCFG ;
.;
.;PRINT OUT TARGET SEMI-CONFIGURATION
.;
.SETS TEMPS "M"
.SETS TEMPS2 "M"
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; Processor:'$TPR'   Memory Size:'$TME'K,'TEMPS'apped   System:RSX-11'TEMPS2'
.IFF $TTCFG ; Processor:'$TPR'   Memory Size:'$TME'K,'TEMPS'apped   System:RSX-11'TEMPS2'
.DATA #3 ;
.IFF $TTCFG ;
.IFT $SWR .DATA #3 ;           Switch Register
.IFT $SWR .IFF $TTCFG ;           Switch Register
.IFT $EAE .DATA #3 ;           Extended Arithmetic Element
.IFT $EAE .IFF $TTCFG ;           Extended Arithmetic Element
.IFT $FPP .DATA #3 ;           Floating Point Processor
.IFT $FPP .IFF $TTCFG ;           Floating Point Processor
.IFT $FIS .DATA #3 ;           Floating Instruction Set
.IFT $FIS .IFF $TTCFG ;           Floating Instruction Set
.IFT $EIS .DATA #3 ;           Extended Instruction Set
.IFT $EIS .IFF $TTCFG ;           Extended Instruction Set
.IFT $MPR .DATA #3 ;           Parity Memory
.IFT $MPR .IFF $TTCFG ;           Parity Memory
.IFT $CAH .DATA #3 ;           Cache Memory
.IFT $CAH .IFF $TTCFG ;           Cache Memory
.IFT $WAT .DATA #3 ;           Watchdog Timer
.IFT $WAT .IFF $TTCFG ;           Watchdog Timer
.IF $PRO NE 0. .DATA #3 ;           Programmable System Clock
.IF $PRO NE 0. .IFF $TTCFG ;           Programmable System Clock
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; Host configuration
.IFF $TTCFG ; Host configuration
.DATA #3 ;
.IFF $TTCFG ;
.;
.;LINE PRINTER AVAILABLE
.;
.IFT $LPR  .DATA #3 ;  1. [$LPR] A line printer was available for last SYSGEN
.IFT $LPR  .IFF $TTCFG ;  1. [$LPR] A line printer was available for last SYSGEN
.IFF $LPR  .DATA #3 ;  1. [$LPR] A line printer was **NOT** available for last SYSGEN
.IFF $LPR  .IFF $TTCFG ;  1. [$LPR] A line printer was **NOT** available for last SYSGEN
.;
.;CHECK IF SPOOLING DESIRED
.;
.IFNDF $SPL .SETS $SPL "/-SP"
.SETT SPO
.IF $SPL EQ "/-SP" .SETF SPO
.IFT SPO  .DATA #3 ;  2. [$SPL] Assembly listings and Executive and driver maps are to 
.IFT SPO  .IFF $TTCFG ;  2. [$SPL] Assembly listings and Executive and driver maps are to 
.IFT SPO  .DATA #3 ;            be spooled
.IFT SPO  .IFF $TTCFG ;            be spooled
.IFF SPO  .DATA #3 ;  2. [$SPL] Assembly listings and Executive and driver maps are 
.IFF SPO  .IFF $TTCFG ;  2. [$SPL] Assembly listings and Executive and driver maps are 
.IFF SPO  .DATA #3 ;            **NOT** to be spooled
.IFF SPO  .IFF $TTCFG ;            **NOT** to be spooled
.;
.;LISTING DEVICE WIDTH
.;
.IFNDF $PWI .SETF $PWI
.IFT $PWI  .DATA #3 ;  3. [$PWI] The listing/map device is assumed to have at least 120 columns
.IFT $PWI  .IFF $TTCFG ;  3. [$PWI] The listing/map device is assumed to have at least 120 columns
.IFF $PWI  .DATA #3 ;  3. [$PWI] The listing/map device is assumed to have less than 120 columns
.IFF $PWI  .IFF $TTCFG ;  3. [$PWI] The listing/map device is assumed to have less than 120 columns
.;
.;ASSEMBLY LISTING DEVICE
.;
.IFNDF $ALD .SETS $ALD "NL:"
.DATA #3 ;  4. [$ALD] Assembly listings device was -- '$ALD'
.IFF $TTCFG ;  4. [$ALD] Assembly listings device was -- '$ALD'
.;
.;MAP DEVICE FOR UTILITIES & DEVICE DRIVERS
.;
.IFNDF $MPD .SETS $MPD "SY:"
.DATA #3 ;  5. [$MPD] Map device for Executive and device drivers was -- '$MPD'
.IFF $TTCFG ;  5. [$MPD] Map device for Executive and device drivers was -- '$MPD'
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; Executive Options
.IFF $TTCFG ; Executive Options
.DATA #3 ;
.IFF $TTCFG ;
.;
.;DBMS-11 EXEC OPTIONS
.;
.IFNDF $DBM .SETF $DBM  
.IFT $DBM  .DATA #3 ;  1. [$DBM] DBMS-11 support included
.IFT $DBM  .IFF $TTCFG ;  1. [$DBM] DBMS-11 support included
.IFF $DBM  .DATA #3 ;  1. [$DBM] DBMS-11 support **NOT** included
.IFF $DBM  .IFF $TTCFG ;  1. [$DBM] DBMS-11 support **NOT** included
.;
.;FILES-11 ACP
.;
.IFNDF $F11  .SETF $F11  
.IFT $F11  .DATA #3 ;  2. [$F11] FILES-11 ACP support included
.IFT $F11  .IFF $TTCFG ;  2. [$F11] FILES-11 ACP support included
.IFF $F11  .DATA #3 ;  2. [$F11] FILES-11 ACP support **NOT** included
.IFF $F11  .IFF $TTCFG ;  2. [$F11] FILES-11 ACP support **NOT** included
.;
.;RMS BUCKET LOCKING
.;
.IFNDF $RMS  .SETF $RMS  
.IFT $RMS  .DATA #3 ;  3. [$RMS] RMS bucket locking and placement control support included
.IFT $RMS  .IFF $TTCFG ;  3. [$RMS] RMS bucket locking and placement control support included
.IFF $RMS  .DATA #3 ;  3. [$RMS] RMS bucket locking and placement control support **NOT** included
.IFF $RMS  .IFF $TTCFG ;  3. [$RMS] RMS bucket locking and placement control support **NOT** included
.;
.;NON-RESIDENT TASK
.;
.IFNDF $NRT  .SETF $NRT  
.IFT $NRT  .DATA #3 ;  4. [$NRT] Non-resident tasks (task loader) supported
.IFT $NRT  .IFF $TTCFG ;  4. [$NRT] Non-resident tasks (task loader) supported
.IFF $NRT  .DATA #3 ;  4. [$NRT] Non-resident tasks (task loader) **NOT** supported
.IFF $NRT  .IFF $TTCFG ;  4. [$NRT] Non-resident tasks (task loader) **NOT** supported
.;
.;LOADABLE LOADER
.;
.IFNDF $LLR  .SETF $LLR  
.IFT $NRT .IFT $LLR  .DATA #3 ;  5. [$LLR] Loadable task loader
.IFT $NRT .IFT $LLR  .IFF $TTCFG ;  5. [$LLR] Loadable task loader
.IFT $NRT .IFF $LLR  .DATA #3 ;  5. [$LLR] Resident task loader
.IFT $NRT .IFF $LLR  .IFF $TTCFG ;  5. [$LLR] Resident task loader
.IFF $NRT .DATA #3 ;  5. [$LLR] *** Not applicable ***
.IFF $NRT .IFF $TTCFG ;  5. [$LLR] *** Not applicable ***
.;
.;EXEC COMMON SUPPORT
.;
.IFNDF $DRC  .SETF $DRC  
.IFT $DRC  .DATA #3 ;  6. [$DRC] Executive Common support included
.IFT $DRC  .IFF $TTCFG ;  6. [$DRC] Executive Common support included
.IFF $DRC  .DATA #3 ;  6. [$DRC] Executive Common support **NOT** included
.IFF $DRC  .IFF $TTCFG ;  6. [$DRC] Executive Common support **NOT** included
.;
.;MEMORY MANAGEMENT DIRECTIVES
.;
.IFNDF $MMD  .SETF $MMD  
.IFT $MMD  .DATA #3 ;  7. [$MMD] Memory management (PLAS) directives support included
.IFT $MMD  .IFF $TTCFG ;  7. [$MMD] Memory management (PLAS) directives support included
.IFF $MMD  .DATA #3 ;  7. [$MMD] Memory management (PLAS) directives support **NOT** included
.IFF $MMD  .IFF $TTCFG ;  7. [$MMD] Memory management (PLAS) directives support **NOT** included
.;
.;SEND/RECEIVE BY REFERENCE
.;
.IFNDF $SRR  .SETF $SRR  
.IFT $SRR  .DATA #3 ;  8. [$SRR] Send/Receive by reference directives support included
.IFT $SRR  .IFF $TTCFG ;  8. [$SRR] Send/Receive by reference directives support included
.IFF $SRR  .DATA #3 ;  8. [$SRR] Send/Receive by reference directives support **NOT** included
.IFF $SRR  .IFF $TTCFG ;  8. [$SRR] Send/Receive by reference directives support **NOT** included
.;
.;GET MAPPING CONTEXT
.;
.IFNDF $GMC  .SETF $GMC  
.IFT $GMC  .DATA #3 ;  9. [$GMC] Get mapping context directive support included
.IFT $GMC  .IFF $TTCFG ;  9. [$GMC] Get mapping context directive support included
.IFF $GMC  .DATA #3 ;  9. [$GMC] Get mapping context directive support **NOT** included
.IFF $GMC  .IFF $TTCFG ;  9. [$GMC] Get mapping context directive support **NOT** included
.;
.;ADDRESS CHECKING
.;
.IFNDF $ACK .SETF $ACK 
.IFT $ACK .DATA #3 ; 10. [$ACK] Address checking support included
.IFT $ACK .IFF $TTCFG ; 10. [$ACK] Address checking support included
.IFF $ACK .DATA #3 ; 10. [$ACK] Address checking support **NOT** included
.IFF $ACK .IFF $TTCFG ; 10. [$ACK] Address checking support **NOT** included
.;
.;I/O RUNDOWN
.;
.IFNDF $IOR .SETF $IOR 
.IFT $IOR .DATA #3 ; 11. [$IOR] I/O rundown support included
.IFT $IOR .IFF $TTCFG ; 11. [$IOR] I/O rundown support included
.IFF $IOR .DATA #3 ; 11. [$IOR] I/O rundown support **NOT** included
.IFF $IOR .IFF $TTCFG ; 11. [$IOR] I/O rundown support **NOT** included
.;
.;Multi-user protection
.;
.IFNDF $MUP .SETF $MUP 
.IFT $MUP .DATA #3 ; 12. [$MUP] Multi-user protection support included
.IFT $MUP .IFF $TTCFG ; 12. [$MUP] Multi-user protection support included
.IFF $MUP .DATA #3 ; 12. [$MUP] Multi-user protection support **NOT** included
.IFF $MUP .IFF $TTCFG ; 12. [$MUP] Multi-user protection support **NOT** included
.;
.;ANSI MAGTAPE
.;
.IFNDF $ANM .SETF $ANM 
.IFT $ANM .DATA #3 ; 13. [$ANM] ANSI Magtape ACP support included
.IFT $ANM .IFF $TTCFG ; 13. [$ANM] ANSI Magtape ACP support included
.IFF $ANM .DATA #3 ; 13. [$ANM] ANSI Magtape ACP support **NOT** included
.IFF $ANM .IFF $TTCFG ; 13. [$ANM] ANSI Magtape ACP support **NOT** included
.;
.;FMT
.;
.IFNDF $OUD .SETF $OUD 
.IFT $OUD .DATA #3 ; 14. [$OUD] On-line formatting (FMT) and diagnostic QIOs supported
.IFT $OUD .IFF $TTCFG ; 14. [$OUD] On-line formatting (FMT) and diagnostic QIOs supported
.IFF $OUD .DATA #3 ; 14. [$OUD] On-line formatting (FMT) and diagnostic QIOs **NOT** supported
.IFF $OUD .IFF $TTCFG ; 14. [$OUD] On-line formatting (FMT) and diagnostic QIOs **NOT** supported
.;
.;LOADABLE DRIVERS
.;
.IFNDF $LOD .SETF $LOD 
.IFT $LOD .DATA #3 ; 15. [$LOD] Loadable device drivers support included
.IFT $LOD .IFF $TTCFG ; 15. [$LOD] Loadable device drivers support included
.IFF $LOD .DATA #3 ; 15. [$LOD] Loadable device drivers support **NOT** included
.IFF $LOD .IFF $TTCFG ; 15. [$LOD] Loadable device drivers support **NOT** included
.IFNDF $LLD .SETF $LLD 
.IFT $LOD .IFT $LLD .DATA #3 ; 16. [$LLD] All applicable drivers will default to loadable
.IFT $LOD .IFT $LLD .IFF $TTCFG ; 16. [$LLD] All applicable drivers will default to loadable
.IFT $LOD .IFF $LLD .DATA #3 ; 16. [$LLD] All applicable drivers will default to resident
.IFT $LOD .IFF $LLD .IFF $TTCFG ; 16. [$LLD] All applicable drivers will default to resident
.IFF $LOD .DATA #3 ; 16. [$LOD] *** Not applicable ***
.IFF $LOD .IFF $TTCFG ; 16. [$LOD] *** Not applicable ***
.;
.;AST
.;
.IFNDF $AST .SETF $AST 
.IFT $AST .DATA #3 ; 17. [$AST] Asynchronous System Traps (AST) support included
.IFT $AST .IFF $TTCFG ; 17. [$AST] Asynchronous System Traps (AST) support included
.IFF $AST .DATA #3 ; 17. [$AST] Asynchronous System Traps (AST) support **NOT** included
.IFF $AST .IFF $TTCFG ; 17. [$AST] Asynchronous System Traps (AST) support **NOT** included
.;
.;CANCEL SELECTIVE MARKTIME
.;
.IFNDF $CSM .SETF $CSM 
.IFT $CSM .DATA #3 ; 18. [$CSM] Cancel Selective Marktime support included
.IFT $CSM .IFF $TTCFG ; 18. [$CSM] Cancel Selective Marktime support included
.IFF $CSM .DATA #3 ; 18. [$CSM] Cancel Selective Marktime support **NOT** included
.IFF $CSM .IFF $TTCFG ; 18. [$CSM] Cancel Selective Marktime support **NOT** included
.;
.;TASK TERMINATION MESSAGES
.;
.IFNDF $TKT .SETF $TKT 
.IFT $TKT .DATA #3 ; 19. [$TKT] Task termination and device not ready messages (TKTN) 
.IFT $TKT .IFF $TTCFG ; 19. [$TKT] Task termination and device not ready messages (TKTN) 
.IFT $TKT .DATA #3 ;            support included
.IFT $TKT .IFF $TTCFG ;            support included
.IFF $TKT .DATA #3 ; 19. [$TKT] Task termination and device not ready messages (TKTN) 
.IFF $TKT .IFF $TTCFG ; 19. [$TKT] Task termination and device not ready messages (TKTN) 
.IFF $TKT .DATA #3 ;            support **NOT** included
.IFF $TKT .IFF $TTCFG ;            support **NOT** included
.;
.;POWER FAIL RECOVERY
.;
.IFNDF $PRF .SETF $PRF 
.IFT $PRF .DATA #3 ; 20. [$PRF] Power fail recovery support included
.IFT $PRF .IFF $TTCFG ; 20. [$PRF] Power fail recovery support included
.IFF $PRF .DATA #3 ; 20. [$PRF] Power fail recovery support **NOT** included
.IFF $PRF .IFF $TTCFG ; 20. [$PRF] Power fail recovery support **NOT** included
.;
.;INS REQ REM ON EXIT
.;
.IFNDF $IRR .SETF $IRR 
.IFT $IRR .DATA #3 ; 21. [$IRR] Install, request, and remove on exit support included
.IFT $IRR .IFF $TTCFG ; 21. [$IRR] Install, request, and remove on exit support included
.IFF $IRR .DATA #3 ; 21. [$IRR] Install, request, and remove on exit support **NOT** included
.IFF $IRR .IFF $TTCFG ; 21. [$IRR] Install, request, and remove on exit support **NOT** included
.;
.;20K EXEC
.;
.IFNDF $20K .SETF $20K 
.IFT $20K .DATA #3 ; 22. [$20K] Large (20K) Executive support included
.IFT $20K .IFF $TTCFG ; 22. [$20K] Large (20K) Executive support included
.IFF $20K .DATA #3 ; 22. [$20K] Large (20K) Executive support **NOT** included
.IFF $20K .IFF $TTCFG ; 22. [$20K] Large (20K) Executive support **NOT** included
.;
.;LOGICAL DEVICE ASSIGNMENT
.;
.IFNDF $LGD .SETF $LGD 
.IFT $LGD .DATA #3 ; 23. [$LGD] Logical device assignment support included
.IFT $LGD .IFF $TTCFG ; 23. [$LGD] Logical device assignment support included
.IFF $LGD .DATA #3 ; 23. [$LGD] Logical device assignment support **NOT** included
.IFF $LGD .IFF $TTCFG ; 23. [$LGD] Logical device assignment support **NOT** included
.;
.;ERROR LOG
.;
.IFNDF $ERL .SETF $ERL 
.IFT $ERL .DATA #3 ; 24. [$ERL] Error logging support included
.IFT $ERL .IFF $TTCFG ; 24. [$ERL] Error logging support included
.IFF $ERL .DATA #3 ; 24. [$ERL] Error logging support **NOT** included
.IFF $ERL .IFF $TTCFG ; 24. [$ERL] Error logging support **NOT** included
.;
.;ERROR LOG OF CONCURRENT I/O
.;
.IFNDF $ELC .SETF $ELC 
.IFT $ERL .IFT $ELC .DATA #3 ; 24A.[$ELC] Logging of concurrent I/O activity support included
.IFT $ERL .IFT $ELC .IFF $TTCFG ; 24A.[$ELC] Logging of concurrent I/O activity support included
.IFT $ERL .IFF $ELC .DATA #3 ; 24A.[$ELC] Logging of concurrent I/O activity support **NOT** included
.IFT $ERL .IFF $ELC .IFF $TTCFG ; 24A.[$ELC] Logging of concurrent I/O activity support **NOT** included
.IFF $ERL .DATA #3 ; 24A.[$ELC] Logging of concurrent I/O activity support *** Not applicable ***
.IFF $ERL .IFF $TTCFG ; 24A.[$ELC] Logging of concurrent I/O activity support *** Not applicable ***
.;
.;USER WRITTEN DRIVER
.;
.IFNDF $UWD .SETF $UWD 
.IFT $UWD .DATA #3 ; 25. [$UWD] A user-written driver is to be included
.IFT $UWD .IFF $TTCFG ; 25. [$UWD] A user-written driver is to be included
.IFF $UWD .DATA #3 ; 25. [$UWD] A user-written driver is **NOT** to be included
.IFF $UWD .IFF $TTCFG ; 25. [$UWD] A user-written driver is **NOT** to be included
.;
.;$GTWRD
.;
.IFNDF $GTW .SETF $GTW 
.IFT $GTW .DATA #3 ; 26. [$GTW] The routine $GTWRD will be included
.IFT $GTW .IFF $TTCFG ; 26. [$GTW] The routine $GTWRD will be included
.IFF $GTW .DATA #3 ; 26. [$GTW] The routine $GTWRD will **NOT** be included
.IFF $GTW .IFF $TTCFG ; 26. [$GTW] The routine $GTWRD will **NOT** be included
.;
.;$PTWRD
.;
.IFNDF $PTW .SETF $PTW 
.IFT $PTW .DATA #3 ; 27. [$PTW] The routine $PTWRD will be included
.IFT $PTW .IFF $TTCFG ; 27. [$PTW] The routine $PTWRD will be included
.IFF $PTW .DATA #3 ; 27. [$PTW] The routine $PTWRD will **NOT** be included
.IFF $PTW .IFF $TTCFG ; 27. [$PTW] The routine $PTWRD will **NOT** be included
.;
.;WRITECHECK SUPPORT
.;
.IFNDF $WCH .SETF $WCH 
.IFT $WCH .DATA #3 ; 28. [$WCH] Disk writecheck support included
.IFT $WCH .IFF $TTCFG ; 28. [$WCH] Disk writecheck support included
.IFF $WCH .DATA #3 ; 28. [$WCH] Disk writecheck support **NOT** included
.IFF $WCH .IFF $TTCFG ; 28. [$WCH] Disk writecheck support **NOT** included
.;
.;SOFTWARE WRITE-LOCK
.;
.IFNDF $SWL .SETF $SWL 
.IFT $SWL .DATA #3 ; 29. [$SWL] Software write-lock support included
.IFT $SWL .IFF $TTCFG ; 29. [$SWL] Software write-lock support included
.IFF $SWL .DATA #3 ; 29. [$SWL] Software write-lock support **NOT** included
.IFF $SWL .IFF $TTCFG ; 29. [$SWL] Software write-lock support **NOT** included
.;
.;XDT
.;
.IFNDF $XDT .SETF $XDT 
.IFT $XDT .DATA #3 ; 30. [$XDT] Executive Debugging Tool (XDT) support included
.IFT $XDT .IFF $TTCFG ; 30. [$XDT] Executive Debugging Tool (XDT) support included
.IFF $XDT .DATA #3 ; 30. [$XDT] Executive Debugging Tool (XDT) support **NOT** included
.IFF $XDT .IFF $TTCFG ; 30. [$XDT] Executive Debugging Tool (XDT) support **NOT** included
.;
.;ROTATING PATTERN IN LIGHTS
.;
.IFNDF $ROT .SETF $ROT 
.IFT $ROT .DATA #3 ; 31. [$ROT] Rotating pattern in data lights support included
.IFT $ROT .IFF $TTCFG ; 31. [$ROT] Rotating pattern in data lights support included
.IFF $ROT .DATA #3 ; 31. [$ROT] Rotating pattern in data lights support **NOT** included
.IFF $ROT .IFF $TTCFG ; 31. [$ROT] Rotating pattern in data lights support **NOT** included
.;
.;DECNET
.;
.IFNDF $NET .SETF $NET 
.IFT $NET .DATA #3 ; 32. [$NET] Communications products support included
.IFT $NET .IFF $TTCFG ; 32. [$NET] Communications products support included
.IFF $NET .DATA #3 ; 32. [$NET] Communications products support **NOT** included
.IFF $NET .IFF $TTCFG ; 32. [$NET] Communications products support **NOT** included
.;
.;RT EMULATOR
.;
.IFNDF $RTE .SETF $RTE 
.IFT $RTE .DATA #3 ; 32A.[$RTE] RT-11 emulation support included
.IFT $RTE .IFF $TTCFG ; 32A.[$RTE] RT-11 emulation support included
.IFF $RTE .DATA #3 ; 32A.[$RTE] RT-11 emulation support **NOT** included
.IFF $RTE .IFF $TTCFG ; 32A.[$RTE] RT-11 emulation support **NOT** included
.;
.; SYSTEM CONTROLLED PARTITIONS
.;
.IFNDF $DMA .SETF $DMA 
.IFT $DMA .DATA #3 ; 33. [$DMA] System controlled partitions support included
.IFT $DMA .IFF $TTCFG ; 33. [$DMA] System controlled partitions support included
.IFF $DMA .DATA #3 ; 33. [$DMA] System controlled partitions support **NOT** included
.IFF $DMA .IFF $TTCFG ; 33. [$DMA] System controlled partitions support **NOT** included
.;
.; AUTO MEMORY COMPACTION (SHF)
.;
.IFNDF $AMC .SETF $AMC 
.IFT $AMC .DATA #3 ; 34. [$AMC] Shuffler support included
.IFT $AMC .IFF $TTCFG ; 34. [$AMC] Shuffler support included
.IFF $AMC .DATA #3 ; 34. [$AMC] Shuffler support **NOT** included
.IFF $AMC .IFF $TTCFG ; 34. [$AMC] Shuffler support **NOT** included
.;
.;PRINT SPOOLER/QUEUE MANAGER
.;
.IFNDF $PRN .SETF $PRN 
.IFT $PRN .DATA #3 ; 35. [$PRN] Queue manager and queued print spooler support included
.IFT $PRN .IFF $TTCFG ; 35. [$PRN] Queue manager and queued print spooler support included
.IFF $PRN .DATA #3 ; 35. [$PRN] Queue manager and queued print spooler support **NOT** included
.IFF $PRN .IFF $TTCFG ; 35. [$PRN] Queue manager and queued print spooler support **NOT** included
.;
.; GROUP GLOBAL EVENT FLAGS
.;
.IFNDF $GGE .SETF $GGE 
.IFT $GGE .DATA #3 ; 36. [$GGE] Group global event flags support included
.IFT $GGE .IFF $TTCFG ; 36. [$GGE] Group global event flags support included
.IFF $GGE .DATA #3 ; 36. [$GGE] Group global event flags support **NOT** included
.IFF $GGE .IFF $TTCFG ; 36. [$GGE] Group global event flags support **NOT** included
.;
.;DIRECTIVES DESIRED
.;
.DATA #3 ;==============================================================================
.IFF $TTCFG ;==============================================================================
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;  Directive options:
.IFF $TTCFG ;  Directive options:
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;     A- Get partition parameters   B- Get task parameters
.IFF $TTCFG ;     A- Get partition parameters   B- Get task parameters
.DATA #3 ;     C- Send/Receive               D- Alter priority
.IFF $TTCFG ;     C- Send/Receive               D- Alter priority
.DATA #3 ;     E- Extend task                F- Connect to interrupt vector
.IFF $TTCFG ;     E- Extend task                F- Connect to interrupt vector
.DATA #3 ;     G- Get sense switch           H- Set system time
.IFF $TTCFG ;     G- Get sense switch           H- Set system time
.DATA #3 ;     I- Stop bit		     J- Specify requested exit AST
.IFF $TTCFG ;     I- Stop bit		     J- Specify requested exit AST
.DATA #3 ;     K- Parent offspring tasking   L- Parent offspring tasking with chaining
.IFF $TTCFG ;     K- Parent offspring tasking   L- Parent offspring tasking with chaining
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;     Responses entered as code1code2code3... (no commas) (e.g.: ABCDF.)
.IFF $TTCFG ;     Responses entered as code1code2code3... (no commas) (e.g.: ABCDF.)
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; 37. [$DRR] Enter code for system directives -- '$DRR'
.IFF $TTCFG ; 37. [$DRR] Enter code for system directives -- '$DRR'
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;  The following options are in effect:
.IFF $TTCFG ;  The following options are in effect:
.DATA #3 ;
.IFF $TTCFG ;
.TEST $DRR "A"
.IF <STRLEN> NE 0 .DATA #3 ;     A- Get partition parameters selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     A- Get partition parameters selected
.IF <STRLEN> EQ 0 .DATA #3 ;     A- Get partition parameters **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     A- Get partition parameters **NOT** selected
.TEST $DRR "B"
.IF <STRLEN> NE 0 .DATA #3 ;     B- Get task parameters selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     B- Get task parameters selected
.IF <STRLEN> EQ 0 .DATA #3 ;     B- Get task parameters **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     B- Get task parameters **NOT** selected
.TEST $DRR "C"
.IF <STRLEN> NE 0 .DATA #3 ;     C- Send/Receive selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     C- Send/Receive selected
.IF <STRLEN> EQ 0 .DATA #3 ;     C- Send/Receive **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     C- Send/Receive **NOT** selected
.TEST $DRR "D"
.IF <STRLEN> NE 0 .DATA #3 ;     D- Alter priority selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     D- Alter priority selected
.IF <STRLEN> EQ 0 .DATA #3 ;     D- Alter priority **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     D- Alter priority **NOT** selected
.TEST $DRR "E"
.IF <STRLEN> NE 0 .DATA #3 ;     E- Extend task selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     E- Extend task selected
.IF <STRLEN> EQ 0 .DATA #3 ;     E- Extend task **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     E- Extend task **NOT** selected
.TEST $DRR "F"
.IF <STRLEN> NE 0 .DATA #3 ;     F- Connect to interrupt vector selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     F- Connect to interrupt vector selected
.IF <STRLEN> EQ 0 .DATA #3 ;     F- Connect to interrupt vector **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     F- Connect to interrupt vector **NOT** selected
.TEST $DRR "G"
.IF <STRLEN> NE 0 .DATA #3 ;     G- Get sense switch selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     G- Get sense switch selected
.IF <STRLEN> EQ 0 .DATA #3 ;     G- Get sense switch **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     G- Get sense switch **NOT** selected
.TEST $DRR "H"
.IF <STRLEN> NE 0 .DATA #3 ;     H- Set system time selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     H- Set system time selected
.IF <STRLEN> EQ 0 .DATA #3 ;     H- Set system time **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     H- Set system time **NOT** selected
.TEST $DRR "I"
.IF <STRLEN> NE 0 .DATA #3 ;     I- Stop bit selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     I- Stop bit selected
.IF <STRLEN> EQ 0 .DATA #3 ;     I- Stop bit **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     I- Stop bit **NOT** selected
.TEST $DRR "J"
.IF <STRLEN> NE 0 .DATA #3 ;     J- Specify requested exit AST selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     J- Specify requested exit AST selected
.IF <STRLEN> EQ 0 .DATA #3 ;     J- Specify requested exit AST **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     J- Specify requested exit AST **NOT** selected
.TEST $DRR "K"
.IF <STRLEN> NE 0 .DATA #3 ;     K- Parent offspring tasking selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     K- Parent offspring tasking selected
.IF <STRLEN> EQ 0 .DATA #3 ;     K- Parent offspring tasking **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     K- Parent offspring tasking **NOT** selected
.TEST $DRR "L"
.IF <STRLEN> NE 0 .DATA #3 ;     L- Parent offspring tasking with chaining selected
.IF <STRLEN> NE 0 .IFF $TTCFG ;     L- Parent offspring tasking with chaining selected
.IF <STRLEN> EQ 0 .DATA #3 ;     L- Parent offspring tasking with chaining **NOT** selected
.IF <STRLEN> EQ 0 .IFF $TTCFG ;     L- Parent offspring tasking with chaining **NOT** selected
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;==============================================================================
.IFF $TTCFG ;==============================================================================
.DATA #3 ;
.IFF $TTCFG ;
.;
.;PREALLOCATED QIO PACKETS
.;
.IFNDF $NPK .SETN $NPK 5
.IF $NPK GT 0 .DATA #3 ; 38. [$NPK] Number of pre-allocated QIO packets -- '$NPK'
.IF $NPK GT 0 .IFF $TTCFG ; 38. [$NPK] Number of pre-allocated QIO packets -- '$NPK'
.IF $NPK EQ 0 .DATA #3 ; 38. [$NPK] Pre-allocated QIO packets **NOT** supported -- $NPK=0
.IF $NPK EQ 0 .IFF $TTCFG ; 38. [$NPK] Pre-allocated QIO packets **NOT** supported -- $NPK=0
.;
.;DATA T.V. SIZE
.;
.IFNDF $DTV .SETN $DTV 33.
.DATA #3 ; 39. [$DTV] Size of data transfer vector in words -- '$DTV'
.IFF $TTCFG ; 39. [$DTV] Size of data transfer vector in words -- '$DTV'
.IF $DTV NE 0 .IF $DTV LT 5 .DATA #3 ;     Data transfer vector size will be forced to 5
.IF $DTV NE 0 .IF $DTV LT 5 .IFF $TTCFG ;     Data transfer vector size will be forced to 5
.;
.;ROUND ROBIN SCHED INTERVAL
.;
.IFNDF $RRS .SETN $RRS 5
.IF $RRS NE 0 .DATA #3 ; 40. [$RRS] Round-robin scheduling interval in ticks -- '$RRS'
.IF $RRS NE 0 .IFF $TTCFG ; 40. [$RRS] Round-robin scheduling interval in ticks -- '$RRS'
.IF $RRS EQ 0 .DATA #3 ; 40. [$RRS] Round-robin scheduling **NOT** supported -- $RRS=0
.IF $RRS EQ 0 .IFF $TTCFG ; 40. [$RRS] Round-robin scheduling **NOT** supported -- $RRS=0
.SETF $RND
.IF $RRS NE 0 .SETT $RND
.;
.;HIGHEST PRIORITY CLASS
.;
.IFNDF $HIC .SETN $HIC 150.
.IFT $RND .DATA #3 ; 41. [$HIC] Highest priority class for consideration -- '$HIC'
.IFT $RND .IFF $TTCFG ; 41. [$HIC] Highest priority class for consideration -- '$HIC'
.;
.;LOWEST PRIORITY CLASS
.;
.IFNDF $LOC .SETN $LOC 1.
.IFT $RND .DATA #3 ; 42. [$LOC] Lowest priority class for consideration -- '$LOC'
.IFT $RND .IFF $TTCFG ; 42. [$LOC] Lowest priority class for consideration -- '$LOC'
.;
.;DISK SWAPPING INTERVAL
.;
.IF $DKS GT 0 .DATA #3 ; 43. [$DKS] Executive level disk swapping interval -- '$DKS'
.IF $DKS GT 0 .IFF $TTCFG ; 43. [$DKS] Executive level disk swapping interval -- '$DKS'
.IF $DKS EQ 0 .DATA #3 ; 43. [$DKS] Executive level disk swapping **NOT** supported -- '$DKS'
.IF $DKS EQ 0 .IFF $TTCFG ; 43. [$DKS] Executive level disk swapping **NOT** supported -- '$DKS'
.SETF $DSP
.IF $DKS GT 0 .SETT $DSP
.;
.;SWAPPING PRIORITY
.;
.IFT $DSP .DATA #3 ; 44. [$SWP] Swapping priority -- '$SWP'
.IFT $DSP .IFF $TTCFG ; 44. [$SWP] Swapping priority -- '$SWP'
.;
.;DSR SIZE
.;
.IFNDF $DSA .SETN $DSA 1042.
.DATA #3 ; 45. [$DSA] Size of dynamic storage region (POOL) in words -- '$DSA'
.IFF $TTCFG ; 45. [$DSA] Size of dynamic storage region (POOL) in words -- '$DSA'
.;
.;PRINTER NOT READY MESSAGES
.;
.IFNDF $PNR .SETN $PNR 0.
.IFT $TKT .IFDF XLP .DATA #3 ; 46. [$PNR] Seconds between printer not ready messages -- '$PNR'
.IFT $TKT .IFDF XLP .IFF $TTCFG ; 46. [$PNR] Seconds between printer not ready messages -- '$PNR'
.;
.;CARD READER NOT READY MESSAGES
.;
.IFNDF $CRR .SETN $CRR 0.
.IFT $TKT .IFDF XCR .DATA #3 ; 47. [$CRR] Seconds between card reader not ready messages -- '$CRR'
.IFT $TKT .IFDF XCR .IFF $TTCFG ; 47. [$CRR] Seconds between card reader not ready messages -- '$CRR'
.;
.;REG AND STACK DUMP DEVICE
.;
.IF $RSD GT 0 .DATA #3 ; 48. [$RSD] System crash register and stack dump device CSR -- '$RSD'
.IF $RSD GT 0 .IFF $TTCFG ; 48. [$RSD] System crash register and stack dump device CSR -- '$RSD'
.IF $RSD EQ 0 .DATA #3 ; 48. [$RSD] System crash register and stack dump **NOT** supported -- $RSD=0
.IF $RSD EQ 0 .IFF $TTCFG ; 48. [$RSD] System crash register and stack dump **NOT** supported -- $RSD=0
.;
.;CHECKPOINTING
.;
.IFNDF $CKP .SETS $CKP ""
.IF $CKP NE "" .IF $CKP NE "A" .IF $CKP NE "B" .SETS $CKP ""
.IF $CKP EQ "" .DATA #3 ; 49. [$CKP] Checkpointing: **NOT** supported
.IF $CKP EQ "" .IFF $TTCFG ; 49. [$CKP] Checkpointing: **NOT** supported
.IF $CKP EQ "A" .DATA #3 ; 49. [$CKP] Checkpointing **WITHOUT** system checkpoint file 
.IF $CKP EQ "A" .IFF $TTCFG ; 49. [$CKP] Checkpointing **WITHOUT** system checkpoint file 
.IF $CKP EQ "A" .DATA #3 ;            support will be included -- $CKP=A
.IF $CKP EQ "A" .IFF $TTCFG ;            support will be included -- $CKP=A
.IF $CKP EQ "B" .DATA #3 ; 49. [$CKP] Checkpointing with system checkpoint file 
.IF $CKP EQ "B" .IFF $TTCFG ; 49. [$CKP] Checkpointing with system checkpoint file 
.IF $CKP EQ "B" .DATA #3 ;            support will be included -- $CKP=B
.IF $CKP EQ "B" .IFF $TTCFG ;            support will be included -- $CKP=B
.;
.;DUMP ANALYSIS
.;
.SETF $CSH
.SETF $PAN
.IFNDF $CRA .SETS $CRA ""
.IF $CRA NE "A" .IF $CRA NE "B" .IF $CRA NE "" .SETS $CRA ""
.IF $CRA EQ "" .DATA #3 ; 50. [$CRA] Crash dump support **NOT** included
.IF $CRA EQ "" .IFF $TTCFG ; 50. [$CRA] Crash dump support **NOT** included
.IF $CRA EQ "A" .DATA #3 ; 50. [$CRA] Panic crash dump support included
.IF $CRA EQ "A" .IFF $TTCFG ; 50. [$CRA] Panic crash dump support included
.IF $CRA EQ "B" .DATA #3 ; 50. [$CRA] Crash Dump Analysis (CDA) support included
.IF $CRA EQ "B" .IFF $TTCFG ; 50. [$CRA] Crash Dump Analysis (CDA) support included
.;
.;OUTPUT NOTIFICATION DEVICE
.;
.IFNDF $NOT .SETN $NOT 0
.IF $CRA EQ "B" .DATA #3 ; 51. [$NOT] CDA output notification device CSR -- '$NOT'
.IF $CRA EQ "B" .IFF $TTCFG ; 51. [$NOT] CDA output notification device CSR -- '$NOT'
.;
.;MEMORY DUMP DEVICE
.;
.IFNDF $MDD .SETS $MDD "**NOT SPECIFIED**"
.IF $CRA EQ "B" .DATA #3 ; 52. [$MDD] CDA memory dump device mnemonic -- '$MDD'
.IF $CRA EQ "B" .IFF $TTCFG ; 52. [$MDD] CDA memory dump device mnemonic -- '$MDD'
.;
.;CSR ADDRESS OF DUMP DEVICE
.;
.IFNDF $MDC .SETN $MDC 0
.IF $CRA EQ "B" .IF $MDC GT 0 .DATA #3 ; 53. [$MDC] CDA memory dump device CSR -- '$MDC'
.IF $CRA EQ "B" .IF $MDC GT 0 .IFF $TTCFG ; 53. [$MDC] CDA memory dump device CSR -- '$MDC'
.IF $CRA EQ "B" .IF $MDC EQ 0 .DATA #3 ; 53. [$MDC] CDA memory dump device CSR -- **NOT SPECIFIED***
.IF $CRA EQ "B" .IF $MDC EQ 0 .IFF $TTCFG ; 53. [$MDC] CDA memory dump device CSR -- **NOT SPECIFIED***
.;
.;PANIC DUMP ROUTINE
.;
.IFNDF $PDD .SETN $PDD 0
.IF $CRA EQ "A" .IF $PDD GT 0 .DATA #3 ; 54. [$PDD] PANIC memory dump device CSR -- '$PDD'
.IF $CRA EQ "A" .IF $PDD GT 0 .IFF $TTCFG ; 54. [$PDD] PANIC memory dump device CSR -- '$PDD'
.IF $CRA EQ "A" .IF $PDD EQ 0 .DATA #3 ; 54. [$PDD] PANIC memory dump device CSR -- **NOT SPECIFIED**
.IF $CRA EQ "A" .IF $PDD EQ 0 .IFF $TTCFG ; 54. [$PDD] PANIC memory dump device CSR -- **NOT SPECIFIED**
.;
.;TERMINAL DRIVER
.;
.IFNDF YL .SETN YL 0
.IFNDF YH .SETN YH 0
.IFNDF YZ .SETN YZ 0
.IFNDF YJ .SETN YJ 0
.IF YL EQ 0 .IF YH EQ 0 .IF YZ EQ 0 .IF YJ EQ 0 .GOTO 2001
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; Terminal driver options
.IFF $TTCFG ; Terminal driver options
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;     Terminal drivers:  A- Tailorable half duplex
.IFF $TTCFG ;     Terminal drivers:  A- Tailorable half duplex
.DATA #3 ;                        B- Tailored half duplex (user-oriented)
.IFF $TTCFG ;                        B- Tailored half duplex (user-oriented)
.DATA #3 ;                        C- Full duplex
.IFF $TTCFG ;                        C- Full duplex
.DATA #3 ;                        D- Baseline half duplex
.IFF $TTCFG ;                        D- Baseline half duplex
.DATA #3 ;
.IFF $TTCFG ;
.IFNDF $TTY .SETS $TTY ""
.IF $TTY NE "A" .IF $TTY NE "B" .IF $TTY NE "C" .IF $TTY NE "D" .SETS $TTY ""
.IF $TTY EQ "A" .DATA #3 ;  1. [$TTY] Terminal driver desired -- A- Tailorable half duplex
.IF $TTY EQ "A" .IFF $TTCFG ;  1. [$TTY] Terminal driver desired -- A- Tailorable half duplex
.IF $TTY EQ "B" .DATA #3 ;  1. [$TTY] Terminal driver desired -- B- Tailored half duplex (user-oriented)
.IF $TTY EQ "B" .IFF $TTCFG ;  1. [$TTY] Terminal driver desired -- B- Tailored half duplex (user-oriented)
.IF $TTY EQ "C" .DATA #3 ;  1. [$TTY] Terminal driver desired -- C- Full duplex
.IF $TTY EQ "C" .IFF $TTCFG ;  1. [$TTY] Terminal driver desired -- C- Full duplex
.IF $TTY EQ "D" .DATA #3 ;  1. [$TTY] Terminal driver desired -- D- Baseline half duplex
.IF $TTY EQ "D" .IFF $TTCFG ;  1. [$TTY] Terminal driver desired -- D- Baseline half duplex
.IF $TTY EQ "" .DATA #3 ;  1. [$TTY] Terminal driver desired -- **INVALID OPTION $TTY='$TTY'
.IF $TTY EQ "" .IFF $TTCFG ;  1. [$TTY] Terminal driver desired -- **INVALID OPTION $TTY='$TTY'
.SETF $FUD
.IF $TTY EQ "C" .SETT $FUD
.IFT $FUD .DATA #3 ;
.IFT $FUD .IFF $TTCFG ;
.IFT $FUD .DATA #3 ;  The following features are built into the
.IFT $FUD .IFF $TTCFG ;  The following features are built into the
.IFT $FUD .DATA #3 ;  Full Duplex Terminal driver. Corresponding
.IFT $FUD .IFF $TTCFG ;  Full Duplex Terminal driver. Corresponding
.IFT $FUD .DATA #3 ;  symbols need not be defined in the saved
.IFT $FUD .IFF $TTCFG ;  symbols need not be defined in the saved
.IFT $FUD .DATA #3 ;  answer file:
.IFT $FUD .IFF $TTCFG ;  answer file:
.IFT $FUD .DATA #3 ;
.IFT $FUD .IFF $TTCFG ;
.IFT $FUD  .DATA #3 ;  3. [$FRM] Passing of form feeds directly to terminal supported
.IFT $FUD  .IFF $TTCFG ;  3. [$FRM] Passing of form feeds directly to terminal supported
.IFT $FUD  .DATA #3 ;  4. [$ACR] Automatic carriage return/line feed
.IFT $FUD  .IFF $TTCFG ;  4. [$ACR] Automatic carriage return/line feed
.IFT $FUD  .DATA #3 ;  5. [$TCK] Task checkpointable during terminal input
.IFT $FUD  .IFF $TTCFG ;  5. [$TCK] Task checkpointable during terminal input
.IFT $FUD  .DATA #3 ;  7. [$CNO] Write with CTRL/O cancellation
.IFT $FUD  .IFF $TTCFG ;  7. [$CNO] Write with CTRL/O cancellation
.IFT $FUD .DATA #3 ; 14. [$HSM] Hold screen mode
.IFT $FUD .IFF $TTCFG ; 14. [$HSM] Hold screen mode
.IFT $FUD .DATA #3 ; 15. [$TRW] Transparent read/write
.IFT $FUD .IFF $TTCFG ; 15. [$TRW] Transparent read/write
.IFT $FUD .DATA #3 ; 16. [$SCC] Settable case conversion for input
.IFT $FUD .IFF $TTCFG ; 16. [$SCC] Settable case conversion for input
.IFT $FUD .DATA #3 ; 18. [$RNE] Read with no echo
.IFT $FUD .IFF $TTCFG ; 18. [$RNE] Read with no echo
.IFT $FUD .DATA #3 ; 19. [$RST] Read with special terminator
.IFT $FUD .IFF $TTCFG ; 19. [$RST] Read with special terminator
.IFT $FUD .DATA #3 ; 21. [$THS] Terminal-host synchronization
.IFT $FUD .IFF $TTCFG ; 21. [$THS] Terminal-host synchronization
.IFT $FUD .DATA #3 ; 22. [$TIB] User terminal input buffering
.IFT $FUD .IFF $TTCFG ; 22. [$TIB] User terminal input buffering
.IFT $FUD .DATA #3 ; 23. [$VTB] Variable length terminal input buffering
.IFT $FUD .IFF $TTCFG ; 23. [$VTB] Variable length terminal input buffering
.IFT $FUD .DATA #3 ; 24. [$L30] LA30P support
.IFT $FUD .IFF $TTCFG ; 24. [$L30] LA30P support
.IFT $FUD .DATA #3 ;
.IFT $FUD .IFF $TTCFG ;
.IFT $FUD .DATA #3 ;  Optional features of Full Duplex Terminal driver:
.IFT $FUD .IFF $TTCFG ;  Optional features of Full Duplex Terminal driver:
.IFT $FUD .DATA #3 ;
.IFT $FUD .IFF $TTCFG ;
.IFNDF $TMN .SETN $TMN 0
.IFT $FUD .IF $TMN GT 0 .DATA #3 ;  2. [$TMN] Unsolicited input timeout value in seconds -- '$TMN'
.IFT $FUD .IF $TMN GT 0 .IFF $TTCFG ;  2. [$TMN] Unsolicited input timeout value in seconds -- '$TMN'
.IFT $FUD .IF $TMN EQ 0 .DATA #3 ;  2. [$TMN] Unsolicited input timeout **NOT** supported -- $TMN=0
.IFT $FUD .IF $TMN EQ 0 .IFF $TTCFG ;  2. [$TMN] Unsolicited input timeout **NOT** supported -- $TMN=0
.IFF $FUD .DATA #3 ;  2. [$TMN]  Unsolicited input timeout **NOT** supported
.IFF $FUD .IFF $TTCFG ;  2. [$TMN]  Unsolicited input timeout **NOT** supported
.;
.;PASS FORM FEEDS
.;
.IFNDF $FRM  .SETF $FRM  
.IFF $FUD .IFT $FRM  .DATA #3 ;  3. [$FRM] Passing of form feeds directly to terminal supported
.IFF $FUD .IFT $FRM  .IFF $TTCFG ;  3. [$FRM] Passing of form feeds directly to terminal supported
.IFF $FUD .IFF $FRM  .DATA #3 ;  3. [$FRM] Passing of form feeds directly to terminal **NOT** supported
.IFF $FUD .IFF $FRM  .IFF $TTCFG ;  3. [$FRM] Passing of form feeds directly to terminal **NOT** supported
.;
.;AUTOMATIC CARRIAGE RETURN
.;
.IFNDF $ACR  .SETF $ACR  
.IFF $FUD .IFT $ACR  .DATA #3 ;  4. [$ACR] Automatic carriage return/line feed supported
.IFF $FUD .IFT $ACR  .IFF $TTCFG ;  4. [$ACR] Automatic carriage return/line feed supported
.IFF $FUD .IFF $ACR  .DATA #3 ;  4. [$ACR] Automatic carriage return/line feed **NOT** supported
.IFF $FUD .IFF $ACR  .IFF $TTCFG ;  4. [$ACR] Automatic carriage return/line feed **NOT** supported
.;
.;TASK CHECKPOINTABLE DURING TERMINAL INPUT
.;
.IFNDF $TCK  .SETF $TCK  
.IFF $FUD .IFT $TCK  .DATA #3 ;  5. [$TCK] Task checkpointable during terminal input supported
.IFF $FUD .IFT $TCK  .IFF $TTCFG ;  5. [$TCK] Task checkpointable during terminal input supported
.IFF $FUD .IFF $TCK  .DATA #3 ;  5. [$TCK] Task checkpointable during terminal input **NOT** supported
.IFF $FUD .IFF $TCK  .IFF $TTCFG ;  5. [$TCK] Task checkpointable during terminal input **NOT** supported
.;
.;UNSOLICITED CHARACTER AST
.;
.IFNDF $USC  .SETF $USC  
.IFT $USC  .DATA #3 ;  6. [$USC] Unsolicited input character AST supported
.IFT $USC  .IFF $TTCFG ;  6. [$USC] Unsolicited input character AST supported
.IFF $USC  .DATA #3 ;  6. [$USC] Unsolicited input character AST **NOT** supported
.IFF $USC  .IFF $TTCFG ;  6. [$USC] Unsolicited input character AST **NOT** supported
.;
.;WRITE WITH ^O
.;
.IFNDF $CNO  .SETF $CNO  
.IFF $FUD .IFT $CNO  .DATA #3 ;  7. [$CNO] Write with CTRL/O cancellation supported
.IFF $FUD .IFT $CNO  .IFF $TTCFG ;  7. [$CNO] Write with CTRL/O cancellation supported
.IFF $FUD .IFF $CNO  .DATA #3 ;  7. [$CNO] Write with CTRL/O cancellation **NOT** supported
.IFF $FUD .IFF $CNO  .IFF $TTCFG ;  7. [$CNO] Write with CTRL/O cancellation **NOT** supported
.;
.;BREAKTHROUGH WRITE
.;
.IFNDF $BWS .SETF $BWS
.IFT $BWS  .DATA #3 ;  8. [$BWS] Breakthrough write supported
.IFT $BWS  .IFF $TTCFG ;  8. [$BWS] Breakthrough write supported
.IFF $BWS  .DATA #3 ;  8. [$BWS] Breakthrough write **NOT** supported
.IFF $BWS  .IFF $TTCFG ;  8. [$BWS] Breakthrough write **NOT** supported
.;
.;^R SUPPORT
.;
.IFNDF $CNR  .SETF $CNR  
.IFT $CNR  .DATA #3 ;  9. [$CNR] CTRL/R (retype) supported
.IFT $CNR  .IFF $TTCFG ;  9. [$CNR] CTRL/R (retype) supported
.IFF $CNR  .DATA #3 ;  9. [$CNR] CTRL/R (retype) **NOT** supported
.IFF $CNR  .IFF $TTCFG ;  9. [$CNR] CTRL/R (retype) **NOT** supported
.;
.;ESCAPE SEQUENCE
.;
.IFNDF $ESC .SETF $ESC 
.IFT $ESC .DATA #3 ; 10. [$ESC] Escape sequence handling supported
.IFT $ESC .IFF $TTCFG ; 10. [$ESC] Escape sequence handling supported
.IFF $ESC .DATA #3 ; 10. [$ESC] Escape sequence handling **NOT** supported
.IFF $ESC .IFF $TTCFG ; 10. [$ESC] Escape sequence handling **NOT** supported
.;
.;GET MULTIPLE CHARACTERISTICS
.;
.IFNDF $MLC .SETF $MLC 
.IFT $MLC .DATA #3 ; 11. [$MLC] Get multiple characteristics supported
.IFT $MLC .IFF $TTCFG ; 11. [$MLC] Get multiple characteristics supported
.IFF $MLC .DATA #3 ; 11. [$MLC] Get multiple characteristics **NOT** supported
.IFF $MLC .IFF $TTCFG ; 11. [$MLC] Get multiple characteristics **NOT** supported
.;
.;SET MULTIPLE CHARACTERISTICS
.;
.IFNDF $SMC .SETF $SMC 
.IFT $SMC .DATA #3 ; 12. [$SMC] Set multiple characteristics supported
.IFT $SMC .IFF $TTCFG ; 12. [$SMC] Set multiple characteristics supported
.IFF $SMC .DATA #3 ; 12. [$SMC] Set multiple characteristics **NOT** supported
.IFF $SMC .IFF $TTCFG ; 12. [$SMC] Set multiple characteristics **NOT** supported
.;
.;GET TT SUPPORT
.;
.IFNDF $GTD .SETF $GTD 
.IFT $GTD .DATA #3 ; 13. [$GTD] Get terminal driver options supported
.IFT $GTD .IFF $TTCFG ; 13. [$GTD] Get terminal driver options supported
.IFF $GTD .DATA #3 ; 13. [$GTD] Get terminal driver options **NOT** supported
.IFF $GTD .IFF $TTCFG ; 13. [$GTD] Get terminal driver options **NOT** supported
.;
.;HOLD SCREEN MODE
.;
.IFNDF $HSM .SETF $HSM 
.IFF $FUD .IFT $HSM .DATA #3 ; 14. [$HSM] Hold screen mode supported
.IFF $FUD .IFT $HSM .IFF $TTCFG ; 14. [$HSM] Hold screen mode supported
.IFF $FUD .IFF $HSM .DATA #3 ; 14. [$HSM] Hold screen mode **NOT** supported
.IFF $FUD .IFF $HSM .IFF $TTCFG ; 14. [$HSM] Hold screen mode **NOT** supported
.;
.;TRANSPARENT READ/WRITE
.;
.IFNDF $TRW .SETF $TRW
.IFF $FUD .IFT $TRW .DATA #3 ; 15. [$TRW] Transparent read/write supported
.IFF $FUD .IFT $TRW .IFF $TTCFG ; 15. [$TRW] Transparent read/write supported
.IFF $FUD .IFF $TRW .DATA #3 ; 15. [$TRW] Transparent read/write **NOT** supported
.IFF $FUD .IFF $TRW .IFF $TTCFG ; 15. [$TRW] Transparent read/write **NOT** supported
.;
.;SETTABLE CASE CONVERSION
.;
.IFNDF $SCC .SETF $SCC 
.IFF $FUD .IFT $SCC .DATA #3 ; 16. [$SCC] Settable case conversion for input supported
.IFF $FUD .IFT $SCC .IFF $TTCFG ; 16. [$SCC] Settable case conversion for input supported
.IFF $FUD .IFF $SCC .DATA #3 ; 16. [$SCC] Settable case conversion for input **NOT** supported
.IFF $FUD .IFF $SCC .IFF $TTCFG ; 16. [$SCC] Settable case conversion for input **NOT** supported
.;
.;READ AFTER PROMPT
.;
.IFNDF $RAP .SETF $RAP 
.IFT $RAP .DATA #3 ; 17. [$RAP] Read after prompt supported
.IFT $RAP .IFF $TTCFG ; 17. [$RAP] Read after prompt supported
.IFF $RAP .DATA #3 ; 17. [$RAP] Read after prompt **NOT** supported
.IFF $RAP .IFF $TTCFG ; 17. [$RAP] Read after prompt **NOT** supported
.;
.;READ WITH NO ECHO
.;
.IFNDF $RNE .SETF $RNE 
.IFF $FUD .IFT $RNE .DATA #3 ; 18. [$RNE] Read with no echo supported
.IFF $FUD .IFT $RNE .IFF $TTCFG ; 18. [$RNE] Read with no echo supported
.IFF $FUD .IFF $RNE .DATA #3 ; 18. [$RNE] Read with no echo **NOT** supported
.IFF $FUD .IFF $RNE .IFF $TTCFG ; 18. [$RNE] Read with no echo **NOT** supported
.;
.;READ WITH SPECIAL TERMINATOR
.;
.IFNDF $RST .SETF $RST 
.IFF $FUD .IFT $RST .DATA #3 ; 19. [$RST] Read with special terminator supported
.IFF $FUD .IFT $RST .IFF $TTCFG ; 19. [$RST] Read with special terminator supported
.IFF $FUD .IFF $RST .DATA #3 ; 19. [$RST] Read with special terminator **NOT** supported
.IFF $FUD .IFF $RST .IFF $TTCFG ; 19. [$RST] Read with special terminator **NOT** supported
.;
.;CRT RUBOUT
.;
.IFNDF $RUB .SETF $RUB 
.IFT $RUB .DATA #3 ; 20. [$RUB] CRT rubout supported
.IFT $RUB .IFF $TTCFG ; 20. [$RUB] CRT rubout supported
.IFF $RUB .DATA #3 ; 20. [$RUB] CRT rubout **NOT** supported
.IFF $RUB .IFF $TTCFG ; 20. [$RUB] CRT rubout **NOT** supported
.;
.;TERMINAL/HOST SYNC
.;
.IFNDF $THS .SETF $THS 
.IFF $FUD .IFT $THS .DATA #3 ; 21. [$THS] Terminal-host synchronization supported
.IFF $FUD .IFT $THS .IFF $TTCFG ; 21. [$THS] Terminal-host synchronization supported
.IFF $FUD .IFF $THS .DATA #3 ; 21. [$THS] Terminal-host synchronization **NOT** supported
.IFF $FUD .IFF $THS .IFF $TTCFG ; 21. [$THS] Terminal-host synchronization **NOT** supported
.;
.;TERMINAL INPUT BUFFERING
.;
.IFNDF $TIB .SETF $TIB 
.IFF $FUD .IFT $TIB .DATA #3 ; 22. [$TIB] User terminal input buffering supported
.IFF $FUD .IFT $TIB .IFF $TTCFG ; 22. [$TIB] User terminal input buffering supported
.IFF $FUD .IFF $TIB .DATA #3 ; 22. [$TIB] User terminal input buffering **NOT** supported
.IFF $FUD .IFF $TIB .IFF $TTCFG ; 22. [$TIB] User terminal input buffering **NOT** supported
.;
.;VARIABLE LENGTH INPUT BUFFERING
.;
.IFNDF $VTB .SETF $VTB 
.IFF $FUD .IFT $VTB .DATA #3 ; 23. [$VTB] Variable length terminal input buffering supported
.IFF $FUD .IFT $VTB .IFF $TTCFG ; 23. [$VTB] Variable length terminal input buffering supported
.IFF $FUD .IFF $VTB .DATA #3 ; 23. [$VTB] Variable length terminal input buffering **NOT** supported
.IFF $FUD .IFF $VTB .IFF $TTCFG ; 23. [$VTB] Variable length terminal input buffering **NOT** supported
.;
.;LA30P SUPPORT
.;
.IFNDF $L30 .SETF $L30 
.IFF $FUD .IFT $L30 .DATA #3 ; 24. [$L30] LA30P supported
.IFF $FUD .IFT $L30 .IFF $TTCFG ; 24. [$L30] LA30P supported
.IFF $FUD .IFF $L30 .DATA #3 ; 24. [$L30] LA30P **NOT** supported
.IFF $FUD .IFF $L30 .IFF $TTCFG ; 24. [$L30] LA30P **NOT** supported
.;
.; HARD RECEIVE ERRORS (FULL DUPLEX ONLY)
.;
.IFNDF $HRE .SETF $HRE 
.IFT $FUD .IFT $HRE .DATA #3 ; 25. [$HRE] Hardware unrecoverable input error notification supported
.IFT $FUD .IFT $HRE .IFF $TTCFG ; 25. [$HRE] Hardware unrecoverable input error notification supported
.IFT $FUD .IFF $HRE .DATA #3 ; 25. [$HRE] Hardware unrecoverable input error notification **NOT** supported
.IFT $FUD .IFF $HRE .IFF $TTCFG ; 25. [$HRE] Hardware unrecoverable input error notification **NOT** supported
.IFF $FUD ; 25. [$HRE] Hardware unrecoverable input error notification **NOT** supported
.;
.;DEVICE INDEPENDENT CURSOR POSITIONING
.;
.IFNDF $DIC .SETF $DIC 
.IFT $FUD .IFT $DIC .DATA #3 ; 26. [$DIC] Device independent cursor positioning supported
.IFT $FUD .IFT $DIC .IFF $TTCFG ; 26. [$DIC] Device independent cursor positioning supported
.IFT $FUD .IFF $DIC .DATA #3 ; 26. [$DIC] Device independent cursor positioning **NOT** supported
.IFT $FUD .IFF $DIC .IFF $TTCFG ; 26. [$DIC] Device independent cursor positioning **NOT** supported
.IFF $FUD .DATA #3 ; 26. [$DIC] Device independent cursor positioning **NOT** supported
.IFF $FUD .IFF $TTCFG ; 26. [$DIC] Device independent cursor positioning **NOT** supported
.;
.;ANCILLARY CONTROL DRIVER SUPPORT
.;
.IFNDF $ACD .SETF $ACD 
.IFT $FUD .IFT $ACD .DATA #3 ; 27. [$ACD] Ancillary control driver support included
.IFT $FUD .IFT $ACD .IFF $TTCFG ; 27. [$ACD] Ancillary control driver support included
.IFT $FUD .IFF $ACD .DATA #3 ; 27. [$ACD] Ancillary control driver support **NOT** included
.IFT $FUD .IFF $ACD .IFF $TTCFG ; 27. [$ACD] Ancillary control driver support **NOT** included
.IFF $FUD .DATA #3 ; 27. [$ACD] Ancillary control driver support **NOT** included
.IFF $FUD .IFF $TTCFG ; 27. [$ACD] Ancillary control driver support **NOT** included
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; System Options
.IFF $TTCFG ; System Options
.DATA #3 ;
.IFF $TTCFG ;
.;
.; BIG-BUFFERING
.;
.IFNDF $BBF  .SETF $BBF  
.IFF $ANM .IFT $BBF  .DATA #3 ;  1. [$BBF] ANSLIB.OLB included to support big-buffering
.IFF $ANM .IFT $BBF  .IFF $TTCFG ;  1. [$BBF] ANSLIB.OLB included to support big-buffering
.IFF $ANM .IFF $BBF  .DATA #3 ;  1. [$BBF] ANSLIB.OLB which supports big-buffering **NOT** included
.IFF $ANM .IFF $BBF  .IFF $TTCFG ;  1. [$BBF] ANSLIB.OLB which supports big-buffering **NOT** included
.;
.; INDUSTRIAL/LAB ROUTINES (OF WHICH MOST ARE PURDUE ISA ROUTINES)
.;
.IFNDF IC .SETN IC 0
.IFNDF IS .SETN IS 0
.IFNDF UD .SETN UD 0
.IFNDF IP .SETN IP 0
.IFNDF AR .SETN AR 0
.IFNDF LS .SETN LS 0
.IFNDF LA .SETN LA 0
.IF IC NE 0 .OR .IF IS NE 0 .OR .IF UD NE 0 .GOTO 2520
.IF IP NE 0 .OR .IF AR NE 0 .OR .IF LS NE 0 .GOTO 2520
.IF LA NE 0 .GOTO 2520
.GOTO 2529
.2520:
.IFNDF $ISA  .SETF $ISA  
.IFT $ISA  .DATA #3 ;  2. [$ISA] Library of ISA FORTRAN industrial/lab routines will be built
.IFT $ISA  .IFF $TTCFG ;  2. [$ISA] Library of ISA FORTRAN industrial/lab routines will be built
.IFF $ISA  .DATA #3 ;  2. [$ISA] Library of ISA FORTRAN industrial/lab routines will **NOT** be built
.IFF $ISA  .IFF $TTCFG ;  2. [$ISA] Library of ISA FORTRAN industrial/lab routines will **NOT** be built
.2529:
.;
.; FCS RESIDENT LIBRARY
.;
.IFNDF $FRL  .SETF $FRL  
.IFT $FRL  .DATA #3 ;  3. [$FRL] PLAS resident FCS resident library will be built
.IFT $FRL  .IFF $TTCFG ;  3. [$FRL] PLAS resident FCS resident library will be built
.IFF $FRL  .DATA #3 ;  3. [$FRL] PLAS resident FCS resident library will **NOT** be built
.IFF $FRL  .IFF $TTCFG ;  3. [$FRL] PLAS resident FCS resident library will **NOT** be built
.;
.; FCP
.;
.IFF $F11 .GOTO 2569
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;	The five FCP codes are:
.IFF $TTCFG ;	The five FCP codes are:
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;	A - MINIMUM:		Minimum functionality (2KW)
.IFF $TTCFG ;	A - MINIMUM:		Minimum functionality (2KW)
.DATA #3 ;	B - SMALL:		Full functionality, heavily overlayed (2.5KW)
.IFF $TTCFG ;	B - SMALL:		Full functionality, heavily overlayed (2.5KW)
.DATA #3 ;	C - MIDDLE:		Full functionality, moderately overlayed (5KW)
.IFF $TTCFG ;	C - MIDDLE:		Full functionality, moderately overlayed (5KW)
.DATA #3 ;	D - LARGE:		Full functionality, non-overlayed (9KW)
.IFF $TTCFG ;	D - LARGE:		Full functionality, non-overlayed (9KW)
.DATA #3 ;	E - OTHER:		User supplied FCP
.IFF $TTCFG ;	E - OTHER:		User supplied FCP
.DATA #3 ;
.IFF $TTCFG ;
.IFNDF $FCP .SETS $FCP "**NONE SPECIFIED**"
.DATA #3 ;  4. [$FCP] FCP selected -- '$FCP'
.IFF $TTCFG ;  4. [$FCP] FCP selected -- '$FCP'
.2569:	.IFNDF $FCP .SETS $FCP ""
.;
.; PMD
.;
.IFNDF $PMD  .SETF $PMD  
.IFT $PMD  .DATA #3 ;  5. [$PMD] Post Mortem Dump (PMD) will be built
.IFT $PMD  .IFF $TTCFG ;  5. [$PMD] Post Mortem Dump (PMD) will be built
.IFF $PMD  .DATA #3 ;  5. [$PMD] Post Mortem Dump (PMD) will **NOT** be built
.IFF $PMD  .IFF $TTCFG ;  5. [$PMD] Post Mortem Dump (PMD) will **NOT** be built
.;
.; RMD
.;
.IFNDF $RMD  .SETF $RMD  
.IFT $RMD  .DATA #3 ;  6. [$RMD] The Resource Monitoring Display task (RMD) will be built
.IFT $RMD  .IFF $TTCFG ;  6. [$RMD] The Resource Monitoring Display task (RMD) will be built
.IFF $RMD  .DATA #3 ;  6. [$RMD] The Resource Monitoring Display task (RMD) will **NOT** be built
.IFF $RMD  .IFF $TTCFG ;  6. [$RMD] The Resource Monitoring Display task (RMD) will **NOT** be built
.;
.; PRT
.;
.IFNDF $PRT  .SETF $PRT  
.IFT $PRT  .DATA #3 ;  7. [$PRT] The non-queue manager print spooler (PRT) will be built
.IFT $PRT  .IFF $TTCFG ;  7. [$PRT] The non-queue manager print spooler (PRT) will be built
.IFF $PRT  .DATA #3 ;  7. [$PRT] The non-queue manager print spooler (PRT) will **NOT** be built
.IFF $PRT  .IFF $TTCFG ;  7. [$PRT] The non-queue manager print spooler (PRT) will **NOT** be built
.;
.; DCL
.;
.IFNDF $DCL  .SETF $DCL  
.IFT $DCL  .DATA #3 ;  8. [$DCL] DIGITAL Command Language (DCL) will be built
.IFT $DCL  .IFF $TTCFG ;  8. [$DCL] DIGITAL Command Language (DCL) will be built
.IFF $DCL  .DATA #3 ;  8. [$DCL] DIGITAL Command Language (DCL) will not be built
.IFF $DCL  .IFF $TTCFG ;  8. [$DCL] DIGITAL Command Language (DCL) will not be built
.;
.; ALTERNATE CLI
.;
.IFNDF $NUC .SETN $NUC 0
.DATA #3 ;  9. [$NUC] Number of user-written CLIs -- '$NUC'
.IFF $TTCFG ;  9. [$NUC] Number of user-written CLIs -- '$NUC'
.;
.; PMT (POOL MONITORING TASK)
.;
.IFNDF $PMT .SETF $PMT 
.IFT $PMT .DATA #3 ; 10. [$PMT] Pool monitoring and low pool recovery (PMT) supported
.IFT $PMT .IFF $TTCFG ; 10. [$PMT] Pool monitoring and low pool recovery (PMT) supported
.IFF $PMT .DATA #3 ; 10. [$PMT] Pool monitoring and low pool recovery (PMT) **NOT** supported
.IFF $PMT .IFF $TTCFG ; 10. [$PMT] Pool monitoring and low pool recovery (PMT) **NOT** supported
.;
.; SYSTEM NAME
.;
.IFNDF $NOD .SETS $NOD "**NONE SPECIFIED**"
.DATA #3 ; 11. [$NOD] System name -- '$NOD'
.IFF $TTCFG ; 11. [$NOD] System name -- '$NOD'
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;==============================================================================
.IFF $TTCFG ;==============================================================================
.IFF $FRL .GOTO NOFRL
.;
.; BUILD FCSRES
.;
.SETS TEMPS "SYSLIB"
.IFT $ANM .SETS TEMPS "ANSLIB"
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ; The 'TEMPS' flavor of the FCS resident library common will be built
.IFF $TTCFG ; The 'TEMPS' flavor of the FCS resident library common will be built
.DATA #3 ;
.IFF $TTCFG ;
.NOFRL:.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;	Note that the following tasks will be built for your system:
.IFF $TTCFG ;	Note that the following tasks will be built for your system:
.DATA #3 ;
.IFF $TTCFG ;
.SETS TEMPS "BOO	DMO	"
.SETN TEMPN 2
.IFNDF CO .SETN CO 0
.IF CO GT 0 .SETS TEMPS TEMPS+"COT	"
.IF CO GT 0 .INC TEMPN
.IF $FCP EQ "MINIMUM" .SETS TEMPS TEMPS+"FCPMIN	"
.IF $FCP EQ "MINIMUM" .INC TEMPN
.IF $FCP EQ "SMALL" .SETS TEMPS TEMPS+"FCPSML	"
.IF $FCP EQ "SMALL" .INC TEMPN
.IF $FCP EQ "MIDDLE" .SETS TEMPS TEMPS+"FCPMDL	"
.IF $FCP EQ "MIDDLE" .INC TEMPN
.IF $FCP EQ "LARGE" .SETS TEMPS TEMPS+"FCPLRG	"
.IF $FCP EQ "LARGE" .INC TEMPN
.IFNDF $MAP .SETT $MAP
.IFT $MAP .SETS TEMPS TEMPS+"ICP	"
.IFF $MAP .IF $TME GE 24. .SETS TEMPS TEMPS+"ICP	"
.IFF $MAP .IF $TME LT 24. .SETS TEMPS TEMPS+"ICQ	"
.SETN TEMPN TEMPN+3
.SETS TEMPS TEMPS+"INI	INS	"
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $PMT .SETS TEMPS TEMPS+"PMT	"
.IFT $PMT .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.SETS TEMPS TEMPS+"MCR	"
.INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $DCL .SETS TEMPS TEMPS+"DCL	"
.IFT $DCL .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.SETS TEMPS TEMPS+"MOU	"
.INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $PRN .SETS TEMPS TEMPS+"QMG	"
.IFT $PRN .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $PRN .SETS TEMPS TEMPS+"QMGCLI	"
.IFT $PRN .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $PRN .SETS TEMPS TEMPS+"QMGPRT	"
.IFT $PRN .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $PRN .SETS TEMPS TEMPS+"LPP	"
.IFT $PRN .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $ANM .SETS TEMPS TEMPS+"F11MSG	"
.IFT $ANM .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $ANM .SETS TEMPS TEMPS+"MTAACP	"
.IFT $ANM .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.SETS TEMPS TEMPS+"SAV	"
          .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $TKT .SETS TEMPS TEMPS+"TKTN	"
.IFT $TKT .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.SETS TEMPS TEMPS+"UFD	"
          .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $LOD .SETS TEMPS TEMPS+"LOA	"
.IFT $LOD .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $LOD .SETS TEMPS TEMPS+"UNL	"
.IFT $LOD .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $PMD .SETS TEMPS TEMPS+"PMD	"
.IFT $PMD .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $RMD .SETS TEMPS TEMPS+"RMD	"
.IFT $RMD .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $AMC .SETS TEMPS TEMPS+"SHF	"
.IFT $AMC .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $PRT .SETS TEMPS TEMPS+"PRT	"
.IFT $PRT .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $MUP .SETS TEMPS TEMPS+"ACNT	"
.IFT $MUP .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $MUP .SETS TEMPS TEMPS+"BYE	"
.IFT $MUP .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $MUP .SETS TEMPS TEMPS+"HEL	"
.IFT $MUP .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $MUP .SETS TEMPS TEMPS+"BRO	"
.IFT $MUP .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $MUP .SETS TEMPS TEMPS+"SHUTUP	"
.IFT $MUP .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.SETF $DYN
.IF $CKP EQ "B" .SETT $DYN
.IFT $DYN .SETS TEMPS TEMPS+"ACS	"
.IFT $DYN .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $ERL .SETS TEMPS TEMPS+"ERRLOG	"
.IFT $ERL .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $ERL .SETS TEMPS TEMPS+"ELI	"
.IFT $ERL .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFDF DU .SETS TEMPS TEMPS+"RCT	"
.IFDF DU .INC TEMPN
.IF TEMPN EQ 7 .DATA #3 ;       'TEMPS'
.IF TEMPN EQ 7 .IFF $TTCFG ;       'TEMPS'
.IF TEMPN EQ 7 .SETS TEMPS ""
.IF TEMPN EQ 7 .SETN TEMPN 0
.IFT $KSR .SETS TEMPS TEMPS+"LPINIT	"
.IFT $KSR .INC TEMPN
.IF TEMPN NE 0 .DATA #3 ;       'TEMPS'
.IF TEMPN NE 0 .IFF $TTCFG ;       'TEMPS'
.DATA #3 ;
.IFF $TTCFG ;
.DATA #3 ;==============================================================================
.IFF $TTCFG ;==============================================================================
.DATA #3 ;
.IFF $TTCFG ;
