#include <stdio.h>
#include <cx.h>
#define MAXUFDS 500
#define USRLEN 70
/* NOTE: look for literal 70's in format strings if changing USRLEN */
/* TOTBLK is a program to report on a file containing a list of
   who (or what) owns a certain UFD and the total blocks allocated to that
   owner. The file is [1,1]DISKUSE.RPT, created by the command file [2,31]
   DISKUSE.CMD.

   USAGE: totblk [owner] [-ffilespec]

    AUTHOR: Allen A. Watson
	    THE RECORD
	    150 River Street
	    Hackensack, NJ 07601
	    (201) 646-4111
*/

int lsw=0, fsw=0, usw=0, found=0;
long count=0, total=0;
int usersw=0;
int alllist, userlist;
char *user=
 "**********************************************************************";
char *fufd;
char *ufdfile = "[1,1]DISKUSE.RPT;              ";	/* filespec buffer */
char *s, *c;

main (argc, argv)
char *argv[];
int argc;

{
  register FILE *in;
  register int n;
  char temp [133];
  char junks[3];
  int junkn,pnt;
  int index();

  tiatt();	/* attach terminal so CNTL/O works */

  /* process arguments */
  if (argc > 3) error ("totblk usage: tot [user] [-ffilespec]");
  while (--argc > 0)
    {
    *s = (*++argv)[0];
    switch (*s)
      {
      case '-': switch (tolower((*argv)[1]))	/* a switch is given */
		  {
		  case 'F':
		  case 'f': cpystr (ufdfile, &((*argv)[2]));
			    fsw = 1;
			    break;
		  case 'U':
		  case 'u': /* prepend unit to filespec */
			    cpystr(temp, &((*argv)[2]));
			    strcat(temp, ufdfile);
			    cpystr(ufdfile, temp);
			    usw = 1;
			    break;
		  default:  error("totblk: illegal switch %c\n", (*argv)[1]);
			    break;
		  }
		break;
      default:  usersw++;
		user = *argv;
		break;
      }
    }
  /* so far, listing is all this program does */
  lsw = 1;

  /* check validity of combinations */
  if (usw+fsw > 1) error("totblk: unit can be included in -ffilespec");

  /* set type of listing wanted */
  alllist = lsw && (!usersw);
  userlist = lsw && usersw;

  /* open files needed */
  if ((in = fopen(ufdfile, "r")) == NULL)
    error ("own: cannot open %s", ufdfile);

  /* do listing if desired */
  if (lsw)
    {
    n = 0;
    while (fgetss(temp, 132, in) != NULL)
      { /* above reads data from line */
      if ((alllist)
      || (userlist && ( (pnt = index(temp, user)) != -1)) )
	{
	sscanf (temp, "%ld", &count);
	printf ("%s\n", temp);
	total = total + count;
	n += 1;
	found = 1;
	}
      }
    if (!found) printf ("%s not found\n", user);
    else 
	{
	printf("\n%d entries found\n", n);
	printf("Total of %ld blocks for %s\n", total, user);
	}
    }
  }
