/*
 *       ***************
 *       *  R S X . H  *
 *       ***************
 *
 * RSX-11M/M+ executive and driver data structure definitions.
 *
 * Edits:
 * 25-Nov-81 RBD  Initial edit
 * 23-Jan-81 RBD  Move typedefs into typdef.h
 * 06-Jul-82 TTC  Changed TCB for RSX-11M V4.0
 */

/*
 * V4.0 style Task Control Block (TCB)
 */
struct tcb     {
               address     t_lnk;      /* Utility link word */
               byte        t_pri;      /* Task priority */
               byte        t_ioc;      /* Outstanding I/O count */
               address     t_cpcb;     /* Checkpoint PCB */
               rad50       t_nam[2];   /* Task name (RAD50) */
               address     t_rcvl[2];  /* Receive Q listhead */
               address     t_astl[2];  /* AST Q listhead */
               word        t_eflg[2];  /* Local event flags */
               struct ucb *t_ucb;      /* TI: UCB address */
               struct tcb *t_tcbl;     /* Task list (TCB's) link */
               word        t_stat;     /* Status word (blocking bits) */
               word        t_st2;      /* Status word (state bits) */
               word        t_st3;      /* Status word (attribute bits) */
               byte        t_dpri;     /* Task default priority */
               byte        t_lbn[3];   /* LBN of task image */
               struct ucb *t_ldv;      /* UCB of load device */
               address     t_pcb;      /* Task PCB address */
               word        t_mxsz;     /* Maximum task size */
               struct tcb *t_actl;     /* Active task list link */
               address     t_sast;     /* Specified AST listhead */
               byte        t_res1;     /* Reserved */
               byte        t_tio;      /* Buffered I/O count */
               word        t_tksz;     /* Task size */
               address     t_att[2];   /* Attachment descriptor listhead */
               address     t_off;      /* Task image partition offset */
               byte        t_res2;     /* Reserved */
               byte        t_srct;     /* EFN count */
               address     t_rrfl[2];  /* Receive by reference listhead */
               address     t_ocbh[2];  /* Offspring control listhead */
               word        t_rdct;     /* Offspring count */
               word        t_eflm[2];  /* Event flag mask word */
               byte        t_hdln;     /* Task header length, 32-word blks */
               };

/*
 * Unit Control Block (UCB)
 *
 * General purpose style UCB.  Add stuff to this at your
 * driver's convenience & use the sizeof() to get the UCB
 * length.
 */
struct ucb     {
               address     u_dcb;      /* Backpointer to DCB */
               struct ucb *u_red;      /* Redirect UCB pointer */
               byte        u_ctl;      /* Control flags */
               byte        u_sts;      /* Status flags byte 1 */
               byte        u_unit;     /* Unit number */
               byte        u_st2;      /* Status flags byte 2 */
               word        u_cw1;      /* Characteristics word 1 */
               word        u_cw2;      /* Characteristics word 2 */
               word        u_cw3;      /* Characteristics word 3 */
               word        u_cw4;      /* Characteristics word 4 */
               address     u_scb;      /* SCB address */
               struct tcb *u_tcb;      /* TCB of attached task */
               word        u_buf[2];   /* Buffer address descriptor */
               word        u_cnt;      /* Byte count of transfer */
               struct tcb *u_acp;      /* TCB of attached ACP task */
               address     u_vcb;      /* Address of VCB */
               };

/*
 * I/O packet
 *
 * Be sure to clear i_prm[7] before calling $iofin or you'll
 * get strange bird droppings left around.  Thanks to Ralph
 * Stamerjohn for warning me about this so I didn't suffer.
 */
struct iopkt   {
               address     i_lnk;      /* Link to next packet */
               byte        i_pri;      /* Priority (byte) */
               byte        i_efn;      /* Event flag number (byte) */
               struct tcb *i_tcb;      /* TCB address of requestor */
               word       *i_ln2;      /* Address of 2nd LUT word */
               struct ucb *i_ucb;      /* Address of redirect UCB */
               word        i_fcn;      /* I/O function & subfunction */
               word        i_iosb[3];  /* IOSB address parameters */
               address     i_ast;      /* Virtual address of AST routine */
               word        i_prm[8];   /* Device parameters */
               };
