	Getting Started with PortaCalc

	The PortaCalc spreadsheet asks some questions when you
run it, to set up its working storage. PortaCalc contains a direct
access file which it sets up and can reuse or reinitialize, containing
the basic information for the spreadsheet's physical sheet.
	When you run PortaCalc, it first asks you whether to change the
default floating point format. This is initially set to the Fortran
format F9.2 (9 characters wide, 2 decimal places), but if you reply
Y, it lets you enter any format you like as the default format. It will
try to use it, so if you enter an illegal format, PortaCalc will issue
error messages before it generates a bad workfile. Note that the default
applies when the workfile is BUILT, not later (though the DF command
will reset the format of any part of the file later). Portacalc then
asks you to enter up to 80 characters as the Title of the spreadsheet. 
	To reply, enter any title you like, up to 80 characters long,
followed (as all PortaCalc commands) by a carriage return (labelled
RETURN on the VT100). This will appear across the top of the sheet
on screen and in print images of it. You may include any desired leading
spaces in the title. It will be printed on screen printouts, so make
it descriptive of the sheet you'll be using.
	The next question is whether there is already a work file on
disk to use or reuse. If you have such a file, you can save considerable
time by letting PortaCalc just reuse it. PortaCalc will create one if
none exists, but one already in existence can be more quickly set up.
Reply N if there is no file and one must be made. The reply Y will
cause PortaCalc to read the old file and find out what format entries
are valid over the whole sheet, so that an old sheet's workfile can
be used to continue; formulas and format information is still there.
To start quickly, you can type Q, which means PortaCalc does not read
the whole file, but only the default display window part. If you
choose this option, all cells will start with 0 until the first
R (Recalculate)command is given, when the values in the display
window will reappear. Other cells' values will not be set up however,
so large sheets may need the Y option if the old cells are to be
used outside the immediate display area.
	Note that the Q option is likely NOT to work if you have
used integer formats. In that case, ALWAYS use the P and G commands
to save and load sheets. These are a good idea anyway. They permit
sheets to be loaded across PortaCalc versions, and some variants
permit graphing the entries. A workfile is only usable as long
as the physical sheet PortaCalc is compiled for is identical
to that which created the workfile.
	The last question of this setup phase is the filename.
A standard filename, either that of the old file, or the name
to use for a new one, is required. Limit it to the max supported
by your system for names (on DEC, 9 character names max).
	If the Q option is not given, PortaCalc displays its help
file while initializing the file or reading it, then goes into the
sheet proper.
	The sheet is displayed at the top part of the screen and
a command cell in Row 23 is shown with the current position
encoded. This starts off looking like

   A  1>

and then PortaCalc awaits your commands. Note that if the cell
pointed to by the command (which is always a Physical sheet address)
is occupied (i.e., has ever had any numbers or text entered into it),
that cell is displayed in the display in reverse video when you
are positioned there. If the cell is totally empty, it is not
displayed, however, in any reverse video. A pattern of >-< is displayed,
however, wherever the cell is null. This pattern is in reverse video.
  You control the sheet by entering a command followed by Return.
These commands are in the first few columns of the command line
and are the first few characters (often the first 1 or 2) you
type, and they are REQUIRED for every command. PortaCalc does NOT
assume any command names.

	The commands will now be listed, in a hopefully useful order
to let you understand how to use the system.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>

	ENTER

	E expression

	This command enters the given expression at your current
cursor position, and may optionally move in some direction that
has been set up by the M command (Move) after the entry is made.
	The text entered becomes the Formula for that cell, and
PortaCalc takes a guess as to whether that text is just text or
a number to compute. If the text contains any of the characters
(, +, -, ., or [, it is assumed to be a formula, and the cell is
marked as containing a computable formula. Otherwise it is just
treated as a label and the formula itself is displayed.
If you find the guess is not to your liking, the DF command
below lets you alter the format and tell PortaCalc that the
entry is / is not a numeric. An additional special character
is the '"' (double quote) character. If this character appears any-
where in the entered formula, PortaCalc will take the formula as
text, regardless of whatever else is in it. You can also combine
comments and formulas by using a separate statement and the *C
construct (e.g. SUM[A3:A12]\SQRT(%)\*C SQUARE ROOT OF THE LENGTHS)
of Calc.
	The expressions that are entered can be numbers or formulas
relating numbers and other cells. They may also consist of several
statements separated by a \ character which will all be evaluated
at that cell, up to 110 characters. Thus, valid commands might be

  E 55.234		Enters literal value 55.234 at current cell
  E B4+H2+D5		Cell will contain the sum of cells B4,H2, and
			D5.
  E Totals		Cell contains literal text "Totals".

Formulas may be used too. These are in 2 classes. The first are the
multi-argument functions, which must appear at the start of their
statements or substatements. The ones present are:
	SUM[variables]		Sum of all arguments
	MAX[variables]		Max of arguments
	MIN[variables]		Min of arguments
	AVG[variables]		Average of arguments
	STD[variables]		Standard deviation squared
	IF [V1.rel.V2] statement | else-statement
In the first 5 cases, arguments are variable names separated by
commas, or variable ranges, or mixtures separaged by columns.
	A valid variable name might be H14 or N22 or A3, or the
position independent forms P#n#m and D#n#m where n and m are
offsets in Physical or Display sheets from the current column
and row. A valid range is 2 variable names separated by colon (:).
Thus the range B2:B12 is valid and means B2 through B12 inclusive.
The range expression D#0#1:D#0#12 is also valid and means the
cells on the display sheet in the same column but 1 to 12 rows
down from the current cell inclusive. (The displacements may
be negative too, with - sign to indicate it, as D#-3#2 for
the display cell 3 columns left and 2 rows down from the
current position.) The P# and D# forms are valuable since they
work wherever you move them. Other variables may be relocated
when moved (renaming them to correspond to their new locations),
but the P# and D# forms need never change and allow working
with projections across the physical sheet in various ways.
	Note that the square brackets ([]) are needed to delimit
arguments in these forms. The results are left in accumulator %
and in the cell. The IF form will compare 2 variables and execute
either the statement or the else-statement (which must NOT be another
IF). The valid relations are:
	.EQ.	Equal
	.NE.	Not Equal
	.GT.	Greater than (V1 greater than V2)
	.LT.	Less than (V1 less than V2)
	.GE.	Greater than or Equal to (V1 >= V2)
	.LE.	Less than or Equal to (V1 =< V2)
and must appear in this form. (Note that your formulas must generally
be in upper case only; text can be anything.)
	The second class of formulas is what the Calc program interprets.
These are more conventional, use parentheses, and include single argument
functions like SQRT, ALOG, EXP, SIN, COS, and so on. See the Calc manual
for more detail. However, they may use variable names as anywhere, not
just single letter accumulators. Thus, SQRT(A5) is a valid number.
	To get, e.g., the square root of the sum of several variables
(in a row or column; ranges may only be in rows or columns together)
one might have a formula line like:

SUM[A1:A20,B4,F2,C5:C20,J3:M3]\SQRT(%)

which computes the sum of the 2 cells and 3 ranges and leaves it in %,
then computes the square root of that and leaves it in the cell. The
formulas to Calc may be complex but MUST NOT be longer than 78 characters.
Break up longer ones so they can be fed to Calc in smaller chunks.
	The commands of CALC should be examined carefully for usefulness.
You can enter programs into CALC which can be used as user-defined
functions from the sheet if need be. Also, there are a few new
commands in CALC for the sheet.
	One of these is the *G command. Its syntax is
*G V1,V2
	which has the effect of evaluating variables V1 and V2 as
column and row numbers on the physical sheet and returning the
physical sheet variable addressed by those variables. The ranges are
clamped to fit on the sheet. This gives indirect addressing, permitting
lookup tables to be made up by creating the index you want and then
accessing the addressed table element. Typically the *G command would
be the last on a formula line, though it need not be. Its value
is returned in the % accumulator.
	Another is the *W command, which simply takes the number
in % and places it in the formula for the current cell on the spread
sheet. This may be used to "freeze" a value, replacing a formula
by a constant for future use. Note that the previous contents of
the formula entry are lost. Thus, a *W command in the sheet will
normally cause itself to be overwritten after one use. The number
is stored in a format E35.24 in the worksheet.
	To implement user functions, if Calc sees an expression of
the form "@filename.ext", it will execute that file as a command
at that cell. Any filename may be used and as many functions as
desired can be handled in this way (with obvious overhead), with
nesting depth of up to 3 permitted. Once Calc starts using logical
unit 4, however, it conflicts with the P or G commands and may
have problems.
	Calc has also a command called *P which allows resetting
of the physical coordinates while executing a cell's formulas,
FOR THE DURATION OF THAT CELL'S FORMULA ONLY or while in K mode
only.
	The syntax of the *P command is either just *P (which causes
Calc to prompt for column and row), or *P Variablename (which moves
the current location to the named location), or *P@ variable1,variable2
(which moves to the location which is defined by variable 1 and 2 as col.
and row).
	Some other commands exist for the main benefit of PortaCalc
in Calc.
	The command *F LABEL
will evaluate the % variable. If it is positive and nonzero, then
the current input line will be rewound and the program will (silently)
seek a line of the form *CLABEL. This allows loops to be defined with
% as the counter. This command acts on the unit used by the Portacalc
@ command, NOT the unit for the Calc @ command, and is a way that
the Calc formula conditionals may be reflected back into its command
processing.
	The command *J LABEL
will act as does *F LABEL but its search will be in the current file
opened by a Calc @ command (i.e., an @file inside a cell on the
sheet, or given from the console after a K command [see below]
to enter bare interactive Calc).
	The command *QF or *QW file ?searchkey? <cc>
will open file and look for lines starting with searchkey as
given (with _ as a wild character). Upon finding this, it will
look for the <cc> and if it finds it, it will select the part of
the line in the file between the 2 characters given (which may be
alike) as they are first found, and will do one of 2 things. If
the command was *QF, then Calc will Float the value found there
(attempting to use a large E format) and return it in %. If the
command was *QW, then Calc will Write the selected part of the
record into the formula at the current physical position on the
sheet (which may be reset by an IMMEDIATELY PRECEDING *P command).
The record may contain the search key anywhere. It is up
to the user to make sure the formulas copied make sense. This
however allows access to sequential files of data which can be
created by an editor, word processor, etc., and which might
hold keyed information that the spreadsheet should be able
to manipulate. As a user convenience, there may be a second
key specified (also inside a pair of ?s). If two keys are
specified, Calc will search for and require that BOTH be
somewhere in the record accepted. Note too that the files
opened may not have any records longer than 128 characters
per line.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>

	EDIT FORMULAS

	ED 'string1'string2'	Replace string1 with string2
				in current cell formula. Either
				string may be null if desired.

	The ED command allows editing of formulas with some extra
bells and whistles. Basically, the new string replaces the old
one, EXCEPT that it is possible to do some limited argument
replacement.
	The constructs &1 through &4 will be replaced by arguments
1 through 4 as last entered by the "-" command (see below). These
may be from 0 to 51 characters long each, and multiple & constructs
may appear in a substitution. No & constructs may recurse, however.
A second ED command can have the effect of the recursion in some
cases however.
	The construct &5 will evaluate accumulator Z and, if it
is in a range where it may be so represented, take its integer part
and convert it to a numeric string (up to 10 characters) in
the place of the &5.
	The construct &6 will replace the cell with the contents
of the integer part of accumulator Z provided that that number
is between 1 and 256. Thus, any single non-null ASCII code can
be entered. Accumulator Z is used to avoid conflicts with %, which
is used too frequently to reserve for this purpose.
	The EDited formula is re-entered into the cell after the
edit.


<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	RECALCULATE

	R	Recalculate all of the sheet.
	RM	Recalculate manually only until R command given

	The R command forces a recalculation of the sheet. This will
evaluate all formulas on the sheet and update the display to show the
new numbers. Normally, recalculation is done after each number is
entered to update the new cell, but the R command forces total
recalculation in case anything was missed.
	Since these calculations can be time-consuming, you can suppress
them while doing input by entering the RM command (Recalculate Manually)
which suppresses recalculation until an R command is entered. This
command's format is just

	RM

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	EXIT

	X		Exit to operating system.

	The X command exits from PortaCalc to the operating system.
In general, this is the ONLY way (short of an abort command to the
operating system) to get out of PortaCalc, and is the ONLY WAY TO
LEAVE GRACEFULLY.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	LOCATE CURSOR (Move Around the sheet)

	L variable-name		Position cursor at variable-name

	The L command moves the current position to the variable
named on the Physical sheet (and the display sheet if the variable
is on the display). Examples might be

	L B3		Move to cell B3
	L D6		Move to cell D6

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	MOTION DIRECTION (Set Default Direction to move after an Enter)

	M1		(Move up)
	M2		(Move down)
	M3		(Move left)
	M4		(Move right)

	The M command causes automatic cursor motion after an E command
in the direction indicated. This only occurs after an E command.
	The default condition is not to move at all after an E command,
and this may be reestablished by a command of form M5 (actually Mc,
where c is any character other than 1 to 4.)

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	CURSOR MOTION (Commands to move around the sheet one cell at a time)

	1		(Move up)
	2		(Move down)
	3		(Move left)
	4		(Move right)

	The cursor motion keys move the cursor on the display in the
direction indicated. Note these keys are in the same order on the
keyboard as the arrow keys of the VT100.
	(The reason the cursor keys are not used directly is that on
VT100 they are multiple characters and difficult for Fortran to parse.)

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	VIEWCREEN UPDATE

	V		Redraw screen with normal formats
	VF		Redraw screen showing all formulas
	VM		Don't redraw screen until a V or VF is
				given.

	The V and VF commands redraw the display screen showing numerics
as numerics in the selected format (V) or displaying whatever part of
the formulas fits on screen in the column (VF). This is used wherever
the picture on the screen is damaged, e.g., by operating system broadcasts.
VM is used to inhibit redraw while numerous changes may be made, to save
time. A V or VF command will re enable display updates.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	ZERO VARIABLES

	ZA		Zero whole sheet
	ZE V1:V2	Zero variables in a row or column in range from
				cell V1 to cell V2 (V1,V2 = names of cells)

	The ZEro commands clear out a sheet. The ZA command will also
ask if you mean it and needs a reply of Yes to actually clobber the whole
sheet and return it to pristine purity.
	The ZA command takes a noticeable time to clear the workfile out;
do not be alarmed at this. It will ask afterwards for a new title, new
display format default for floating point, etc.
	If you give the ZA command, PortaCalc will ask you to confirm that
you indeed want to zero the entire sheet. A reply of Y will proceed to execute
the command; any other reply will abort the clearing operation.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	ORIGIN RESET  (Windows onto physical sheet)

	OA variable	Reset origin of display to variable
	OR variable	Reset display down and right to start with
				variable


	The OA and OR commands let you do quick scrolls around the physical
sheet by resetting the upper left corner of the display sheet to point
at any variable on the physical one and make the rest follow suit (OA),
or will reset the display sheet starting at your current cursor location
to point at the physical sheet variable and make all parts of the displayed
sheet down and right from your current location correspond likewise.
	Thus, if you start with a normal initial display and execute
the commands

	L C1
	OR H1

you wind up with columns A and B still on screen, but now the remaining
columns are H, I, J, K, L instead of C, D, E, F, and G. This happened
because cell H1, down and right were pointed to by the display sheet
starting where you were, which was cell C1, initially the 3rd column
and first row. Had the command been OA H1, the column labels would
be H-N rather than the initial A-G.


<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	DISPLAY LOCATE (Map physical sheet variables onto Display Sheet)

	DL V1:V2 Rn:m	point at display coordinates (n,m) (col,row)
			and, going left to right along a Row, copy in
			variables V1 through V2 (actually, point those
			display sheet cells at variables V1 thru V2).
	DL V1:V2 Cn:m	point at display coordinates (n,m) (col,row)
			and, going top to bottom along a Column, copy in
			variables V1 through V2 (actually, point those
			display sheet cells at variables V1 thru V2).

	The DL command lets you associate any variables in the physical
sheet with any location on the display sheet (the display sheet coordinates
always count from 1 as the topmost row or leftmost column, through the
maximum number there). This flexible association means that in principle
every cell on the display sheet can be a "window" in the sense of other
sheets, though that would be quite hard to follow. If the :V2 part of
the command is left off, only one display cell is changed.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	COPYING CELLS

	CA V1:V2 V3:V4		Copy all cell attributes from V1:V2
				to V3:V4.
	CV V1:V2 V3:V4		Copy numeric values only
	CD V1:V2 V3:V4		Copy Display Formats only
	CF V1:V2 V3:V4		Copy Formulas only (no relocation)
	CR V1:V2 V3:V4		Copy all cell attributes as in CA but
				relocate cell names to new location
				from old one.

	The Copy commands let you reproduce cells' contents in other
locations on your sheet without re-entering them. The CA form is most
useful, though the CD part can be used to change default formats and
the others may be handy. Note that formulas are NOT changed by the
copy operation. If they should function correctly in their new
location relative to different cells, the cell identifications
should be position independent forms (P#n#m for forms relative
to physical sheet, D#n#m for forms relative to display sheet) so
no modification is necessary. CA will normally save all information
about a cell in the new cell.
	When you specify one variable to the C class commands in
the V1:V2 range location and give a range V3:V4, the command will
copy the named V1 into all cells in the V3:V4 range.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	DISPLAY FORMAT SETTING

	DF V1:V2 [format]

	The DF command sets the display format for the variable range
V1 to V2 inclusive to be whatever is in the square brackets. This is
expected to be a valid FORTRAN FORMAT specifier for display of the
number and may be up to 9 characters long. If the format specifier
entered is however just A or L in the first character, the program
will indicate the text is to be displayed literally, not as a number,
so titles and such can be shown. To display numbers in Fortran A or
L forms, just use formats like 4A1 or similar; as long as there is
something ahead of the A or L it goes to Fortran. The program will
try your format once before writing to disk to ensure against any
crashes that will damage your file. Otherwise, the format is up
to you. You can even display in octal or hex if you wish!
	The DF command will also set the type to Floating if the
format begins with F or E, and will set the type to Integer if the
format begins with I. Beyond this (e.g., for octal or hex) you
must use the DT command (below) to set the storage to floating
(8 bytes) or integer (4 bytes).
	NOTE:
	There are 2 items in any cell which may be displayed.
	One of these is the number in the cell, which takes
	4 bytes if an integer, 8 if floating point, and which
	is displayed normally using a Fortran FORMAT statement
	type declaration. The other is the FORMULA associated
	with the cell, which may contain just text or labels.
	This is selected by the A or L formats.
		Thus, the declaration
	DF A1:A64 [8A1]
		would display the NUMBERs in column A as 8 characters
		(assuming this makes sense), and would cause strange errors
		if the number did not make sense as characters.
	The declaration

	DF A1:A64 [A]
		would display the FORMULA TEXT in column A on the screen.
		This normally will always make sense, and is the normal
		way to display labels.

	To reset FORTRAN Formats, the Fw.d format is useful. In that
format, w means an integer giving the width in characters of the output
number, and d is the number of decimal places to be shown. For example
F9.2 has 9 places total, 2 to the right of a decimal point. A valid
number in this format might be
	123456.78

	The format F9.1 would give
	 123456.8		(note rounding)
You may devise whatever formats desired. In addition, PortaCalc will only
display the number of characters that fit in the column on screen, so
display width can be set to remove undesired decimals.


<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	DISPLAY TYPE SETTING

	DT V1:V2 F	Set V1 thru V2 to Floating data type
	DT V1:V2 I	Set V1 thru V2 to Integer data type

	The DT command sets Float/Integer attributes on physical
cells. Initial default is F (8 bytes) but this can set it to I
(4 byte integer). Computation is done in floating point always,
but I type variables will be converted to integer when stored
and may be displayed in valid Fortran formats. This information
is stored/restored by the P/G class commands, but not on disk as
it is considered volatile.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	DISPLAY WIDTH SETTING

	DW N,M		Set column N on display to be M characters
				wide

	DW lets you set any column width. They are independent
of each other, and may be set in any order. Maximum width supported
is 132 columns with the present version of UVT100; it may be larger
on terminals where it makes sense, if UVT100 is altered.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	DISPLAY BOUNDARIES SETTING

	DB n,m		Set number of columns displayed on screen
				to n, number of rows displayed to
				m.

	The DB command sets display size. It also effects the
number of cells modified by the OA and OR commands, so setting the
display small, doing an OA or OR, then setting it large, leaves
the part omitted as it was before the OA or OR.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	WRITING SCREEN TO HARDCOPY

	W

	The W command lets you write a hard copy of the screen
as it exists on display to a file. PortaCalc will prompt you for
the file name; the device specifier should be included.
	Note that if the filename you enter (or the last character
after the device or file specifier) is a "/" character, PortaCalc
will omit the column and row labels in the output file or printout
so that you need not edit them out afterwards. They will always be
displayed on the screen however.
	To output to the lineprinter on PDP11, the file specifiers
to give are either "LP:" or "LP:/", then. The device name normally
should be given on PDP11. On other systems (e.g., VAX), the device
will default to disk unless otherwise specified. The output file
in any case has no strange escape sequences and may be edited with
any normal system editor.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	EXECUTING COMMAND FILES

	@filespec	Read filespec and execute commands as though
			typed in.

	The @ command lets you treat a file as though it were your
console input (returns on endfile) to let you execute saved sets
of commands to set up your sheets. Note that if you issue the K
command (below), those inputs come from a separate file on logical
unit 1.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	DROPPING INTO INTERACTIVE CALCULATOR

	K		Drop into Calc program straight.

	The K command gets you into Calc, described in Calc.rno
and lets you do computations. When you give the interactive
Calc program the *E command to exit, you return to PortaCalc.
This may be useful where you want to do auxiliary computations
not in the spread sheet or try out formulas that you may want to
debug interactively before entering them onto the sheet.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	SAVING YOUR SPREADSHEET

	PD		Put out current Display sheet (Formulas)
	PP		Put out current Physical sheet (Formulas)
	PDN		Put out current Display sheet (Numbers)
	PPN		Put out current Physical sheet (Numbers)
	S		Save work file, allow you to start using a new one

	The S command just returns to the start of Calc to let
you select a new work file. You may reselect the old one if you
wish; this lets you change the title only. Otherwise you can use
the direct access file as primary saved info on a sheet. The
PP and PD commands (with the GP/GD commands described below) are
intended to be the primary means of saving/restoring sheets, and
allow more flexibility in saving, restoring, or mixing sheets than
the S command. Thus, the S command is intended as a highly temporary
form of saving data, and should NOT be used as an archival means
of storing a spread sheet.
	The PD and PP commands write Display or Physical sheet
cells that are active to a specially formatted sequential ASCII
text file, always starting from the current position of the cursor
and saving right and down. Some questions will be asked so you
may enter a maximum displacement to save (so not all of a large
sheet need be saved) in columns and rows. On reload (the GP/GD
commands), these questions are also asked, and minimum displacements
are asked also to allow you to enter basically any region of the
saved sheets into the current sheet starting at the current
location and moving down and right. This gives a large scale
move capability and a sheet merge capability.
	The PPN and PDN commands save numbers instead of formats
to permit loading of isolated numeric values from other sheets
by using the GD or GP commands (below). They record only numbers
and not formulas, but this allows any cell's numeric value from
other sheets to be loaded into another sheet without loading all
formulas and repeating calculations. Also, the PPN/PDN commands
are needed to use the PCGRAF program to graph parts of a sheet if
this form of output is desired.
	The PP/PD commands are suitable for archival storage of
spread sheet data, or for its transportation to differently
compiled versions of PortaCalc.


<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>

	ADJUSTING PHYSICAL LOCATIONS

	AA number R	Add "number" rows ahead of the current
			physical position, moving all cells below
			the current cell down by "number" rows and
			losing the physical sheet's bottom "number"
			rows' contents, NOT adjusting variable references
			where the variables are in the moved range
			and are not the position independent (P## or D##
			forms) type.
	AA number C	Add "number" columns ahead of the current
			physical position, moving all cells right of
			the current cell right by "number" columns and
			losing the physical sheet's bottom "number"
			columns' contents, NOT adjusting variable references
			where the variables are in the moved range
			and are not the position independent (P## or D##
			forms) type.
	AR number R	Add "number" rows ahead of the current
			physical position, moving all cells below
			the current cell down by "number" rows and
			losing the physical sheet's bottom "number"
			rows' contents, adjusting variable references
			where the variables are in the moved range
			and are not the position independent (P## or D##
			forms) type.
	AR number C	Add "number" columns ahead of the current
			physical position, moving all cells right of
			the current cell right by "number" columns and
			losing the physical sheet's bottom "number"
			columns' contents, adjusting variable references
			where the variables are in the moved range
			and are not the position independent (P## or D##
			forms) type.

	These commands permit the operations known on other spread sheets
as "insertion" or "deletion". Deletion takes place where "number" is 
negative and the sense of the motion is reversed. These commands change
the physical sheet's contents and permit wholesale modifications to
variable names (other than P## or D## forms which are position independent
already and are left alone for simplicity and to preserve some of
the flexibility of the D## forms which can be used for projections of
3D sheets onto the display and math with ranges of these).
another computation to be used. To save a sheet for merging such
selected values, both forms, or at least the numeric form, should
be used.
	Note that the previous contents of the rows or columns inserted
is RETAINED, though it can be zeroed by the ZE command if desired. It
will have been copied also to the lower or further-right row/column
also, but do not be alarmed; the space is free to re-use. You may however
elect to use this feature as a shorthand for copy.
	The AR/AA operations take place on the physical sheet and
do not affect the display sheet mapping to the physical sheet.
	CAUTION: the rows/columns not moved are not relocated in
a relocating insert/delete.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>


	RESTORING YOUR SPREADSHEET

	GD		Reload sheet down/right onto display
			coordinates.
	GP		Reload sheet down/right onto physical
			coordinates.

	The GP/GD commands are the inverse of the PP/PD commands
and load those files to potentially new locations. This is the
simple way to merge sheets. In these cases, you are separately
asked for filenames and limits on what part of the sheets to
load/save. Only cells that are marked in use are saved, so sparse
sheets take less space than saving the direct access files.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>

	READING ARGUMENTS OFF CONSOLE

	- Prompt

	The "-" command will print the prompt text on the screen
and await entry of a line of text. This text is stored as up
to 4 arguments for possible later use in EDit commands. Spaces
separate input arguments, and no argument may be longer than
51 characters. This facility is intended for use with indirect
command files (@ files) which may want to be able to prompt
for parts of formulas and then edit them into the command formulas
for use, or to prompt for parts of later-used Calc commands. Note
that Calc never sees any formulas that are given the A format,
so they can be prepared in this way, to be used when they are
given a numeric format.
	A suitable - command might be

-Enter net pay>
	which would produce the printout (in row 23 of the screen)
Enter net pay>
	and to which one might reply with a number to be entered
onto a "template" worksheet.

<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>

	LOOPING COMMAND FILES

	<		Rewind the current Portacalc input file

	This command will allow a command file to restart
itself from the beginning. It does so only if the % variable is
positive (permitting some control over it).


<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>

	COMMENTS

	* any text

	Any line beginning with * is treated by PortaCalc as
a comment (except when in the *F mode when it is sought). This
allows you to comment your indirect PortaCalc command files.


<=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=><=>

NOTES:

	Note that if PortaCalc crashes, your data is on the direct
access file and may be recovered and reused if need be. It's a
good idea to exit Portacalc once you create your workfile, then
reenter it with the Q option. This leaves it fully created and
you need not worry about a file whose EOF was never put into
a directory. (This is true in DEC-land; maybe not for others.)

	In entering numbers, use a decimal (.) to get them to
go in correctly. The parser doesn't seem to understand they are
numeric otherwise (even integers).

	Note that the default format for numeric output is
F9.2 and that it may be changed if desired. If you set up the
format of a cell, that marks the cell valid and the format
is not altered by input defaults, nor the numeric/text
interpretation of the cell. To put in a lot of labels, then,
set up format A using DF and then enter the labels.

	If the sheet's calculations contain forward references
(down or right), you may need to give the R (Recalculate) command
a few times to get proper values. If the values on the sheet do
not stabilize, you probably have a circular reference in your
formulas and should examine the cells that do not stabilize for
the circularity.

	If you enter numbers with exponentials, use +/- in front
of the E so that PortaCalc can tell that the "E4" type strings
in numbers like "1.3E4" are really exponents, not cell names.
That is, 
	Don't enter
		1.35E4
	Enter
		1.35E+4
to avoid confusion when cells are relocated. You may use lowercase
E also (1.35e4) to avoid confusion.
