/*
 *       *********************
 *       *  F 1 1 Q I O . H  *
 *       *********************
 *
 * Files-11 QIO directive parameter block and symbolics
 *
 * Edits:
 * V1.0 25-Nov-81 RBD   Initial edit
 * V1.1 22-Jan-82 RBD   IOSB address is now a word *
 * V1.2 23-Jan-82 RBD   Typedefs -> typdef.h
 */

struct f11qio  {
               byte  dic;              /* DIC always = 1 */
               byte  size;             /* Size always = 12. */
               word  q_iofn;           /* I/O function & subfunction */
               byte  q_iolu;           /* LUN */
               byte  q_res0;           /* Reserved */
               byte  q_ioef;           /* Event flag */
               byte  q_iopr;           /* Priority */
               word *q_iosb;           /* I/O Status block address */
               address  q_ioae;        /* AST service entry address */
               /*
                * Parameters specific to Files-11 QIO's
                */
               word *q_fidp;           /* FID address */
               word *q_attl;           /* Attribute list address */
               byte  q_sizh;           /* Hi 8 bits of size/extend value */
               byte  q_extc;           /* Extend control flags */
               word  q_sizl;           /* Lo 16 bits of size/extend value */
               byte  q_wsiz;           /* Window size */
               byte  q_accc;           /* Access control flags */
               struct fnb *q_fnbp;     /* FNB address */
               };

/*
 * Files-11 I/O function codes.
 */
#define   IO_ACE     3840              /* Access file for Read/Write/Extend */
#define   IO_ACR     3328              /* Access file for Read */
#define   IO_ACW     3584              /* Access file for Read/Write */
#define   IO_CRE     5120              /* Create file */
#define   IO_DAC     4096              /* Deaccess file */
#define   IO_DEL     5376              /* Delete or truncate file */
#define   IO_ENA     3072              /* Enter name into directory */
#define   IO_EXT     4864              /* Extend file */
#define   IO_FNA     2304              /* Find filename in directory */
#define   IO_RAT     5632              /* Read attributes */
#define   IO_RNA     2816              /* Remove name from directory */
#define   IO_WAT     5888              /* Write attributes */

