.;
.; User Monitor Generation Command File
.;
.SETS VERSN "1.14"
.ENABLE SUBSTITUTION
.SETS UIC <UIC>
;
;	User terminal monitor program generation procedure
;	Version 'VERSN'
;
;	This user terminal monitor program is a  privileged  task  which
;	continuously  runs  under  RSX-11M  to monitor the status of all
;	logged-on terminals.  It is particularly useful for cleaning  up
;	otherwise unusable areas of POOL which might be allocated when a
;	terminal logs in and would not be released until it logs out.
;
;	This monitor program  periodically  runs  through  the  terminal
;	driver data structures looking for logged on terminals.  It then
;	runs through the  active  task  list  looking  for  the  "owning
;	terminal" for each task.
;
.ASKS NULL Use carriage return to proceed
;
;	If a check of the active  task  list  finds  no  activity  on  a
;	terminal,  a  counter  is  bumped  to indicate an idle terminal;
;	contrariwise, if the terminal is found to have active tasks, the
;	counter is reset.
;
;	If  no  activity  occurs  on  the  terminal  within  the   first
;	monitoring period, a warning is sent to the terminal.
;
;	If no activity occurs on the terminal after  the  first  warning
;	during the second monitoring period, a second warning is sent to
;	the terminal.
;
;	If no activity occurs on the terminal after the second warning up
;	to  one  minute  before  the  expiration  of the third monitoring
;	period, a final warning is sent.  If no  activity  occurs  during
;	the third monitoring period, the user monitor spawns BYE for that
;	terminal.
;
.ASKS NULL Use carriage return to proceed
;
;
;	Option Generation Phase
;
;
; 	Specify values in WHOLE MINUTES for these parameters:
;
.ASKN [2:33.:10.] MONP1 Enter the length of the first monitoring period
;
.ASKN [2:33.:10.] MONP2 Enter the length of the second monitoring period
;
.ASKN [2:33.:10.] MONP3 Enter the length of the third monitoring period
;
;	Specify a value in WHOLE SECONDS for this parameter:
;
.TIME:
.ASKN [5.:60.:15.] SECNDS Enter the time between task list checks
.;
.; Check to see that the number given divides evenly into a minute
.;
.SETN TEMP 60./SECNDS
.SETN TEMP 60.-(TEMP*SECNDS)
.IF TEMP EQ 0 .GOTO OK
;
;	The number must divide evenly into one minute.
;	Valid numbers are:  5, 6, 10, 12, 15, 20, 30, 60
;
.GOTO TIME
.OK:
.;
.;	Compute the number of monitoring periods for warning and logout times
.;
.SETN NO1 (MONP1*60.)/SECNDS
.SETS $NO1 "'MONP1'"
.SETN TEMP MONP1+MONP2
.SETN NO2 (TEMP*60.)/SECNDS
.SETS $NO2 "'TEMP'"
.SETN TEMP MONP1+MONP2+MONP3-1
.SETN NO3 (TEMP*60.)/SECNDS
.SETS $NO3 "'TEMP'"
.INC TEMP
.SETN NO4 (TEMP*60.)/SECNDS
.SETS $NO4 "'TEMP'"
.;
.;	Create string values for warning time messages
.;
.SETN WARN2 TEMP-MONP2-MONP1
.SETS $WARN2 "'WARN2'"
.SETS $WN2 "0"
.TEST $WARN2
.IF <STRLEN> EQ 2 .SETS $WN2 "''"+$WARN2[2:2]
.SETS $WARN2 "TIME2 = ''"+$WARN2[1:1]+" + <"+$WN2+"*256.>"
.SETN WARN1 TEMP-MONP1
.SETS $WARN1 "'WARN1'"
.SETS $WN1 "0"
.TEST $WARN1
.IF <STRLEN> EQ 2 .SETS $WN1 "''"+$WARN1[2:2]
.SETS $WARN1 "TIME1 = ''"+$WARN1[1:1]+" + <"+$WN1+"*256.>"
;
.ASK DECNET Is DECnet supported on this machine
.IFF DECNET .GOTO UICGET
;
.ASK NETSUP Do you want idle DECnet HT: terminals logged out
.IFF NETSUP .GOTO UICGET
;
;	The user monitor decides how many DECnet HT: terminals are in
;	your system by examining RMHPRE.MAC.  This file has to be in
;	with your DECnet subsystem files somewhere.
;
.ASKS NETUIC Enter the UFD on LB: where RMHPRE.MAC can be found [ggg,mmm]
.UICGET:
;
;	To build the user monitor, it is almost necessary that a copy
;	of RSXMC.MAC be present on LB: .  If one is not available, you
;	will have to define the symbols for your terminal controllers
;	manually in a dummy RSXMC.MAC file somewhere on LB: .
;
.ASKS RSXUIC Enter the UFD on LB: where RSXMC.MAC can be found [ggg,uuu]
;
;	Idle terminal logouts are printed on the statistic logging device,
;	usually CL: or CO: .  However, you may direct them anywhere your
;	heart desires.
;
.ASKS CONSOL Enter the console device for statistic logging (DDn:)
;
;	You can include VT100 cursor control sequences which will do
;	some fancy things if the majority of your terminals are VT100
;	compatible terminals.
;
.ASK VT100 Do you want VT100 support in the user monitor
;
.ASK LIST Do you want a listing of the user monitor
;
.ASK MAP Do you want a map of the user monitor
;
;
;	Assemble and Build Phase
;
.;
.;	Set up MACRO assembly prefix file from data given
.;
PIP USERPRE.MAC;*/DE
PIP USERPRE.MAC=USERPRE0.MAC
.OPENA USERPRE.MAC
.ENABLE DATA
SECNDS = 'SECNDS'.				; Task monitoring interval
FIRST = 'NO1'.				; First warning time '$NO1' mins
SECOND = 'NO2'.				; Second warning time '$NO2' mins
THIRD = 'NO3'.				; Third warning time '$NO3' mins
FOURTH = 'NO4'.				; Logout time '$NO4' mins
'$WARN1'				; ASCII time left at first warning
'$WARN2'				; ASCII time left at second warning
.DISABLE DATA
.IFT VT100 .DATA V$T100 = 0			; VT100 support included
.CLOSE USERPRE.MAC
;
;	Assemble the source file
;
Pip USER.OBJ;*/de
.SETS LST ""
.IFT LIST .SETS LST ",USER/-SP"
.OPEN USERMAC.CMD
.DATA SY:USER'LST' = LB:[1,1]EXEMC/ML, LB:'RSXUIC'RSXMC/PA:1, -
.IFF DECNET .GOTO NONET
.IFT NETSUP .DATA LB:'NETUIC'RMHPRE/PA:1, -
.NONET:
.DATA SY:'UIC'USERPRE/PA:1, -
.DATA SY:'UIC'USER
.CLOSE USERMAC.CMD
MAC @USERMAC
PIP USERMAC.CMD;*, USERPRE.MAC;*/NM/DE
;
;	Build the task 
;
PIP USERBLD.CMD;*/DE
.SETS $MAP ""
.IFT MAP .SETS $MAP ", SY:'UIC'USER/MA/-SP"
.OPEN USERBLD.CMD
.DATA LB:[1,54]USER/PR/-CP '$MAP'=
.DATA SY:'UIC'USER, LB:[1,54]RSX11M.STB/SS
.DATA /
.DATA UNITS=2
.DATA TASK=USERMN
.DATA ASG='CONSOL'1
.DATA PRI=150
.DATA //
.CLOSE
SET /UIC=[1,54]
PIP LB:USER.TSK;*/PR:0/FO
PIP LB:USER.TSK;*/NM/DE
TKB @'UIC'USERBLD
;
;	Clean up the mess
;
PIP SY:'UIC'USER.MAP;*/PR/FO
SET /UIC='UIC'
PIP USER.LST, USER.MAP/PU
PIP USER.OBJ;*, USERBLD.CMD;*/NM/DE
;
;	Remember to install and run the new user monitor at startup time
;
