	.ENABLE SUBSTITUTION
	;
	; The KMS Fusion Terminal Load Simulator
	;	     '<DATE>'  '<TIME>'
	;
	.ENABLE QUIET
	.SETN PRISHF 105.		! DEFAULT SHUFFLER PRIORITY
	.SETN PRIIND 65.		! DEFAULT ...AT. PRIORITY
.IFNINS DSKMON INS $DSKMON
.IFACT DSKMON RUN $DSKOFF
.;     This command procedure will simulate a program development load on
.; a system of from 1 to "n" terminals.   The user may either leave SHF...
.; in SYSPAR (the SYSGEN default), REMOVE it, or FIX it in a small TASK
.; partition(In our system we call this partition SHTPAR.  The name will
.; have to be changed depending on the system used.).
.;
.;     The user is also allowed to alter the ROUND ROBIN and SWAP interval
.; from run to run.  This allows tailoring performance for disk and CPU
.; speed.  To do this the task SCH is used.
.;
.;     This procedure depends on the ability to pass command lines to non
.; installed tasks using INS filespec/CMD="cmdline"/TASK=tsknam.  In this
.; way an "n" terminal environment is all forced to run on a single terminal.
.; Another requirement is the use of PIN, a procedure interpreter which
.; spawns single line MCR commands from a command file to MCR.  This
.; allows creating "n" independent job streams all controlled from a single
.; copy of ...AT. runing on TI:.
.;
.;     The final feature is using the program SNPSHT to take snap shots
.; of system performance parameters (# loader requests, # SHF requests,
.; # checkpoint requests, elapsed CPU time, #QIO's issued).  While all
.; system parameters are not measured, these provide a good measure for
.; the activity and the level of load imposed by this test on the sytem.
.; SNPSHT creates a command file of .SETN XYZ 123. type commands to
.; pass on the variables to ...AT. without having to modify ...AT. to
.; monitor these values directly.  Given the length of time this load
.; test will run, the overhead of opening and closing the command file
.; does not drastically affect the validity of the timings produced.
   
	.SETN TTL2 0
	.SETF REMSHF
	.SETF FIXSHF
	.SETS SHFPAR ""
	.ASKS BASLVL System Base Level code
	.ASKN[1.:20.:1.] TRMCNT Maximum number of terminals to simulate
	.ASKN[1.:10.:1.] PASCNT How many passes should be made
	.DISABLE QUIET
	; The current ROUND ROBIN and SWAP times are
	.ENABLE QUIET
	SCH /DSP
	.ASKN[5.:100.:5.] ROBIN  How many tics for ROUND ROBIN interval
	.ASKN[40.:100.:40.] SWAP  How many tics for SWAP interval
	.ASKN[1.:100.:5.] SHFCT  How many times/SWAP interval can SHF run
	.ASK CPUMON Monitor CPU performance (use SNPSHT)
	.SETS COMNT1 ""
	.ASKS COMNT1 Special conditions
.SHF:
	.ASK REMSHF Remove the Shuffler for this run
	.IFF REMSHF.ASK FIXSHF Fix the Shuffler for this run
	.IFT FIXSHF .ASKS SHFPAR What partition shall SHF be fixed in
	.IFT FIXSHF .IF SHFPAR EQ "" .GOTO SHFERR
	.IFT FIXSHF .IF SHFPAR EQ "SYSPAR" .GOTO SHFERR
	.IFT REMSHF REM SHF...
	.IFT FIXSHF REM SHF...
	.IFT FIXSHF INS $SHF/PAR='SHFPAR'/CKP=NO
	.IF <EXSTAT> EQ 1 .GOTO FIXSHF	
.SHFERR:
	.DISABLE QUIET
	;  Some sort of error was made in trying to Install SHF in 'SHFPAR'.
	;  Perhaps the partition does not exist.  Try again!!
	.ENABLE QUIET
	REM SHF...
	INS $SHF/PAR=SYSPAR
	.GOTO SHF
.FIXSHF:.IFT FIXSHF FIX SHF...
	.IF <EXSTAT> NE 1 .GOTO SHFERR
	.IFF REMSHF .ASK SHFPRI Alter the Shuffler priority (default=105.)
	.IFT REMSHF .SETF SHFPRI
	.IFT SHFPRI .ASKN [1.:200.:105.] PRISHF What is the Shuffler priority
	.ASK INDPRI Alter ...AT. priority (default=65.)
	.IFT INDPRI .ASKN [1.:100.:65.] PRIIND Running priority for ...at.
	.ASK MONDSK Monitor disk activity on LB: (use DSKMON)
	.ASKN [1.:10.:2.] DELTA Scanning rate(sec) for this command procedure
	ALT AT./RPRI='PRIIND'.
	.IFINS SHF... ALT SHF.../PRI='PRISHF'.

	SCH /RBN:'ROBIN'/SWP:'SWAP'/MSF:'SHFCT'
	.IFT MONDSK .IFINS DSKMON RUN DSKMON
	.SETN TERM 0
	.SETN MAXTI TRMCNT-1
.INSINS:
	.SETS FIL "0"
	.IF TERM GT 7 .SETS FIL ""
	.SETS INS "I"+FIL
	.SETN CNT'TERM' 0
	.SETS STRT'TERM' ""
	.IFNINS 'INS''TERM' INS $INS/TASK=...'INS''TERM'
	.INC TERM
	.IF TERM LE MAXTI .GOTO INSINS
	.;
	.; CREATE A FILE TO COMPILE AND TASKBUILD
	.OPEN DUMMY.FTN;1
	.DISABLE SUBSTITUTION
.ENABLE DATA
	WRITE(5,100)
100	FORMAT(' HI')
	END
.DISABLE DATA
	.CLOSE
	.ENABLE SUBSTITUTION
	.; 
	.; CREATE UP TO MAXTI COPIES OF .PRC FILES TO DRIVE THE LOAD TEST
	.SETN TERM 0
.CREATE:.SETS FIL "0"
	.IF TERM GT 7 .SETS FIL ""
	.SETS INS "I"+FIL
	.SETN T TERM
	.OPEN LOADT'TERM'.PRC;1
	.DATA $NOTRACE
.DATA 'INS''T' $PIP/TASK=PIPX'T'/CMD="PIP DUMMY'T'.OBJ;1/DE/NM"
.DATA 'INS''T' $F77/TASK=F4PX'T'/CMD="F4P DUMMY'T'.OBJ;1=DUMMY"
.DATA 'INS''T' $TKB/INC=1000/TASK=TKBX'T'/CMD="TKB @DUMMY'T'.BLD"
.DATA 'INS''T' $PIP/TASK=PIPX'T'/CMD="PIP DUMMY'T'.OBJ;1/DE/NM"
	.CLOSE
	.OPEN DUMMY'TERM'.BLD;1
	.DATA DUMMY'TERM'.TSK;1/CP/FP=DUMMY'TERM',LB:[1,1]F4POTS/LB
	.DATA /
	.DATA CLSTR=F4PRES,FCSRES:RO
	.DATA //
	.CLOSE
	.INC TERM
	.IF TERM LE MAXTI .GOTO CREATE
	.SETN TOTAL TRMCNT*PASCNT
	.OPEN LOADTST.LOG;1
	.DATA ; 
	.DATA ; System Load Test on '<NETNOD>' 
	.DATA ; RSX11M V4.0 'BASLVL'
	.DATA ;		'<DATE>'  '<TIME>'
	.DATA ; Simulating 'TRMCNT' terminals running for 'PASCNT' passes
	.DATA ; 
	.DATA ;	Load test environment and parameters
	.IFACT RMD100 .DATA ;  RMD100 is running
	.IFACT DSKMON .DATA ;  DSKMON is running
	.IFACT ...RMD .DATA ;  ...RMD is running
	.DATA ;
	.DATA ; 	Round Robin interval(tics) = 'ROBIN'
	.DATA ; 	Executive Swap time(tics)  = 'SWAP'
	.DATA ; 	# SHF requests/SWAP time   = 'SHFCT'
	.IFINS SHF... .IFF FIXSHF .DATA ;	The SHUFFLER is in SYSPAR
	.IFT REMSHF .DATA ;	The SHUFFLER is removed
	.IFT FIXSHF .DATA ;	The SHUFFLER is fixed in 'SHFPAR'
		    .DATA ;	The SHUFFLER priority = 'PRISHF'
		    .DATA ;	The Indirect priority = 'PRIIND'
		    .DATA ;	Indirect delay time   = 'DELTA' sec
		    .DATA ;
		    .DATA ; 'COMNT1'
	.DATA ;
	.DATA   JOB   PASCNT   START      STOP
	.SETN TERM 0
	.SETS START <TIME>

	.; TAKE A SNAPSHOT OF THE SYSTEM PERFORMANCE PARAMETERS
	.; $CKPRQ	- NUMBER OF CHECKPOINT REQUESTS
	.; $LDRQ	- NUMBER OF LOADER REQUESTS
	.; $SHFRQ	- NUMBER OF SHUFFLE REQUESTS
	.; $QIOCT	- NUMBER OF QIO'S/10
	.; $CPUTM	- NUMBER OF CPU TICS/100
	.IFF CPUMON .GOTO RUN
	.IFNINS SNPSHT INS $SNPSHT
	RUN SNPSHT
	.WAIT SNPSHT
	@SNAPSHOT.CMD/DE
	.SETN CKPCT1 $CKPRQ
	.SETN LDRCT1 $LDRQ
	.SETN SHFCT1 $SHFRQ
	.SETN QIOCT1 $QIOCT
	.SETN CPUTM1 $CPUTM

	;
	; Starting run at '<DATE>' '<TIME>'
.RUN:	
	.SETS FIL "0"
	.IF TERM GT 7 .SETS FIL ""
	.SETS INS "I"+FIL
	.SETS STRT'TERM' <TIME>
	.XQT 'INS''TERM' $PIN/TASK=PINX'TERM'/CMD="PIN LOADT'TERM'.PRC"
	.INC TERM
	.IF TERM LE MAXTI .GOTO RUN
.WATLOD:
	.IFNACT PINX0 .GOTO WATLOD
.TSTACT:
	.SETN TERM 0
	.DELAY 'DELTA'.S
.LOOP:
	.IF CNT'TERM' GE PASCNT .GOTO STLACT
	.IFACT PINX'TERM' .GOTO STLACT
	.SETS STRTIM STRT'TERM'
	.INC CNT'TERM'
	.INC TTL2
	.SETN CNT CNT'TERM'
	.DATA  PINX'TERM'    'CNT'    'STRTIM'   '<TIME>'
	.SETS STRT'TERM' <TIME>
.IF CNT LT PASCNT .XQT INS $PIN/TASK=PINT'TERM'/CMD="PIN LOADT'TERM'.PRC"
.STLACT:
	.IF TTL2 GE TOTAL .GOTO ENDUP
.NEXT:
	.INC TERM
	.IF TERM GT MAXTI .GOTO TSTACT
	.GOTO LOOP
	.DISABLE QUIET
.ENDUP:
	.SETS LAST <TIME>
	.SETS HR START[1:2]
	.SETS MIN START[4:5]
	.SETS SEC START[7:8.]
	.SETN HOUR 'HR'.
	.SETN MINIT 'MIN'.
	.SETN SECND 'SEC'.
	.SETN STRTHR HOUR
.;	.SETN TOT 3600.*HOUR
	.SETN TOT1 60.*MINIT
;	.SETN TIME1 TOT+TOT1+SECND
	.SETN TIME1 TOT1+SECND
	.SETS HR LAST[1:2]
	.SETS MIN LAST[4:5]
	.SETS SEC LAST[7:8.]
	.SETN HOUR 'HR'.
	.SETN HOUR HOUR-STRTHR
	.SETN MINIT 'MIN'.
	.SETN SECND 'SEC'.
	.SETN TOT 3600.*HOUR
	.SETN TOT1 60.*MINIT
	.SETN TIME2 TOT+TOT1+SECND
	.SETN ELAPD TIME2-TIME1
	.SETN NLOADS PASCNT*TRMCNT
	.SETN TIMPER ELAPD/NLOADS
	.DATA ;
	.DATA ; Total elapsed time(sec) = 'ELAPD'
	.DATA ; Time/terminal load(sec) = 'TIMPER'
	.IFF CPUMON .GOTO CLS

	.; GET THE CLOSING PERFORMANCE STATISTICS
	RUN SNPSHT
	.WAIT SNPSHT
	REM SNPSHT
	@SNAPSHOT.CMD/DE
	.SETN CKPCT $CKPRQ-CKPCT1
	.SETN LDRQ  $LDRQ-LDRCT1
	.SETN SHFRQ $SHFRQ-SHFCT1
	.SETN QIOCT $QIOCT-QIOCT1
	.SETN CPUTM $CPUTM-CPUTM1
	.SETN PERCNT 100.*CPUTM
	.SETN PERCNT PERCNT/ELAPD
	.DATA ;
	.DATA ; Checkpoint requests = 'CKPCT'      Loader requests = 'LDRQ'
	.DATA ;   Shuffler requests = 'SHFRQ'         QIO count/10 = 'QIOCT'
	.DATA ; CPU time = 'CPUTM'               % CPU utilization = 'PERCNT'

.CLS:	.CLOSE
	.SETN TERM 0
.CLEAN:	PIP LOADT'TERM'.PRC;*/DE/NM,DUMMY'TERM'.BLD;*,DUMMY'TERM'.TSK;*
	PIP DUMMY'TERM'.OBJ;*/DE/NM,DUMMY.FTN;*
	PIP LOADTST.LOG/TR
	.INC TERM
	.IF TERM LE MAXTI .GOTO CLEAN
	.SETN TERM 0
.REMINS:
	.SETS FIL "0"
	.IF TERM GT 7 .SETS FIL ""
	.SETS INS "I"+FIL
	.IFINS 'INS''TERM' REM 'INS''TERM'
	.INC TERM
	.IF TERM LE MAXTI .GOTO REMINS
	.IFT FIXSHF REM SHF...
	.IFNINS SHF... INS $SHF


	.DISABLE QUIET
	; 
	; The load simulator has completed 'PASCNT' passes 
	; simulating 'MAXTI' terminals
	.ENABLE QUIET
	PIP TI:=LOADTST.LOG
	.IFACT DSKMON .IFNINS DSKOFF INS $DSKOFF
	.IFACT DSKMON RUN DSKOFF
	.IFINS DSKOFF REM DSKOFF
	.IFINS DSKMON REM DSKMON
	PRINT LOADTST.LOG
