/*
 *       ***************
 *       *  F 1 1 . H  *
 *       ***************
 *
 * Files-11 on-disk structures.
 *
 * Edits:
 * 24-Nov-81 RBD  Initial edit
 */
typedef char byte;
typedef unsigned word;
typedef unsigned rad50;

/*
 * Home block.
 */
struct  home
        {
        word    h_ibsz;         /* Index bit map size */
        long    h_iblb;         /* Indec bit map loc. */
        word    h_fmax;         /* Max. files */
        word    h_sbcl;         /* Storage map cluster factor */
        word    h_dvty;         /* Device type */
        word    h_vlev;         /* Structure level */
        char    h_vnam[12];     /* Volume id */
        byte    h_res0[4];      /* Reserved */
        word    h_vown;         /* Owner's UIC */
        word    h_vpro;         /* Volume protection code */
        word    h_vcha;         /* Volume characteristics */
        word    h_dfpr;         /* Default protection */
        byte    h_res1[6];      /* Reserved */
        byte    h_wisz;         /* Default pointers per window */
        byte    h_fiex;         /* Default extension */
        byte    h_lruc;         /* Entries in dir. lru */
        byte    h_res2[11];     /* Reserved */
        word    h_chk1;         /* First checksum */
        char    h_vdat[14];     /* Creation date and time */
        char    h_vhlb[100];    /* Volume header label */
        byte    h_ssin[82];     /* System specific information */
        byte    h_rvtb[254];    /* Rel. vol. table */
        word    h_chk2;         /* Second checksum */
        };

/*
 * User attributes.
 */
struct  ufat
        {
        byte    f_rtyp;         /* Record type */
        byte    f_ratt;         /* Record attributes */
        word    f_rsiz;         /* Record size */
        long    f_hibk;         /* Highest block in file */
        long    f_efbk;         /* End of file block */
        word    f_ffby;         /* First free byte */
        byte    f_crap[18];     /* Pad to 32 bytes */
};

#define R_FIX   1               /* Fixed length */
#define R_VAR   2               /* Variable length */
#define R_SEQ   3               /* Sequenced */

#define FD_FTN  01              /* Fortran slew */
#define FD_CR   02              /* Need slew */
#define FD_PRN  04		/* Print control */
#define FD_BLK  010             /* No block span */

/*
 * Header block.
 */
struct  header
        {
        byte    h_idof;         /* Ident. area offset (words) */
        byte    h_mpof;         /* Map area offset (words) */
        word    h_fnum;         /* File number */
        word    h_fseq;         /* File sequence */
        word    h_flev;         /* Structure level and system number */
        byte    h_prog;         /* Programmer number */
        byte    h_proj;         /* Project number */
        word    h_fpro;         /* Protection */
        byte    h_ucha;         /* User char. */
        byte    h_scha;         /* System char. */
        struct  ufat h_ufat;    /* User file attributes */

        rad50   i_fnam[3];      /* File name */
        rad50   i_ftyp[1];      /* File type */
        word    i_fver;         /* File version */
        word    i_rvno;         /* Rev. number */
        char    i_rvdt[7];      /* Rev. date */
        char    i_rvti[6];      /* Rev. time */
        char    i_crdt[7];      /* Creation date */
        char    i_crti[6];      /* Creation time */
        char    i_exdt[7];      /* Expiration date */
        byte    i_res0;         /* Reserved */

        byte    m_esqn;         /* Ext. seg. number */
        byte    m_ervn;         /* Ext. rel. vol. number */
        word    m_efnu;         /* Ext. file number */
        word    m_efsq;         /* Ext. file sequence */
        byte    m_ctsz;         /* Size of block count field */
        byte    m_lbsz;         /* Size of lbn field */
        byte    m_use;          /* No. of pointers in use */
        byte    m_max;          /* No. of pointers avail. */
        word    m_map[204];     /* Map words */

        word    h_cksm;         /* Checksum */
        };

#define	UC_CON	0200		/* Logically contig. */
#define	UC_DLK	0100		/* Locked */
#define UC_CNB	0040		/* Contig best effort */
#define UC_WCK	0020		/* Write check */
#define UC_RCK	0010		/* Read check */
#define UC_WBC	0004		/* Write back cache */
#define UC_NID	0002		/* No incremental dump */
#define	SC_MDL	0200		/* Marked for delete */
#define	SC_BAD	0100		/* Bad blocks in file */
#define SC_DIR	0040		/* Directory file */
#define	SC_SPL	0020		/* Spool intermediate file */

/*
 * Directory.
 */
struct  dir
        {
        word    d_fid[3];       /* File id */
        rad50   d_fnam[3];      /* File name */
        rad50   d_ftyp[1];      /* File type */
        word    d_fver;         /* File version */
        };

/*
 * Magic.
 */
#define BOOTB   1               /* Boot block */
#define HOMEB   2               /* Home block */
#define IMAPB   3               /* Base of index bitmap */
