/*
 * RSX11M V3.2 System Definition Headers for C.
 *
 * ADDR (address) data type and rad50 structure definitions.
 * Standard error codes returned by system directives in the DSW.
 * See Appendix B of the RSX-11M/M+ Executive Ref. Manual.
 *
 * Used with all RSX-11M V3.2 system call C functions.
 *
 * Bob Denny
 * 14-May-80
 * Updated for byte sized error codes.
 * 24-Feb-82 (RBD)
 *
 */

struct	rad50	{
		int w[2];
		};

typedef char *ADDR;		/* Virtual address */

/*
 * Success codes.
 */
#define		IS_CLR	0
#define		IS_SUC	1
#define		IS_SET	2
/*
 * Errors from task requests.
 */
#define		IE_UPN	0377
#define		IE_INS	0376
#define		IE_PTS  0375
#define		IE_UNS	0374
#define		IE_ULN	0373
#define		IE_HWR	0372
#define		IE_ACT	0371
#define		IE_ITS	0370

#define		IE_FIX	0367
#define		IE_CKP	0366
#define		IE_TCH	0365
#define		IE_RBS	0361
#define		IE_PRI	0360

#define		IE_RSU	0357
#define		IE_NSW	0356
#define		IE_ILV	0355

/*
 * Misc returns.
 */
#define		IE_AST	0260

#define		IE_MAP	0257
#define		IE_IOP	0255
#define		IE_ALG	0254
#define		IE_WOV	0253
#define		IE_NVR	0252
#define		IE_NVW	0251
#define		IE_ITP	0250

#define		IE_IBS	0247
#define		IE_LNL	0246
#define		IE_IUI	0245
#define		IE_IDU	0244
#define		IE_ITI	0243
#define		IE_PNS	0242
#define		IE_IPR	0241
#define		IE_ILU	0240

#define		IE_IEF	0237
#define		IE_ADP	0236
#define		IE_SDP	0235
