;	EXECSLP.CMD
;
.ENABLE QUIET
.ENABLE SUBSTITUTION
.SETT SKIP1
.SETT SKIP2
.SETT SKIP3
.SETT SKIP3A
.SETT SKIP3B
.SETT SKIP4
.SETT SKIP5
.SETT SKIP6
.SETT SKIP7
.SETT SKIP8
.SETT SKIP9
.SETT SKIP10
.SETT ALLDON
	.IFDF $OU .GOTO DEF1
	ASN SY:=OU:
	.GOTO DEF2
.DEF1:  ASN '$OU'=OU:
.DEF2:	.IFDF $IN .GOTO DEF3
	ASN SY:=IN:
	.GOTO DEF4
.DEF3:	ASN '$IN'=IN:
.DEF4:	
.DISABLE QUIET
;
; This file will attempt to lead you through the SYSGEN modifications
; and Executive SLP patches.  When it is done you should SLP the MCR sources
; and perform a  SYSGEN and then restart KMSGEN.CMD.  It is assumed that the 
; user is sitting with his/her KMSKIT on SY:.  To SLP the MCR sources
; you should mount the MCR source disk (or disks one at a time) so 
; that the sources on [12,10] and [15,10] can be slipped by MCRSLP.CMD.
;
; The distribution DEC sources will be renamed to .VGN;1, the SLPed modules
; will be named .MAC;2.  The distribution DEC command files will be renamed
; .VMD;1 and the SLPed command files will be named .CMD;2.
;
; These SLP files will be applied to distribution sources
;
;	1.  [200,200]SYSGEN.CMD;1
;	2.  [200,200]SGNTT.CMD;1
;	3.  [200,200]SGNPER.CMD;1
;	4.  [200,200]SGNEXEC.CMD;1
;	5.  [011,010]DREIF.MAC;1
;	6.  [011,010]TDSCH.MAC;1
;	7.  [011,010]TTICH.MAC;1		(optional)
;	8.  [011,010]SYSCM.MAC;1
;	9.  [011,010]SYSXT.MAC;1
;      10.  [001,020]BYEBLD.BLD;1
;      11.  [001,020]HELBLD.BLD;1
;
; An optional patch for SYSGEN3.CMD exists for those wishing to customize
; SYSGEN3.  It is not necessary for the KMS enhancements to work.
;
.ASK OPTPAT Apply the optional SLP patch to SYSGEN3
.ENABLE QUIET
.SETS OURUIC <UIC>
.ASKUIC:
.ASKS FILUIC On what UIC are the SLP patch files (<cr> defaults to [344,40])
.IF FILUIC EQ "" .SETS FILUIC "[344,40]"
SET /UIC ='FILUIC'
.IF <EXSTAT> NE 1 ;You typed in an illegal UIC string try again
.IF <EXSTAT> NE 1 .GOTO ASKUIC
;
.ENABLE QUIET
SET /PRIV=TI:
.DISABLE QUIET
.IF <EXSTAT> NE 1 ; Sorry this uic is not privleged, EXITING
.IF <EXSTAT> NE 1 /

.ENABLE QUIET
.SETS DSK <SYDISK>+"'<SYUNIT>'"+":"
.Q2:.ASKS TEMP Which device is the Executive Source Disk( <CR>-EXIT, DDU)
.IF TEMP EQ "" /
.SETS $EXC TEMP[1:3]
ASN '$EXC':=SY:
.IF <EXSTAT> EQ 1 .GOTO Q3
.DISABLE QUIET
;
; You entered an illegal device or device string, Try again
;
.ENABLE QUIET
.GOTO Q2
.Q3:.ASKS TEMP Which device is SYSGEN.CMD on(<CR>-EXIT, DDU)
.IF TEMP EQ "" /
.SETS $LBX TEMP[1:3]
ASN '$LBX':=SY:
.IF <EXSTAT> EQ 1 .GOTO CONT1
.DISABLE QUIET
;
; You entered an illegal device or device string, Try again
;
.ENABLE QUIET
.GOTO Q3
.CONT1:
.DISABLE QUIET
;
; An optional patch to enable the terminal driver to recognize <BACKSPACE>
; as the delete key for terminals of type 77 (SET /TERM=TTnn:77) exists.
;
.ENABLE QUIET
.ASK TRMPAT Apply the patch to the terminal driver
.SETS UIC <UIC>
SET /UIC=[11,10]
ASN '$EXC':=SY:

; Test for EXEC files to SLP
.SETS OLDEXT "MAC"				! TEST FOR .MAC SOURCES
.SETS NEWEXT "VGN"				! RENAME TO .VGN SOURCE
.SETS TSTUIC "[11,10]

.; 1) TDSCH.MAC					!
.SETS FILE "TDSCH"				! SET FILE TO RENAME
.GOSUB RENAME					! RENAME IT
.SET'SKIPIT' SKIP1				! SET SKIP FLAG

.; 2) SYSCM.MAC
.SETS FILE "SYSCM"				! SET FILE TO RENAME
.GOSUB RENAME					! RENAME IT
.SET'SKIPIT' SKIP2				! SET SKIP FLAG AS APPROPRIATE

.; 3) SYSXT.MAC
.SETS FILE "SYSXT"				! SET FILE TO RENAME
.GOSUB RENAME					! RENAME IT
.SET'SKIPIT' SKIP3				! SET SKIP FLAG 

.; 3a) DREIF.MAC
.SETS FILE "DREIF"				! Set file to rename
.GOSUB RENAME					! Rename it if present
.SET'SKIPIT' SKIP3A				! Set skip flag

.; 3b) TTICH.MAC
.SETS FILE "TTICH"				! Set file to rename
.IFT TRMPAT .GOSUB RENAME			! Rename it if present
.IFT TRMPAT .SET'SKIPIT' SKIP3B			! Set skip flag as appropriate

.;
.; Transfer SLP files over to the EXEC source disk
.;
SET /UIC=[11,40]
PIP SY:/NV='DSK''UIC'TDSCH.SLP,SYSCM.SLP,SYSXT.SLP,DREIF.SLP,TTICH.SLP
.IFNINS SLP INS $SLP
SET /UIC=[11,10]
.IFF SKIP1  SLP @[11,40]SYSCM.SLP
.IFF SKIP2  SLP @[11,40]TDSCH.SLP
.IFF SKIP3  SLP @[11,40]SYSXT.SLP
.IFF SKIP3A SLP @[11,40]DREIF.SLP
.IFF SKIP3B SLP @[11,40]TTICH.SLP
.;
.; Modify the required SYSGEN command files
.;
.;   First check for correct command files for SYSGEN
.;
SET /UIC=[200,200]
ASN '$LBX':=SY:
.SETS OLDEXT "CMD"			! SET STARTING EXTENSION
.SETS NEWEXT "VMD"			! SET RENAMED EXTENSION
.SETS TSTUIC "[200,200]"		! WHERE TO LOOK FOR IT
 
.; 
.; Do required command files exist?  If so SLP theM
.;
.; 4) SGNEXEC.CMD
.SETS FILE "SGNEXEC"			! SET FILE NAME
.GOSUB RENAME				!
.SET'SKIPIT' SKIP4			! SET FLAG

.; 5) SGNPER.CMD
.SETS FILE "SGNPER"			! NAME IT
.GOSUB RENAME				! RENAME IT
.SET'SKIPIT' SKIP5			! SET FLAG

.; 6) SGNTT.CMD
.SETS FILE "SGNTT"			! NAME IT
.GOSUB RENAME				! RENAME IT
.SET'SKIPIT' SKIP6			! SET FLAG

.; 7) SYSGEN.CMD
.SETS FILE "SYSGEN"			! NAME IT
.GOSUB RENAME				! RENAME
.SET'SKIPIT' SKIP7			! SET FLAG 

.IFF OPTPAT .GOTO CPY			! Do not do SYSGEN3 patch
.; 8) SYSGEN3.CMD			!
.; SYSGEN3.SLP is optional for those desireing flexibility in tailoring
.; SYSGENs for their own use.
.SETS FILE "SYSGEN3"			! NAME IT
.GOSUB RENAME				! Rename it
.SET'SKIPIT' SKIP8			!
 
.CPY:.; Copy the SLP files onto SY: the distribution source disk 
PIP SY:/NV='DSK''UIC'SYSGEN.SLP,SGNEXEC,SGNPER,SGNTT
.IFT OPTPAT PIP SY:/NV='DSK''UIC'SYSGEN3.SLP

.IFF SKIP4 SLP @SGNEXEC.SLP
.IFF SKIP5 SLP @SGNPER.SLP
.IFF SKIP6 SLP @SGNTT.SLP
.IFF SKIP7 SLP @SYSGEN.SLP
.IFF SKIP8 SLP @SYSGEN3.SLP
.;
.; Check for correct BLD.BLD command files for SYSGEN 
.;
SET /UIC=[1,20]
ASN '$LBX':=SY:
PIP SY:/NV='DSK''UIC'BYEBLD.SLP,HELBLD.SLP

.SETS OLDEXT "BLD"			! SET STARTING EXTENSION
.SETS NEWEXT "VLD"			! SET RENAMED EXTENSION
.SETS TSTUIC "[1,20]"			! WHERE TO LOOK FOR IT
 
 
.; Do required command files exist?
.; 9) BYEBLD.BLD
.SETS FILE "BYEBLD"			! SET FILE NAME
.GOSUB RENAME				!
.SET'SKIPIT' SKIP9			! SET FLAG

.; 10) HELBLD.BLD			!
.SETS FILE "HELBLD"			!
.GOSUB RENAME				!
.SET'SKIPIT' SKIP10			!

.IFF SKIP9  SLP @BYEBLD.SLP		!
.IFF SKIP10 SLP @HELBLD.SLP		!

.DISABLE QUIET
.IFT SKIP1 .OR .IFT SKIP1 .OR .IFT SKIP3 .OR .IFT SKIP4 .SETF ALLDON
.IFT SKIP3A .OR .IFT SKIP3B .SETF ALLDON
.IFT SKIP5 .OR .IFT SKIP6 .OR .IFT SKIP7 .SETF ALLDON
.IFT OPTPAT .IFT SKIP8 .SETF ALLDON
.IFT SKIP9 .OR .IFT SKIP10 .SETF ALLDON
;
.IFF ALLDON .GOTO BADBAD
.DISABLE QUIET
;
; This ends the EXEC SLP modifications and the SYSGEN command
; file modifications.  Now SLP MCR sources and do a SYSGEN before 
; proceeding with  KMSGEN.
;
SET /UIC ='OURUIC'
ASN 'DSK'=SY:
.EXIT
.BADBAD:
.DISABLE QUIET
;
;   One or more of your EXECUTIVE modules or SYSGEN command files
; has not been updated.  Find out why and fix the problem.
;
.ENABLE QUIET
SET /UIC ='OURUIC'
ASN 'DSK'=SY:
.EXIT 4

.; Subroutine to test/rename files prior to SLPing
.; FILE = name of file to be SLPed
.; OLDEXT = old file name extension
.; NEWEXT= new file name extension
.; SKIPIT=<TRUE>  if FILE.NEWEXT exists
.;       =<FALSE> if FILE.NEWEXT does not exist and can't be 
.;				 renamed from FILE.OLDEXT
.RENAME:
.SETT SKIPIT				! Assume already SLPed or file missing
.TESTFILE 'TSTUIC''FILE'.'OLDEXT';1
.IF <FILERR> EQ 1 .SETF SKIPIT		! If EQ yes it exists, don't skip SLP
.IFF SKIPIT .GOTO RENAM1		! IFF, it exists, go rename it
.; If it does not, maybe already renamed
.TESTFILE 'TSTUIC''FILE'.'NEWEXT';1
.IF <FILERR> EQ 1 .SETF SKIPIT		! If EQ, it has been renamed
.IFF SKIPIT .RETURN			! IFF, has been renamed, skip rename
.; 
.; At this point the file neither exists, nor has it already been renamed
.DISABLE QUIET
;
; 'FILE'.'OLDEXT';1 is not on this device/uic.
; >>>>WARNING, This patch failed!
;
.ENABLE QUIET
.RETURN
.RENAM1:
PIP 'FILE'.'NEWEXT'/RE='FILE'.'OLDEXT';1	! RENAME THE FILE
.IF <EXSTAT> NE 1 .SETT SKIPIT			! IF RENAME FAILS
.DISABLE QUIET
;
.IFT SKIPIT ; Error renaming 'FILE'.'OLDEXT' to 'FILE'.'NEWEXT'
.IFF SKIPIT ; EXECSLP -- File 'FILE'.'OLDEXT'  renamde to 'FILE'.'NEWEXT'
;
.ENABLE QUIET
.RETURN					! RETURN TO MAINLINE
