$!			INCBACKUP.COM
$!	This command procedure will perform an incremental backup
$!	of a disk from the date of the last backup to the current time.  
$!	It will log the following information for later use;
$!
$!		a) The Operators name
$!		b) The Disk name and device
$!		c) The Tape Number and Tape name
$!		d) The Container file name
$!		e) The date(s) spanned by the backup
$!		f) The last date/time backuped to
$!		g) The # of tape errors if any.
$!
$	Verify_at_Start = 'F$VERIFY(0)'			!
$	ON ERROR THEN GOTO The_End			!
$	ON CONTROL_Y THEN GOTO Catch_Abort		! Trap aborts
$	@SYS$SYSDISK:[SYSMGR.CMDFIL]PAGE		!
$	TYPE SYS$INPUT					!
			INCBACKUP.COM
			     V2.2

	Remember -- the disk must be mounted for the backup to work!!

$	ON CONTROL_Y THEN GOTO Catch_Abort		!
$	SET CONTROL_Y					!
$!
$	Tmp:='Last_Name'				!
$	Last_Name:='Tmp'				!
$	If Last_Name .EQS. "" THEN -			!
		INQUIRE Last_Name "What is your last name"
$Get_Device:						!
$	INQUIRE Device "Which device do you wish to backup"! Find which disk
$	IF Device .EQS. "" THEN GOTO  Get_Device	! Insist we have the
$	IF Device .EQS. "DRA0:" THEN GOTO Got_Device	!  specified drive
$	IF Device .EQS. "DRA1:" THEN GOTO Got_Device	!
$	IF Device .EQS. "DMA1:" THEN GOTO Got_Device	!
$	WRITE SYS$OUTPUT ""				!
$	WRITE SYS$OUTPUT "INCBACKUP -- Invalid device name"
$	WRITE SYS$OUTPUT "             Valid names are: DRA0:, DRA1:, DMA1:"
$	GOTO Get_Device					!
$Got_Device: SET NOCONTROL_Y				! No aborts now
$	ASSIGN/USER DEVICEXXX.XXX SYS$OUTPUT 		! Create a temp file
$	SHOW DEVICE 'Device'				!
$	OPEN/READ INFILE DEVICEXXX.XXX			! Read back in data
$	READ INFILE Record				! Read file until we
$	READ INFILE Record				!  get to the last
$	READ INFILE Record				!  line with the
$	READ INFILE Record				!  device information
$	CLOSE INFILE					! Close the input file
$	ON CONTROL_Y THEN GOTO Catch_Abort		!
$	SET CONTROL_Y					! Allow aborts now
$	DELETE DEVICEXXX.XXX;*				! Clean up
$	Length='F$LENGTH(Record)'			! Get length of string
$	Position='F$LOCATE("mnt",Record)'		! Is the disk mounted
$	IF Position .NE. Length THEN GOTO Is_Mounted 	!
$	WRITE SYS$OUTPUT " "				!
$	WRITE SYS$OUTPUT "INCBACKUP -- ''Device' is not mounted"
$	WRITE SYS$OUTPUT "             Mount the disk and restart backup"
$	WRITE SYS$OUTPUT "             Exiting!!"	!
$	IF Verify_at_Start THEN SET VERIFY		!
$	EXIT						!
$Is_Mounted:						!
$	Disk_Name:='F$EXTRACT(42,9,RECORD)'		! Extract disk name
$	Today[0,11]:="''F$TIME()'"			! Get today's date
$	Month:='F$EXTRACT(3,3,Today)'			! Get month
$	Year:='F$EXTRACT(7,4,Today)'			! Get year
$	Day:="''F$EXTRACT(0,2,Today)'"			! Get day
$	Test:='F$EXTRACT(0,1,Today)'			! Check for blank
$	IF Test .EQS. " " THEN Day[0,1]:="0"		!  If so, make a 0
$	IF Test .EQS. " " THEN Today[0,1]:="0"		!  If so, make a 0
$!
$Get_Tape_Name:						!
$	System:='F$LOGICAL("SYS$SYSDISK")		! System disk device
$	IF System .NES. Device THEN GOTO Get_Tape_Name_2!
$	TYPE SYS$INPUT 					!

   Since the disk specified is the system disk, this backup may
be part of the daily/weekly backup cycle.  If this is the case,
$	This_Day='Day'					! Make a number
$	Week=This_Day/7+1				! Find week in month
$	BKPTAP:=WK'Week'BKP				! The tape to mount
$	WRITE SYS$OUTPUT "use the tape named ''BKPTAP'"	!   for the week
$Get_Tape_Name_2:
$	INQUIRE Tape_Name "What is the backup tape name"!
$	IF Tape_Name .EQS."" THEN GOTO Get_Tape_Name_2	!
$	Length='F$LENGTH(Tape_Name)'			! Is name Valid?
$	Tape[0,6]:=" "					! Force 6 spaces
$	Tape[0,'Length']:='Tape_Name'			!
$	IF Length .LE. 6 THEN GOTO Get_Tape_Number	!
$	WRITE SYS$OUTPUT " "				!
$	WRITE SYS$OUTPUT "INCBACKUP -- Tape names must be <= 6 characters"
$	GOTO Get_Tape_Name				!
$Get_Tape_Number:					!
$	INQUIRE Tape_Number "What is the backup tape number"
$	IF Tape_Number .eqs. "" THEN GOTO Get_Tape_Nnumber!
$	Length='F$LENGTH(Tape_Number)'			!
$	Tap_Nbr[0,3]:=" "				! Blank fill
$	Tap_Nbr[0,'Length']:='Tape_Number'		!
$Ask_New_Tape:						!
$	INQUIRE New_Tape -				!
	"Initialize a new tape or append to existing backup sets (I/A)"
$	IF New_Tape .NES. "I"	.AND. -			! If neither init
	   New_Tape .NES. "A"	THEN GOTO Ask_New_Tape	!
$	IF New_Tape .EQS. "A"   THEN GOTO Append_It	!
$	WRITE SYS$OUTPUT " "				!
$	WRITE SYS$OUTPUT -				!
	"Initializing the tape will wipe out all old backups on the tape"
$	INQUIRE Are_You_Sure "Are you sure you want to do this [Y/N]"
$	IF .NOT. Are_You_Sure THEN GOTO Ask_New_Tape	!
$	Rewind:=/REWIND					!
$	Label:="/LABEL=''Tape_Name'"			! Lable a new tape
$	New:="Y"					!
$	GOTO Get_Last_Backup				! Get date of last bkp
$Append_It: Rewind:=/NOREWIND				! Force Append
$	Label:=""					! No label on append
$	New:="N"					!
$Get_Last_Backup:					!
$	Disk$Name:='Disk_Name'				!
$	Name_Length='F$LENGTH(Disk$NAME)'		! See if a _ is pres
$	Position='F$LOCATE("_",Disk$Name)		!
$	IF Position .EQ. Name_Length THEN GOTO Name_OK	! If EQ, no _ found
$	Disk$Name['Position',1]:="X"			! Make _ into an X
$Name_OK:						!
$	Start_Date:=01-JAN-1980				! Defaults to long ago
$	TESTFILE SYS$SYSDISK:[OPERATOR.BACKUP]'Disk$Name'.BAK ! Prev bkp done?
$	IF $STATUS .NE.1 THEN GOTO Get_Time		! No, prompt for time
$	SET NOCONTROL_Y					! No aborts for now
	OPEN/READ INFILE -				!
	SYS$SYSDISK:[OPERATOR.BACKUP]'Disk$Name'.BAK 	! Yes, find last time
$Loop:							!
$	READ/END_OF_FILE=End_Loop INFILE RECORD		! Read file up to end
$	GOTO Loop					! 
$End_Loop: CLOSE INFILE					! Extract time of last
$	ON CONTROL_Y THEN GOTO Catch_Abort		!
$	SET CONTROL_Y					! Allow them now
$	Start_Date:='F$EXTRACT(14,11,RECORD)'		!  backup done on disk
$	WRITE SYS$OUTPUT -				!
	"''Disk_Name' was last incrementally backed up on ''Start_Date'"!
$Get_Time:						!
$!	INQUIRE From "Backup files starting from (<CR> => ''Start_Date')"
	INQUIRE From "Backup files starting from (<CR> => ''Start_Date')"
$	IF From .EQS. "" THEN From:='Start_Date'	! <CR> => default
$	Length='F$LENGTH(From)				! Get string length
$	IF Length .NE. 11 THEN -			! Insure proper date
	WRITE SYS$OUTPUT "INCBACKUP -- Invalid time string" ! Warn and
$	IF Length .NE. 11 THEN GOTO Get_Time		! reprompt if bad
$	Backup_Name:='Month''Day''Year'".BKP"		!
$!
$Mount_Tape:						!
$	ON CONTROL_Y  THEN GOTO Catch_Abort		! Trap aborts
$	SET CONTROL_Y					! Allow aborts
$	WRITE SYS$OUTPUT " "				!
$	WRITE SYS$OUTPUT "Place a mag-tape on MSA0"	!
$	INQUIRE READY "Type <return> when ready"	!
$	MOUNT MSA0: /FOREIGN				!
$	IF $STATUS .NE. 1 THEN GOTO Mount_Tape		!
$	ON CONTROL_Y THEN GOTO Finish_Up		!
$	SET NOCONTROL_Y					!
$	ASSIGN/USER DEVICEXXX.XXX SYS$OUTPUT 		! Create a temp file
$	SHOW DEVICE MSA0:				! Want to get err cnt
$	OPEN/READ INFILE DEVICEXXX.XXX			! Read back in data
$	READ INFILE Record				! Read file until we
$	READ INFILE Record				!  get to the last
$	READ INFILE Record				!  line with the
$	READ INFILE Record				!  device information
$	CLOSE INFILE					! Close the input file
$	ON CONTROL_Y THEN GOTO Finish_Up		!
$	SET CONTROL_Y					! Allow aborts now
$	DELETE DEVICEXXX.XXX;*				! Clean up
$	Length='F$LENGTH(Record)'			! Get length of string
$	Error:='F$EXTRACT(36,5,Record)'			! Get starting err cnt
$	Error_at_Start='Error'				! Make a #
$	ON ERROR THEN GOTO Tape_Error			! Catch tape errors
$	WRITE SYS$OUTPUT "Starting backup"		! 
$	SHOW TIME					!
$	BACKUP/FAST/VERIFY -				!
'Device'[*...]/SINCE:'From'-				!
/EXCLUDE=([SYSEXE]SWAPFILE.SYS,PAGEFILE.SYS,*.DMP) -	!
MSA0:'Backup_Name''Rewind''Label'-			!
/BLOCK_SIZE=2048					! Suggested by DEC
$	ON ERROR THEN GOTO The_End			!
$	SET NOCONTROL_Y					!
$	ASSIGN/USER DEVICEXXX.XXX SYS$OUTPUT 		! Create a temp file
$	SHOW DEVICE MSA0:				! Want to get err cnt
$	OPEN/READ INFILE DEVICEXXX.XXX			! Read back in data
$	READ INFILE Record				! Read file until we
$	READ INFILE Record				!  get to the last
$	READ INFILE Record				!  line with the
$	READ INFILE Record				!  device information
$	CLOSE INFILE					! Close the input file
$	ON CONTROL_Y THEN GOTO Finish_Up		!
$	SET CONTROL_Y					! Allow aborts now
$	DELETE DEVICEXXX.XXX;*				! Clean up
$	Length='F$LENGTH(Record)'			! Get length of string
$	Error:='F$EXTRACT(36,5,Record)'			! Get starting err cnt
$	Error_at_End= 'Error'				! Make a #
$	Err= Error_at_End - Error_at_Start		! Calc the dif
$	Error[0,5]:='Err'				! Make a string
$	IF Err .ne. 0 THEN WRITE SYS$OUTPUT -		!
	"WARNING -- ''Err' Tape errors were encountered during the backup"
$	SET NOCONTROL_Y					! Don't allow aborts
$!
$	TESTFILE SYS$SYSDISK:[OPERATOR.BACKUP]'Disk$Name'.BAK ! Logfile exist?
$	IF $STATUS .EQ. 1	THEN GOTO Add_Rec	! 
$!
$! File does not yet exist, create it
$	OPEN/WRITE OUTFILE -				!
	SYS$SYSDISK:[OPERATOR.BACKUP]'Disk$Name'.BAK	!
$	WRITE OUTFILE -					!
"   From           To       Tape    #   Init  Set_Name     Error    Operator"
$	WRITE OUTFILE -
"''From'   ''Today'  ''Tape'  ''Tap_Nbr'  ",-		!
"''New'   ''Backup_Name'   ''Error'  ''Last_Name'"	!
$	CLOSE OUTFILE					!
$	ASSIGN/USER NL: SYS$OUTPUT			!
$	ASSIGN/USER NL: EDTINI				!
$	EDT SYS$SYSDISK:[OPERATOR.BACKUP]'Disk$Name'.BAK! Fix carriage control
EXIT
$	PURGE SYS$SYSDISK:[OPERATOR.BACKUP]'Disk$Name'.BAK! 
$	GOTO Finish_Up					!
$Add_Rec:						!
$	OPEN/WRITE OUTFILE -				!
	'Disk$Name'.XXX					! A temp file
$	WRITE OUTFILE -					!
"''From'   ''Today'  ''Tape'  ''Tap_Nbr'  ",-		!
"''New'   ''Backup_Name'   ''Error'  ''Last_Name'"	!
$	CLOSE OUTFILE					!
$	ASSIGN/USER NL: EDTINI				!
$	ASSIGN/USER NL: SYS$OUTPUT			!
$	EDT 'Disk$Name'.XXX 				! Fix carriage control
EXIT
$	APPEND 'Disk$Name'.XXX -			!
	SYS$SYSDISK:[OPERATOR.BACKUP]'Disk$Name'.BAK	! Tack on record
$	DELETE 'Disk$Name'.XXX;*			!
$Finish_Up:						!
$	SHOW TIME					!
$	DISMOUNT MSA0:/UNLOAD				!
$	TYPE SYS$INPUT					!

INCBACKUP -- The disk backup is now complete.  Please remember to;
             a) Affix a date sticker to the tape reel.
             b) Physically dismount the tape and return it
                to it's cabinet.

$The_End:						!
$	SET CONTROL_Y					! Allow aborts
$	IF Verify_at_Start THEN SET VERIFY		!
$	EXIT						! all done
$!
$Tape_Error:
$	SHOW TIME					!
$	DISMOUNT MSA0:/UNLOAD				!
$	TYPE SYS$INPUT					!

INCBACKUP -- A tape error occurred which probably means the backup
             tape is now useless.  Get HELP!!!
$	SET CONTROL_Y					!
$	IF Verify_at_Start THEN SET VERIFY		!
$	EXIT
$!
$Catch_abort:						!
$	WRITE SYS$OUTPUT -				!
"^Y - Abort, cleaning up and exiting"			!
$	GOTO The_End					!
$!
$!  File Name:	INCBACKUP.COM
$!  Author:	James G. Downward
$!  Date:	05-Feb-1982
$!  Function:	Provide for an automatic backup procedure which
$!		keeps a log of backup as they are done.
$!
$! Required files:	[SYSMGR.CMDFIL]PAGE.COM      - Erase Screen or FF
$!
$!  Modified:
$!
